# Code generated by protoc-gen-meshpy. DO NOT EDIT.
# source: meshtrade/trading/limit_order/v1/service.proto

"""
LimitOrderService gRPC service wrapper with authentication, timeouts, and resource management.

This module provides a high-level gRPC service for the LimitOrderService service that combines
the service interface with resource management capabilities, providing authentication,
timeouts, and proper connection handling.
"""

from datetime import timedelta
from typing import Optional

from meshtrade.common import BaseGRPCClient
from meshtrade.iam.api_user.v1.api_credentials import find_credentials

from .limit_order_pb2 import LimitOrder
from meshtrade.common.service_options import ServiceOptions
from .service_pb2 import (
GetLimitOrderRequest,
)
from .service_pb2_grpc import LimitOrderServiceStub


def _create_limitorderservice_stub(channel):
    """Factory function to create LimitOrderServiceStub from gRPC channel."""
    return LimitOrderServiceStub(channel)


class LimitOrderService(BaseGRPCClient):
    """LimitOrderService gRPC service with authentication, timeouts, and resource management.

    This service provides a complete implementation of the LimitOrderService with proper authentication, timeout handling, and automatic resource cleanup.

    Full Service documentation: https://meshtrade.github.io/api/docs/api-reference/trading/limit_order/v1

    Basic service usage with default SDK Configuration:
    ```python
    service = LimitOrderService()

    with service:   # `with` ensures proper clean up of underlying connection after use
        response = service.get_api_user(request)
    ```
        
    With default configuration API credentials are searched for using the standard discovery hierarchy:
    
    1. MESH_API_CREDENTIALS environment variable
    
    2. Default credential file location:
    
    - Linux:   `$XDG_CONFIG_HOME/mesh/credentials.json` or fallback to `$HOME/.config/mesh/credentials.json`
    - macOS:   `$HOME/Library/Application Support/mesh/credentials.json`
    - Windows: `C:\\Users\\<user>\\AppData\\Roaming\\mesh\\credentials.json`
    
    For more information on authentication: https://meshtrade.github.io/api/docs/architecture/authentication

    The service may also be configured with custom options:
    ```python
    from .service_options_meshpy import ServiceOptions
    from datetime import timedelta

    options = ServiceOptions(
        url="api.staging.example.com",
        port=443,
        api_key="your-api-key",
        group="groups/your-group-id",
        timeout=timedelta(seconds=60)
    )

    service = LimitOrderService(options)

    with service: # `with` ensures proper clean up of underlying connection after use
        response = service.get_api_user(request)
    ```

    For more information on service configuration: https://meshtrade.github.io/api/docs/architecture/sdk-configuration
    """

    def __init__(self, options: Optional[ServiceOptions] = None):
        """Construct and initialize the LimitOrderService service.

        Full Service documentation: https://meshtrade.github.io/api/docs/api-reference/trading/limit_order/v1

        Args:
            options: Optional ServiceOptions for configuring the service.
                    If None, service is constructed with default configuration.
                    With default configuration API credentials are searched for using the standard discovery hierarchy:
                    
                    1. MESH_API_CREDENTIALS environment variable
                    
                    2. Default credential file location:
                    
                    - Linux:   `$XDG_CONFIG_HOME/mesh/credentials.json` or fallback to `$HOME/.config/mesh/credentials.json`
                    - macOS:   `$HOME/Library/Application Support/mesh/credentials.json`
                    - Windows: `C:\\Users\\<user>\\AppData\\Roaming\\mesh\\credentials.json`      

                    For more information on authentication: https://meshtrade.github.io/api/docs/architecture/authentication

                    For more information on service configuration: https://meshtrade.github.io/api/docs/architecture/sdk-configuration            

        Example:
        ```python
        # construct with default configuration
        service = LimitOrderService()

        # construct with custom configuration
        options = ServiceOptions(
            url="api.example.com",
            api_key="your-key",
            group="groups/your-group"
        )
        service = LimitOrderService(options)
        ```
        """
        if options is None:
            options = ServiceOptions()

        # Initialize the base client with all common functionality
        super().__init__(
            service_name="LimitOrderService",
            stub_factory=_create_limitorderservice_stub,
            find_credentials_func=find_credentials,
            url=options.url,
            port=options.port,
            api_key=options.api_key,
            group=options.group,
            timeout=options.timeout,
            tls=options.tls,
        )

    def get_limit_order(self, request: GetLimitOrderRequest, timeout: Optional[timedelta] = None) -> LimitOrder:
        """GetLimitOrder method.

        Args:
            request: The GetLimitOrder request message
            timeout: Optional timeout override for this call

        Returns:
            The GetLimitOrder response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("GetLimitOrder", request, timeout)


# Create aliases to match expected exports
LimitOrderServiceGRPCClient = LimitOrderService
LimitOrderServiceGRPCClientInterface = LimitOrderService
