# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from meshtrade.wallet.account.v1 import account_pb2 as meshtrade_dot_wallet_dot_account_dot_v1_dot_account__pb2
from meshtrade.wallet.account.v1 import service_pb2 as meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2


class AccountServiceStub(object):
    """
    AccountService manages blockchain wallet accounts and their lifecycle operations (BETA).

    This service provides comprehensive account management capabilities across multiple
    blockchain networks (Stellar, Solana, Bitcoin, Ethereum). Accounts serve as the 
    primary containers for holding and managing digital assets on the Mesh platform.

    Key capabilities include account creation, opening on-chain, balance queries,
    and account lifecycle management. All operations are scoped to the authenticated
    group's hierarchy and require appropriate wallet domain permissions.

    Note: This service is currently in BETA. Interface and functionality may change.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.CreateAccount = channel.unary_unary(
                '/meshtrade.wallet.account.v1.AccountService/CreateAccount',
                request_serializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.CreateAccountRequest.SerializeToString,
                response_deserializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_account__pb2.Account.FromString,
                _registered_method=True)
        self.UpdateAccount = channel.unary_unary(
                '/meshtrade.wallet.account.v1.AccountService/UpdateAccount',
                request_serializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.UpdateAccountRequest.SerializeToString,
                response_deserializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_account__pb2.Account.FromString,
                _registered_method=True)
        self.OpenAccount = channel.unary_unary(
                '/meshtrade.wallet.account.v1.AccountService/OpenAccount',
                request_serializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.OpenAccountRequest.SerializeToString,
                response_deserializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.OpenAccountResponse.FromString,
                _registered_method=True)
        self.GetAccount = channel.unary_unary(
                '/meshtrade.wallet.account.v1.AccountService/GetAccount',
                request_serializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.GetAccountRequest.SerializeToString,
                response_deserializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_account__pb2.Account.FromString,
                _registered_method=True)
        self.GetAccountByNumber = channel.unary_unary(
                '/meshtrade.wallet.account.v1.AccountService/GetAccountByNumber',
                request_serializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.GetAccountByNumberRequest.SerializeToString,
                response_deserializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_account__pb2.Account.FromString,
                _registered_method=True)
        self.ListAccounts = channel.unary_unary(
                '/meshtrade.wallet.account.v1.AccountService/ListAccounts',
                request_serializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.ListAccountsRequest.SerializeToString,
                response_deserializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.ListAccountsResponse.FromString,
                _registered_method=True)
        self.SearchAccounts = channel.unary_unary(
                '/meshtrade.wallet.account.v1.AccountService/SearchAccounts',
                request_serializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.SearchAccountsRequest.SerializeToString,
                response_deserializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.SearchAccountsResponse.FromString,
                _registered_method=True)


class AccountServiceServicer(object):
    """
    AccountService manages blockchain wallet accounts and their lifecycle operations (BETA).

    This service provides comprehensive account management capabilities across multiple
    blockchain networks (Stellar, Solana, Bitcoin, Ethereum). Accounts serve as the 
    primary containers for holding and managing digital assets on the Mesh platform.

    Key capabilities include account creation, opening on-chain, balance queries,
    and account lifecycle management. All operations are scoped to the authenticated
    group's hierarchy and require appropriate wallet domain permissions.

    Note: This service is currently in BETA. Interface and functionality may change.
    """

    def CreateAccount(self, request, context):
        """
        Creates a new account record in the system (off-chain).

        The account is created in a pending state and must be explicitly opened
        on the blockchain using OpenAccount before it can receive funds or execute
        transactions. Account ownership must match the executing context.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UpdateAccount(self, request, context):
        """
        Updates an existing account's mutable metadata.

        Only the display_name field can be modified. All other fields including
        ownership, ledger, and account number are immutable after creation.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def OpenAccount(self, request, context):
        """
        Opens an account on the blockchain ledger.

        Initializes the account on-chain, making it ready to receive deposits
        and execute transactions. Returns the opened account and a transaction
        reference for monitoring the blockchain operation.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetAccount(self, request, context):
        """
        Retrieves a specific account by its resource identifier.

        Provides access to account metadata and optionally fetches live
        balance data from the blockchain when populate_ledger_data is true.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetAccountByNumber(self, request, context):
        """
        Retrieves an account using its Account Number.

        Provides a convenient lookup method using the 7-digit account number.
        Optionally fetches live balance data when populate_ledger_data is true.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListAccounts(self, request, context):
        """
        Lists all accounts within the authenticated group's hierarchical scope.

        Returns the complete set of accounts accessible to the executing context,
        including accounts owned by the group and all descendant groups.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SearchAccounts(self, request, context):
        """
        Searches accounts using flexible text criteria within the hierarchy.

        Performs case-insensitive substring matching on display names,
        returning accounts that match the search criteria.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_AccountServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'CreateAccount': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateAccount,
                    request_deserializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.CreateAccountRequest.FromString,
                    response_serializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_account__pb2.Account.SerializeToString,
            ),
            'UpdateAccount': grpc.unary_unary_rpc_method_handler(
                    servicer.UpdateAccount,
                    request_deserializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.UpdateAccountRequest.FromString,
                    response_serializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_account__pb2.Account.SerializeToString,
            ),
            'OpenAccount': grpc.unary_unary_rpc_method_handler(
                    servicer.OpenAccount,
                    request_deserializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.OpenAccountRequest.FromString,
                    response_serializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.OpenAccountResponse.SerializeToString,
            ),
            'GetAccount': grpc.unary_unary_rpc_method_handler(
                    servicer.GetAccount,
                    request_deserializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.GetAccountRequest.FromString,
                    response_serializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_account__pb2.Account.SerializeToString,
            ),
            'GetAccountByNumber': grpc.unary_unary_rpc_method_handler(
                    servicer.GetAccountByNumber,
                    request_deserializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.GetAccountByNumberRequest.FromString,
                    response_serializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_account__pb2.Account.SerializeToString,
            ),
            'ListAccounts': grpc.unary_unary_rpc_method_handler(
                    servicer.ListAccounts,
                    request_deserializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.ListAccountsRequest.FromString,
                    response_serializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.ListAccountsResponse.SerializeToString,
            ),
            'SearchAccounts': grpc.unary_unary_rpc_method_handler(
                    servicer.SearchAccounts,
                    request_deserializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.SearchAccountsRequest.FromString,
                    response_serializer=meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.SearchAccountsResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'meshtrade.wallet.account.v1.AccountService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('meshtrade.wallet.account.v1.AccountService', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class AccountService(object):
    """
    AccountService manages blockchain wallet accounts and their lifecycle operations (BETA).

    This service provides comprehensive account management capabilities across multiple
    blockchain networks (Stellar, Solana, Bitcoin, Ethereum). Accounts serve as the 
    primary containers for holding and managing digital assets on the Mesh platform.

    Key capabilities include account creation, opening on-chain, balance queries,
    and account lifecycle management. All operations are scoped to the authenticated
    group's hierarchy and require appropriate wallet domain permissions.

    Note: This service is currently in BETA. Interface and functionality may change.
    """

    @staticmethod
    def CreateAccount(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.wallet.account.v1.AccountService/CreateAccount',
            meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.CreateAccountRequest.SerializeToString,
            meshtrade_dot_wallet_dot_account_dot_v1_dot_account__pb2.Account.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UpdateAccount(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.wallet.account.v1.AccountService/UpdateAccount',
            meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.UpdateAccountRequest.SerializeToString,
            meshtrade_dot_wallet_dot_account_dot_v1_dot_account__pb2.Account.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def OpenAccount(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.wallet.account.v1.AccountService/OpenAccount',
            meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.OpenAccountRequest.SerializeToString,
            meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.OpenAccountResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetAccount(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.wallet.account.v1.AccountService/GetAccount',
            meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.GetAccountRequest.SerializeToString,
            meshtrade_dot_wallet_dot_account_dot_v1_dot_account__pb2.Account.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetAccountByNumber(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.wallet.account.v1.AccountService/GetAccountByNumber',
            meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.GetAccountByNumberRequest.SerializeToString,
            meshtrade_dot_wallet_dot_account_dot_v1_dot_account__pb2.Account.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListAccounts(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.wallet.account.v1.AccountService/ListAccounts',
            meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.ListAccountsRequest.SerializeToString,
            meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.ListAccountsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def SearchAccounts(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.wallet.account.v1.AccountService/SearchAccounts',
            meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.SearchAccountsRequest.SerializeToString,
            meshtrade_dot_wallet_dot_account_dot_v1_dot_service__pb2.SearchAccountsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
