# -*- coding: utf-8 -*-
# Generated by Django 1.9.9 on 2017-02-06 02:43
from __future__ import unicode_literals

import cms.models.fields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields
import djangocms_text_ckeditor.fields
import filer.fields.file
import filer.fields.image
import leprikon.models.courses
import leprikon.models.fields
import leprikon.models.startend
import localflavor.generic.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('cms', '0001_initial'),
        ('filer', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('sites', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AgeGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='name')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'age group',
                'verbose_name_plural': 'age groups',
            },
        ),
        migrations.CreateModel(
            name='Contact',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('contact_type', models.CharField(choices=[('email', 'email'), ('phone', 'phone'), ('url', 'url')], max_length=30, verbose_name='contact type')),
                ('contact', models.CharField(max_length=250, verbose_name='contact')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
                ('public', models.BooleanField(default=False, verbose_name='public')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'contact',
                'verbose_name_plural': 'contacts',
            },
        ),
        migrations.CreateModel(
            name='CourseDiscount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='time of discount')),
                ('amount', leprikon.models.fields.PriceField(decimal_places=0, default=0, max_digits=10, verbose_name='discount')),
                ('explanation', models.CharField(blank=True, default='', max_length=250, verbose_name='discount explanation')),
            ],
            options={
                'ordering': ('created',),
                'abstract': False,
                'verbose_name': 'discount',
                'verbose_name_plural': 'discounts',
            },
        ),
        migrations.CreateModel(
            name='CourseJournalEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(verbose_name='date')),
                ('start', models.TimeField(blank=True, help_text='Leave empty, if the course does not take place', null=True, verbose_name='start time')),
                ('end', models.TimeField(blank=True, help_text='Leave empty, if the course does not take place', null=True, verbose_name='end time')),
                ('agenda', djangocms_text_ckeditor.fields.HTMLField(default=leprikon.models.courses.get_default_agenda, verbose_name='session agenda')),
            ],
            options={
                'ordering': ('date', 'start', 'end'),
                'verbose_name': 'journal entry',
                'verbose_name_plural': 'journal entries',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name='CourseJournalLeaderEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.TimeField(verbose_name='start time')),
                ('end', models.TimeField(verbose_name='end time')),
                ('course_entry', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='leader_entries', to='leprikon.CourseJournalEntry', verbose_name='course journal entry')),
            ],
            options={
                'verbose_name': 'course journal leader entry',
                'verbose_name_plural': 'course journal leader entries',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name='CourseListPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='leprikon_courselistplugin', serialize=False, to='cms.CMSPlugin')),
                ('template', models.CharField(choices=[('default', 'Default'), ('grouped', 'Grouped by course groups')], default='default', help_text='The template used to render plugin.', max_length=100, verbose_name='template')),
                ('age_groups', models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by age groups.', related_name='_courselistplugin_age_groups_+', to='leprikon.AgeGroup', verbose_name='age groups')),
            ],
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='CoursePlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='leprikon_courseplugin', serialize=False, to='cms.CMSPlugin')),
                ('template', models.CharField(choices=[('default', 'Default')], default='default', help_text='The template used to render plugin.', max_length=100, verbose_name='template')),
            ],
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='CourseRegistrationHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateField()),
                ('end', models.DateField(blank=True, null=True)),
            ],
            options={
                'ordering': ('start',),
                'verbose_name': 'course registration history',
                'verbose_name_plural': 'course registration history',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name='CourseTime',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('day_of_week', leprikon.models.fields.DayOfWeekField(choices=[(1, 'Monday'), (2, 'Tuesday'), (3, 'Wednesday'), (4, 'Thursday'), (5, 'Friday'), (6, 'Saturday'), (7, 'Sunday')], verbose_name='day of week')),
                ('start', models.TimeField(blank=True, null=True, verbose_name='start time')),
                ('end', models.TimeField(blank=True, null=True, verbose_name='end time')),
            ],
            options={
                'ordering': ('day_of_week', 'start'),
                'verbose_name': 'time',
                'verbose_name_plural': 'times',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name='EventDiscount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='time of discount')),
                ('amount', leprikon.models.fields.PriceField(decimal_places=0, default=0, max_digits=10, verbose_name='discount')),
                ('explanation', models.CharField(blank=True, default='', max_length=250, verbose_name='discount explanation')),
            ],
            options={
                'ordering': ('created',),
                'abstract': False,
                'verbose_name': 'discount',
                'verbose_name_plural': 'discounts',
            },
        ),
        migrations.CreateModel(
            name='EventListPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='leprikon_eventlistplugin', serialize=False, to='cms.CMSPlugin')),
                ('template', models.CharField(choices=[('default', 'Default'), ('grouped', 'Grouped by event groups')], default='default', help_text='The template used to render plugin.', max_length=100, verbose_name='template')),
                ('age_groups', models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by age groups.', related_name='_eventlistplugin_age_groups_+', to='leprikon.AgeGroup', verbose_name='age groups')),
            ],
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='EventPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='leprikon_eventplugin', serialize=False, to='cms.CMSPlugin')),
                ('template', models.CharField(choices=[('default', 'Default')], default='default', help_text='The template used to render plugin.', max_length=100, verbose_name='template')),
            ],
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='FilteredCourseListPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='leprikon_filteredcourselistplugin', serialize=False, to='cms.CMSPlugin')),
            ],
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='FilteredEventListPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='leprikon_filteredeventlistplugin', serialize=False, to='cms.CMSPlugin')),
            ],
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='FilteredLeaderListPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='leprikon_filteredleaderlistplugin', serialize=False, to='cms.CMSPlugin')),
            ],
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='Insurance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=10, unique=True, verbose_name='code')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
            ],
            options={
                'ordering': ('code',),
                'verbose_name': 'insurance company',
                'verbose_name_plural': 'insurance companies',
            },
        ),
        migrations.CreateModel(
            name='Leader',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', djangocms_text_ckeditor.fields.HTMLField(blank=True, default='', verbose_name='description')),
                ('page', cms.models.fields.PageField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='cms.Page', verbose_name='page')),
                ('photo', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='filer.Image', verbose_name='photo')),
            ],
            options={
                'ordering': ('user__first_name', 'user__last_name'),
                'verbose_name': 'leader',
                'verbose_name_plural': 'leaders',
            },
        ),
        migrations.CreateModel(
            name='LeaderListPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='leprikon_leaderlistplugin', serialize=False, to='cms.CMSPlugin')),
                ('template', models.CharField(choices=[('default', 'Default')], default='default', help_text='The template used to render plugin.', max_length=100, verbose_name='template')),
            ],
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='LeaderPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='leprikon_leaderplugin', serialize=False, to='cms.CMSPlugin')),
                ('template', models.CharField(choices=[('default', 'Default')], default='default', help_text='The template used to render plugin.', max_length=100, verbose_name='template')),
                ('leader', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.Leader', verbose_name='leader')),
            ],
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='LeprikonSite',
            fields=[
                ('site_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='sites.Site')),
                ('city', models.CharField(blank=True, max_length=150, null=True, verbose_name='city')),
                ('postal_code', leprikon.models.fields.PostalCodeField(blank=True, null=True, verbose_name='postal code')),
                ('email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='email address')),
                ('phone', models.CharField(blank=True, max_length=30, null=True, verbose_name='phone')),
                ('street', models.CharField(blank=True, max_length=150, null=True, verbose_name='street')),
                ('company_num', models.CharField(blank=True, max_length=8, null=True, verbose_name='company number')),
                ('vat_number', models.CharField(blank=True, max_length=10, null=True, verbose_name='VAT number')),
                ('iban', localflavor.generic.models.IBANField('IBAN', None, blank=True, null=True)),
                ('bic', localflavor.generic.models.BICField(blank=True, null=True, verbose_name='BIC (SWIFT)')),
                ('agreement', models.TextField(blank=True, null=True, verbose_name='registration agreement')),
            ],
            options={
                'verbose_name': 'leprikon site',
                'verbose_name_plural': 'leprikon sites',
            },
            bases=('sites.site',),
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='created')),
                ('subject', models.CharField(max_length=150, verbose_name='subject')),
                ('text', djangocms_text_ckeditor.fields.HTMLField(default='', verbose_name='text')),
            ],
            options={
                'ordering': ('-created',),
                'verbose_name': 'message',
                'verbose_name_plural': 'messages',
            },
        ),
        migrations.CreateModel(
            name='MessageAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', filer.fields.file.FilerFileField(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='filer.File')),
                ('message', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='leprikon.Message', verbose_name='message')),
            ],
            options={
                'verbose_name': 'attachment',
                'verbose_name_plural': 'attachments',
            },
        ),
        migrations.CreateModel(
            name='MessageRecipient',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField(editable=False)),
                ('sent', models.DateTimeField(auto_now_add=True, verbose_name='sent')),
                ('viewed', models.DateTimeField(default=None, editable=False, null=True, verbose_name='viewed on site')),
                ('sent_mail', models.DateTimeField(default=None, editable=False, null=True, verbose_name='sent by email')),
                ('message', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='recipients', to='leprikon.Message', verbose_name='message')),
                ('recipient', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='leprikon_messages', to=settings.AUTH_USER_MODEL, verbose_name='recipient')),
            ],
            options={
                'ordering': ('-sent',),
                'verbose_name': 'recipient',
                'verbose_name_plural': 'recipients',
            },
        ),
        migrations.CreateModel(
            name='Parent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(max_length=30, verbose_name='last name')),
                ('street', models.CharField(max_length=150, verbose_name='street')),
                ('city', models.CharField(max_length=150, verbose_name='city')),
                ('postal_code', leprikon.models.fields.PostalCodeField(verbose_name='postal code')),
                ('email', models.EmailField(blank=True, default='', max_length=254, verbose_name='email address')),
                ('phone', models.CharField(max_length=30, verbose_name='phone')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='leprikon_parents', to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'verbose_name': 'parent',
                'verbose_name_plural': 'parents',
            },
        ),
        migrations.CreateModel(
            name='Participant',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(max_length=30, verbose_name='last name')),
                ('birth_num', leprikon.models.fields.BirthNumberField(verbose_name='birth number')),
                ('street', models.CharField(max_length=150, verbose_name='street')),
                ('city', models.CharField(max_length=150, verbose_name='city')),
                ('postal_code', leprikon.models.fields.PostalCodeField(verbose_name='postal code')),
                ('email', models.EmailField(blank=True, default='', max_length=254, verbose_name='email address')),
                ('phone', models.CharField(blank=True, default='', max_length=30, verbose_name='phone')),
                ('citizenship', django_countries.fields.CountryField(max_length=2, verbose_name='citizenship')),
                ('school_other', models.CharField(blank=True, default='', max_length=150, verbose_name='other school')),
                ('school_class', models.CharField(blank=True, default='', max_length=30, verbose_name='class')),
                ('health', models.TextField(blank=True, default='', verbose_name='health')),
                ('gender', models.CharField(choices=[('m', 'male'), ('f', 'female')], editable=False, max_length=1, verbose_name='gender')),
                ('age_group', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.AgeGroup', verbose_name='age group')),
                ('insurance', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.Insurance', verbose_name='insurance')),
            ],
            options={
                'verbose_name': 'participant',
                'verbose_name_plural': 'participants',
            },
        ),
        migrations.CreateModel(
            name='Place',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='name')),
                ('place', models.CharField(blank=True, default='', max_length=50, verbose_name='place')),
            ],
            options={
                'ordering': ('place',),
                'verbose_name': 'place',
                'verbose_name_plural': 'places',
            },
        ),
        migrations.CreateModel(
            name='PrintSetup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('top', models.IntegerField(blank=True, default=20, help_text='distance in milimetres', verbose_name='margin top')),
                ('left', models.IntegerField(blank=True, default=20, help_text='distance in milimetres', verbose_name='margin left')),
                ('right', models.IntegerField(blank=True, default=20, help_text='distance in milimetres', verbose_name='margin right')),
                ('bottom', models.IntegerField(blank=True, default=20, help_text='distance in milimetres', verbose_name='margin bottom')),
                ('background', filer.fields.file.FilerFileField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='filer.File', verbose_name='pdf background')),
            ],
            options={
                'ordering': ('name',),
                'verbose_name': 'print setup',
                'verbose_name_plural': 'print setups',
            },
        ),
        migrations.CreateModel(
            name='Question',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, unique=True, verbose_name='name')),
                ('question', models.CharField(max_length=50, verbose_name='question')),
                ('help_text', models.TextField(blank=True, help_text='This is help text. The help text is shown next to the form field.', null=True, verbose_name='help text')),
                ('field', models.CharField(choices=[('char', 'char field'), ('text', 'text field'), ('boolean', 'boolean field'), ('date', 'date field'), ('choice', 'choice field')], max_length=150, verbose_name='field')),
                ('field_args', models.TextField(blank=True, default='{}', help_text='Enter valid JSON structure representing field configuration.', verbose_name='field_args')),
            ],
            options={
                'verbose_name': 'additional question',
                'verbose_name_plural': 'additional questions',
            },
        ),
        migrations.CreateModel(
            name='School',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='name')),
                ('street', models.CharField(blank=True, default='', max_length=50, verbose_name='street')),
                ('city', models.CharField(blank=True, default='', max_length=50, verbose_name='city')),
            ],
            options={
                'ordering': ('city', 'name'),
                'verbose_name': 'school',
                'verbose_name_plural': 'schools',
            },
        ),
        migrations.CreateModel(
            name='SchoolYear',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('year', models.IntegerField(unique=True, verbose_name='year')),
                ('active', models.BooleanField(default=False, verbose_name='active')),
            ],
            options={
                'ordering': ('-year',),
                'verbose_name': 'school year',
                'verbose_name_plural': 'school years',
            },
        ),
        migrations.CreateModel(
            name='SchoolYearPeriod',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('start', models.DateField(verbose_name='start date')),
                ('end', models.DateField(verbose_name='end date')),
                ('school_year', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='periods', to='leprikon.SchoolYear', verbose_name='school year')),
            ],
            options={
                'ordering': ('start',),
                'verbose_name': 'school year period',
                'verbose_name_plural': 'school year periods',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Subject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('description', djangocms_text_ckeditor.fields.HTMLField(blank=True, default='', verbose_name='description')),
                ('price', leprikon.models.fields.PriceField(blank=True, decimal_places=0, max_digits=10, null=True, verbose_name='price')),
                ('public', models.BooleanField(default=False, verbose_name='public')),
                ('reg_from', models.DateTimeField(blank=True, null=True, verbose_name='registration active from')),
                ('reg_to', models.DateTimeField(blank=True, null=True, verbose_name='registration active to')),
                ('min_count', models.IntegerField(blank=True, null=True, verbose_name='minimal count')),
                ('max_count', models.IntegerField(blank=True, null=True, verbose_name='maximal count')),
                ('risks', djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name='risks')),
                ('plan', djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name='plan')),
                ('evaluation', djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name='evaluation')),
                ('note', models.CharField(blank=True, default='', max_length=300, verbose_name='note')),
                ('agreement', models.TextField(blank=True, null=True, verbose_name='registration agreement')),
            ],
            options={
                'ordering': ('name',),
                'verbose_name': 'subject',
                'verbose_name_plural': 'subjects',
            },
        ),
        migrations.CreateModel(
            name='SubjectAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
                ('file', filer.fields.file.FilerFileField(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='filer.File')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'attachment',
                'verbose_name_plural': 'attachments',
            },
        ),
        migrations.CreateModel(
            name='SubjectGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('plural', models.CharField(max_length=150, verbose_name='plural')),
                ('color', leprikon.models.fields.ColorField(max_length=10, verbose_name='color')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'subject group',
                'verbose_name_plural': 'subject groups',
            },
        ),
        migrations.CreateModel(
            name='SubjectPayment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='payment time')),
                ('payment_type', models.CharField(choices=[('PAYMENT_CASH', 'payment - cash'), ('PAYMENT_BANK', 'payment - bank'), ('PAYMENT_ONLINE', 'payment - online'), ('PAYMENT_TRANSFER', 'payment - transfer from return'), ('RETURN_CASH', 'return - cash'), ('RETURN_BANK', 'return - bank'), ('RETURN_TRANSFER', 'return - transfer to payment')], max_length=30, verbose_name='payment type')),
                ('amount', leprikon.models.fields.PriceField(decimal_places=0, help_text='positive value for payment, negative value for return', max_digits=10, verbose_name='amount')),
                ('note', models.CharField(blank=True, default='', max_length=300, verbose_name='note')),
            ],
            options={
                'ordering': ('created',),
                'verbose_name': 'payment',
                'verbose_name_plural': 'payments',
            },
        ),
        migrations.CreateModel(
            name='SubjectRegistration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField(editable=False)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='time of registration')),
                ('price', leprikon.models.fields.PriceField(decimal_places=0, editable=False, max_digits=10, verbose_name='price')),
                ('answers', models.TextField(blank=True, default='{}', editable=False, verbose_name='additional answers')),
                ('approved', models.DateTimeField(editable=False, null=True, verbose_name='time of approval')),
                ('canceled', models.DateTimeField(editable=False, null=True, verbose_name='time of cancellation')),
                ('cancel_request', models.BooleanField(default=False, verbose_name='cancel request')),
                ('participant_gender', models.CharField(choices=[('m', 'male'), ('f', 'female')], editable=False, max_length=1, verbose_name='gender')),
                ('participant_first_name', models.CharField(max_length=30, verbose_name='first name')),
                ('participant_last_name', models.CharField(max_length=30, verbose_name='last name')),
                ('participant_birth_num', leprikon.models.fields.BirthNumberField(verbose_name='birth number')),
                ('participant_street', models.CharField(max_length=150, verbose_name='street')),
                ('participant_city', models.CharField(max_length=150, verbose_name='city')),
                ('participant_postal_code', leprikon.models.fields.PostalCodeField(verbose_name='postal code')),
                ('participant_citizenship', django_countries.fields.CountryField(max_length=2, verbose_name='citizenship')),
                ('participant_phone', models.CharField(blank=True, default='', max_length=30, verbose_name='phone')),
                ('participant_email', models.EmailField(blank=True, default='', max_length=254, verbose_name='email address')),
                ('participant_school_other', models.CharField(blank=True, default='', max_length=150, verbose_name='other school')),
                ('participant_school_class', models.CharField(blank=True, default='', max_length=30, verbose_name='class')),
                ('participant_health', models.TextField(blank=True, default='', verbose_name='health')),
                ('has_parent1', models.BooleanField(default=False, verbose_name='first parent')),
                ('parent1_first_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='first name')),
                ('parent1_last_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='last name')),
                ('parent1_street', models.CharField(blank=True, max_length=150, null=True, verbose_name='street')),
                ('parent1_city', models.CharField(blank=True, max_length=150, null=True, verbose_name='city')),
                ('parent1_postal_code', leprikon.models.fields.PostalCodeField(blank=True, null=True, verbose_name='postal code')),
                ('parent1_phone', models.CharField(blank=True, max_length=30, null=True, verbose_name='phone')),
                ('parent1_email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='email address')),
                ('has_parent2', models.BooleanField(default=False, verbose_name='second parent')),
                ('parent2_first_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='first name')),
                ('parent2_last_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='last name')),
                ('parent2_street', models.CharField(blank=True, max_length=150, null=True, verbose_name='street')),
                ('parent2_city', models.CharField(blank=True, max_length=150, null=True, verbose_name='city')),
                ('parent2_postal_code', leprikon.models.fields.PostalCodeField(blank=True, null=True, verbose_name='postal code')),
                ('parent2_phone', models.CharField(blank=True, max_length=30, null=True, verbose_name='phone')),
                ('parent2_email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='email address')),
            ],
            options={
                'verbose_name': 'registration',
                'verbose_name_plural': 'registrations',
            },
        ),
        migrations.CreateModel(
            name='SubjectType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject_type', models.CharField(choices=[('course', 'course'), ('event', 'event')], max_length=10, verbose_name='subjects')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('name_genitiv', models.CharField(blank=True, max_length=150, verbose_name='name (genitiv)')),
                ('name_akuzativ', models.CharField(blank=True, max_length=150, verbose_name='name (akuzativ)')),
                ('plural', models.CharField(max_length=150, verbose_name='name (plural)')),
                ('slug', models.SlugField()),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
                ('questions', models.ManyToManyField(blank=True, help_text='Add additional questions to be asked in the registration form.', related_name='_subjecttype_questions_+', to='leprikon.Question', verbose_name='additional questions')),
                ('agreement', models.TextField(blank=True, null=True, verbose_name='registration agreement')),
                ('reg_print_setup', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='leprikon.PrintSetup', verbose_name='registration print setup')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'subject type',
                'verbose_name_plural': 'subject types',
            },
        ),
        migrations.CreateModel(
            name='SubjectTypeAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
                ('file', filer.fields.file.FilerFileField(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='filer.File')),
                ('subject_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='leprikon.SubjectType', verbose_name='subject type')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'attachment',
                'verbose_name_plural': 'attachments',
            },
        ),
        migrations.CreateModel(
            name='Timesheet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('submitted', models.BooleanField(default=False, verbose_name='submitted')),
                ('paid', models.BooleanField(default=False, verbose_name='paid')),
                ('leader', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='timesheets', to='leprikon.Leader', verbose_name='leader')),
            ],
            options={
                'ordering': ('-period__start',),
                'verbose_name': 'timesheet',
                'verbose_name_plural': 'timesheets',
            },
        ),
        migrations.CreateModel(
            name='TimesheetEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(verbose_name='date')),
                ('start', models.TimeField(verbose_name='start time')),
                ('end', models.TimeField(verbose_name='end time')),
                ('description', djangocms_text_ckeditor.fields.HTMLField(verbose_name='work description')),
            ],
            options={
                'ordering': ('start',),
                'verbose_name': 'timesheet entry',
                'verbose_name_plural': 'timesheet entries',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name='TimesheetEntryType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'timesheet entry type',
                'verbose_name_plural': 'timesheet entry types',
            },
        ),
        migrations.CreateModel(
            name='TimesheetPeriod',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateField(editable=False, unique=True, verbose_name='start date')),
                ('end', models.DateField(editable=False, unique=True, verbose_name='end date')),
            ],
            options={
                'ordering': ('-start',),
                'verbose_name': 'timesheet period',
                'verbose_name_plural': 'timesheet periods',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Course',
            fields=[
                ('subject_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='leprikon.Subject')),
                ('unit', models.CharField(max_length=150, verbose_name='unit')),
                ('periods', models.ManyToManyField(related_name='courses', to='leprikon.SchoolYearPeriod', verbose_name='periods')),
            ],
            options={
                'ordering': ('name',),
                'verbose_name': 'course',
                'verbose_name_plural': 'courses',
            },
            bases=('leprikon.subject',),
        ),
        migrations.CreateModel(
            name='CourseRegistration',
            fields=[
                ('subjectregistration_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='leprikon.SubjectRegistration')),
            ],
            options={
                'verbose_name': 'course registration',
                'verbose_name_plural': 'course registrations',
            },
            bases=('leprikon.subjectregistration',),
        ),
        migrations.CreateModel(
            name='Event',
            fields=[
                ('subject_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='leprikon.Subject')),
                ('start_date', models.DateField(verbose_name='start date')),
                ('end_date', models.DateField(verbose_name='end date')),
                ('start_time', models.TimeField(blank=True, null=True, verbose_name='start time')),
                ('end_time', models.TimeField(blank=True, null=True, verbose_name='end time')),
            ],
            options={
                'ordering': ('-start_date', 'start_time'),
                'verbose_name': 'event',
                'verbose_name_plural': 'events',
            },
            bases=('leprikon.subject',),
        ),
        migrations.CreateModel(
            name='EventRegistration',
            fields=[
                ('subjectregistration_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='leprikon.SubjectRegistration')),
            ],
            options={
                'verbose_name': 'event registration',
                'verbose_name_plural': 'event registrations',
            },
            bases=('leprikon.subjectregistration',),
        ),
        migrations.AddField(
            model_name='timesheetentry',
            name='entry_type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='entries', to='leprikon.TimesheetEntryType', verbose_name='entry type'),
        ),
        migrations.AddField(
            model_name='timesheetentry',
            name='timesheet',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='timesheet_entries', to='leprikon.Timesheet', verbose_name='timesheet'),
        ),
        migrations.AddField(
            model_name='timesheet',
            name='period',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='timesheets', to='leprikon.TimesheetPeriod', verbose_name='period'),
        ),
        migrations.AddField(
            model_name='subjectregistration',
            name='participant_age_group',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.AgeGroup', verbose_name='age group'),
        ),
        migrations.AddField(
            model_name='subjectregistration',
            name='participant_insurance',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.Insurance', verbose_name='insurance'),
        ),
        migrations.AddField(
            model_name='subjectregistration',
            name='participant_school',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.School', verbose_name='school'),
        ),
        migrations.AddField(
            model_name='subjectregistration',
            name='subject',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='registrations', to='leprikon.Subject', verbose_name='subject'),
        ),
        migrations.AddField(
            model_name='subjectregistration',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='leprikon_registrations', to=settings.AUTH_USER_MODEL, verbose_name='user'),
        ),
        migrations.AddField(
            model_name='subjectpayment',
            name='registration',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='payments', to='leprikon.SubjectRegistration', verbose_name='registration'),
        ),
        migrations.AddField(
            model_name='subjectpayment',
            name='related_payment',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='related_payments', to='leprikon.SubjectPayment', verbose_name='related payment'),
        ),
        migrations.AddField(
            model_name='subjectgroup',
            name='subject_types',
            field=models.ManyToManyField(related_name='groups', to='leprikon.SubjectType', verbose_name='subject type'),
        ),
        migrations.AddField(
            model_name='subjectattachment',
            name='subject',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='leprikon.Subject', verbose_name='subject'),
        ),
        migrations.AddField(
            model_name='subject',
            name='age_groups',
            field=models.ManyToManyField(blank=True, related_name='subjects', to='leprikon.AgeGroup', verbose_name='age groups'),
        ),
        migrations.AddField(
            model_name='subject',
            name='groups',
            field=models.ManyToManyField(blank=True, related_name='subjects', to='leprikon.SubjectGroup', verbose_name='groups'),
        ),
        migrations.AddField(
            model_name='subject',
            name='leaders',
            field=models.ManyToManyField(blank=True, related_name='subjects', to='leprikon.Leader', verbose_name='leaders'),
        ),
        migrations.AddField(
            model_name='subject',
            name='page',
            field=cms.models.fields.PageField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='cms.Page', verbose_name='page'),
        ),
        migrations.AddField(
            model_name='subject',
            name='photo',
            field=filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='filer.Image', verbose_name='photo'),
        ),
        migrations.AddField(
            model_name='subject',
            name='place',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='subjects', to='leprikon.Place', verbose_name='place'),
        ),
        migrations.AddField(
            model_name='subject',
            name='questions',
            field=models.ManyToManyField(blank=True, help_text='Add additional questions to be asked in the registration form.', related_name='_subject_questions_+', to='leprikon.Question', verbose_name='additional questions'),
        ),
        migrations.AddField(
            model_name='subject',
            name='reg_print_setup',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='leprikon.PrintSetup', verbose_name='registration print setup'),
        ),
        migrations.AddField(
            model_name='subject',
            name='school_year',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='subjects', to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AddField(
            model_name='subject',
            name='subject_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='subjects', to='leprikon.SubjectType', verbose_name='subject type'),
        ),
        migrations.AddField(
            model_name='participant',
            name='school',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='participants', to='leprikon.School', verbose_name='school'),
        ),
        migrations.AddField(
            model_name='participant',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='leprikon_participants', to=settings.AUTH_USER_MODEL, verbose_name='user'),
        ),
        migrations.AddField(
            model_name='leprikonsite',
            name='bill_print_setup',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='leprikon.PrintSetup', verbose_name='bill print setup'),
        ),
        migrations.AddField(
            model_name='leprikonsite',
            name='reg_print_setup',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='leprikon.PrintSetup', verbose_name='registration print setup'),
        ),
        migrations.AddField(
            model_name='leaderlistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AddField(
            model_name='leaderlistplugin',
            name='subject',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.Subject', verbose_name='subject'),
        ),
        migrations.AddField(
            model_name='leader',
            name='school_years',
            field=models.ManyToManyField(related_name='leaders', to='leprikon.SchoolYear', verbose_name='school years'),
        ),
        migrations.AddField(
            model_name='leader',
            name='user',
            field=models.OneToOneField(on_delete=django.db.models.deletion.PROTECT, related_name='leprikon_leader', to=settings.AUTH_USER_MODEL, verbose_name='user'),
        ),
        migrations.AddField(
            model_name='filteredleaderlistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AddField(
            model_name='filteredeventlistplugin',
            name='event_types',
            field=models.ManyToManyField(related_name='_filteredeventlistplugin_event_types_+', to='leprikon.SubjectType', verbose_name='event types'),
        ),
        migrations.AddField(
            model_name='filteredeventlistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AddField(
            model_name='filteredcourselistplugin',
            name='course_types',
            field=models.ManyToManyField(related_name='_filteredcourselistplugin_course_types_+', to='leprikon.SubjectType', verbose_name='course types'),
        ),
        migrations.AddField(
            model_name='filteredcourselistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AddField(
            model_name='eventlistplugin',
            name='event_types',
            field=models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by event types.', related_name='_eventlistplugin_event_types_+', to='leprikon.SubjectType', verbose_name='event types'),
        ),
        migrations.AddField(
            model_name='eventlistplugin',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by groups.', related_name='_eventlistplugin_groups_+', to='leprikon.SubjectGroup', verbose_name='event groups'),
        ),
        migrations.AddField(
            model_name='eventlistplugin',
            name='leaders',
            field=models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by leaders.', related_name='_eventlistplugin_leaders_+', to='leprikon.Leader', verbose_name='leaders'),
        ),
        migrations.AddField(
            model_name='eventlistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AddField(
            model_name='courselistplugin',
            name='course_types',
            field=models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by course types.', related_name='_courselistplugin_course_types_+', to='leprikon.SubjectType', verbose_name='course types'),
        ),
        migrations.AddField(
            model_name='courselistplugin',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by groups.', related_name='_courselistplugin_groups_+', to='leprikon.SubjectGroup', verbose_name='course groups'),
        ),
        migrations.AddField(
            model_name='courselistplugin',
            name='leaders',
            field=models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by leaders.', related_name='_courselistplugin_leaders_+', to='leprikon.Leader', verbose_name='leaders'),
        ),
        migrations.AddField(
            model_name='courselistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AddField(
            model_name='coursejournalleaderentry',
            name='timesheet',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='course_entries', to='leprikon.Timesheet', verbose_name='timesheet'),
        ),
        migrations.AddField(
            model_name='coursediscount',
            name='period',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='discounts', to='leprikon.SchoolYearPeriod', verbose_name='period'),
        ),
        migrations.AddField(
            model_name='contact',
            name='leader',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='contacts', to='leprikon.Leader', verbose_name='leader'),
        ),
        migrations.AlterUniqueTogether(
            name='timesheet',
            unique_together=set([('period', 'leader')]),
        ),
        migrations.AlterUniqueTogether(
            name='subjectregistration',
            unique_together=set([('subject', 'participant_birth_num')]),
        ),
        migrations.AlterUniqueTogether(
            name='participant',
            unique_together=set([('user', 'birth_num')]),
        ),
        migrations.AlterUniqueTogether(
            name='messagerecipient',
            unique_together=set([('message', 'recipient')]),
        ),
        migrations.AddField(
            model_name='eventplugin',
            name='event',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.Event', verbose_name='event'),
        ),
        migrations.AddField(
            model_name='eventdiscount',
            name='registration',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='discounts', to='leprikon.EventRegistration', verbose_name='registration'),
        ),
        migrations.AddField(
            model_name='coursetime',
            name='course',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='times', to='leprikon.Course', verbose_name='course'),
        ),
        migrations.AddField(
            model_name='courseregistrationhistory',
            name='course',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='registrations_history', to='leprikon.Course', verbose_name='course'),
        ),
        migrations.AddField(
            model_name='courseregistrationhistory',
            name='registration',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='course_history', to='leprikon.CourseRegistration', verbose_name='course'),
        ),
        migrations.AddField(
            model_name='courseplugin',
            name='course',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.Course', verbose_name='course'),
        ),
        migrations.AlterUniqueTogether(
            name='coursejournalleaderentry',
            unique_together=set([('course_entry', 'timesheet')]),
        ),
        migrations.AddField(
            model_name='coursejournalentry',
            name='course',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='journal_entries', to='leprikon.Course', verbose_name='course'),
        ),
        migrations.AddField(
            model_name='coursejournalentry',
            name='registrations',
            field=models.ManyToManyField(blank=True, related_name='journal_entries', to='leprikon.CourseRegistration', verbose_name='participants'),
        ),
        migrations.AddField(
            model_name='coursediscount',
            name='registration',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='discounts', to='leprikon.CourseRegistration', verbose_name='registration'),
        ),
    ]
