# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2017-10-31 22:56
from __future__ import unicode_literals

from django.db import migrations, models

from ..models.utils import generate_variable_symbol


def generate_variable_symbols(apps, schema_editor):
    SubjectRegistration = apps.get_model('leprikon', 'SubjectRegistration')
    for registration in SubjectRegistration.objects.all():
        registration.variable_symbol = generate_variable_symbol(registration)
        registration.save()


class Migration(migrations.Migration):

    dependencies = [
        ('leprikon', '0004_multiple_registrations'),
    ]

    operations = [
        migrations.AddField(
            model_name='subjectregistration',
            name='variable_symbol',
            field=models.IntegerField(db_index=True, editable=False, null=True, verbose_name='variable symbol'),
        ),
        migrations.RunPython(generate_variable_symbols),
    ]
