# -*- coding: utf-8 -*-
# Generated by Django 1.9.4 on 2016-03-26 11:09
from __future__ import unicode_literals

import cms.models.fields
from django.db import migrations, models
from leprikon.conf import settings
import django.db.models.deletion
import djangocms_text_ckeditor.fields
import filer.fields.file
import filer.fields.image
import leprikon.models.courses
import leprikon.models.fields
import leprikon.models.startend


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('cms', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('filer', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AgeGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='name')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'age group',
                'verbose_name_plural': 'age groups',
            },
        ),
        migrations.CreateModel(
            name='Club',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('description', djangocms_text_ckeditor.fields.HTMLField(blank=True, default='', verbose_name='description')),
                ('price', leprikon.models.fields.PriceField(decimal_places=0, max_digits=10, verbose_name='price')),
                ('unit', models.CharField(max_length=150, verbose_name='unit')),
                ('public', models.BooleanField(default=False, verbose_name='public')),
                ('reg_active', models.BooleanField(default=False, verbose_name='active registration')),
                ('min_count', models.IntegerField(blank=True, null=True, verbose_name='minimal count')),
                ('max_count', models.IntegerField(blank=True, null=True, verbose_name='maximal count')),
                ('risks', djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name='risks')),
                ('plan', djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name='plan')),
                ('evaluation', djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name='evaluation')),
                ('note', models.CharField(blank=True, default='', max_length=300, verbose_name='note')),
                ('age_groups', models.ManyToManyField(blank=True, related_name='clubs', to='leprikon.AgeGroup', verbose_name='age groups')),
            ],
            options={
                'ordering': ('name',),
                'verbose_name': 'club',
                'verbose_name_plural': 'clubs',
            },
        ),
        migrations.CreateModel(
            name='ClubAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
                ('club', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='leprikon.Club', verbose_name='club')),
                ('file', filer.fields.file.FilerFileField(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='filer.File')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'attachment',
                'verbose_name_plural': 'attachments',
            },
        ),
        migrations.CreateModel(
            name='ClubGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('plural', models.CharField(max_length=150, verbose_name='plural')),
                ('color', leprikon.models.fields.ColorField(max_length=10, verbose_name='color')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'club group',
                'verbose_name_plural': 'club groups',
            },
        ),
        migrations.CreateModel(
            name='ClubJournalEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(verbose_name='date')),
                ('start', models.TimeField(blank=True, help_text='Leave empty, if the club does not take place', null=True, verbose_name='start time')),
                ('end', models.TimeField(blank=True, help_text='Leave empty, if the club does not take place', null=True, verbose_name='end time')),
                ('agenda', djangocms_text_ckeditor.fields.HTMLField(default=leprikon.models.courses.get_default_agenda, verbose_name='session agenda')),
                ('club', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='journal_entries', to='leprikon.Club', verbose_name='club')),
            ],
            options={
                'ordering': ('date', 'start', 'end'),
                'verbose_name': 'journal entry',
                'verbose_name_plural': 'journal entries',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name='ClubJournalLeaderEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.TimeField(verbose_name='start time')),
                ('end', models.TimeField(verbose_name='end time')),
                ('club_entry', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='leader_entries', to='leprikon.ClubJournalEntry', verbose_name='club journal entry')),
            ],
            options={
                'verbose_name': 'club journal leader entry',
                'verbose_name_plural': 'club journal leader entries',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name='ClubPayment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(verbose_name='payment date')),
                ('amount', leprikon.models.fields.PriceField(decimal_places=0, max_digits=10, verbose_name='amount')),
            ],
            options={
                'verbose_name': 'club payment',
                'verbose_name_plural': 'club payments',
            },
        ),
        migrations.CreateModel(
            name='ClubPeriod',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('start', models.DateField(verbose_name='start date')),
                ('end', models.DateField(verbose_name='end date')),
                ('club', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='periods', to='leprikon.Club', verbose_name='club')),
            ],
            options={
                'ordering': ('club__name', 'start'),
                'verbose_name': 'period',
                'verbose_name_plural': 'periods',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name='ClubRegistration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField(editable=False)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='time of registration')),
                ('citizenship', models.CharField(max_length=50, verbose_name='citizenship')),
                ('insurance', models.CharField(max_length=50, verbose_name='insurance')),
                ('school_other', models.CharField(blank=True, default='', max_length=150, verbose_name='other school')),
                ('school_class', models.CharField(blank=True, default='', max_length=30, verbose_name='class')),
                ('health', models.TextField(blank=True, default='', verbose_name='health')),
                ('answers', models.TextField(blank=True, default='{}', editable=False, verbose_name='additional answers')),
                ('cancel_request', models.BooleanField(default=False, verbose_name='cancel request')),
                ('canceled', models.DateField(blank=True, null=True, verbose_name='date of cancellation')),
                ('discount', leprikon.models.fields.PriceField(decimal_places=0, default=0, max_digits=10, verbose_name='discount')),
                ('explanation', models.TextField(blank=True, default='', verbose_name='discount explanation')),
                ('age_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.AgeGroup', verbose_name='age group')),
                ('club', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='registrations', to='leprikon.Club', verbose_name='club')),
            ],
            options={
                'verbose_name': 'club registration',
                'verbose_name_plural': 'club registrations',
            },
        ),
        migrations.CreateModel(
            name='ClubTime',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('day_of_week', leprikon.models.fields.DayOfWeekField(choices=[(1, 'Monday'), (2, 'Tuesday'), (3, 'Wednesday'), (4, 'Thursday'), (5, 'Friday'), (6, 'Saturday'), (7, 'Sunday')], verbose_name='day of week')),
                ('start', models.TimeField(blank=True, null=True, verbose_name='start time')),
                ('end', models.TimeField(blank=True, null=True, verbose_name='end time')),
                ('club', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='times', to='leprikon.Club', verbose_name='club')),
            ],
            options={
                'ordering': ('day_of_week', 'start'),
                'verbose_name': 'time',
                'verbose_name_plural': 'times',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Contact',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('contact_type', models.CharField(choices=[('email', 'email'), ('phone', 'phone'), ('url', 'url')], max_length=30, verbose_name='contact type')),
                ('contact', models.CharField(max_length=250, verbose_name='contact')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
                ('public', models.BooleanField(default=False, verbose_name='public')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'contact',
                'verbose_name_plural': 'contacts',
            },
        ),
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('description', djangocms_text_ckeditor.fields.HTMLField(blank=True, default='', verbose_name='description')),
                ('start_date', models.DateField(verbose_name='start date')),
                ('end_date', models.DateField(verbose_name='end date')),
                ('start_time', models.TimeField(blank=True, null=True, verbose_name='start time')),
                ('end_time', models.TimeField(blank=True, null=True, verbose_name='end time')),
                ('price', leprikon.models.fields.PriceField(decimal_places=0, max_digits=10, verbose_name='price')),
                ('public', models.BooleanField(default=False, verbose_name='public')),
                ('reg_active', models.BooleanField(default=False, verbose_name='active registration')),
                ('min_count', models.IntegerField(blank=True, null=True, verbose_name='minimal count')),
                ('max_count', models.IntegerField(blank=True, null=True, verbose_name='maximal count')),
                ('risks', djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name='risks')),
                ('plan', djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name='plan')),
                ('evaluation', djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name='evaluation')),
                ('note', models.CharField(blank=True, default='', max_length=300, verbose_name='note')),
                ('age_groups', models.ManyToManyField(blank=True, related_name='events', to='leprikon.AgeGroup', verbose_name='age groups')),
            ],
            options={
                'ordering': ('start_date', 'start_time'),
                'verbose_name': 'event',
                'verbose_name_plural': 'events',
            },
        ),
        migrations.CreateModel(
            name='EventAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
                ('event', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='leprikon.Event', verbose_name='event')),
                ('file', filer.fields.file.FilerFileField(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='filer.File')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'attachment',
                'verbose_name_plural': 'attachments',
            },
        ),
        migrations.CreateModel(
            name='EventGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('plural', models.CharField(max_length=150, verbose_name='plural')),
                ('color', leprikon.models.fields.ColorField(max_length=10, verbose_name='color')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'event group',
                'verbose_name_plural': 'event groups',
            },
        ),
        migrations.CreateModel(
            name='EventPayment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(verbose_name='payment date')),
                ('amount', leprikon.models.fields.PriceField(decimal_places=0, max_digits=10, verbose_name='amount')),
            ],
            options={
                'verbose_name': 'event payment',
                'verbose_name_plural': 'event payments',
            },
        ),
        migrations.CreateModel(
            name='EventRegistration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField(editable=False)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='time of registration')),
                ('citizenship', models.CharField(max_length=50, verbose_name='citizenship')),
                ('insurance', models.CharField(max_length=50, verbose_name='insurance')),
                ('school_other', models.CharField(blank=True, default='', max_length=150, verbose_name='other school')),
                ('school_class', models.CharField(blank=True, default='', max_length=30, verbose_name='class')),
                ('health', models.TextField(blank=True, default='', verbose_name='health')),
                ('answers', models.TextField(blank=True, default='{}', editable=False, verbose_name='additional answers')),
                ('cancel_request', models.BooleanField(default=False, verbose_name='cancel request')),
                ('canceled', models.DateField(blank=True, null=True, verbose_name='date of cancellation')),
                ('discount', leprikon.models.fields.PriceField(decimal_places=0, default=0, max_digits=10, verbose_name='discount')),
                ('explanation', models.TextField(blank=True, default='', verbose_name='discount explanation')),
                ('age_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.AgeGroup', verbose_name='age group')),
                ('event', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='registrations', to='leprikon.Event', verbose_name='event')),
            ],
            options={
                'verbose_name': 'event registration',
                'verbose_name_plural': 'event registrations',
            },
        ),
        migrations.CreateModel(
            name='EventType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField()),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'event type',
                'verbose_name_plural': 'event types',
            },
        ),
        migrations.CreateModel(
            name='EventTypeAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
                ('event', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='leprikon.EventType', verbose_name='event type')),
                ('file', filer.fields.file.FilerFileField(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='filer.File')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'attachment',
                'verbose_name_plural': 'attachments',
            },
        ),
        migrations.CreateModel(
            name='Leader',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', djangocms_text_ckeditor.fields.HTMLField(blank=True, default='', verbose_name='description')),
                ('page', cms.models.fields.PageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='cms.Page', verbose_name='page')),
                ('photo', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='filer.Image', verbose_name='photo')),
            ],
            options={
                'ordering': ('user__first_name', 'user__last_name'),
                'verbose_name': 'leader',
                'verbose_name_plural': 'leaders',
            },
        ),
        migrations.CreateModel(
            name='LeprikonClubListPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cms.CMSPlugin')),
                ('template', models.CharField(choices=[('default', 'Default'), ('grouped', 'Grouped by club groups')], default='default', help_text='The template used to render plugin.', max_length=100, verbose_name='template')),
                ('age_groups', models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by age groups.', to='leprikon.AgeGroup', verbose_name='age groups')),
                ('groups', models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by groups.', to='leprikon.ClubGroup', verbose_name='club groups')),
                ('leaders', models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by leaders.', to='leprikon.Leader', verbose_name='leaders')),
            ],
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='LeprikonEventListPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cms.CMSPlugin')),
                ('template', models.CharField(choices=[('default', 'Default'), ('grouped', 'Grouped by event groups')], default='default', help_text='The template used to render plugin.', max_length=100, verbose_name='template')),
                ('age_groups', models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by age groups.', to='leprikon.AgeGroup', verbose_name='age groups')),
                ('event_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='leprikon.EventType', verbose_name='event type')),
                ('groups', models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by groups.', to='leprikon.EventGroup', verbose_name='event groups')),
                ('leaders', models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by leaders.', to='leprikon.Leader', verbose_name='leaders')),
            ],
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='LeprikonFilteredClubListPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cms.CMSPlugin')),
            ],
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='LeprikonFilteredEventListPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cms.CMSPlugin')),
                ('event_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='leprikon.EventType', verbose_name='event type')),
            ],
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='Parent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(max_length=30, verbose_name='last name')),
                ('street', models.CharField(max_length=150, verbose_name='street')),
                ('city', models.CharField(max_length=150, verbose_name='city')),
                ('postal_code', leprikon.models.fields.PostalCodeField(verbose_name='postal code')),
                ('email', models.EmailField(blank=True, default='', max_length=254, verbose_name='email address')),
                ('phone', models.CharField(max_length=30, verbose_name='phone')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='leprikon_parents', to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'verbose_name': 'parent',
                'verbose_name_plural': 'parents',
            },
        ),
        migrations.CreateModel(
            name='Participant',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(max_length=30, verbose_name='last name')),
                ('birth_num', leprikon.models.fields.BirthNumberField(unique=True, verbose_name='birth number')),
                ('street', models.CharField(max_length=150, verbose_name='street')),
                ('city', models.CharField(max_length=150, verbose_name='city')),
                ('postal_code', leprikon.models.fields.PostalCodeField(verbose_name='postal code')),
                ('email', models.EmailField(blank=True, default='', max_length=254, verbose_name='email address')),
                ('phone', models.CharField(blank=True, default='', max_length=30, verbose_name='phone')),
                ('citizenship', models.CharField(max_length=50, verbose_name='citizenship')),
                ('insurance', models.CharField(max_length=50, verbose_name='insurance')),
                ('school_other', models.CharField(blank=True, default='', max_length=150, verbose_name='other school')),
                ('school_class', models.CharField(blank=True, default='', max_length=30, verbose_name='class')),
                ('health', models.TextField(blank=True, default='', verbose_name='health')),
                ('age_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.AgeGroup', verbose_name='age group')),
                ('parents', models.ManyToManyField(blank=True, related_name='participants', to='leprikon.Parent', verbose_name='parents')),
            ],
            options={
                'verbose_name': 'participant',
                'verbose_name_plural': 'participants',
            },
        ),
        migrations.CreateModel(
            name='Place',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='name')),
                ('place', models.CharField(blank=True, default='', max_length=50, verbose_name='place')),
            ],
            options={
                'ordering': ('place',),
                'verbose_name': 'place',
                'verbose_name_plural': 'places',
            },
        ),
        migrations.CreateModel(
            name='Question',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, unique=True, verbose_name='name')),
                ('question', models.CharField(max_length=50, verbose_name='question')),
                ('help_text', models.TextField(blank=True, help_text='This is help text. The help text is shown next to the form field.', null=True, verbose_name='help text')),
                ('field', models.CharField(choices=((key, val['name']) for key, val in settings.LEPRIKON_QUESTION_FIELDS.items()), max_length=150, verbose_name='field')),
                ('field_args', models.TextField(blank=True, default='{}', help_text='Enter valid JSON structure representing field configuration.', verbose_name='field_args')),
            ],
            options={
                'verbose_name': 'additional question',
                'verbose_name_plural': 'additional questions',
            },
        ),
        migrations.CreateModel(
            name='School',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='name')),
                ('street', models.CharField(blank=True, default='', max_length=50, verbose_name='street')),
                ('city', models.CharField(blank=True, default='', max_length=50, verbose_name='city')),
            ],
            options={
                'ordering': ('city', 'name'),
                'verbose_name': 'school',
                'verbose_name_plural': 'schools',
            },
        ),
        migrations.CreateModel(
            name='SchoolYear',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('year', models.IntegerField(unique=True, verbose_name='year')),
                ('active', models.BooleanField(default=False, verbose_name='active')),
            ],
            options={
                'ordering': ('-year',),
                'verbose_name': 'school year',
                'verbose_name_plural': 'school years',
            },
        ),
        migrations.CreateModel(
            name='Timesheet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('submitted', models.BooleanField(default=False, verbose_name='submitted')),
                ('paid', models.BooleanField(default=False, verbose_name='paid')),
                ('leader', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='timesheets', to='leprikon.Leader', verbose_name='leader')),
            ],
            options={
                'ordering': ('-period__start',),
                'verbose_name': 'timesheet',
                'verbose_name_plural': 'timesheets',
            },
        ),
        migrations.CreateModel(
            name='TimesheetEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(verbose_name='date')),
                ('start', models.TimeField(verbose_name='start time')),
                ('end', models.TimeField(verbose_name='end time')),
                ('description', djangocms_text_ckeditor.fields.HTMLField(verbose_name='work description')),
            ],
            options={
                'ordering': ('start',),
                'verbose_name': 'timesheet entry',
                'verbose_name_plural': 'timesheet entries',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name='TimesheetEntryType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'timesheet entry type',
                'verbose_name_plural': 'timesheet entry types',
            },
        ),
        migrations.CreateModel(
            name='TimesheetPeriod',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateField(editable=False, unique=True, verbose_name='start date')),
                ('end', models.DateField(editable=False, unique=True, verbose_name='end date')),
            ],
            options={
                'ordering': ('-start',),
                'verbose_name': 'timesheet period',
                'verbose_name_plural': 'timesheet periods',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.AddField(
            model_name='timesheetentry',
            name='entry_type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='entries', to='leprikon.TimesheetEntryType', verbose_name='entry type'),
        ),
        migrations.AddField(
            model_name='timesheetentry',
            name='timesheet',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='timesheet_entries', to='leprikon.Timesheet', verbose_name='timesheet'),
        ),
        migrations.AddField(
            model_name='timesheet',
            name='period',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='timesheets', to='leprikon.TimesheetPeriod', verbose_name='period'),
        ),
        migrations.AddField(
            model_name='participant',
            name='school',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='participants', to='leprikon.School', verbose_name='school'),
        ),
        migrations.AddField(
            model_name='participant',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='leprikon_participants', to=settings.AUTH_USER_MODEL, verbose_name='user'),
        ),
        migrations.AddField(
            model_name='leprikonfilteredeventlistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AddField(
            model_name='leprikonfilteredclublistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AddField(
            model_name='leprikoneventlistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AddField(
            model_name='leprikonclublistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AddField(
            model_name='leader',
            name='school_years',
            field=models.ManyToManyField(related_name='leaders', to='leprikon.SchoolYear', verbose_name='school years'),
        ),
        migrations.AddField(
            model_name='leader',
            name='user',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='leprikon_leader', to=settings.AUTH_USER_MODEL, verbose_name='user'),
        ),
        migrations.AddField(
            model_name='eventtype',
            name='questions',
            field=models.ManyToManyField(blank=True, help_text='Add additional questions to be asked in the registration form.', to='leprikon.Question', verbose_name='additional questions'),
        ),
        migrations.AddField(
            model_name='eventregistration',
            name='participant',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='event_registrations', to='leprikon.Participant', verbose_name='participant'),
        ),
        migrations.AddField(
            model_name='eventregistration',
            name='school',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='event_registrations', to='leprikon.School', verbose_name='school'),
        ),
        migrations.AddField(
            model_name='eventpayment',
            name='registration',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='payments', to='leprikon.EventRegistration', verbose_name='registration'),
        ),
        migrations.AddField(
            model_name='event',
            name='event_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='events', to='leprikon.EventType', verbose_name='event type'),
        ),
        migrations.AddField(
            model_name='event',
            name='groups',
            field=models.ManyToManyField(related_name='events', to='leprikon.EventGroup', verbose_name='groups'),
        ),
        migrations.AddField(
            model_name='event',
            name='leaders',
            field=models.ManyToManyField(blank=True, related_name='events', to='leprikon.Leader', verbose_name='leaders'),
        ),
        migrations.AddField(
            model_name='event',
            name='page',
            field=cms.models.fields.PageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='cms.Page', verbose_name='page'),
        ),
        migrations.AddField(
            model_name='event',
            name='photo',
            field=filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='filer.Image', verbose_name='photo'),
        ),
        migrations.AddField(
            model_name='event',
            name='place',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='events', to='leprikon.Place', verbose_name='place'),
        ),
        migrations.AddField(
            model_name='event',
            name='questions',
            field=models.ManyToManyField(blank=True, help_text='Add additional questions to be asked in the registration form.', to='leprikon.Question', verbose_name='additional questions'),
        ),
        migrations.AddField(
            model_name='event',
            name='school_year',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='events', to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AddField(
            model_name='contact',
            name='leader',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='contacts', to='leprikon.Leader', verbose_name='leader'),
        ),
        migrations.AddField(
            model_name='clubregistration',
            name='participant',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='club_registrations', to='leprikon.Participant', verbose_name='participant'),
        ),
        migrations.AddField(
            model_name='clubregistration',
            name='school',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='club_registrations', to='leprikon.School', verbose_name='school'),
        ),
        migrations.AddField(
            model_name='clubpayment',
            name='registration',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='payments', to='leprikon.ClubRegistration', verbose_name='registration'),
        ),
        migrations.AddField(
            model_name='clubjournalleaderentry',
            name='timesheet',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='club_entries', to='leprikon.Timesheet', verbose_name='timesheet'),
        ),
        migrations.AddField(
            model_name='clubjournalentry',
            name='participants',
            field=models.ManyToManyField(blank=True, related_name='journal_entries', to='leprikon.Participant', verbose_name='participants'),
        ),
        migrations.AddField(
            model_name='club',
            name='groups',
            field=models.ManyToManyField(related_name='clubs', to='leprikon.ClubGroup', verbose_name='groups'),
        ),
        migrations.AddField(
            model_name='club',
            name='leaders',
            field=models.ManyToManyField(blank=True, related_name='clubs', to='leprikon.Leader', verbose_name='leaders'),
        ),
        migrations.AddField(
            model_name='club',
            name='page',
            field=cms.models.fields.PageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='cms.Page', verbose_name='page'),
        ),
        migrations.AddField(
            model_name='club',
            name='photo',
            field=filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='filer.Image', verbose_name='photo'),
        ),
        migrations.AddField(
            model_name='club',
            name='place',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clubs', to='leprikon.Place', verbose_name='place'),
        ),
        migrations.AddField(
            model_name='club',
            name='questions',
            field=models.ManyToManyField(blank=True, help_text='Add additional questions to be asked in the registration form.', to='leprikon.Question', verbose_name='additional questions'),
        ),
        migrations.AddField(
            model_name='club',
            name='school_year',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='clubs', to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AlterUniqueTogether(
            name='timesheet',
            unique_together=set([('period', 'leader')]),
        ),
        migrations.AlterUniqueTogether(
            name='eventregistration',
            unique_together=set([('event', 'participant')]),
        ),
        migrations.AlterUniqueTogether(
            name='clubregistration',
            unique_together=set([('club', 'participant')]),
        ),
        migrations.AlterUniqueTogether(
            name='clubjournalleaderentry',
            unique_together=set([('club_entry', 'timesheet')]),
        ),
    ]
