# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-04-23 10:23
from __future__ import unicode_literals

from django.db import migrations, models


def migrate_parents(apps, schema_editor):
    from datetime import date, timedelta

    ClubRegistration    = apps.get_model('leprikon', 'ClubRegistration')
    EventRegistration   = apps.get_model('leprikon', 'EventRegistration')

    for regs in ClubRegistration.objects.all(), EventRegistration.objects.all():
        for reg in regs:
            reg.parents = reg.participant.parents.all()


class Migration(migrations.Migration):

    dependencies = [
        ('leprikon', '0002_messages'),
    ]

    operations = [
        migrations.AddField(
            model_name='clubregistration',
            name='parents',
            field=models.ManyToManyField(blank=True, related_name='club_registrations', to='leprikon.Parent', verbose_name='parents'),
        ),
        migrations.AddField(
            model_name='eventregistration',
            name='parents',
            field=models.ManyToManyField(blank=True, related_name='event_registrations', to='leprikon.Parent', verbose_name='parents'),
        ),
        migrations.RunPython(migrate_parents),
        migrations.RemoveField(
            model_name='participant',
            name='parents',
        ),
    ]
