# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-04-25 14:03
from __future__ import unicode_literals

from django.db import migrations, models


def migrate_event_list_plugins(apps, schema_editor):
    from datetime import date, timedelta

    LeprikonFilteredEventListPlugin = apps.get_model('leprikon', 'LeprikonFilteredEventListPlugin')

    for plugin in LeprikonFilteredEventListPlugin.objects.all():
        plugin.event_types.add(plugin.event_type)


class Migration(migrations.Migration):

    dependencies = [
        ('leprikon', '0003_parents'),
    ]

    operations = [
        migrations.AddField(
            model_name='leprikonfilteredeventlistplugin',
            name='event_types',
            field=models.ManyToManyField(to='leprikon.EventType', verbose_name='event type'),
        ),
        migrations.RunPython(migrate_event_list_plugins),
        migrations.RemoveField(
            model_name='leprikonfilteredeventlistplugin',
            name='event_type',
        ),
    ]
