# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-06-03 06:18
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


def fix_message_dates(apps, schema_editor):
    from datetime import date, timedelta

    MessageRecipient = apps.get_model('leprikon', 'MessageRecipient')

    for rec in MessageRecipient.objects.all():
        rec.sent_mail = rec.sent
        rec.save()


class Migration(migrations.Migration):

    dependencies = [
        ('leprikon', '0006_deletable_pages'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='message',
            options={'ordering': ('-created',), 'verbose_name': 'message', 'verbose_name_plural': 'messages'},
        ),
        migrations.AlterModelOptions(
            name='messagerecipient',
            options={'ordering': ('sent',), 'verbose_name': 'recipient', 'verbose_name_plural': 'recipients'},
        ),
        migrations.RenameField(
            model_name='message',
            old_name='sent',
            new_name='created',
        ),
        migrations.AlterField(
            model_name='message',
            name='created',
            field=models.DateTimeField(auto_now_add=True, verbose_name='created'),
        ),
        migrations.AlterField(
            model_name='messagerecipient',
            name='message',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='recipients', to='leprikon.Message', verbose_name='message'),
        ),
        migrations.AlterField(
            model_name='messagerecipient',
            name='recipient',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='leprikon_messages', to=settings.AUTH_USER_MODEL, verbose_name='recipient'),
        ),
        migrations.RenameField(
            model_name='messagerecipient',
            old_name='received',
            new_name='viewed',
        ),
        migrations.AlterField(
            model_name='messagerecipient',
            name='viewed',
            field=models.DateTimeField(default=None, editable=False, null=True, verbose_name='viewed on site'),
        ),
        migrations.AddField(
            model_name='messagerecipient',
            name='sent_mail',
            field=models.DateTimeField(default=None, editable=False, null=True, verbose_name='sent by email'),
        ),
        migrations.RunPython(fix_message_dates),
    ]
