# -*- coding: utf-8 -*-
# Generated by Django 1.9.9 on 2016-09-05 15:44
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('leprikon', '0010_club_discounts'),
    ]

    operations = [
        migrations.CreateModel(
            name='ClubRegistrationRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='time of request')),
                ('contact', models.CharField(help_text='Enter phone number, e-mail address or other contact.', max_length=150, verbose_name='contact')),
                ('club', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='registration_requests', to='leprikon.Club', verbose_name='club')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='club_registration_requests', to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'ordering': ('created',),
                'verbose_name': 'club registration request',
                'verbose_name_plural': 'club registration requests',
            },
        ),
        migrations.CreateModel(
            name='EventRegistrationRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='time of request')),
                ('contact', models.CharField(help_text='Enter phone number, e-mail address or other contact.', max_length=150, verbose_name='contact')),
                ('event', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='registration_requests', to='leprikon.Event', verbose_name='event')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='event_registration_requests', to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'ordering': ('created',),
                'verbose_name': 'event registration request',
                'verbose_name_plural': 'event registration requests',
            },
        ),
        migrations.AlterUniqueTogether(
            name='eventregistrationrequest',
            unique_together=set([('user', 'event')]),
        ),
        migrations.AlterUniqueTogether(
            name='clubregistrationrequest',
            unique_together=set([('user', 'club')]),
        ),
    ]
