# -*- coding: utf-8 -*-
# Generated by Django 1.9.9 on 2016-11-10 21:21
from __future__ import unicode_literals

from django.db import migrations, models


def set_gender(apps, schema_editor):

    Participant = apps.get_model('leprikon', 'Participant')

    for participant in Participant.objects.all():
        if participant.birth_num[2:4] > '50':
            participant.gender = 'f'
            participant.save()


class Migration(migrations.Migration):

    dependencies = [
        ('leprikon', '0013_allow_duplicit_participants'),
    ]

    operations = [
        migrations.AddField(
            model_name='participant',
            name='gender',
            field=models.CharField(choices=[('m', 'male'), ('f', 'female')], default='m', editable=False, max_length=1, verbose_name='gender'),
        ),
        migrations.RunPython(set_gender),
        migrations.AlterField(
            model_name='participant',
            name='gender',
            field=models.CharField(choices=[('m', 'male'), ('f', 'female')], editable=False, max_length=1, verbose_name='gender'),
        ),
    ]
