# -*- coding: utf-8 -*-
# Generated by Django 1.9.9 on 2016-11-25 09:15
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import leprikon.models.fields


def populate_registrations(apps, schema_editor):
    for model_name in ['ClubRegistration', 'EventRegistration']:
        Model = apps.get_model('leprikon', model_name)

        for reg in Model.objects.all():
            reg.user = reg.participant.user
            for attr in ['birth_num', 'first_name', 'last_name', 'street', 'city', 'postal_code', 'phone', 'email', 'gender']:
                setattr(reg, 'participant_{}'.format(attr), getattr(reg.participant, attr))
            for n, parent in enumerate(reg.parents.all()[:2]):
                setattr(reg, 'has_parent{}'.format(n+1), True)
                for attr in ['first_name', 'last_name', 'street', 'city', 'postal_code', 'phone', 'email']:
                    setattr(reg, 'parent{}_{}'.format(n+1, attr), getattr(parent, attr))
            reg.save()


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('leprikon', '0018_insurance_cleanup'),
    ]

    operations = [
        migrations.AlterField(
            model_name='clubjournalleaderentry',
            name='timesheet',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='club_entries', to='leprikon.Timesheet', verbose_name='timesheet'),
        ),
        migrations.AlterField(
            model_name='timesheetentry',
            name='timesheet',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='timesheet_entries', to='leprikon.Timesheet', verbose_name='timesheet'),
        ),
    ]
    for model_name in ['clubregistration', 'eventregistration']:
        for field in ['age_group', 'insurance', 'citizenship', 'school', 'school_other', 'school_class', 'health']:
            operations.append(
                migrations.RenameField(
                    model_name=model_name,
                    old_name=field,
                    new_name='participant_{}'.format(field),
                )
            )
        operations += [
            migrations.AlterField(
                model_name=model_name,
                name='participant_age_group',
                field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.AgeGroup', verbose_name='age group'),
            ),
            migrations.AlterField(
                model_name=model_name,
                name='participant_insurance',
                field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.Insurance', verbose_name='insurance'),
            ),
            migrations.AlterField(
                model_name=model_name,
                name='participant_school',
                field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.School', verbose_name='school'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='user',
                field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='leprikon_{}s'.format(model_name), to=settings.AUTH_USER_MODEL, verbose_name='user'),
                preserve_default=False,
            ),
            migrations.AddField(
                model_name=model_name,
                name='participant_birth_num',
                field=leprikon.models.fields.BirthNumberField(default='', verbose_name='birth number'),
                preserve_default=False,
            ),
            migrations.AddField(
                model_name=model_name,
                name='participant_gender',
                field=models.CharField(choices=[('m', 'male'), ('f', 'female')], default='', editable=False, max_length=1, verbose_name='gender'),
                preserve_default=False,
            ),
            migrations.AddField(
                model_name=model_name,
                name='participant_first_name',
                field=models.CharField(default='', max_length=30, verbose_name='first name'),
                preserve_default=False,
            ),
            migrations.AddField(
                model_name=model_name,
                name='participant_last_name',
                field=models.CharField(default='', max_length=30, verbose_name='last name'),
                preserve_default=False,
            ),
            migrations.AddField(
                model_name=model_name,
                name='participant_street',
                field=models.CharField(default='', max_length=150, verbose_name='street'),
                preserve_default=False,
            ),
            migrations.AddField(
                model_name=model_name,
                name='participant_city',
                field=models.CharField(default='', max_length=150, verbose_name='city'),
                preserve_default=False,
            ),
            migrations.AddField(
                model_name=model_name,
                name='participant_postal_code',
                field=leprikon.models.fields.PostalCodeField(default='', verbose_name='postal code'),
                preserve_default=False,
            ),
            migrations.AddField(
                model_name=model_name,
                name='participant_phone',
                field=models.CharField(blank=True, default='', max_length=30, verbose_name='phone'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='participant_email',
                field=models.EmailField(blank=True, default='', max_length=254, verbose_name='email address'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='has_parent1',
                field=models.BooleanField(default=False, verbose_name='first parent'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='parent1_first_name',
                field=models.CharField(blank=True, max_length=30, null=True, verbose_name='first name'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='parent1_last_name',
                field=models.CharField(blank=True, max_length=30, null=True, verbose_name='last name'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='parent1_street',
                field=models.CharField(blank=True, max_length=150, null=True, verbose_name='street'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='parent1_city',
                field=models.CharField(blank=True, max_length=150, null=True, verbose_name='city'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='parent1_postal_code',
                field=leprikon.models.fields.PostalCodeField(blank=True, null=True, verbose_name='postal code'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='parent1_phone',
                field=models.CharField(blank=True, max_length=30, null=True, verbose_name='phone'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='parent1_email',
                field=models.EmailField(blank=True, max_length=254, null=True, verbose_name='email address'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='has_parent2',
                field=models.BooleanField(default=False, verbose_name='second parent'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='parent2_first_name',
                field=models.CharField(blank=True, max_length=30, null=True, verbose_name='first name'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='parent2_last_name',
                field=models.CharField(blank=True, max_length=30, null=True, verbose_name='last name'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='parent2_street',
                field=models.CharField(blank=True, max_length=150, null=True, verbose_name='street'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='parent2_city',
                field=models.CharField(blank=True, max_length=150, null=True, verbose_name='city'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='parent2_postal_code',
                field=leprikon.models.fields.PostalCodeField(blank=True, null=True, verbose_name='postal code'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='parent2_phone',
                field=models.CharField(blank=True, max_length=30, null=True, verbose_name='phone'),
            ),
            migrations.AddField(
                model_name=model_name,
                name='parent2_email',
                field=models.EmailField(blank=True, max_length=254, null=True, verbose_name='email address'),
            ),
        ]
    operations.append(migrations.RunPython(populate_registrations))
    for model_name in ['clubregistration', 'eventregistration']:
        operations += [
            migrations.AlterField(
                model_name=model_name,
                name='user',
                field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='leprikon_{}s'.format(model_name), to=settings.AUTH_USER_MODEL, verbose_name='user'),
            ),
        ]
    operations += [
        migrations.AlterUniqueTogether(
            name='clubregistration',
            unique_together=set([('club', 'participant_birth_num')]),
        ),
        migrations.AlterUniqueTogether(
            name='eventregistration',
            unique_together=set([('event', 'participant_birth_num')]),
        ),
    ]
