# -*- coding: utf-8 -*-
# Generated by Django 1.9.9 on 2016-11-28 12:19
from __future__ import unicode_literals

from django.db import migrations, models


def migrate_entries(apps, schema_editor):
    ClubJournalEntry = apps.get_model('leprikon', 'clubjournalentry')
    ClubRegistration = apps.get_model('leprikon', 'clubregistration')

    for entry in ClubJournalEntry.objects.all():
        entry.registrations = ClubRegistration.objects.filter(club=entry.club, participant_birth_num__in=entry.participants.values_list('birth_num', flat=True))


class Migration(migrations.Migration):

    dependencies = [
        ('leprikon', '0020_registrations_cleanup'),
    ]

    operations = [
        migrations.AddField(
            model_name='clubjournalentry',
            name='registrations',
            field=models.ManyToManyField(blank=True, related_name='journal_entries', to='leprikon.ClubRegistration', verbose_name='participants'),
        ),
        migrations.RunPython(migrate_entries),
        migrations.RemoveField(
            model_name='clubjournalentry',
            name='participants',
        ),
    ]
