# -*- coding: utf-8 -*-
# Generated by Django 1.9.9 on 2016-12-06 17:25
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


def populate_history(apps, schema_editor):
    ClubRegistration = apps.get_model('leprikon', 'clubregistration')
    ClubRegistrationHistory = apps.get_model('leprikon', 'clubregistrationhistory')

    for reg in ClubRegistration.objects.all():
        ClubRegistrationHistory.objects.create(club=reg.club, registration=reg, start=reg.created.date())


class Migration(migrations.Migration):

    dependencies = [
        ('leprikon', '0021_clubjournalentry_participants'),
    ]

    operations = [
        migrations.CreateModel(
            name='clubregistrationhistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateField()),
                ('end', models.DateField(default=None, null=True)),
                ('club', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='registrations_history', to='leprikon.Club', verbose_name='club')),
                ('registration', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='club_history', to='leprikon.ClubRegistration', verbose_name='club')),
            ],
            options={'ordering': ('start',)},
        ),
        migrations.RunPython(populate_history),
    ]
