# -*- coding: utf-8 -*-
# Generated by Django 1.9.9 on 2017-01-12 21:23
from __future__ import unicode_literals

from django.db import migrations
import leprikon.models.fields


def populate_registration_prices(apps, schema_editor):
    ClubRegistration = apps.get_model('leprikon', 'clubregistration')
    EventRegistration = apps.get_model('leprikon', 'eventregistration')

    for reg in ClubRegistration.objects.all():
        reg.price = reg.club.price
        reg.save()

    for reg in EventRegistration.objects.all():
        reg.price = reg.event.price
        reg.save()


class Migration(migrations.Migration):

    dependencies = [
        ('leprikon', '0022_club_registration_history'),
    ]

    operations = [
        migrations.AddField(
            model_name='clubregistration',
            name='price',
            field=leprikon.models.fields.PriceField(decimal_places=0, default=0, editable=False, max_digits=10, verbose_name='price'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='eventregistration',
            name='price',
            field=leprikon.models.fields.PriceField(decimal_places=0, default=0, editable=False, max_digits=10, verbose_name='price'),
            preserve_default=False,
        ),
        migrations.RunPython(populate_registration_prices),
    ]
