# -*- coding: utf-8 -*-
# Generated by Django 1.9.9 on 2017-01-13 17:32
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import filer.fields.file


def populate_club_types(apps, schema_editor):
    Club = apps.get_model('leprikon', 'club')
    ClubListPlugin = apps.get_model('leprikon', 'clublistplugin')
    FilteredClubListPlugin = apps.get_model('leprikon', 'filteredclublistplugin')
    ClubType = apps.get_model('leprikon', 'clubtype')

    club_type = ClubType.objects.create(name='Kroužky', slug='krouzky')

    Club.objects.update(club_type=club_type)
    ClubListPlugin.objects.update(club_type=club_type)
    for fclp in FilteredClubListPlugin.objects.all():
        fclp.club_types.add(club_type)


class Migration(migrations.Migration):

    dependencies = [
        ('filer', '0001_initial'),
        ('leprikon', '0024_price_not_mandatory'),
    ]

    operations = [
        migrations.CreateModel(
            name='ClubType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('slug', models.SlugField()),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
                ('questions', models.ManyToManyField(blank=True, help_text='Add additional questions to be asked in the registration form.', to='leprikon.Question', verbose_name='additional questions')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'club type',
                'verbose_name_plural': 'club types',
            },
        ),
        migrations.CreateModel(
            name='ClubTypeAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
                ('club_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='leprikon.ClubType', verbose_name='club type')),
                ('file', filer.fields.file.FilerFileField(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='filer.File')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'attachment',
                'verbose_name_plural': 'attachments',
            },
        ),
        migrations.RenameField(
            model_name='eventtypeattachment',
            old_name='event',
            new_name='event_type',
        ),
        migrations.AddField(
            model_name='club',
            name='club_type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clubs', to='leprikon.ClubType', verbose_name='club type'),
        ),
        migrations.AddField(
            model_name='clublistplugin',
            name='club_type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='leprikon.ClubType', verbose_name='club type'),
        ),
        migrations.AddField(
            model_name='filteredclublistplugin',
            name='club_types',
            field=models.ManyToManyField(to='leprikon.ClubType', verbose_name='club type'),
        ),
        migrations.RunPython(populate_club_types),
        migrations.AlterField(
            model_name='club',
            name='club_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='clubs', to='leprikon.ClubType', verbose_name='club type'),
        ),
        migrations.AlterField(
            model_name='clublistplugin',
            name='club_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='leprikon.ClubType', verbose_name='club type'),
        ),
    ]
