# -*- coding: utf-8 -*-
# Generated by Django 1.9.9 on 2017-01-28 12:10
from __future__ import unicode_literals

from datetime import datetime, time
from sys import stderr

import cms.models.fields
from django.conf import settings
from django.db import migrations, models
from django.utils import timezone
import django.db.models.deletion
import django_countries.fields
import djangocms_text_ckeditor.fields
import filer.fields.file
import filer.fields.image
import leprikon.models.courses
import leprikon.models.fields
import leprikon.models.startend
import localflavor.generic.models


tz = timezone.get_default_timezone()


def create_subject_types(apps, schema_editor):
    PrintSetup = apps.get_model('leprikon', 'printsetup')
    SubjectType = apps.get_model('leprikon', 'subjecttype')
    SubjectTypeAttachment = apps.get_model('leprikon', 'subjecttypeattachment')
    ClubType = apps.get_model('leprikon', 'clubtype')
    EventType = apps.get_model('leprikon', 'eventtype')

    order = 1

    stderr.write('\n\t{} course types...'.format(ClubType.objects.count()))
    for club_type in ClubType.objects.all():
        subject_type = SubjectType.objects.create(
            subject_type='course',
            name=club_type.name,
            name_genitiv=club_type.name,
            name_akuzativ=club_type.name,
            plural=club_type.name,
            slug=club_type.slug,
            order=order,
            reg_print_setup=club_type.reg_printsetup,
        )
        subject_type.questions = club_type.questions.all()
        club_type.subject_type = subject_type
        club_type.save()
        for attachment in club_type.attachments.all():
            SubjectTypeAttachment.objects.create(
                subject_type=subject_type,
                file=attachment.file,
                order=attachment.order,
            )
        order += 1

    stderr.write('\n\t{} event types...'.format(EventType.objects.count()))
    for event_type in EventType.objects.all():
        subject_type = SubjectType.objects.create(
            subject_type='event',
            name=event_type.name,
            name_genitiv=event_type.name,
            name_akuzativ=event_type.name,
            plural=event_type.name,
            slug=event_type.slug,
            order=order,
            reg_print_setup=event_type.reg_printsetup,
        )
        subject_type.questions = event_type.questions.all()
        event_type.subject_type = subject_type
        event_type.save()
        for attachment in event_type.attachments.all():
            SubjectTypeAttachment.objects.create(
                subject_type=subject_type,
                file=attachment.file,
                order=attachment.order,
            )
        order += 1


def create_subject_groups(apps, schema_editor):
    SubjectType = apps.get_model('leprikon', 'subjecttype')
    SubjectGroup = apps.get_model('leprikon', 'subjectgroup')
    ClubGroup = apps.get_model('leprikon', 'clubgroup')
    EventGroup = apps.get_model('leprikon', 'eventgroup')

    order = 1

    stderr.write('\n\t{} course groups...'.format(ClubGroup.objects.count()))
    for club_group in ClubGroup.objects.all():
        subject_group = SubjectGroup.objects.create(
            name=club_group.name,
            plural=club_group.name,
            color=club_group.color,
            order=order,
        )
        subject_group.subject_types = SubjectType.objects.filter(subject_type='course')
        club_group.subject_group = subject_group
        club_group.save()
        order += 1

    stderr.write('\n\t{} event groups...'.format(EventGroup.objects.count()))
    for event_group in EventGroup.objects.all():
        subject_group = SubjectGroup.objects.create(
            name=event_group.name,
            plural=event_group.name,
            color=event_group.color,
            order=order,
        )
        subject_group.subject_types = SubjectType.objects.filter(subject_type='event')
        event_group.subject_group = subject_group
        event_group.save()
        order += 1


def create_subjects(apps, schema_editor):
    SubjectAttachment = apps.get_model('leprikon', 'subjectattachment')
    Course = apps.get_model('leprikon', 'course')
    CourseTime = apps.get_model('leprikon', 'coursetime')
    SchoolYearPeriod = apps.get_model('leprikon', 'schoolyearperiod')
    Event = apps.get_model('leprikon', 'event')
    Club = apps.get_model('leprikon', 'club')
    OldEvent = apps.get_model('leprikon', 'oldevent')

    now = timezone.now()

    stderr.write('\n\t{} courses...'.format(Club.objects.count()))
    for club in Club.objects.all():
        course = Course.objects.create(
            school_year     = club.school_year,
            subject_type    = club.club_type.subject_type,
            name            = club.name,
            description     = club.description,
            place           = club.place,
            price           = club.price,
            public          = club.public,
            reg_from        = club.reg_active and now or None,
            reg_to          = None,
            photo           = club.photo,
            page            = club.page,
            min_count       = club.min_count,
            max_count       = club.max_count,
            risks           = club.risks,
            plan            = club.plan,
            evaluation      = club.evaluation,
            note            = club.note,
            reg_print_setup = club.reg_printsetup,
            unit            = club.unit,
        )
        course.groups       = [g.subject_group for g in club.groups.all()]
        course.age_groups   = club.age_groups.all()
        course.leaders      = club.leaders.all()
        course.questions    = club.questions.all()
        for t in club.times.all():
            CourseTime.objects.create(
                course      = course,
                day_of_week = t.day_of_week,
                start       = t.start,
                end         = t.end
            )
        for p in club.periods.all():
            p.school_year_period = SchoolYearPeriod.objects.get_or_create(
                school_year = club.school_year,
                name        = p.name,
                start       = p.start,
                end         = p.end,
            )[0]
            p.save()
            course.periods.add(p.school_year_period)
        club.course = course
        club.save()
        for attachment in club.attachments.all():
            SubjectAttachment.objects.create(
                subject = course,
                file    = attachment.file,
                order   = attachment.order,
            )

    stderr.write('\n\t{} events...'.format(OldEvent.objects.count()))
    for oldevent in OldEvent.objects.all():
        event = Event.objects.create(
            school_year     = oldevent.school_year,
            subject_type    = oldevent.event_type.subject_type,
            name            = oldevent.name,
            description     = oldevent.description,
            place           = oldevent.place,
            price           = oldevent.price,
            public          = oldevent.public,
            reg_from        = oldevent.reg_active and now or None,
            reg_to          = None,
            photo           = oldevent.photo,
            page            = oldevent.page,
            min_count       = oldevent.min_count,
            max_count       = oldevent.max_count,
            risks           = oldevent.risks,
            plan            = oldevent.plan,
            evaluation      = oldevent.evaluation,
            note            = oldevent.note,
            reg_print_setup = oldevent.reg_printsetup,
            start_date      = oldevent.start_date,
            start_time      = oldevent.start_time,
            end_date        = oldevent.end_date,
            end_time        = oldevent.end_time,
        )
        event.groups       = [g.subject_group for g in oldevent.groups.all()]
        event.age_groups   = oldevent.age_groups.all()
        event.leaders      = oldevent.leaders.all()
        event.questions    = oldevent.questions.all()
        oldevent.event = event
        oldevent.save()
        for attachment in oldevent.attachments.all():
            SubjectAttachment.objects.create(
                subject = event,
                file    = attachment.file,
                order   = attachment.order,
            )


def create_subject_registrations(apps, schema_editor):
    CourseRegistration = apps.get_model('leprikon', 'courseregistration')
    EventRegistration = apps.get_model('leprikon', 'eventregistration')
    CourseRegistrationHistory = apps.get_model('leprikon', 'courseregistrationhistory')
    CourseDiscount = apps.get_model('leprikon', 'coursediscount')
    EventDiscount = apps.get_model('leprikon', 'eventdiscount')
    ClubRegistration = apps.get_model('leprikon', 'clubregistration')
    OldEventRegistration = apps.get_model('leprikon', 'oldeventregistration')

    stderr.write('\n\t{} course registrations...'.format(ClubRegistration.objects.count()))
    for club_registration in ClubRegistration.objects.all():
        course_registration = CourseRegistration.objects.create(
            slug                        = club_registration.slug,
            created                     = club_registration.created,
            approved                    = club_registration.created,
            user                        = club_registration.user,
            subject                     = club_registration.club.course,
            price                       = club_registration.price,
            answers                     = club_registration.answers,
            cancel_request              = club_registration.cancel_request,
            canceled                    = club_registration.canceled and tz.localize(datetime.combine(club_registration.canceled, time(12, 0))),

            participant_gender          = club_registration.participant_gender,
            participant_first_name      = club_registration.participant_first_name,
            participant_last_name       = club_registration.participant_last_name,
            participant_birth_num       = club_registration.participant_birth_num,
            participant_age_group       = club_registration.participant_age_group,
            participant_street          = club_registration.participant_street,
            participant_city            = club_registration.participant_city,
            participant_postal_code     = club_registration.participant_postal_code,
            participant_citizenship     = club_registration.participant_citizenship,
            participant_insurance       = club_registration.participant_insurance,
            participant_phone           = club_registration.participant_phone,
            participant_email           = club_registration.participant_email,
            participant_school          = club_registration.participant_school,
            participant_school_other    = club_registration.participant_school_other,
            participant_school_class    = club_registration.participant_school_class,
            participant_health          = club_registration.participant_health,

            has_parent1                 = club_registration.has_parent1,
            parent1_first_name          = club_registration.parent1_first_name,
            parent1_last_name           = club_registration.parent1_last_name,
            parent1_street              = club_registration.parent1_street,
            parent1_city                = club_registration.parent1_city,
            parent1_postal_code         = club_registration.parent1_postal_code,
            parent1_phone               = club_registration.parent1_phone,
            parent1_email               = club_registration.parent1_email,

            has_parent2                 = club_registration.has_parent2,
            parent2_first_name          = club_registration.parent2_first_name,
            parent2_last_name           = club_registration.parent2_last_name,
            parent2_street              = club_registration.parent2_street,
            parent2_city                = club_registration.parent2_city,
            parent2_postal_code         = club_registration.parent2_postal_code,
            parent2_phone               = club_registration.parent2_phone,
            parent2_email               = club_registration.parent2_email,
        )
        for h in club_registration.club_history.all():
            CourseRegistrationHistory.objects.create(
                registration    = course_registration,
                course          = h.club.course,
                start           = h.start,
                end             = h.end,
            )
        for d in club_registration.discounts.all():
            CourseDiscount.objects.create(
                registration    = course_registration,
                period          = d.period.school_year_period,
                created         = course_registration.created,
                amount          = d.discount,
                explanation     = d.explanation,
            )
        club_registration.course_registration = course_registration
        club_registration.save()

    stderr.write('\n\t{} event registrations...'.format(OldEventRegistration.objects.count()))
    for old_event_registration in OldEventRegistration.objects.all():
        event_registration = EventRegistration.objects.create(
            slug                        = old_event_registration.slug,
            created                     = old_event_registration.created,
            approved                    = old_event_registration.created,
            user                        = old_event_registration.user,
            subject                     = old_event_registration.event.event,
            price                       = old_event_registration.price,
            answers                     = old_event_registration.answers,
            cancel_request              = old_event_registration.cancel_request,
            canceled                    = old_event_registration.canceled and tz.localize(datetime.combine(old_event_registration.canceled, time(12, 0))),

            participant_gender          = old_event_registration.participant_gender,
            participant_first_name      = old_event_registration.participant_first_name,
            participant_last_name       = old_event_registration.participant_last_name,
            participant_birth_num       = old_event_registration.participant_birth_num,
            participant_age_group       = old_event_registration.participant_age_group,
            participant_street          = old_event_registration.participant_street,
            participant_city            = old_event_registration.participant_city,
            participant_postal_code     = old_event_registration.participant_postal_code,
            participant_citizenship     = old_event_registration.participant_citizenship,
            participant_insurance       = old_event_registration.participant_insurance,
            participant_phone           = old_event_registration.participant_phone,
            participant_email           = old_event_registration.participant_email,
            participant_school          = old_event_registration.participant_school,
            participant_school_other    = old_event_registration.participant_school_other,
            participant_school_class    = old_event_registration.participant_school_class,
            participant_health          = old_event_registration.participant_health,

            has_parent1                 = old_event_registration.has_parent1,
            parent1_first_name          = old_event_registration.parent1_first_name,
            parent1_last_name           = old_event_registration.parent1_last_name,
            parent1_street              = old_event_registration.parent1_street,
            parent1_city                = old_event_registration.parent1_city,
            parent1_postal_code         = old_event_registration.parent1_postal_code,
            parent1_phone               = old_event_registration.parent1_phone,
            parent1_email               = old_event_registration.parent1_email,

            has_parent2                 = old_event_registration.has_parent2,
            parent2_first_name          = old_event_registration.parent2_first_name,
            parent2_last_name           = old_event_registration.parent2_last_name,
            parent2_street              = old_event_registration.parent2_street,
            parent2_city                = old_event_registration.parent2_city,
            parent2_postal_code         = old_event_registration.parent2_postal_code,
            parent2_phone               = old_event_registration.parent2_phone,
            parent2_email               = old_event_registration.parent2_email,
        )
        if old_event_registration.discount:
            EventDiscount.objects.create(
                registration    = event_registration,
                created         = event_registration.created,
                amount          = old_event_registration.discount,
                explanation     = old_event_registration.explanation,
            )
        old_event_registration.event_registration = event_registration
        old_event_registration.save()



def create_subject_payments(apps, schema_editor):
    SubjectPayment = apps.get_model('leprikon', 'subjectpayment')
    ClubPayment = apps.get_model('leprikon', 'clubpayment')
    EventPayment = apps.get_model('leprikon', 'eventpayment')

    stderr.write('\n\t{} course payments...'.format(ClubPayment.objects.count()))
    for club_payment in ClubPayment.objects.all():
        SubjectPayment.objects.create(
            registration = club_payment.registration.course_registration,
            created = tz.localize(datetime.combine(club_payment.date, time(12, 0))),
            amount = club_payment.amount,
            payment_type = '',
        )

    stderr.write('\n\t{} event payments...'.format(EventPayment.objects.count()))
    for event_payment in EventPayment.objects.all():
        SubjectPayment.objects.create(
            registration = event_payment.registration.event_registration,
            created = tz.localize(datetime.combine(event_payment.date, time(12, 0))),
            amount = event_payment.amount,
            payment_type = '',
        )


def create_course_journals(apps, schema_editor):
    CourseJournalEntry = apps.get_model('leprikon', 'coursejournalentry')
    CourseJournalLeaderEntry = apps.get_model('leprikon', 'coursejournalleaderentry')
    ClubJournalEntry = apps.get_model('leprikon', 'clubjournalentry')

    stderr.write('\n\t{} course journal entries...'.format(ClubJournalEntry.objects.count()))
    for club_journal_entry in ClubJournalEntry.objects.all():
        course_journal_entry = CourseJournalEntry.objects.create(
            course  = club_journal_entry.club.course,
            date    = club_journal_entry.date,
            start   = club_journal_entry.start,
            end     = club_journal_entry.end,
            agenda  = club_journal_entry.agenda,
        )
        course_journal_entry.registrations = [
            reg.course_registration
            for reg in club_journal_entry.registrations.all()
        ]
        for leader_entry in club_journal_entry.leader_entries.all():
            CourseJournalLeaderEntry.objects.create(
                course_entry    = course_journal_entry,
                timesheet       = leader_entry.timesheet,
                start           = leader_entry.start,
                end             = leader_entry.end,
            )


def migrate_plugins(apps, schema_editor):
    CoursePlugin = apps.get_model('leprikon', 'courseplugin')
    CourseListPlugin = apps.get_model('leprikon', 'courselistplugin')
    FilteredCourseListPlugin = apps.get_model('leprikon', 'filteredcourselistplugin')
    EventPlugin = apps.get_model('leprikon', 'eventplugin')
    EventListPlugin = apps.get_model('leprikon', 'eventlistplugin')
    FilteredEventListPlugin = apps.get_model('leprikon', 'filteredeventlistplugin')
    LeaderListPlugin = apps.get_model('leprikon', 'leaderlistplugin')

    stderr.write('\n\tcms plugins...')
    for p in CoursePlugin.objects.all():
        p.course = p.old_course.course
        p.plugin_type = 'LeprikonCoursePlugin'
        p.save()

    for p in EventPlugin.objects.all():
        p.event = p.old_event.event
        p.save()

    for p in CourseListPlugin.objects.all():
        p.groups = [g.subject_group for g in p.old_groups.all()]
        if p.club_type:
            p.course_types.add(p.club_type.subject_type)
        p.plugin_type = 'LeprikonCourseListPlugin'
        p.save()

    for p in EventListPlugin.objects.all():
        p.groups = [g.subject_group for g in p.old_groups.all()]
        if p.event_type:
            p.event_types.add(p.event_type.subject_type)

    for p in FilteredCourseListPlugin.objects.all():
        p.course_types = [t.subject_type for t in p.club_types.all()]
        p.plugin_type = 'LeprikonFilteredCourseListPlugin'
        p.save()

    for p in FilteredEventListPlugin.objects.all():
        p.event_types = [t.subject_type for t in p.old_event_types.all()]

    for p in LeaderListPlugin.objects.all():
        if p.course:
            p.subject = p.course.subject
        elif p.event:
            p.subject = p.event.subject


class Migration(migrations.Migration):

    dependencies = [
        ('cms', '0001_initial'),
        ('filer', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('leprikon', '0026_printsetup'),
        ('sites', '0001_initial'),
    ]

    operations = [
        #
        # Subject Types
        #
        migrations.CreateModel(
            name='LeprikonSite',
            fields=[
                ('site_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='sites.Site')),
                ('city', models.CharField(blank=True, max_length=150, null=True, verbose_name='city')),
                ('postal_code', leprikon.models.fields.PostalCodeField(blank=True, null=True, verbose_name='postal code')),
                ('email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='email address')),
                ('phone', models.CharField(blank=True, max_length=30, null=True, verbose_name='phone')),
                ('street', models.CharField(blank=True, max_length=150, null=True, verbose_name='street')),
                ('company_num', models.CharField(blank=True, max_length=8, null=True, verbose_name='company number')),
                ('vat_number', models.CharField(blank=True, max_length=10, null=True, verbose_name='VAT number')),
                ('iban', localflavor.generic.models.IBANField('IBAN', None, blank=True, null=True)),
                ('bic', localflavor.generic.models.BICField(blank=True, null=True, verbose_name='BIC (SWIFT)')),
                ('bill_print_setup', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='leprikon.PrintSetup', verbose_name='bill print setup')),
                ('agreement', models.TextField(blank=True, null=True, verbose_name='registration agreement')),
                ('reg_print_setup', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='leprikon.PrintSetup', verbose_name='registration print setup')),
            ],
            options={
                'verbose_name': 'leprikon site',
                'verbose_name_plural': 'leprikon sites',
            },
            bases=('sites.site',),
        ),
        migrations.CreateModel(
            name='SubjectType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject_type', models.CharField(choices=[('course', 'course'), ('event', 'event')], max_length=10, verbose_name='subjects')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('name_genitiv', models.CharField(blank=True, max_length=150, verbose_name='name (genitiv)')),
                ('name_akuzativ', models.CharField(blank=True, max_length=150, verbose_name='name (akuzativ)')),
                ('plural', models.CharField(max_length=150, verbose_name='name (plural)')),
                ('slug', models.SlugField()),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
                ('questions', models.ManyToManyField(blank=True, help_text='Add additional questions to be asked in the registration form.', related_name='+', to='leprikon.Question', verbose_name='additional questions')),
                ('agreement', models.TextField(blank=True, null=True, verbose_name='registration agreement')),
                ('reg_print_setup', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='leprikon.PrintSetup', verbose_name='registration print setup')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'subject type',
                'verbose_name_plural': 'subject types',
            },
        ),
        migrations.CreateModel(
            name='SubjectTypeAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='leprikon.SubjectType', verbose_name='subject type')),
                ('file', filer.fields.file.FilerFileField(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='filer.File')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'attachment',
                'verbose_name_plural': 'attachments',
            },
        ),
        migrations.AddField(
            model_name='clubtype',
            name='subject_type',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, null=True, related_name='old_course_type', to='leprikon.SubjectType', verbose_name='subject type'),
        ),
        migrations.AddField(
            model_name='eventtype',
            name='subject_type',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, null=True, related_name='old_event_type', to='leprikon.SubjectType', verbose_name='subject type'),
        ),
        migrations.RunPython(create_subject_types),
        migrations.AlterField(
            model_name='clubtype',
            name='subject_type',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='old_course_type', to='leprikon.SubjectType', verbose_name='subject type'),
        ),
        migrations.AlterField(
            model_name='eventtype',
            name='subject_type',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='old_event_type', to='leprikon.SubjectType', verbose_name='subject type'),
        ),
        #
        # Subject Groups
        #
        migrations.CreateModel(
            name='SubjectGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('plural', models.CharField(max_length=150, verbose_name='plural')),
                ('color', leprikon.models.fields.ColorField(max_length=10, verbose_name='color')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
                ('subject_types', models.ManyToManyField(related_name='groups', to='leprikon.SubjectType', verbose_name='subject type')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'subject group',
                'verbose_name_plural': 'subject groups',
            },
        ),
        migrations.AddField(
            model_name='clubgroup',
            name='subject_group',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, null=True, related_name='old_course_group', to='leprikon.SubjectGroup', verbose_name='subject group'),
        ),
        migrations.AddField(
            model_name='eventgroup',
            name='subject_group',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, null=True, related_name='old_event_group', to='leprikon.SubjectGroup', verbose_name='subject group'),
        ),
        migrations.RunPython(create_subject_groups),
        migrations.AlterField(
            model_name='clubgroup',
            name='subject_group',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='old_course_group', to='leprikon.SubjectGroup', verbose_name='subject group'),
        ),
        migrations.AlterField(
            model_name='eventgroup',
            name='subject_group',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='old_event_group', to='leprikon.SubjectGroup', verbose_name='subject group'),
        ),
        #
        # Subjects
        #
        migrations.RenameModel('Event', 'OldEvent'),
        migrations.CreateModel(
            name='Subject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('school_year', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='subjects', to='leprikon.SchoolYear', verbose_name='school year')),
                ('subject_type', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='subjects', to='leprikon.SubjectType', verbose_name='subject type')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('description', djangocms_text_ckeditor.fields.HTMLField(blank=True, default='', verbose_name='description')),
                ('groups', models.ManyToManyField(blank=True, related_name='subjects', to='leprikon.SubjectGroup', verbose_name='groups')),
                ('place', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='subjects', to='leprikon.Place', verbose_name='place')),
                ('age_groups', models.ManyToManyField(blank=True, related_name='subjects', to='leprikon.AgeGroup', verbose_name='age groups')),
                ('leaders', models.ManyToManyField(blank=True, related_name='subjects', to='leprikon.Leader', verbose_name='leaders')),
                ('price', leprikon.models.fields.PriceField(blank=True, decimal_places=0, max_digits=10, null=True, verbose_name='price')),
                ('public', models.BooleanField(default=False, verbose_name='public')),
                ('reg_from', models.DateTimeField(blank=True, null=True, verbose_name='registration active from')),
                ('reg_to', models.DateTimeField(blank=True, null=True, verbose_name='registration active to')),
                ('photo', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='filer.Image', verbose_name='photo')),
                ('page', cms.models.fields.PageField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='cms.Page', verbose_name='page')),
                ('min_count', models.IntegerField(blank=True, null=True, verbose_name='minimal count')),
                ('max_count', models.IntegerField(blank=True, null=True, verbose_name='maximal count')),
                ('risks', djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name='risks')),
                ('plan', djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name='plan')),
                ('evaluation', djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name='evaluation')),
                ('note', models.CharField(blank=True, default='', max_length=300, verbose_name='note')),
                ('questions', models.ManyToManyField(blank=True, help_text='Add additional questions to be asked in the registration form.', related_name='+', to='leprikon.Question', verbose_name='additional questions')),
                ('agreement', models.TextField(blank=True, null=True, verbose_name='registration agreement')),
                ('reg_print_setup', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='leprikon.PrintSetup', verbose_name='registration print setup')),
            ],
            options={
                'ordering': ('name',),
                'verbose_name': 'subject',
                'verbose_name_plural': 'subjects',
            },
        ),
        migrations.CreateModel(
            name='SubjectAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='leprikon.Subject', verbose_name='subject')),
                ('file', filer.fields.file.FilerFileField(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='filer.File')),
                ('order', models.IntegerField(blank=True, default=0, verbose_name='order')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': 'attachment',
                'verbose_name_plural': 'attachments',
            },
        ),
        migrations.CreateModel(
            name='SchoolYearPeriod',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('start', models.DateField(verbose_name='start date')),
                ('end', models.DateField(verbose_name='end date')),
                ('school_year', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='periods', to='leprikon.SchoolYear', verbose_name='school year')),
            ],
            options={
                'ordering': ('start',),
                'verbose_name': 'school year period',
                'verbose_name_plural': 'school year periods',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Course',
            fields=[
                ('subject_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='leprikon.Subject')),
                ('unit', models.CharField(max_length=150, verbose_name='unit')),
                ('periods', models.ManyToManyField(related_name='courses', to='leprikon.SchoolYearPeriod', verbose_name='periods')),
            ],
            options={
                'ordering': ('name',),
                'verbose_name': 'course',
                'verbose_name_plural': 'courses',
            },
            bases=('leprikon.subject',),
        ),
        migrations.CreateModel(
            name='CourseTime',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='times', to='leprikon.Course', verbose_name='course')),
                ('day_of_week', leprikon.models.fields.DayOfWeekField(choices=[(1, 'Monday'), (2, 'Tuesday'), (3, 'Wednesday'), (4, 'Thursday'), (5, 'Friday'), (6, 'Saturday'), (7, 'Sunday')], verbose_name='day of week')),
                ('start', models.TimeField(blank=True, null=True, verbose_name='start time')),
                ('end', models.TimeField(blank=True, null=True, verbose_name='end time')),
            ],
            options={
                'ordering': ('day_of_week', 'start'),
                'verbose_name': 'time',
                'verbose_name_plural': 'times',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Event',
            fields=[
                ('subject_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='leprikon.Subject')),
                ('start_date', models.DateField(verbose_name='start date')),
                ('end_date', models.DateField(verbose_name='end date')),
                ('start_time', models.TimeField(blank=True, null=True, verbose_name='start time')),
                ('end_time', models.TimeField(blank=True, null=True, verbose_name='end time')),
            ],
            options={
                'ordering': ('-start_date', 'start_time'),
                'verbose_name': 'event',
                'verbose_name_plural': 'events',
            },
            bases=('leprikon.subject',),
        ),
        migrations.AddField(
            model_name='Club',
            name='course',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, null=True, related_name='old_course', to='leprikon.Course', verbose_name='course'),
        ),
        migrations.AddField(
            model_name='ClubPeriod',
            name='school_year_period',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, null=True, related_name='old_course_period', to='leprikon.SchoolYearPeriod', verbose_name='school year period'),
        ),
        migrations.AddField(
            model_name='OldEvent',
            name='event',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, null=True, related_name='old_event', to='leprikon.Event', verbose_name='event'),
        ),
        migrations.RunPython(create_subjects),
        migrations.AlterField(
            model_name='Club',
            name='course',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='old_course', to='leprikon.Course', verbose_name='course'),
        ),
        migrations.AlterField(
            model_name='ClubPeriod',
            name='school_year_period',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='old_course_period', to='leprikon.SchoolYearPeriod', verbose_name='school year period'),
        ),
        migrations.AlterField(
            model_name='OldEvent',
            name='event',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='old_event', to='leprikon.Event', verbose_name='event'),
        ),
        #
        # Subject Registrations
        #
        migrations.RenameModel('EventRegistration', 'OldEventRegistration'),
        migrations.CreateModel(
            name='SubjectRegistration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField(editable=False)),
                ('created', models.DateTimeField(verbose_name='time of registration')),
                ('approved', models.DateTimeField(editable=False, null=True, verbose_name='time of approval')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='leprikon_registrations', to=settings.AUTH_USER_MODEL, verbose_name='user')),
                ('subject', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='registrations', to='leprikon.Subject', verbose_name='subject')),
                ('price', leprikon.models.fields.PriceField(decimal_places=0, editable=False, max_digits=10, verbose_name='price')),
                ('answers', models.TextField(blank=True, default='{}', editable=False, verbose_name='additional answers')),
                ('cancel_request', models.BooleanField(default=False, verbose_name='cancel request')),
                ('canceled', models.DateTimeField(editable=False, null=True, verbose_name='time of cancellation')),
                ('participant_gender', models.CharField(choices=[('m', 'male'), ('f', 'female')], editable=False, max_length=1, verbose_name='gender')),
                ('participant_first_name', models.CharField(max_length=30, verbose_name='first name')),
                ('participant_last_name', models.CharField(max_length=30, verbose_name='last name')),
                ('participant_birth_num', leprikon.models.fields.BirthNumberField(verbose_name='birth number')),
                ('participant_age_group', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.AgeGroup', verbose_name='age group')),
                ('participant_street', models.CharField(max_length=150, verbose_name='street')),
                ('participant_city', models.CharField(max_length=150, verbose_name='city')),
                ('participant_postal_code', leprikon.models.fields.PostalCodeField(verbose_name='postal code')),
                ('participant_citizenship', django_countries.fields.CountryField(max_length=2, verbose_name='citizenship')),
                ('participant_insurance', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.Insurance', verbose_name='insurance')),
                ('participant_phone', models.CharField(blank=True, default='', max_length=30, verbose_name='phone')),
                ('participant_email', models.EmailField(blank=True, default='', max_length=254, verbose_name='email address')),
                ('participant_school', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.School', verbose_name='school')),
                ('participant_school_other', models.CharField(blank=True, default='', max_length=150, verbose_name='other school')),
                ('participant_school_class', models.CharField(blank=True, default='', max_length=30, verbose_name='class')),
                ('participant_health', models.TextField(blank=True, default='', verbose_name='health')),
                ('has_parent1', models.BooleanField(default=False, verbose_name='first parent')),
                ('parent1_first_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='first name')),
                ('parent1_last_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='last name')),
                ('parent1_street', models.CharField(blank=True, max_length=150, null=True, verbose_name='street')),
                ('parent1_city', models.CharField(blank=True, max_length=150, null=True, verbose_name='city')),
                ('parent1_postal_code', leprikon.models.fields.PostalCodeField(blank=True, null=True, verbose_name='postal code')),
                ('parent1_phone', models.CharField(blank=True, max_length=30, null=True, verbose_name='phone')),
                ('parent1_email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='email address')),
                ('has_parent2', models.BooleanField(default=False, verbose_name='second parent')),
                ('parent2_first_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='first name')),
                ('parent2_last_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='last name')),
                ('parent2_street', models.CharField(blank=True, max_length=150, null=True, verbose_name='street')),
                ('parent2_city', models.CharField(blank=True, max_length=150, null=True, verbose_name='city')),
                ('parent2_postal_code', leprikon.models.fields.PostalCodeField(blank=True, null=True, verbose_name='postal code')),
                ('parent2_phone', models.CharField(blank=True, max_length=30, null=True, verbose_name='phone')),
                ('parent2_email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='email address')),
            ],
            options={
                'verbose_name': 'registration',
                'verbose_name_plural': 'registrations',
            },
        ),
        migrations.AlterUniqueTogether(
            name='subjectregistration',
            unique_together=set([('subject', 'participant_birth_num')]),
        ),
        migrations.CreateModel(
            name='CourseRegistration',
            fields=[
                ('subjectregistration_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='leprikon.SubjectRegistration')),
            ],
            options={
                'verbose_name': 'course registration',
                'verbose_name_plural': 'course registrations',
            },
            bases=('leprikon.subjectregistration',),
        ),
        migrations.CreateModel(
            name='EventRegistration',
            fields=[
                ('subjectregistration_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='leprikon.SubjectRegistration')),
            ],
            options={
                'verbose_name': 'event registration',
                'verbose_name_plural': 'event registrations',
            },
            bases=('leprikon.subjectregistration',),
        ),
        migrations.CreateModel(
            name='CourseRegistrationHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('registration', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='course_history', to='leprikon.CourseRegistration', verbose_name='course')),
                ('course', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='registrations_history', to='leprikon.Course', verbose_name='course')),
                ('start', models.DateField()),
                ('end', models.DateField(blank=True, null=True)),
            ],
            options={
                'ordering': ('start',),
                'verbose_name': 'course registration history',
                'verbose_name_plural': 'course registration history',
            },
        ),
        migrations.CreateModel(
            name='CourseDiscount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('registration', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='discounts', to='leprikon.CourseRegistration', verbose_name='registration')),
                ('period', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='discounts', to='leprikon.SchoolYearPeriod', verbose_name='period')),
                ('created', models.DateTimeField(verbose_name='time of discount')),
                ('amount', leprikon.models.fields.PriceField(decimal_places=0, default=0, max_digits=10, verbose_name='discount')),
                ('explanation', models.CharField(blank=True, default='', max_length=250, verbose_name='discount explanation')),
            ],
            options={
                'ordering': ('created',),
                'abstract': False,
                'verbose_name': 'discount',
                'verbose_name_plural': 'discounts',
            },
        ),
        migrations.CreateModel(
            name='EventDiscount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('registration', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='discounts', to='leprikon.EventRegistration', verbose_name='registration')),
                ('created', models.DateTimeField(verbose_name='time of discount')),
                ('amount', leprikon.models.fields.PriceField(decimal_places=0, default=0, max_digits=10, verbose_name='discount')),
                ('explanation', models.CharField(blank=True, default='', max_length=250, verbose_name='discount explanation')),
            ],
            options={
                'ordering': ('created',),
                'abstract': False,
                'verbose_name': 'discount',
                'verbose_name_plural': 'discounts',
            },
        ),
        migrations.AddField(
            model_name='ClubRegistration',
            name='course_registration',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, null=True, related_name='old_course_registration', to='leprikon.CourseRegistration', verbose_name='course registration'),
        ),
        migrations.AddField(
            model_name='OldEventRegistration',
            name='event_registration',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, null=True, related_name='old_event_registration', to='leprikon.EventRegistration', verbose_name='event registration'),
        ),
        migrations.RunPython(create_subject_registrations),
        migrations.AlterField(
            model_name='ClubRegistration',
            name='course_registration',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='old_course_registration', to='leprikon.CourseRegistration', verbose_name='course registration'),
        ),
        migrations.AlterField(
            model_name='OldEventRegistration',
            name='event_registration',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='old_event_registration', to='leprikon.EventRegistration', verbose_name='event registration'),
        ),
        migrations.AlterField(
            model_name='coursediscount',
            name='created',
            field=models.DateTimeField(auto_now_add=True, verbose_name='time of discount'),
        ),
        migrations.AlterField(
            model_name='eventdiscount',
            name='created',
            field=models.DateTimeField(auto_now_add=True, verbose_name='time of discount'),
        ),
        migrations.AlterField(
            model_name='subjectregistration',
            name='created',
            field=models.DateTimeField(auto_now_add=True, verbose_name='time of registration'),
        ),
        #
        # Subject Payments
        #
        migrations.CreateModel(
            name='SubjectPayment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('registration', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='payments', to='leprikon.SubjectRegistration', verbose_name='registration')),
                ('created', models.DateTimeField(verbose_name='payment time')),
                ('payment_type', models.CharField(choices=[('PAYMENT_CASH', 'payment - cash'), ('PAYMENT_BANK', 'payment - bank'), ('PAYMENT_ONLINE', 'payment - online'), ('PAYMENT_TRANSFER', 'payment - transfer from return'), ('RETURN_CASH', 'return - cash'), ('RETURN_BANK', 'return - bank'), ('RETURN_TRANSFER', 'return - transfer to payment')], max_length=30, verbose_name='payment type')),
                ('amount', leprikon.models.fields.PriceField(decimal_places=0, help_text='positive value for payment, negative value for return', max_digits=10, verbose_name='amount')),
                ('note', models.CharField(blank=True, default='', max_length=300, verbose_name='note')),
            ],
            options={
                'ordering': ('created',),
                'verbose_name': 'payment',
                'verbose_name_plural': 'payments',
            },
        ),
        migrations.AddField(
            model_name='subjectpayment',
            name='related_payment',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='related_payments', to='leprikon.SubjectPayment', verbose_name='related payment'),
        ),
        migrations.RunPython(create_subject_payments),
        migrations.AlterField(
            model_name='subjectpayment',
            name='created',
            field=models.DateTimeField(auto_now_add=True, verbose_name='payment time'),
        ),
        #
        # Course Journals
        #
        migrations.CreateModel(
            name='CourseJournalEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('course', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='journal_entries', to='leprikon.Course', verbose_name='course')),
                ('date', models.DateField(verbose_name='date')),
                ('start', models.TimeField(blank=True, help_text='Leave empty, if the course does not take place', null=True, verbose_name='start time')),
                ('end', models.TimeField(blank=True, help_text='Leave empty, if the course does not take place', null=True, verbose_name='end time')),
                ('agenda', djangocms_text_ckeditor.fields.HTMLField(default=leprikon.models.courses.get_default_agenda, verbose_name='session agenda')),
                ('registrations', models.ManyToManyField(blank=True, related_name='journal_entries', to='leprikon.CourseRegistration', verbose_name='participants')),
            ],
            options={
                'ordering': ('date', 'start', 'end'),
                'verbose_name': 'journal entry',
                'verbose_name_plural': 'journal entries',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name='CourseJournalLeaderEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('course_entry', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='leader_entries', to='leprikon.CourseJournalEntry', verbose_name='course journal entry')),
                ('timesheet', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='course_entries', to='leprikon.Timesheet', verbose_name='timesheet')),
                ('start', models.TimeField(verbose_name='start time')),
                ('end', models.TimeField(verbose_name='end time')),
            ],
            options={
                'verbose_name': 'course journal leader entry',
                'verbose_name_plural': 'course journal leader entries',
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.AlterUniqueTogether(
            name='coursejournalleaderentry',
            unique_together=set([('course_entry', 'timesheet')]),
        ),
        migrations.RunPython(create_course_journals),
        #
        # Plugins
        #
        # CoursePlugin
        migrations.RenameModel('ClubPlugin', 'CoursePlugin'),
        migrations.RenameField(
            model_name='courseplugin',
            old_name='club',
            new_name='old_course',
        ),
        migrations.AddField(
            model_name='courseplugin',
            name='course',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.Course', verbose_name='course'),
        ),
        # EventPlugin
        migrations.RenameField(
            model_name='eventplugin',
            old_name='event',
            new_name='old_event',
        ),
        migrations.AddField(
            model_name='eventplugin',
            name='event',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.Event', verbose_name='event'),
        ),
        # CourseListPlugin
        migrations.RenameModel('ClubListPlugin', 'CourseListPlugin'),
        migrations.RenameField(
            model_name='courselistplugin',
            old_name='groups',
            new_name='old_groups',
        ),
        migrations.AddField(
            model_name='courselistplugin',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by groups.', related_name='_courselistplugin_groups_+', to='leprikon.SubjectGroup', verbose_name='course groups'),
        ),
        migrations.AddField(
            model_name='courselistplugin',
            name='course_types',
            field=models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by course types.', related_name='_courselistplugin_course_types_+', to='leprikon.SubjectType', verbose_name='course types'),
        ),
        # EventListPlugin
        migrations.RenameField(
            model_name='eventlistplugin',
            old_name='groups',
            new_name='old_groups',
        ),
        migrations.AddField(
            model_name='eventlistplugin',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by groups.', related_name='_eventlistplugin_groups_+', to='leprikon.SubjectGroup', verbose_name='event groups'),
        ),
        migrations.AddField(
            model_name='eventlistplugin',
            name='event_types',
            field=models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by event types.', related_name='_eventlistplugin_event_types_+', to='leprikon.SubjectType', verbose_name='event types'),
        ),
        # FilteredCourseListPlugin
        migrations.RenameModel('FilteredClubListPlugin', 'FilteredCourseListPlugin'),
        migrations.AddField(
            model_name='filteredcourselistplugin',
            name='course_types',
            field=models.ManyToManyField(related_name='_filteredcourselistplugin_course_types_+', to='leprikon.SubjectType', verbose_name='course types'),
        ),
        # FilteredEventListPlugin
        migrations.RenameField(
            model_name='filteredeventlistplugin',
            old_name='event_types',
            new_name='old_event_types',
        ),
        migrations.AddField(
            model_name='filteredeventlistplugin',
            name='event_types',
            field=models.ManyToManyField(related_name='_filteredeventlistplugin_event_types_+', to='leprikon.SubjectType', verbose_name='event types'),
        ),
        # LeaderListPlugin
        migrations.AddField(
            model_name='leaderlistplugin',
            name='subject',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.Subject', verbose_name='subject'),
        ),
        migrations.RunPython(migrate_plugins),
        migrations.AlterField(
            model_name='courseplugin',
            name='course',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.Course', verbose_name='course'),
        ),
        migrations.AlterField(
            model_name='eventplugin',
            name='event',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.Event', verbose_name='event'),
        ),
        #
        # Update some fields
        #
        migrations.RenameField(
            model_name='printsetup',
            old_name='template',
            new_name='background',
        ),
        migrations.AlterField(
            model_name='courselistplugin',
            name='age_groups',
            field=models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by age groups.', related_name='_courselistplugin_age_groups_+', to='leprikon.AgeGroup', verbose_name='age groups'),
        ),
        migrations.AlterField(
            model_name='courselistplugin',
            name='cmsplugin_ptr',
            field=models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='leprikon_courselistplugin', serialize=False, to='cms.CMSPlugin'),
        ),
        migrations.AlterField(
            model_name='courselistplugin',
            name='leaders',
            field=models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by leaders.', related_name='_courselistplugin_leaders_+', to='leprikon.Leader', verbose_name='leaders'),
        ),
        migrations.AlterField(
            model_name='courselistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AlterField(
            model_name='courselistplugin',
            name='template',
            field=models.CharField(choices=[('default', 'Default'), ('grouped', 'Grouped by course groups')], default='default', help_text='The template used to render plugin.', max_length=100, verbose_name='template'),
        ),
        migrations.AlterField(
            model_name='courseplugin',
            name='cmsplugin_ptr',
            field=models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='leprikon_courseplugin', serialize=False, to='cms.CMSPlugin'),
        ),
        migrations.AlterField(
            model_name='eventlistplugin',
            name='age_groups',
            field=models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by age groups.', related_name='_eventlistplugin_age_groups_+', to='leprikon.AgeGroup', verbose_name='age groups'),
        ),
        migrations.AlterField(
            model_name='eventlistplugin',
            name='leaders',
            field=models.ManyToManyField(blank=True, help_text='Keep empty to skip searching by leaders.', related_name='_eventlistplugin_leaders_+', to='leprikon.Leader', verbose_name='leaders'),
        ),
        migrations.AlterField(
            model_name='eventlistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AlterField(
            model_name='filteredcourselistplugin',
            name='cmsplugin_ptr',
            field=models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='leprikon_filteredcourselistplugin', serialize=False, to='cms.CMSPlugin'),
        ),
        migrations.AlterField(
            model_name='filteredcourselistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AlterField(
            model_name='filteredeventlistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AlterField(
            model_name='filteredleaderlistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AlterField(
            model_name='leader',
            name='photo',
            field=filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='filer.Image', verbose_name='photo'),
        ),
        migrations.AlterField(
            model_name='leaderlistplugin',
            name='school_year',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.SchoolYear', verbose_name='school year'),
        ),
        migrations.AlterField(
            model_name='leaderplugin',
            name='leader',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='leprikon.Leader', verbose_name='leader'),
        ),
        migrations.AlterModelOptions(
            name='messagerecipient',
            options={'ordering': ('-sent',), 'verbose_name': 'recipient', 'verbose_name_plural': 'recipients'},
        ),
        migrations.AlterField(
            model_name='participant',
            name='age_group',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.AgeGroup', verbose_name='age group'),
        ),
        migrations.AlterField(
            model_name='participant',
            name='insurance',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.Insurance', verbose_name='insurance'),
        ),
        migrations.AlterField(
            model_name='participant',
            name='school',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='participants', to='leprikon.School', verbose_name='school'),
        ),
        migrations.AlterField(
            model_name='printsetup',
            name='background',
            field=filer.fields.file.FilerFileField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='filer.File', verbose_name='pdf background'),
        ),
        migrations.AlterField(
            model_name='printsetup',
            name='bottom',
            field=models.IntegerField(blank=True, default=20, help_text='distance in milimetres', verbose_name='margin bottom'),
        ),
        migrations.AlterField(
            model_name='printsetup',
            name='left',
            field=models.IntegerField(blank=True, default=20, help_text='distance in milimetres', verbose_name='margin left'),
        ),
        migrations.AlterField(
            model_name='printsetup',
            name='right',
            field=models.IntegerField(blank=True, default=20, help_text='distance in milimetres', verbose_name='margin right'),
        ),
        migrations.AlterField(
            model_name='printsetup',
            name='top',
            field=models.IntegerField(blank=True, default=20, help_text='distance in milimetres', verbose_name='margin top'),
        ),
        migrations.AlterField(
            model_name='timesheet',
            name='leader',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='timesheets', to='leprikon.Leader', verbose_name='leader'),
        ),
        migrations.AlterField(
            model_name='timesheet',
            name='period',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='timesheets', to='leprikon.TimesheetPeriod', verbose_name='period'),
        ),
        migrations.AlterField(
            model_name='timesheetentry',
            name='entry_type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='entries', to='leprikon.TimesheetEntryType', verbose_name='entry type'),
        ),
        #
        # Remove stale models
        #
        migrations.RemoveField(
            model_name='club',
            name='age_groups',
        ),
        migrations.RemoveField(
            model_name='club',
            name='club_type',
        ),
        migrations.RemoveField(
            model_name='club',
            name='course',
        ),
        migrations.RemoveField(
            model_name='club',
            name='groups',
        ),
        migrations.RemoveField(
            model_name='club',
            name='leaders',
        ),
        migrations.RemoveField(
            model_name='club',
            name='page',
        ),
        migrations.RemoveField(
            model_name='club',
            name='photo',
        ),
        migrations.RemoveField(
            model_name='club',
            name='place',
        ),
        migrations.RemoveField(
            model_name='club',
            name='questions',
        ),
        migrations.RemoveField(
            model_name='club',
            name='reg_printsetup',
        ),
        migrations.RemoveField(
            model_name='club',
            name='school_year',
        ),
        migrations.RemoveField(
            model_name='clubattachment',
            name='club',
        ),
        migrations.RemoveField(
            model_name='clubattachment',
            name='file',
        ),
        migrations.RemoveField(
            model_name='clubgroup',
            name='subject_group',
        ),
        migrations.RemoveField(
            model_name='clubjournalentry',
            name='club',
        ),
        migrations.RemoveField(
            model_name='clubjournalentry',
            name='registrations',
        ),
        migrations.AlterUniqueTogether(
            name='clubjournalleaderentry',
            unique_together=set([]),
        ),
        migrations.RemoveField(
            model_name='clubjournalleaderentry',
            name='club_entry',
        ),
        migrations.RemoveField(
            model_name='clubjournalleaderentry',
            name='timesheet',
        ),
        migrations.RemoveField(
            model_name='clubpayment',
            name='registration',
        ),
        migrations.RemoveField(
            model_name='clubperiod',
            name='club',
        ),
        migrations.RemoveField(
            model_name='clubperiod',
            name='school_year_period',
        ),
        migrations.AlterUniqueTogether(
            name='clubregistration',
            unique_together=set([]),
        ),
        migrations.RemoveField(
            model_name='clubregistration',
            name='club',
        ),
        migrations.RemoveField(
            model_name='clubregistration',
            name='course_registration',
        ),
        migrations.RemoveField(
            model_name='clubregistration',
            name='participant_age_group',
        ),
        migrations.RemoveField(
            model_name='clubregistration',
            name='participant_insurance',
        ),
        migrations.RemoveField(
            model_name='clubregistration',
            name='participant_school',
        ),
        migrations.RemoveField(
            model_name='clubregistration',
            name='user',
        ),
        migrations.AlterUniqueTogether(
            name='clubregistrationdiscount',
            unique_together=set([]),
        ),
        migrations.RemoveField(
            model_name='clubregistrationdiscount',
            name='period',
        ),
        migrations.RemoveField(
            model_name='clubregistrationdiscount',
            name='registration',
        ),
        migrations.RemoveField(
            model_name='clubregistrationhistory',
            name='club',
        ),
        migrations.RemoveField(
            model_name='clubregistrationhistory',
            name='registration',
        ),
        migrations.AlterUniqueTogether(
            name='clubregistrationrequest',
            unique_together=set([]),
        ),
        migrations.RemoveField(
            model_name='clubregistrationrequest',
            name='club',
        ),
        migrations.RemoveField(
            model_name='clubregistrationrequest',
            name='user',
        ),
        migrations.RemoveField(
            model_name='clubtime',
            name='club',
        ),
        migrations.RemoveField(
            model_name='clubtype',
            name='questions',
        ),
        migrations.RemoveField(
            model_name='clubtype',
            name='reg_printsetup',
        ),
        migrations.RemoveField(
            model_name='clubtype',
            name='subject_type',
        ),
        migrations.RemoveField(
            model_name='clubtypeattachment',
            name='club_type',
        ),
        migrations.RemoveField(
            model_name='clubtypeattachment',
            name='file',
        ),
        migrations.RemoveField(
            model_name='eventattachment',
            name='event',
        ),
        migrations.RemoveField(
            model_name='eventattachment',
            name='file',
        ),
        migrations.RemoveField(
            model_name='eventgroup',
            name='subject_group',
        ),
        migrations.RemoveField(
            model_name='eventpayment',
            name='registration',
        ),
        migrations.AlterUniqueTogether(
            name='eventregistrationrequest',
            unique_together=set([]),
        ),
        migrations.RemoveField(
            model_name='eventregistrationrequest',
            name='event',
        ),
        migrations.RemoveField(
            model_name='eventregistrationrequest',
            name='user',
        ),
        migrations.RemoveField(
            model_name='eventtype',
            name='questions',
        ),
        migrations.RemoveField(
            model_name='eventtype',
            name='reg_printsetup',
        ),
        migrations.RemoveField(
            model_name='eventtype',
            name='subject_type',
        ),
        migrations.RemoveField(
            model_name='eventtypeattachment',
            name='event_type',
        ),
        migrations.RemoveField(
            model_name='eventtypeattachment',
            name='file',
        ),
        migrations.RemoveField(
            model_name='oldevent',
            name='age_groups',
        ),
        migrations.RemoveField(
            model_name='oldevent',
            name='event',
        ),
        migrations.RemoveField(
            model_name='oldevent',
            name='event_type',
        ),
        migrations.RemoveField(
            model_name='oldevent',
            name='groups',
        ),
        migrations.RemoveField(
            model_name='oldevent',
            name='leaders',
        ),
        migrations.RemoveField(
            model_name='oldevent',
            name='page',
        ),
        migrations.RemoveField(
            model_name='oldevent',
            name='photo',
        ),
        migrations.RemoveField(
            model_name='oldevent',
            name='place',
        ),
        migrations.RemoveField(
            model_name='oldevent',
            name='questions',
        ),
        migrations.RemoveField(
            model_name='oldevent',
            name='reg_printsetup',
        ),
        migrations.RemoveField(
            model_name='oldevent',
            name='school_year',
        ),
        migrations.AlterUniqueTogether(
            name='oldeventregistration',
            unique_together=set([]),
        ),
        migrations.RemoveField(
            model_name='oldeventregistration',
            name='event',
        ),
        migrations.RemoveField(
            model_name='oldeventregistration',
            name='event_registration',
        ),
        migrations.RemoveField(
            model_name='oldeventregistration',
            name='participant_age_group',
        ),
        migrations.RemoveField(
            model_name='oldeventregistration',
            name='participant_insurance',
        ),
        migrations.RemoveField(
            model_name='oldeventregistration',
            name='participant_school',
        ),
        migrations.RemoveField(
            model_name='oldeventregistration',
            name='user',
        ),
        migrations.RemoveField(
            model_name='courselistplugin',
            name='club_type',
        ),
        migrations.RemoveField(
            model_name='courselistplugin',
            name='old_groups',
        ),
        migrations.RemoveField(
            model_name='courseplugin',
            name='old_course',
        ),
        migrations.RemoveField(
            model_name='eventlistplugin',
            name='event_type',
        ),
        migrations.RemoveField(
            model_name='eventlistplugin',
            name='old_groups',
        ),
        migrations.RemoveField(
            model_name='eventplugin',
            name='old_event',
        ),
        migrations.RemoveField(
            model_name='filteredcourselistplugin',
            name='club_types',
        ),
        migrations.RemoveField(
            model_name='filteredeventlistplugin',
            name='old_event_types',
        ),
        migrations.RemoveField(
            model_name='leaderlistplugin',
            name='club',
        ),
        migrations.RemoveField(
            model_name='leaderlistplugin',
            name='event',
        ),
        migrations.DeleteModel(
            name='Club',
        ),
        migrations.DeleteModel(
            name='ClubAttachment',
        ),
        migrations.DeleteModel(
            name='ClubGroup',
        ),
        migrations.DeleteModel(
            name='ClubJournalEntry',
        ),
        migrations.DeleteModel(
            name='ClubJournalLeaderEntry',
        ),
        migrations.DeleteModel(
            name='ClubPayment',
        ),
        migrations.DeleteModel(
            name='ClubPeriod',
        ),
        migrations.DeleteModel(
            name='ClubRegistration',
        ),
        migrations.DeleteModel(
            name='ClubRegistrationDiscount',
        ),
        migrations.DeleteModel(
            name='clubregistrationhistory',
        ),
        migrations.DeleteModel(
            name='ClubRegistrationRequest',
        ),
        migrations.DeleteModel(
            name='ClubTime',
        ),
        migrations.DeleteModel(
            name='ClubType',
        ),
        migrations.DeleteModel(
            name='ClubTypeAttachment',
        ),
        migrations.DeleteModel(
            name='EventAttachment',
        ),
        migrations.DeleteModel(
            name='EventGroup',
        ),
        migrations.DeleteModel(
            name='EventPayment',
        ),
        migrations.DeleteModel(
            name='EventRegistrationRequest',
        ),
        migrations.DeleteModel(
            name='EventType',
        ),
        migrations.DeleteModel(
            name='EventTypeAttachment',
        ),
        migrations.DeleteModel(
            name='OldEvent',
        ),
        migrations.DeleteModel(
            name='OldEventRegistration',
        ),
    ]
