# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFlavorsResult',
    'AwaitableGetFlavorsResult',
    'get_flavors',
    'get_flavors_output',
]

@pulumi.output_type
class GetFlavorsResult:
    """
    A collection of values returned by getFlavors.
    """
    def __init__(__self__, flavors=None, id=None, name_filter=None, region=None, service_name=None):
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_filter and not isinstance(name_filter, str):
            raise TypeError("Expected argument 'name_filter' to be a str")
        pulumi.set(__self__, "name_filter", name_filter)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @_builtins.property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetFlavorsFlavorResult']:
        return pulumi.get(self, "flavors")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nameFilter")
    def name_filter(self) -> Optional[_builtins.str]:
        """
        Filter flavors using the given name (strict equality, e.g. b2-7)
        """
        return pulumi.get(self, "name_filter")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Flavor region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        Service name
        """
        return pulumi.get(self, "service_name")


class AwaitableGetFlavorsResult(GetFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlavorsResult(
            flavors=self.flavors,
            id=self.id,
            name_filter=self.name_filter,
            region=self.region,
            service_name=self.service_name)


def get_flavors(name_filter: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                service_name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlavorsResult:
    """
    Retrieves the available flavors on the given public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    flavors = ovh.CloudProject.get_flavors(service_name="YYYY")
    ```


    :param _builtins.str name_filter: Filter flavors using the given name (strict equality, e.g. b2-7)
    :param _builtins.str region: Flavor region
    :param _builtins.str service_name: Service name
    """
    __args__ = dict()
    __args__['nameFilter'] = name_filter
    __args__['region'] = region
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult).value

    return AwaitableGetFlavorsResult(
        flavors=pulumi.get(__ret__, 'flavors'),
        id=pulumi.get(__ret__, 'id'),
        name_filter=pulumi.get(__ret__, 'name_filter'),
        region=pulumi.get(__ret__, 'region'),
        service_name=pulumi.get(__ret__, 'service_name'))
def get_flavors_output(name_filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       service_name: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlavorsResult]:
    """
    Retrieves the available flavors on the given public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    flavors = ovh.CloudProject.get_flavors(service_name="YYYY")
    ```


    :param _builtins.str name_filter: Filter flavors using the given name (strict equality, e.g. b2-7)
    :param _builtins.str region: Flavor region
    :param _builtins.str service_name: Service name
    """
    __args__ = dict()
    __args__['nameFilter'] = name_filter
    __args__['region'] = region
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult)
    return __ret__.apply(lambda __response__: GetFlavorsResult(
        flavors=pulumi.get(__response__, 'flavors'),
        id=pulumi.get(__response__, 'id'),
        name_filter=pulumi.get(__response__, 'name_filter'),
        region=pulumi.get(__response__, 'region'),
        service_name=pulumi.get(__response__, 'service_name')))
