# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetMongoDbUserResult',
    'AwaitableGetMongoDbUserResult',
    'get_mongo_db_user',
    'get_mongo_db_user_output',
]

@pulumi.output_type
class GetMongoDbUserResult:
    """
    A collection of values returned by getMongoDbUser.
    """
    def __init__(__self__, cluster_id=None, created_at=None, id=None, name=None, roles=None, service_name=None, status=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Date of the creation of the user.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence[_builtins.str]:
        """
        Roles the user belongs to
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        Current status of the user.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Current status of the user.
        """
        return pulumi.get(self, "status")


class AwaitableGetMongoDbUserResult(GetMongoDbUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMongoDbUserResult(
            cluster_id=self.cluster_id,
            created_at=self.created_at,
            id=self.id,
            name=self.name,
            roles=self.roles,
            service_name=self.service_name,
            status=self.status)


def get_mongo_db_user(cluster_id: Optional[_builtins.str] = None,
                      name: Optional[_builtins.str] = None,
                      service_name: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMongoDbUserResult:
    """
    Use this data source to get information about a user of a mongodb cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    mongo_user = ovh.CloudProject.get_mongo_db_user(service_name="XXX",
        cluster_id="YYY",
        name="ZZZ@admin")
    pulumi.export("mongoUserRoles", mongo_user.roles)
    ```


    :param _builtins.str cluster_id: Cluster ID
    :param _builtins.str name: Name of the user with the authentication database in the format name@authDB, for example: johndoe@admin
    :param _builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getMongoDbUser:getMongoDbUser', __args__, opts=opts, typ=GetMongoDbUserResult).value

    return AwaitableGetMongoDbUserResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        roles=pulumi.get(__ret__, 'roles'),
        service_name=pulumi.get(__ret__, 'service_name'),
        status=pulumi.get(__ret__, 'status'))
def get_mongo_db_user_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                             name: Optional[pulumi.Input[_builtins.str]] = None,
                             service_name: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMongoDbUserResult]:
    """
    Use this data source to get information about a user of a mongodb cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    mongo_user = ovh.CloudProject.get_mongo_db_user(service_name="XXX",
        cluster_id="YYY",
        name="ZZZ@admin")
    pulumi.export("mongoUserRoles", mongo_user.roles)
    ```


    :param _builtins.str cluster_id: Cluster ID
    :param _builtins.str name: Name of the user with the authentication database in the format name@authDB, for example: johndoe@admin
    :param _builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getMongoDbUser:getMongoDbUser', __args__, opts=opts, typ=GetMongoDbUserResult)
    return __ret__.apply(lambda __response__: GetMongoDbUserResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        roles=pulumi.get(__response__, 'roles'),
        service_name=pulumi.get(__response__, 'service_name'),
        status=pulumi.get(__response__, 'status')))
