# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkPrivateSubnetsResult',
    'AwaitableGetNetworkPrivateSubnetsResult',
    'get_network_private_subnets',
    'get_network_private_subnets_output',
]

@pulumi.output_type
class GetNetworkPrivateSubnetsResult:
    """
    A collection of values returned by getNetworkPrivateSubnets.
    """
    def __init__(__self__, id=None, network_id=None, service_name=None, subnets=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if subnets and not isinstance(subnets, list):
            raise TypeError("Expected argument 'subnets' to be a list")
        pulumi.set(__self__, "subnets", subnets)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        ID of the network
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        ID of the public cloud project
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Sequence['outputs.GetNetworkPrivateSubnetsSubnetResult']:
        """
        List of subnets
        """
        return pulumi.get(self, "subnets")


class AwaitableGetNetworkPrivateSubnetsResult(GetNetworkPrivateSubnetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkPrivateSubnetsResult(
            id=self.id,
            network_id=self.network_id,
            service_name=self.service_name,
            subnets=self.subnets)


def get_network_private_subnets(network_id: Optional[_builtins.str] = None,
                                service_name: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkPrivateSubnetsResult:
    """
    List public cloud project subnets of a private network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    private = ovh.CloudProject.get_network_private_subnets(service_name="XXXXXX",
        network_id="XXXXXX")
    pulumi.export("private", private)
    ```


    :param _builtins.str network_id: ID of the network
    :param _builtins.str service_name: The ID of the public cloud project.
    """
    __args__ = dict()
    __args__['networkId'] = network_id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getNetworkPrivateSubnets:getNetworkPrivateSubnets', __args__, opts=opts, typ=GetNetworkPrivateSubnetsResult).value

    return AwaitableGetNetworkPrivateSubnetsResult(
        id=pulumi.get(__ret__, 'id'),
        network_id=pulumi.get(__ret__, 'network_id'),
        service_name=pulumi.get(__ret__, 'service_name'),
        subnets=pulumi.get(__ret__, 'subnets'))
def get_network_private_subnets_output(network_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkPrivateSubnetsResult]:
    """
    List public cloud project subnets of a private network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    private = ovh.CloudProject.get_network_private_subnets(service_name="XXXXXX",
        network_id="XXXXXX")
    pulumi.export("private", private)
    ```


    :param _builtins.str network_id: ID of the network
    :param _builtins.str service_name: The ID of the public cloud project.
    """
    __args__ = dict()
    __args__['networkId'] = network_id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getNetworkPrivateSubnets:getNetworkPrivateSubnets', __args__, opts=opts, typ=GetNetworkPrivateSubnetsResult)
    return __ret__.apply(lambda __response__: GetNetworkPrivateSubnetsResult(
        id=pulumi.get(__response__, 'id'),
        network_id=pulumi.get(__response__, 'network_id'),
        service_name=pulumi.get(__response__, 'service_name'),
        subnets=pulumi.get(__response__, 'subnets')))
