# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 billing_period: pulumi.Input[_builtins.str],
                 boot_from: pulumi.Input['InstanceBootFromArgs'],
                 flavor: pulumi.Input['InstanceFlavorArgs'],
                 network: pulumi.Input['InstanceNetworkArgs'],
                 region: pulumi.Input[_builtins.str],
                 auto_backup: Optional[pulumi.Input['InstanceAutoBackupArgs']] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 bulk: Optional[pulumi.Input[_builtins.int]] = None,
                 group: Optional[pulumi.Input['InstanceGroupArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_key: Optional[pulumi.Input['InstanceSshKeyArgs']] = None,
                 ssh_key_create: Optional[pulumi.Input['InstanceSshKeyCreateArgs']] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] billing_period: Billing period - hourly or monthly
        :param pulumi.Input['InstanceBootFromArgs'] boot_from: Boot the instance from an image or a volume
        :param pulumi.Input['InstanceFlavorArgs'] flavor: Flavor information
        :param pulumi.Input['InstanceNetworkArgs'] network: Create network interfaces
        :param pulumi.Input[_builtins.str] region: Instance region
        :param pulumi.Input['InstanceAutoBackupArgs'] auto_backup: Create an autobackup workflow after instance start up.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone where the instance will be created
        :param pulumi.Input[_builtins.int] bulk: Create multiple instances
        :param pulumi.Input['InstanceGroupArgs'] group: Start instance in group
        :param pulumi.Input[_builtins.str] name: Instance name
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used
        :param pulumi.Input['InstanceSshKeyArgs'] ssh_key: Existing SSH Keypair
        :param pulumi.Input['InstanceSshKeyCreateArgs'] ssh_key_create: Add existing SSH Key pair into your Public Cloud project and link it to the instance
        :param pulumi.Input[_builtins.str] user_data: Configuration information or scripts to use upon launch
        """
        pulumi.set(__self__, "billing_period", billing_period)
        pulumi.set(__self__, "boot_from", boot_from)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "region", region)
        if auto_backup is not None:
            pulumi.set(__self__, "auto_backup", auto_backup)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if bulk is not None:
            pulumi.set(__self__, "bulk", bulk)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if ssh_key_create is not None:
            pulumi.set(__self__, "ssh_key_create", ssh_key_create)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter(name="billingPeriod")
    def billing_period(self) -> pulumi.Input[_builtins.str]:
        """
        Billing period - hourly or monthly
        """
        return pulumi.get(self, "billing_period")

    @billing_period.setter
    def billing_period(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "billing_period", value)

    @_builtins.property
    @pulumi.getter(name="bootFrom")
    def boot_from(self) -> pulumi.Input['InstanceBootFromArgs']:
        """
        Boot the instance from an image or a volume
        """
        return pulumi.get(self, "boot_from")

    @boot_from.setter
    def boot_from(self, value: pulumi.Input['InstanceBootFromArgs']):
        pulumi.set(self, "boot_from", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Input['InstanceFlavorArgs']:
        """
        Flavor information
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input['InstanceFlavorArgs']):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input['InstanceNetworkArgs']:
        """
        Create network interfaces
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input['InstanceNetworkArgs']):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        Instance region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="autoBackup")
    def auto_backup(self) -> Optional[pulumi.Input['InstanceAutoBackupArgs']]:
        """
        Create an autobackup workflow after instance start up.
        """
        return pulumi.get(self, "auto_backup")

    @auto_backup.setter
    def auto_backup(self, value: Optional[pulumi.Input['InstanceAutoBackupArgs']]):
        pulumi.set(self, "auto_backup", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability zone where the instance will be created
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter
    def bulk(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Create multiple instances
        """
        return pulumi.get(self, "bulk")

    @bulk.setter
    def bulk(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bulk", value)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input['InstanceGroupArgs']]:
        """
        Start instance in group
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input['InstanceGroupArgs']]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[pulumi.Input['InstanceSshKeyArgs']]:
        """
        Existing SSH Keypair
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: Optional[pulumi.Input['InstanceSshKeyArgs']]):
        pulumi.set(self, "ssh_key", value)

    @_builtins.property
    @pulumi.getter(name="sshKeyCreate")
    def ssh_key_create(self) -> Optional[pulumi.Input['InstanceSshKeyCreateArgs']]:
        """
        Add existing SSH Key pair into your Public Cloud project and link it to the instance
        """
        return pulumi.get(self, "ssh_key_create")

    @ssh_key_create.setter
    def ssh_key_create(self, value: Optional[pulumi.Input['InstanceSshKeyCreateArgs']]):
        pulumi.set(self, "ssh_key_create", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configuration information or scripts to use upon launch
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAddressArgs']]]] = None,
                 attached_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAttachedVolumeArgs']]]] = None,
                 auto_backup: Optional[pulumi.Input['InstanceAutoBackupArgs']] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_period: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_from: Optional[pulumi.Input['InstanceBootFromArgs']] = None,
                 bulk: Optional[pulumi.Input[_builtins.int]] = None,
                 flavor: Optional[pulumi.Input['InstanceFlavorArgs']] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_name: Optional[pulumi.Input[_builtins.str]] = None,
                 group: Optional[pulumi.Input['InstanceGroupArgs']] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input['InstanceNetworkArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_key: Optional[pulumi.Input['InstanceSshKeyArgs']] = None,
                 ssh_key_create: Optional[pulumi.Input['InstanceSshKeyCreateArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 task_state: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceAddressArgs']]] addresses: Instance IP addresses
        :param pulumi.Input[Sequence[pulumi.Input['InstanceAttachedVolumeArgs']]] attached_volumes: Volumes attached to the instance
        :param pulumi.Input['InstanceAutoBackupArgs'] auto_backup: Create an autobackup workflow after instance start up.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone where the instance will be created
        :param pulumi.Input[_builtins.str] billing_period: Billing period - hourly or monthly
        :param pulumi.Input['InstanceBootFromArgs'] boot_from: Boot the instance from an image or a volume
        :param pulumi.Input[_builtins.int] bulk: Create multiple instances
        :param pulumi.Input['InstanceFlavorArgs'] flavor: Flavor information
        :param pulumi.Input[_builtins.str] flavor_id: Flavor id
        :param pulumi.Input[_builtins.str] flavor_name: Flavor name
        :param pulumi.Input['InstanceGroupArgs'] group: Start instance in group
        :param pulumi.Input[_builtins.str] image_id: Image id
        :param pulumi.Input[_builtins.str] name: Instance name
        :param pulumi.Input['InstanceNetworkArgs'] network: Create network interfaces
        :param pulumi.Input[_builtins.str] region: Instance region
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used
        :param pulumi.Input['InstanceSshKeyArgs'] ssh_key: Existing SSH Keypair
        :param pulumi.Input['InstanceSshKeyCreateArgs'] ssh_key_create: Add existing SSH Key pair into your Public Cloud project and link it to the instance
        :param pulumi.Input[_builtins.str] status: Instance status
        :param pulumi.Input[_builtins.str] task_state: Instance task state
        :param pulumi.Input[_builtins.str] user_data: Configuration information or scripts to use upon launch
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if attached_volumes is not None:
            pulumi.set(__self__, "attached_volumes", attached_volumes)
        if auto_backup is not None:
            pulumi.set(__self__, "auto_backup", auto_backup)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if billing_period is not None:
            pulumi.set(__self__, "billing_period", billing_period)
        if boot_from is not None:
            pulumi.set(__self__, "boot_from", boot_from)
        if bulk is not None:
            pulumi.set(__self__, "bulk", bulk)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if flavor_name is not None:
            pulumi.set(__self__, "flavor_name", flavor_name)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if ssh_key_create is not None:
            pulumi.set(__self__, "ssh_key_create", ssh_key_create)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if task_state is not None:
            pulumi.set(__self__, "task_state", task_state)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAddressArgs']]]]:
        """
        Instance IP addresses
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAddressArgs']]]]):
        pulumi.set(self, "addresses", value)

    @_builtins.property
    @pulumi.getter(name="attachedVolumes")
    def attached_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAttachedVolumeArgs']]]]:
        """
        Volumes attached to the instance
        """
        return pulumi.get(self, "attached_volumes")

    @attached_volumes.setter
    def attached_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAttachedVolumeArgs']]]]):
        pulumi.set(self, "attached_volumes", value)

    @_builtins.property
    @pulumi.getter(name="autoBackup")
    def auto_backup(self) -> Optional[pulumi.Input['InstanceAutoBackupArgs']]:
        """
        Create an autobackup workflow after instance start up.
        """
        return pulumi.get(self, "auto_backup")

    @auto_backup.setter
    def auto_backup(self, value: Optional[pulumi.Input['InstanceAutoBackupArgs']]):
        pulumi.set(self, "auto_backup", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability zone where the instance will be created
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="billingPeriod")
    def billing_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Billing period - hourly or monthly
        """
        return pulumi.get(self, "billing_period")

    @billing_period.setter
    def billing_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_period", value)

    @_builtins.property
    @pulumi.getter(name="bootFrom")
    def boot_from(self) -> Optional[pulumi.Input['InstanceBootFromArgs']]:
        """
        Boot the instance from an image or a volume
        """
        return pulumi.get(self, "boot_from")

    @boot_from.setter
    def boot_from(self, value: Optional[pulumi.Input['InstanceBootFromArgs']]):
        pulumi.set(self, "boot_from", value)

    @_builtins.property
    @pulumi.getter
    def bulk(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Create multiple instances
        """
        return pulumi.get(self, "bulk")

    @bulk.setter
    def bulk(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bulk", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input['InstanceFlavorArgs']]:
        """
        Flavor information
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input['InstanceFlavorArgs']]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Flavor id
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Flavor name
        """
        return pulumi.get(self, "flavor_name")

    @flavor_name.setter
    def flavor_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_name", value)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input['InstanceGroupArgs']]:
        """
        Start instance in group
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input['InstanceGroupArgs']]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image id
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['InstanceNetworkArgs']]:
        """
        Create network interfaces
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['InstanceNetworkArgs']]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[pulumi.Input['InstanceSshKeyArgs']]:
        """
        Existing SSH Keypair
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: Optional[pulumi.Input['InstanceSshKeyArgs']]):
        pulumi.set(self, "ssh_key", value)

    @_builtins.property
    @pulumi.getter(name="sshKeyCreate")
    def ssh_key_create(self) -> Optional[pulumi.Input['InstanceSshKeyCreateArgs']]:
        """
        Add existing SSH Key pair into your Public Cloud project and link it to the instance
        """
        return pulumi.get(self, "ssh_key_create")

    @ssh_key_create.setter
    def ssh_key_create(self, value: Optional[pulumi.Input['InstanceSshKeyCreateArgs']]):
        pulumi.set(self, "ssh_key_create", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="taskState")
    def task_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance task state
        """
        return pulumi.get(self, "task_state")

    @task_state.setter
    def task_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task_state", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configuration information or scripts to use upon launch
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)


@pulumi.type_token("ovh:CloudProject/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_backup: Optional[pulumi.Input[Union['InstanceAutoBackupArgs', 'InstanceAutoBackupArgsDict']]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_period: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_from: Optional[pulumi.Input[Union['InstanceBootFromArgs', 'InstanceBootFromArgsDict']]] = None,
                 bulk: Optional[pulumi.Input[_builtins.int]] = None,
                 flavor: Optional[pulumi.Input[Union['InstanceFlavorArgs', 'InstanceFlavorArgsDict']]] = None,
                 group: Optional[pulumi.Input[Union['InstanceGroupArgs', 'InstanceGroupArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_key: Optional[pulumi.Input[Union['InstanceSshKeyArgs', 'InstanceSshKeyArgsDict']]] = None,
                 ssh_key_create: Optional[pulumi.Input[Union['InstanceSshKeyCreateArgs', 'InstanceSshKeyCreateArgsDict']]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        **This resource uses a Beta API** Creates an instance associated with a public cloud project.

        ## Example Usage

        Create a instance.

        ```python
        import pulumi
        import pulumi_ovh as ovh

        instance = ovh.cloudproject.Instance("instance",
            service_name="XXX",
            region="RRRR",
            billing_period="hourly",
            boot_from={
                "image_id": "UUID",
            },
            flavor={
                "flavor_id": "UUID",
            },
            name="instance name",
            ssh_key={
                "name": "sshname",
            },
            network={
                "public": True,
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InstanceAutoBackupArgs', 'InstanceAutoBackupArgsDict']] auto_backup: Create an autobackup workflow after instance start up.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone where the instance will be created
        :param pulumi.Input[_builtins.str] billing_period: Billing period - hourly or monthly
        :param pulumi.Input[Union['InstanceBootFromArgs', 'InstanceBootFromArgsDict']] boot_from: Boot the instance from an image or a volume
        :param pulumi.Input[_builtins.int] bulk: Create multiple instances
        :param pulumi.Input[Union['InstanceFlavorArgs', 'InstanceFlavorArgsDict']] flavor: Flavor information
        :param pulumi.Input[Union['InstanceGroupArgs', 'InstanceGroupArgsDict']] group: Start instance in group
        :param pulumi.Input[_builtins.str] name: Instance name
        :param pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']] network: Create network interfaces
        :param pulumi.Input[_builtins.str] region: Instance region
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used
        :param pulumi.Input[Union['InstanceSshKeyArgs', 'InstanceSshKeyArgsDict']] ssh_key: Existing SSH Keypair
        :param pulumi.Input[Union['InstanceSshKeyCreateArgs', 'InstanceSshKeyCreateArgsDict']] ssh_key_create: Add existing SSH Key pair into your Public Cloud project and link it to the instance
        :param pulumi.Input[_builtins.str] user_data: Configuration information or scripts to use upon launch
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        **This resource uses a Beta API** Creates an instance associated with a public cloud project.

        ## Example Usage

        Create a instance.

        ```python
        import pulumi
        import pulumi_ovh as ovh

        instance = ovh.cloudproject.Instance("instance",
            service_name="XXX",
            region="RRRR",
            billing_period="hourly",
            boot_from={
                "image_id": "UUID",
            },
            flavor={
                "flavor_id": "UUID",
            },
            name="instance name",
            ssh_key={
                "name": "sshname",
            },
            network={
                "public": True,
            })
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_backup: Optional[pulumi.Input[Union['InstanceAutoBackupArgs', 'InstanceAutoBackupArgsDict']]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_period: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_from: Optional[pulumi.Input[Union['InstanceBootFromArgs', 'InstanceBootFromArgsDict']]] = None,
                 bulk: Optional[pulumi.Input[_builtins.int]] = None,
                 flavor: Optional[pulumi.Input[Union['InstanceFlavorArgs', 'InstanceFlavorArgsDict']]] = None,
                 group: Optional[pulumi.Input[Union['InstanceGroupArgs', 'InstanceGroupArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_key: Optional[pulumi.Input[Union['InstanceSshKeyArgs', 'InstanceSshKeyArgsDict']]] = None,
                 ssh_key_create: Optional[pulumi.Input[Union['InstanceSshKeyCreateArgs', 'InstanceSshKeyCreateArgsDict']]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_backup"] = auto_backup
            __props__.__dict__["availability_zone"] = availability_zone
            if billing_period is None and not opts.urn:
                raise TypeError("Missing required property 'billing_period'")
            __props__.__dict__["billing_period"] = billing_period
            if boot_from is None and not opts.urn:
                raise TypeError("Missing required property 'boot_from'")
            __props__.__dict__["boot_from"] = boot_from
            __props__.__dict__["bulk"] = bulk
            if flavor is None and not opts.urn:
                raise TypeError("Missing required property 'flavor'")
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["group"] = group
            __props__.__dict__["name"] = name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["ssh_key"] = ssh_key
            __props__.__dict__["ssh_key_create"] = ssh_key_create
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["addresses"] = None
            __props__.__dict__["attached_volumes"] = None
            __props__.__dict__["flavor_id"] = None
            __props__.__dict__["flavor_name"] = None
            __props__.__dict__["image_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["task_state"] = None
        super(Instance, __self__).__init__(
            'ovh:CloudProject/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceAddressArgs', 'InstanceAddressArgsDict']]]]] = None,
            attached_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceAttachedVolumeArgs', 'InstanceAttachedVolumeArgsDict']]]]] = None,
            auto_backup: Optional[pulumi.Input[Union['InstanceAutoBackupArgs', 'InstanceAutoBackupArgsDict']]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            billing_period: Optional[pulumi.Input[_builtins.str]] = None,
            boot_from: Optional[pulumi.Input[Union['InstanceBootFromArgs', 'InstanceBootFromArgsDict']]] = None,
            bulk: Optional[pulumi.Input[_builtins.int]] = None,
            flavor: Optional[pulumi.Input[Union['InstanceFlavorArgs', 'InstanceFlavorArgsDict']]] = None,
            flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
            flavor_name: Optional[pulumi.Input[_builtins.str]] = None,
            group: Optional[pulumi.Input[Union['InstanceGroupArgs', 'InstanceGroupArgsDict']]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            ssh_key: Optional[pulumi.Input[Union['InstanceSshKeyArgs', 'InstanceSshKeyArgsDict']]] = None,
            ssh_key_create: Optional[pulumi.Input[Union['InstanceSshKeyCreateArgs', 'InstanceSshKeyCreateArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            task_state: Optional[pulumi.Input[_builtins.str]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceAddressArgs', 'InstanceAddressArgsDict']]]] addresses: Instance IP addresses
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceAttachedVolumeArgs', 'InstanceAttachedVolumeArgsDict']]]] attached_volumes: Volumes attached to the instance
        :param pulumi.Input[Union['InstanceAutoBackupArgs', 'InstanceAutoBackupArgsDict']] auto_backup: Create an autobackup workflow after instance start up.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone where the instance will be created
        :param pulumi.Input[_builtins.str] billing_period: Billing period - hourly or monthly
        :param pulumi.Input[Union['InstanceBootFromArgs', 'InstanceBootFromArgsDict']] boot_from: Boot the instance from an image or a volume
        :param pulumi.Input[_builtins.int] bulk: Create multiple instances
        :param pulumi.Input[Union['InstanceFlavorArgs', 'InstanceFlavorArgsDict']] flavor: Flavor information
        :param pulumi.Input[_builtins.str] flavor_id: Flavor id
        :param pulumi.Input[_builtins.str] flavor_name: Flavor name
        :param pulumi.Input[Union['InstanceGroupArgs', 'InstanceGroupArgsDict']] group: Start instance in group
        :param pulumi.Input[_builtins.str] image_id: Image id
        :param pulumi.Input[_builtins.str] name: Instance name
        :param pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']] network: Create network interfaces
        :param pulumi.Input[_builtins.str] region: Instance region
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used
        :param pulumi.Input[Union['InstanceSshKeyArgs', 'InstanceSshKeyArgsDict']] ssh_key: Existing SSH Keypair
        :param pulumi.Input[Union['InstanceSshKeyCreateArgs', 'InstanceSshKeyCreateArgsDict']] ssh_key_create: Add existing SSH Key pair into your Public Cloud project and link it to the instance
        :param pulumi.Input[_builtins.str] status: Instance status
        :param pulumi.Input[_builtins.str] task_state: Instance task state
        :param pulumi.Input[_builtins.str] user_data: Configuration information or scripts to use upon launch
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["addresses"] = addresses
        __props__.__dict__["attached_volumes"] = attached_volumes
        __props__.__dict__["auto_backup"] = auto_backup
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["billing_period"] = billing_period
        __props__.__dict__["boot_from"] = boot_from
        __props__.__dict__["bulk"] = bulk
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["flavor_name"] = flavor_name
        __props__.__dict__["group"] = group
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["region"] = region
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["ssh_key"] = ssh_key
        __props__.__dict__["ssh_key_create"] = ssh_key_create
        __props__.__dict__["status"] = status
        __props__.__dict__["task_state"] = task_state
        __props__.__dict__["user_data"] = user_data
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> pulumi.Output[Sequence['outputs.InstanceAddress']]:
        """
        Instance IP addresses
        """
        return pulumi.get(self, "addresses")

    @_builtins.property
    @pulumi.getter(name="attachedVolumes")
    def attached_volumes(self) -> pulumi.Output[Sequence['outputs.InstanceAttachedVolume']]:
        """
        Volumes attached to the instance
        """
        return pulumi.get(self, "attached_volumes")

    @_builtins.property
    @pulumi.getter(name="autoBackup")
    def auto_backup(self) -> pulumi.Output[Optional['outputs.InstanceAutoBackup']]:
        """
        Create an autobackup workflow after instance start up.
        """
        return pulumi.get(self, "auto_backup")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The availability zone where the instance will be created
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="billingPeriod")
    def billing_period(self) -> pulumi.Output[_builtins.str]:
        """
        Billing period - hourly or monthly
        """
        return pulumi.get(self, "billing_period")

    @_builtins.property
    @pulumi.getter(name="bootFrom")
    def boot_from(self) -> pulumi.Output['outputs.InstanceBootFrom']:
        """
        Boot the instance from an image or a volume
        """
        return pulumi.get(self, "boot_from")

    @_builtins.property
    @pulumi.getter
    def bulk(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Create multiple instances
        """
        return pulumi.get(self, "bulk")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Output['outputs.InstanceFlavor']:
        """
        Flavor information
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[_builtins.str]:
        """
        Flavor id
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> pulumi.Output[_builtins.str]:
        """
        Flavor name
        """
        return pulumi.get(self, "flavor_name")

    @_builtins.property
    @pulumi.getter
    def group(self) -> pulumi.Output[Optional['outputs.InstanceGroup']]:
        """
        Start instance in group
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[_builtins.str]:
        """
        Image id
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Instance name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output['outputs.InstanceNetwork']:
        """
        Create network interfaces
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Instance region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> pulumi.Output[Optional['outputs.InstanceSshKey']]:
        """
        Existing SSH Keypair
        """
        return pulumi.get(self, "ssh_key")

    @_builtins.property
    @pulumi.getter(name="sshKeyCreate")
    def ssh_key_create(self) -> pulumi.Output[Optional['outputs.InstanceSshKeyCreate']]:
        """
        Add existing SSH Key pair into your Public Cloud project and link it to the instance
        """
        return pulumi.get(self, "ssh_key_create")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Instance status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="taskState")
    def task_state(self) -> pulumi.Output[_builtins.str]:
        """
        Instance task state
        """
        return pulumi.get(self, "task_state")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Configuration information or scripts to use upon launch
        """
        return pulumi.get(self, "user_data")

