# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VolumeBackupArgs', 'VolumeBackup']

@pulumi.input_type
class VolumeBackupArgs:
    def __init__(__self__, *,
                 region_name: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 volume_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VolumeBackup resource.
        :param pulumi.Input[_builtins.str] region_name: Region name
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.str] volume_id: ID of the volume to backup
        :param pulumi.Input[_builtins.str] name: name of the backup
        """
        pulumi.set(__self__, "region_name", region_name)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "volume_id", volume_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Input[_builtins.str]:
        """
        Region name
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the volume to backup
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "volume_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of the backup
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _VolumeBackupState:
    def __init__(__self__, *,
                 creation_date: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 region_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.float]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VolumeBackup resources.
        :param pulumi.Input[_builtins.str] creation_date: Creation date of the backup
        :param pulumi.Input[_builtins.str] name: name of the backup
        :param pulumi.Input[_builtins.str] region: Volume backup region
        :param pulumi.Input[_builtins.str] region_name: Region name
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.float] size: Size of the backup in GiB
        :param pulumi.Input[_builtins.str] status: Staus of the backup
        :param pulumi.Input[_builtins.str] volume_id: ID of the volume to backup
        """
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation date of the backup
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_date", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of the backup
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Volume backup region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region name
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Size of the backup in GiB
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Staus of the backup
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the volume to backup
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_id", value)


@pulumi.type_token("ovh:CloudProject/volumeBackup:VolumeBackup")
class VolumeBackup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage backups for the given volume in a public cloud project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        backup = ovh.cloudproject.VolumeBackup("backup",
            service_name="<public cloud project ID>",
            region_name="GRA9",
            volume_id="<volume ID>",
            name="ExampleBackup")
        ```

        ## Import

        A volume backup in a public cloud project can be imported using the `service_name`, `region_name` and `id` attributes. Using the following configuration:

        terraform

        import {

          id = "<service_name>/<region_name>/<id>"

          to = ovh_cloud_project_volume_backup.backup

        }

        You can then run:

        bash

        $ pulumi preview -generate-config-out=backup.tf

        $ pulumi up

        The file `backup.tf` will then contain the imported resource's configuration, that can be copied next to the `import` block above. See https://developer.hashicorp.com/terraform/language/import/generating-configuration for more details.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: name of the backup
        :param pulumi.Input[_builtins.str] region_name: Region name
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.str] volume_id: ID of the volume to backup
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeBackupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage backups for the given volume in a public cloud project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        backup = ovh.cloudproject.VolumeBackup("backup",
            service_name="<public cloud project ID>",
            region_name="GRA9",
            volume_id="<volume ID>",
            name="ExampleBackup")
        ```

        ## Import

        A volume backup in a public cloud project can be imported using the `service_name`, `region_name` and `id` attributes. Using the following configuration:

        terraform

        import {

          id = "<service_name>/<region_name>/<id>"

          to = ovh_cloud_project_volume_backup.backup

        }

        You can then run:

        bash

        $ pulumi preview -generate-config-out=backup.tf

        $ pulumi up

        The file `backup.tf` will then contain the imported resource's configuration, that can be copied next to the `import` block above. See https://developer.hashicorp.com/terraform/language/import/generating-configuration for more details.

        :param str resource_name: The name of the resource.
        :param VolumeBackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeBackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeBackupArgs.__new__(VolumeBackupArgs)

            __props__.__dict__["name"] = name
            if region_name is None and not opts.urn:
                raise TypeError("Missing required property 'region_name'")
            __props__.__dict__["region_name"] = region_name
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if volume_id is None and not opts.urn:
                raise TypeError("Missing required property 'volume_id'")
            __props__.__dict__["volume_id"] = volume_id
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["region"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["status"] = None
        super(VolumeBackup, __self__).__init__(
            'ovh:CloudProject/volumeBackup:VolumeBackup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_date: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            region_name: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.float]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            volume_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VolumeBackup':
        """
        Get an existing VolumeBackup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] creation_date: Creation date of the backup
        :param pulumi.Input[_builtins.str] name: name of the backup
        :param pulumi.Input[_builtins.str] region: Volume backup region
        :param pulumi.Input[_builtins.str] region_name: Region name
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.float] size: Size of the backup in GiB
        :param pulumi.Input[_builtins.str] status: Staus of the backup
        :param pulumi.Input[_builtins.str] volume_id: ID of the volume to backup
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeBackupState.__new__(_VolumeBackupState)

        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["region_name"] = region_name
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        __props__.__dict__["volume_id"] = volume_id
        return VolumeBackup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[_builtins.str]:
        """
        Creation date of the backup
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        name of the backup
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Volume backup region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Output[_builtins.str]:
        """
        Region name
        """
        return pulumi.get(self, "region_name")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.float]:
        """
        Size of the backup in GiB
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Staus of the backup
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the volume to backup
        """
        return pulumi.get(self, "volume_id")

