# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetKafkaAclResult',
    'AwaitableGetKafkaAclResult',
    'get_kafka_acl',
    'get_kafka_acl_output',
]

@pulumi.output_type
class GetKafkaAclResult:
    """
    A collection of values returned by getKafkaAcl.
    """
    def __init__(__self__, cluster_id=None, id=None, permission=None, service_name=None, topic=None, username=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if permission and not isinstance(permission, str):
            raise TypeError("Expected argument 'permission' to be a str")
        pulumi.set(__self__, "permission", permission)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if topic and not isinstance(topic, str):
            raise TypeError("Expected argument 'topic' to be a str")
        pulumi.set(__self__, "topic", topic)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def permission(self) -> _builtins.str:
        """
        Permission to give to this username on this topic.
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> _builtins.str:
        """
        Topic affected by this ACL.
        """
        return pulumi.get(self, "topic")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Username affected by this ACL.
        """
        return pulumi.get(self, "username")


class AwaitableGetKafkaAclResult(GetKafkaAclResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKafkaAclResult(
            cluster_id=self.cluster_id,
            id=self.id,
            permission=self.permission,
            service_name=self.service_name,
            topic=self.topic,
            username=self.username)


def get_kafka_acl(cluster_id: Optional[_builtins.str] = None,
                  id: Optional[_builtins.str] = None,
                  service_name: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKafkaAclResult:
    """
    Use this data source to get information about an ACL of a kafka cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    acl = ovh.CloudProjectDatabase.get_kafka_acl(service_name="XXX",
        cluster_id="YYY",
        id="ZZZ")
    pulumi.export("aclPermission", acl.permission)
    ```


    :param _builtins.str cluster_id: Cluster ID
    :param _builtins.str id: ACL ID
    :param _builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['id'] = id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProjectDatabase/getKafkaAcl:getKafkaAcl', __args__, opts=opts, typ=GetKafkaAclResult).value

    return AwaitableGetKafkaAclResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        permission=pulumi.get(__ret__, 'permission'),
        service_name=pulumi.get(__ret__, 'service_name'),
        topic=pulumi.get(__ret__, 'topic'),
        username=pulumi.get(__ret__, 'username'))
def get_kafka_acl_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                         id: Optional[pulumi.Input[_builtins.str]] = None,
                         service_name: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKafkaAclResult]:
    """
    Use this data source to get information about an ACL of a kafka cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    acl = ovh.CloudProjectDatabase.get_kafka_acl(service_name="XXX",
        cluster_id="YYY",
        id="ZZZ")
    pulumi.export("aclPermission", acl.permission)
    ```


    :param _builtins.str cluster_id: Cluster ID
    :param _builtins.str id: ACL ID
    :param _builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['id'] = id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProjectDatabase/getKafkaAcl:getKafkaAcl', __args__, opts=opts, typ=GetKafkaAclResult)
    return __ret__.apply(lambda __response__: GetKafkaAclResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        id=pulumi.get(__response__, 'id'),
        permission=pulumi.get(__response__, 'permission'),
        service_name=pulumi.get(__response__, 'service_name'),
        topic=pulumi.get(__response__, 'topic'),
        username=pulumi.get(__response__, 'username')))
