# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'OpensearchUserAcl',
    'PrometheusTarget',
    'GetCapabilitiesEngineResult',
    'GetCapabilitiesFlavorResult',
    'GetCapabilitiesOptionResult',
    'GetCapabilitiesPlanResult',
    'GetDatabaseEndpointResult',
    'GetDatabaseIpRestrictionResult',
    'GetDatabaseNodeResult',
]

@pulumi.output_type
class OpensearchUserAcl(dict):
    def __init__(__self__, *,
                 pattern: _builtins.str,
                 permission: _builtins.str):
        """
        :param _builtins.str pattern: Pattern of the ACL.
        :param _builtins.str permission: Permission of the ACL Available permission:
        """
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "permission", permission)

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> _builtins.str:
        """
        Pattern of the ACL.
        """
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter
    def permission(self) -> _builtins.str:
        """
        Permission of the ACL Available permission:
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class PrometheusTarget(dict):
    def __init__(__self__, *,
                 host: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str host: Host of the endpoint
        :param _builtins.int port: Connection port for the endpoint
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Host of the endpoint
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Connection port for the endpoint
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetCapabilitiesEngineResult(dict):
    def __init__(__self__, *,
                 default_version: _builtins.str,
                 description: _builtins.str,
                 name: _builtins.str,
                 ssl_modes: Sequence[_builtins.str],
                 versions: Sequence[_builtins.str]):
        """
        :param _builtins.str default_version: Default version used for the engine.
        :param _builtins.str description: Description of the plan.
        :param _builtins.str name: Name of the plan.
        :param Sequence[_builtins.str] ssl_modes: SSL modes for this engine.
        :param Sequence[_builtins.str] versions: Versions available for this engine.
        """
        pulumi.set(__self__, "default_version", default_version)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ssl_modes", ssl_modes)
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> _builtins.str:
        """
        Default version used for the engine.
        """
        return pulumi.get(self, "default_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the plan.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the plan.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sslModes")
    def ssl_modes(self) -> Sequence[_builtins.str]:
        """
        SSL modes for this engine.
        """
        return pulumi.get(self, "ssl_modes")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence[_builtins.str]:
        """
        Versions available for this engine.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetCapabilitiesFlavorResult(dict):
    def __init__(__self__, *,
                 core: _builtins.int,
                 memory: _builtins.int,
                 name: _builtins.str,
                 storage: _builtins.int):
        """
        :param _builtins.int core: Flavor core number.
        :param _builtins.int memory: Flavor ram size in GB.
        :param _builtins.str name: Name of the plan.
        :param _builtins.int storage: Flavor disk size in GB.
        """
        pulumi.set(__self__, "core", core)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "storage", storage)

    @_builtins.property
    @pulumi.getter
    def core(self) -> _builtins.int:
        """
        Flavor core number.
        """
        return pulumi.get(self, "core")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.int:
        """
        Flavor ram size in GB.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the plan.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> _builtins.int:
        """
        Flavor disk size in GB.
        """
        return pulumi.get(self, "storage")


@pulumi.output_type
class GetCapabilitiesOptionResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str name: Name of the plan.
        :param _builtins.str type: Type of the option.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the plan.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the option.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetCapabilitiesPlanResult(dict):
    def __init__(__self__, *,
                 backup_retention: _builtins.str,
                 description: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str backup_retention: Automatic backup retention duration.
        :param _builtins.str description: Description of the plan.
        :param _builtins.str name: Name of the plan.
        """
        pulumi.set(__self__, "backup_retention", backup_retention)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="backupRetention")
    def backup_retention(self) -> _builtins.str:
        """
        Automatic backup retention duration.
        """
        return pulumi.get(self, "backup_retention")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the plan.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the plan.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDatabaseEndpointResult(dict):
    def __init__(__self__, *,
                 component: _builtins.str,
                 domain: _builtins.str,
                 path: _builtins.str,
                 port: _builtins.int,
                 scheme: _builtins.str,
                 ssl: _builtins.bool,
                 ssl_mode: _builtins.str,
                 uri: _builtins.str):
        """
        :param _builtins.str component: Type of component the URI relates to.
        :param _builtins.str domain: Domain of the cluster.
        :param _builtins.str path: Path of the endpoint.
        :param _builtins.int port: Connection port for the endpoint.
        :param _builtins.str scheme: Scheme used to generate the URI.
        :param _builtins.bool ssl: Defines whether the endpoint uses SSL.
        :param _builtins.str ssl_mode: SSL mode used to connect to the service if the SSL is enabled.
        :param _builtins.str uri: URI of the endpoint.
        """
        pulumi.set(__self__, "component", component)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "scheme", scheme)
        pulumi.set(__self__, "ssl", ssl)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def component(self) -> _builtins.str:
        """
        Type of component the URI relates to.
        """
        return pulumi.get(self, "component")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        Domain of the cluster.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path of the endpoint.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Connection port for the endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> _builtins.str:
        """
        Scheme used to generate the URI.
        """
        return pulumi.get(self, "scheme")

    @_builtins.property
    @pulumi.getter
    def ssl(self) -> _builtins.bool:
        """
        Defines whether the endpoint uses SSL.
        """
        return pulumi.get(self, "ssl")

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> _builtins.str:
        """
        SSL mode used to connect to the service if the SSL is enabled.
        """
        return pulumi.get(self, "ssl_mode")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        URI of the endpoint.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetDatabaseIpRestrictionResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 ip: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str description: Description of the IP restriction
        :param _builtins.str ip: Authorized IP
        :param _builtins.str status: Current status of the cluster.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the IP restriction
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        Authorized IP
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Current status of the cluster.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDatabaseNodeResult(dict):
    def __init__(__self__, *,
                 network_id: _builtins.str,
                 region: _builtins.str,
                 subnet_id: _builtins.str):
        """
        :param _builtins.str network_id: Private network id in which the node should be deployed. It's the regional openstackId of the private network
        :param _builtins.str region: Public cloud region in which the node should be deployed.
        :param _builtins.str subnet_id: Private subnet ID in which the node is.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        Private network id in which the node should be deployed. It's the regional openstackId of the private network
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Public cloud region in which the node should be deployed.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        Private subnet ID in which the node is.
        """
        return pulumi.get(self, "subnet_id")


