# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LogsTokenArgs', 'LogsToken']

@pulumi.input_type
class LogsTokenArgs:
    def __init__(__self__, *,
                 service_name: pulumi.Input[_builtins.str],
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LogsToken resource.
        :param pulumi.Input[_builtins.str] service_name: The LDP service name
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID. If not provided, the default cluster_id is used
        :param pulumi.Input[_builtins.str] name: Name of the token
        """
        pulumi.set(__self__, "service_name", service_name)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The LDP service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster ID. If not provided, the default cluster_id is used
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the token
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _LogsTokenState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 token_id: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogsToken resources.
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID. If not provided, the default cluster_id is used
        :param pulumi.Input[_builtins.str] created_at: Token creation date
        :param pulumi.Input[_builtins.str] name: Name of the token
        :param pulumi.Input[_builtins.str] service_name: The LDP service name
        :param pulumi.Input[_builtins.str] token_id: ID of the token
        :param pulumi.Input[_builtins.str] updated_at: Token last update date
        :param pulumi.Input[_builtins.str] value: Token value
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if token_id is not None:
            pulumi.set(__self__, "token_id", token_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster ID. If not provided, the default cluster_id is used
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Token creation date
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the token
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The LDP service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the token
        """
        return pulumi.get(self, "token_id")

    @token_id.setter
    def token_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_id", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Token last update date
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Token value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("ovh:Dbaas/logsToken:LogsToken")
class LogsToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows to manipulate LDP tokens.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        token = ovh.dbaas.LogsToken("token",
            service_name="ldp-xx-xxxxx",
            name="ExampleToken")
        ```

        ## Import

        A token can be imported using the `service_name` and `token_id` fields.

        Using the following configuration:

        terraform

        import {

          to = ovh_dbaas_logs_token.token

          id = "<service_name>/<token_id"

        }

        You can then run:

        bash

        $ pulumi preview -generate-config-out=token.tf

        $ pulumi up

        The file `token.tf` will then contain the imported resource's configuration, that can be copied next to the `import` block above. See https://developer.hashicorp.com/terraform/language/import/generating-configuration for more details.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID. If not provided, the default cluster_id is used
        :param pulumi.Input[_builtins.str] name: Name of the token
        :param pulumi.Input[_builtins.str] service_name: The LDP service name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogsTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows to manipulate LDP tokens.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        token = ovh.dbaas.LogsToken("token",
            service_name="ldp-xx-xxxxx",
            name="ExampleToken")
        ```

        ## Import

        A token can be imported using the `service_name` and `token_id` fields.

        Using the following configuration:

        terraform

        import {

          to = ovh_dbaas_logs_token.token

          id = "<service_name>/<token_id"

        }

        You can then run:

        bash

        $ pulumi preview -generate-config-out=token.tf

        $ pulumi up

        The file `token.tf` will then contain the imported resource's configuration, that can be copied next to the `import` block above. See https://developer.hashicorp.com/terraform/language/import/generating-configuration for more details.

        :param str resource_name: The name of the resource.
        :param LogsTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogsTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogsTokenArgs.__new__(LogsTokenArgs)

            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["name"] = name
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["created_at"] = None
            __props__.__dict__["token_id"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["value"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["value"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LogsToken, __self__).__init__(
            'ovh:Dbaas/logsToken:LogsToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            token_id: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'LogsToken':
        """
        Get an existing LogsToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID. If not provided, the default cluster_id is used
        :param pulumi.Input[_builtins.str] created_at: Token creation date
        :param pulumi.Input[_builtins.str] name: Name of the token
        :param pulumi.Input[_builtins.str] service_name: The LDP service name
        :param pulumi.Input[_builtins.str] token_id: ID of the token
        :param pulumi.Input[_builtins.str] updated_at: Token last update date
        :param pulumi.Input[_builtins.str] value: Token value
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogsTokenState.__new__(_LogsTokenState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["name"] = name
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["token_id"] = token_id
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["value"] = value
        return LogsToken(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Cluster ID. If not provided, the default cluster_id is used
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Token creation date
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the token
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The LDP service name
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the token
        """
        return pulumi.get(self, "token_id")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Token last update date
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        Token value
        """
        return pulumi.get(self, "value")

