# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCloudResult',
    'AwaitableGetCloudResult',
    'get_cloud',
    'get_cloud_output',
]

@pulumi.output_type
class GetCloudResult:
    """
    A collection of values returned by getCloud.
    """
    def __init__(__self__, advanced_security=None, bandwidth=None, billing_type=None, can_migrate_to_vcd=None, certified_interface_url=None, commercial_range=None, description=None, generation=None, iam=None, id=None, location=None, management_interface=None, product_reference=None, service_name=None, service_pack_name=None, spla=None, ssl_v3=None, state=None, user_access_policy=None, user_limit_concurrent_session=None, user_logout_policy=None, user_session_timeout=None, v_scope_url=None, version=None, web_interface_url=None):
        if advanced_security and not isinstance(advanced_security, bool):
            raise TypeError("Expected argument 'advanced_security' to be a bool")
        pulumi.set(__self__, "advanced_security", advanced_security)
        if bandwidth and not isinstance(bandwidth, str):
            raise TypeError("Expected argument 'bandwidth' to be a str")
        pulumi.set(__self__, "bandwidth", bandwidth)
        if billing_type and not isinstance(billing_type, str):
            raise TypeError("Expected argument 'billing_type' to be a str")
        pulumi.set(__self__, "billing_type", billing_type)
        if can_migrate_to_vcd and not isinstance(can_migrate_to_vcd, bool):
            raise TypeError("Expected argument 'can_migrate_to_vcd' to be a bool")
        pulumi.set(__self__, "can_migrate_to_vcd", can_migrate_to_vcd)
        if certified_interface_url and not isinstance(certified_interface_url, str):
            raise TypeError("Expected argument 'certified_interface_url' to be a str")
        pulumi.set(__self__, "certified_interface_url", certified_interface_url)
        if commercial_range and not isinstance(commercial_range, str):
            raise TypeError("Expected argument 'commercial_range' to be a str")
        pulumi.set(__self__, "commercial_range", commercial_range)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if generation and not isinstance(generation, str):
            raise TypeError("Expected argument 'generation' to be a str")
        pulumi.set(__self__, "generation", generation)
        if iam and not isinstance(iam, dict):
            raise TypeError("Expected argument 'iam' to be a dict")
        pulumi.set(__self__, "iam", iam)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if management_interface and not isinstance(management_interface, str):
            raise TypeError("Expected argument 'management_interface' to be a str")
        pulumi.set(__self__, "management_interface", management_interface)
        if product_reference and not isinstance(product_reference, str):
            raise TypeError("Expected argument 'product_reference' to be a str")
        pulumi.set(__self__, "product_reference", product_reference)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if service_pack_name and not isinstance(service_pack_name, str):
            raise TypeError("Expected argument 'service_pack_name' to be a str")
        pulumi.set(__self__, "service_pack_name", service_pack_name)
        if spla and not isinstance(spla, bool):
            raise TypeError("Expected argument 'spla' to be a bool")
        pulumi.set(__self__, "spla", spla)
        if ssl_v3 and not isinstance(ssl_v3, bool):
            raise TypeError("Expected argument 'ssl_v3' to be a bool")
        pulumi.set(__self__, "ssl_v3", ssl_v3)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if user_access_policy and not isinstance(user_access_policy, str):
            raise TypeError("Expected argument 'user_access_policy' to be a str")
        pulumi.set(__self__, "user_access_policy", user_access_policy)
        if user_limit_concurrent_session and not isinstance(user_limit_concurrent_session, float):
            raise TypeError("Expected argument 'user_limit_concurrent_session' to be a float")
        pulumi.set(__self__, "user_limit_concurrent_session", user_limit_concurrent_session)
        if user_logout_policy and not isinstance(user_logout_policy, str):
            raise TypeError("Expected argument 'user_logout_policy' to be a str")
        pulumi.set(__self__, "user_logout_policy", user_logout_policy)
        if user_session_timeout and not isinstance(user_session_timeout, float):
            raise TypeError("Expected argument 'user_session_timeout' to be a float")
        pulumi.set(__self__, "user_session_timeout", user_session_timeout)
        if v_scope_url and not isinstance(v_scope_url, str):
            raise TypeError("Expected argument 'v_scope_url' to be a str")
        pulumi.set(__self__, "v_scope_url", v_scope_url)
        if version and not isinstance(version, dict):
            raise TypeError("Expected argument 'version' to be a dict")
        pulumi.set(__self__, "version", version)
        if web_interface_url and not isinstance(web_interface_url, str):
            raise TypeError("Expected argument 'web_interface_url' to be a str")
        pulumi.set(__self__, "web_interface_url", web_interface_url)

    @_builtins.property
    @pulumi.getter(name="advancedSecurity")
    def advanced_security(self) -> _builtins.bool:
        """
        Advanced security state
        """
        return pulumi.get(self, "advanced_security")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.str:
        """
        The current bandwidth of your VMware on OVHcloud
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> _builtins.str:
        """
        Billing type of your VMware on OVHcloud
        """
        return pulumi.get(self, "billing_type")

    @_builtins.property
    @pulumi.getter(name="canMigrateToVcd")
    def can_migrate_to_vcd(self) -> _builtins.bool:
        """
        Can the PCC be migrated to VCD
        """
        return pulumi.get(self, "can_migrate_to_vcd")

    @_builtins.property
    @pulumi.getter(name="certifiedInterfaceUrl")
    def certified_interface_url(self) -> _builtins.str:
        """
        Url to the VMware on OVHcloud certified interface
        """
        return pulumi.get(self, "certified_interface_url")

    @_builtins.property
    @pulumi.getter(name="commercialRange")
    def commercial_range(self) -> _builtins.str:
        """
        The current version of your VMware on OVHcloud
        """
        return pulumi.get(self, "commercial_range")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of your VMware on OVHcloud
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> _builtins.str:
        """
        Generation of your VMware on OVHcloud
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter
    def iam(self) -> 'outputs.GetCloudIamResult':
        """
        IAM resource metadata
        """
        return pulumi.get(self, "iam")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Datacenter where your VMware on OVHcloud is physically located
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managementInterface")
    def management_interface(self) -> _builtins.str:
        """
        The management interface name
        """
        return pulumi.get(self, "management_interface")

    @_builtins.property
    @pulumi.getter(name="productReference")
    def product_reference(self) -> _builtins.str:
        """
        The reference universe information for your VMware on OVHcloud
        """
        return pulumi.get(self, "product_reference")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        Domain of the service
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="servicePackName")
    def service_pack_name(self) -> _builtins.str:
        """
        Name of the current service pack
        """
        return pulumi.get(self, "service_pack_name")

    @_builtins.property
    @pulumi.getter
    def spla(self) -> _builtins.bool:
        """
        SPLA licensing state
        """
        return pulumi.get(self, "spla")

    @_builtins.property
    @pulumi.getter(name="sslV3")
    def ssl_v3(self) -> _builtins.bool:
        """
        Enable SSL v3 support. Warning : this option is not recommended as it was recognized as a security breach. If this is enabled, we advise you to enable the filtered User access policy
        """
        return pulumi.get(self, "ssl_v3")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Current state of your VMware on OVHcloud
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="userAccessPolicy")
    def user_access_policy(self) -> _builtins.str:
        """
        Access policy of your VMware on OVHcloud : opened to every IPs or filtered
        """
        return pulumi.get(self, "user_access_policy")

    @_builtins.property
    @pulumi.getter(name="userLimitConcurrentSession")
    def user_limit_concurrent_session(self) -> _builtins.float:
        """
        The maximum amount of connected users allowed on the VMware on OVHcloud management interface
        """
        return pulumi.get(self, "user_limit_concurrent_session")

    @_builtins.property
    @pulumi.getter(name="userLogoutPolicy")
    def user_logout_policy(self) -> _builtins.str:
        """
        Which user will be disconnected first in case of quota of maximum connection is reached
        """
        return pulumi.get(self, "user_logout_policy")

    @_builtins.property
    @pulumi.getter(name="userSessionTimeout")
    def user_session_timeout(self) -> _builtins.float:
        """
        The timeout (in seconds) for the user sessions on the VMware on OVHcloud management interface. 0 value disable the timeout
        """
        return pulumi.get(self, "user_session_timeout")

    @_builtins.property
    @pulumi.getter(name="vScopeUrl")
    def v_scope_url(self) -> _builtins.str:
        """
        Url to the VMware on OVHcloud vScope interface
        """
        return pulumi.get(self, "v_scope_url")

    @_builtins.property
    @pulumi.getter
    def version(self) -> 'outputs.GetCloudVersionResult':
        """
        Version of the management interface
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="webInterfaceUrl")
    def web_interface_url(self) -> _builtins.str:
        """
        Url to the VMware on OVHcloud web interface
        """
        return pulumi.get(self, "web_interface_url")


class AwaitableGetCloudResult(GetCloudResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudResult(
            advanced_security=self.advanced_security,
            bandwidth=self.bandwidth,
            billing_type=self.billing_type,
            can_migrate_to_vcd=self.can_migrate_to_vcd,
            certified_interface_url=self.certified_interface_url,
            commercial_range=self.commercial_range,
            description=self.description,
            generation=self.generation,
            iam=self.iam,
            id=self.id,
            location=self.location,
            management_interface=self.management_interface,
            product_reference=self.product_reference,
            service_name=self.service_name,
            service_pack_name=self.service_pack_name,
            spla=self.spla,
            ssl_v3=self.ssl_v3,
            state=self.state,
            user_access_policy=self.user_access_policy,
            user_limit_concurrent_session=self.user_limit_concurrent_session,
            user_logout_policy=self.user_logout_policy,
            user_session_timeout=self.user_session_timeout,
            v_scope_url=self.v_scope_url,
            version=self.version,
            web_interface_url=self.web_interface_url)


def get_cloud(service_name: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudResult:
    """
    Get information about a Managed VMware service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    pcc = ovh.Dedicated.get_cloud(service_name="<Dedicated Cloud service name>")
    ```


    :param _builtins.str service_name: Domain of the service
    """
    __args__ = dict()
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Dedicated/getCloud:getCloud', __args__, opts=opts, typ=GetCloudResult).value

    return AwaitableGetCloudResult(
        advanced_security=pulumi.get(__ret__, 'advanced_security'),
        bandwidth=pulumi.get(__ret__, 'bandwidth'),
        billing_type=pulumi.get(__ret__, 'billing_type'),
        can_migrate_to_vcd=pulumi.get(__ret__, 'can_migrate_to_vcd'),
        certified_interface_url=pulumi.get(__ret__, 'certified_interface_url'),
        commercial_range=pulumi.get(__ret__, 'commercial_range'),
        description=pulumi.get(__ret__, 'description'),
        generation=pulumi.get(__ret__, 'generation'),
        iam=pulumi.get(__ret__, 'iam'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        management_interface=pulumi.get(__ret__, 'management_interface'),
        product_reference=pulumi.get(__ret__, 'product_reference'),
        service_name=pulumi.get(__ret__, 'service_name'),
        service_pack_name=pulumi.get(__ret__, 'service_pack_name'),
        spla=pulumi.get(__ret__, 'spla'),
        ssl_v3=pulumi.get(__ret__, 'ssl_v3'),
        state=pulumi.get(__ret__, 'state'),
        user_access_policy=pulumi.get(__ret__, 'user_access_policy'),
        user_limit_concurrent_session=pulumi.get(__ret__, 'user_limit_concurrent_session'),
        user_logout_policy=pulumi.get(__ret__, 'user_logout_policy'),
        user_session_timeout=pulumi.get(__ret__, 'user_session_timeout'),
        v_scope_url=pulumi.get(__ret__, 'v_scope_url'),
        version=pulumi.get(__ret__, 'version'),
        web_interface_url=pulumi.get(__ret__, 'web_interface_url'))
def get_cloud_output(service_name: Optional[pulumi.Input[_builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudResult]:
    """
    Get information about a Managed VMware service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    pcc = ovh.Dedicated.get_cloud(service_name="<Dedicated Cloud service name>")
    ```


    :param _builtins.str service_name: Domain of the service
    """
    __args__ = dict()
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:Dedicated/getCloud:getCloud', __args__, opts=opts, typ=GetCloudResult)
    return __ret__.apply(lambda __response__: GetCloudResult(
        advanced_security=pulumi.get(__response__, 'advanced_security'),
        bandwidth=pulumi.get(__response__, 'bandwidth'),
        billing_type=pulumi.get(__response__, 'billing_type'),
        can_migrate_to_vcd=pulumi.get(__response__, 'can_migrate_to_vcd'),
        certified_interface_url=pulumi.get(__response__, 'certified_interface_url'),
        commercial_range=pulumi.get(__response__, 'commercial_range'),
        description=pulumi.get(__response__, 'description'),
        generation=pulumi.get(__response__, 'generation'),
        iam=pulumi.get(__response__, 'iam'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        management_interface=pulumi.get(__response__, 'management_interface'),
        product_reference=pulumi.get(__response__, 'product_reference'),
        service_name=pulumi.get(__response__, 'service_name'),
        service_pack_name=pulumi.get(__response__, 'service_pack_name'),
        spla=pulumi.get(__response__, 'spla'),
        ssl_v3=pulumi.get(__response__, 'ssl_v3'),
        state=pulumi.get(__response__, 'state'),
        user_access_policy=pulumi.get(__response__, 'user_access_policy'),
        user_limit_concurrent_session=pulumi.get(__response__, 'user_limit_concurrent_session'),
        user_logout_policy=pulumi.get(__response__, 'user_logout_policy'),
        user_session_timeout=pulumi.get(__response__, 'user_session_timeout'),
        v_scope_url=pulumi.get(__response__, 'v_scope_url'),
        version=pulumi.get(__response__, 'version'),
        web_interface_url=pulumi.get(__response__, 'web_interface_url')))
