# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ZoneImportArgs', 'ZoneImport']

@pulumi.input_type
class ZoneImportArgs:
    def __init__(__self__, *,
                 zone_file: pulumi.Input[_builtins.str],
                 zone_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ZoneImport resource.
        :param pulumi.Input[_builtins.str] zone_file: Content of the zone file to import
        :param pulumi.Input[_builtins.str] zone_name: The name of the domain zone
        """
        pulumi.set(__self__, "zone_file", zone_file)
        pulumi.set(__self__, "zone_name", zone_name)

    @_builtins.property
    @pulumi.getter(name="zoneFile")
    def zone_file(self) -> pulumi.Input[_builtins.str]:
        """
        Content of the zone file to import
        """
        return pulumi.get(self, "zone_file")

    @zone_file.setter
    def zone_file(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_file", value)

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the domain zone
        """
        return pulumi.get(self, "zone_name")

    @zone_name.setter
    def zone_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_name", value)


@pulumi.input_type
class _ZoneImportState:
    def __init__(__self__, *,
                 exported_content: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_file: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZoneImport resources.
        :param pulumi.Input[_builtins.str] exported_content: Zone file exported from the API
        :param pulumi.Input[_builtins.str] zone_file: Content of the zone file to import
        :param pulumi.Input[_builtins.str] zone_name: The name of the domain zone
        """
        if exported_content is not None:
            pulumi.set(__self__, "exported_content", exported_content)
        if zone_file is not None:
            pulumi.set(__self__, "zone_file", zone_file)
        if zone_name is not None:
            pulumi.set(__self__, "zone_name", zone_name)

    @_builtins.property
    @pulumi.getter(name="exportedContent")
    def exported_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone file exported from the API
        """
        return pulumi.get(self, "exported_content")

    @exported_content.setter
    def exported_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exported_content", value)

    @_builtins.property
    @pulumi.getter(name="zoneFile")
    def zone_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Content of the zone file to import
        """
        return pulumi.get(self, "zone_file")

    @zone_file.setter
    def zone_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_file", value)

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the domain zone
        """
        return pulumi.get(self, "zone_name")

    @zone_name.setter
    def zone_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_name", value)


@pulumi.type_token("ovh:Domain/zoneImport:ZoneImport")
class ZoneImport(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 zone_file: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Handle a whole DNS zone using a zone file.

        > **WARNING** This resource and resource `Domain.ZoneRecord` should not be used together as `Domain.ZoneImport` controls the whole DNS zone at once.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] zone_file: Content of the zone file to import
        :param pulumi.Input[_builtins.str] zone_name: The name of the domain zone
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZoneImportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Handle a whole DNS zone using a zone file.

        > **WARNING** This resource and resource `Domain.ZoneRecord` should not be used together as `Domain.ZoneImport` controls the whole DNS zone at once.

        :param str resource_name: The name of the resource.
        :param ZoneImportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneImportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 zone_file: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneImportArgs.__new__(ZoneImportArgs)

            if zone_file is None and not opts.urn:
                raise TypeError("Missing required property 'zone_file'")
            __props__.__dict__["zone_file"] = zone_file
            if zone_name is None and not opts.urn:
                raise TypeError("Missing required property 'zone_name'")
            __props__.__dict__["zone_name"] = zone_name
            __props__.__dict__["exported_content"] = None
        super(ZoneImport, __self__).__init__(
            'ovh:Domain/zoneImport:ZoneImport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            exported_content: Optional[pulumi.Input[_builtins.str]] = None,
            zone_file: Optional[pulumi.Input[_builtins.str]] = None,
            zone_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ZoneImport':
        """
        Get an existing ZoneImport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] exported_content: Zone file exported from the API
        :param pulumi.Input[_builtins.str] zone_file: Content of the zone file to import
        :param pulumi.Input[_builtins.str] zone_name: The name of the domain zone
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneImportState.__new__(_ZoneImportState)

        __props__.__dict__["exported_content"] = exported_content
        __props__.__dict__["zone_file"] = zone_file
        __props__.__dict__["zone_name"] = zone_name
        return ZoneImport(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="exportedContent")
    def exported_content(self) -> pulumi.Output[_builtins.str]:
        """
        Zone file exported from the API
        """
        return pulumi.get(self, "exported_content")

    @_builtins.property
    @pulumi.getter(name="zoneFile")
    def zone_file(self) -> pulumi.Output[_builtins.str]:
        """
        Content of the zone file to import
        """
        return pulumi.get(self, "zone_file")

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the domain zone
        """
        return pulumi.get(self, "zone_name")

