# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetStorageEfsShareAccessPathResult',
    'AwaitableGetStorageEfsShareAccessPathResult',
    'get_storage_efs_share_access_path',
    'get_storage_efs_share_access_path_output',
]

@pulumi.output_type
class GetStorageEfsShareAccessPathResult:
    """
    A collection of values returned by getStorageEfsShareAccessPath.
    """
    def __init__(__self__, id=None, path=None, preferred=None, service_name=None, share_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if preferred and not isinstance(preferred, bool):
            raise TypeError("Expected argument 'preferred' to be a bool")
        pulumi.set(__self__, "preferred", preferred)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if share_id and not isinstance(share_id, str):
            raise TypeError("Expected argument 'share_id' to be a str")
        pulumi.set(__self__, "share_id", share_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Access path ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Access path
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def preferred(self) -> _builtins.bool:
        """
        Is this the preferred access path?
        """
        return pulumi.get(self, "preferred")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="shareId")
    def share_id(self) -> _builtins.str:
        """
        Share ID
        """
        return pulumi.get(self, "share_id")


class AwaitableGetStorageEfsShareAccessPathResult(GetStorageEfsShareAccessPathResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStorageEfsShareAccessPathResult(
            id=self.id,
            path=self.path,
            preferred=self.preferred,
            service_name=self.service_name,
            share_id=self.share_id)


def get_storage_efs_share_access_path(id: Optional[_builtins.str] = None,
                                      service_name: Optional[_builtins.str] = None,
                                      share_id: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStorageEfsShareAccessPathResult:
    """
    Get access path detailed information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    efs = ovh.get_storage_efs(service_name="XXX")
    access_path = ovh.get_storage_efs_share_access_path(service_name=efs.service_name,
        share_id="XXX",
        id="XXX")
    ```


    :param _builtins.str id: Access path ID
    :param _builtins.str service_name: Service name
    :param _builtins.str share_id: Share ID
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['serviceName'] = service_name
    __args__['shareId'] = share_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:index/getStorageEfsShareAccessPath:getStorageEfsShareAccessPath', __args__, opts=opts, typ=GetStorageEfsShareAccessPathResult).value

    return AwaitableGetStorageEfsShareAccessPathResult(
        id=pulumi.get(__ret__, 'id'),
        path=pulumi.get(__ret__, 'path'),
        preferred=pulumi.get(__ret__, 'preferred'),
        service_name=pulumi.get(__ret__, 'service_name'),
        share_id=pulumi.get(__ret__, 'share_id'))
def get_storage_efs_share_access_path_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                             service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                             share_id: Optional[pulumi.Input[_builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStorageEfsShareAccessPathResult]:
    """
    Get access path detailed information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    efs = ovh.get_storage_efs(service_name="XXX")
    access_path = ovh.get_storage_efs_share_access_path(service_name=efs.service_name,
        share_id="XXX",
        id="XXX")
    ```


    :param _builtins.str id: Access path ID
    :param _builtins.str service_name: Service name
    :param _builtins.str share_id: Share ID
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['serviceName'] = service_name
    __args__['shareId'] = share_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:index/getStorageEfsShareAccessPath:getStorageEfsShareAccessPath', __args__, opts=opts, typ=GetStorageEfsShareAccessPathResult)
    return __ret__.apply(lambda __response__: GetStorageEfsShareAccessPathResult(
        id=pulumi.get(__response__, 'id'),
        path=pulumi.get(__response__, 'path'),
        preferred=pulumi.get(__response__, 'preferred'),
        service_name=pulumi.get(__response__, 'service_name'),
        share_id=pulumi.get(__response__, 'share_id')))
