# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPolicyResult',
    'AwaitableGetPolicyResult',
    'get_policy',
    'get_policy_output',
]

@pulumi.output_type
class GetPolicyResult:
    """
    A collection of values returned by getPolicy.
    """
    def __init__(__self__, allows=None, created_at=None, denies=None, description=None, excepts=None, id=None, identities=None, name=None, owner=None, permissions_groups=None, read_only=None, resources=None, updated_at=None):
        if allows and not isinstance(allows, list):
            raise TypeError("Expected argument 'allows' to be a list")
        pulumi.set(__self__, "allows", allows)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if denies and not isinstance(denies, list):
            raise TypeError("Expected argument 'denies' to be a list")
        pulumi.set(__self__, "denies", denies)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if excepts and not isinstance(excepts, list):
            raise TypeError("Expected argument 'excepts' to be a list")
        pulumi.set(__self__, "excepts", excepts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if permissions_groups and not isinstance(permissions_groups, list):
            raise TypeError("Expected argument 'permissions_groups' to be a list")
        pulumi.set(__self__, "permissions_groups", permissions_groups)
        if read_only and not isinstance(read_only, bool):
            raise TypeError("Expected argument 'read_only' to be a bool")
        pulumi.set(__self__, "read_only", read_only)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def allows(self) -> Optional[Sequence[_builtins.str]]:
        """
        Set of actions allowed by the policy.
        """
        return pulumi.get(self, "allows")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Creation date of this group.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def denies(self) -> Optional[Sequence[_builtins.str]]:
        """
        Set of actions that will be denied no matter what policy exists.
        """
        return pulumi.get(self, "denies")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Group description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def excepts(self) -> Optional[Sequence[_builtins.str]]:
        """
        Set of actions that will be subtracted from the `allow` list.
        """
        return pulumi.get(self, "excepts")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence[_builtins.str]:
        """
        Set of identities affected by the policy.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        """
        Owner of the policy.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="permissionsGroups")
    def permissions_groups(self) -> Optional[Sequence[_builtins.str]]:
        """
        Set of permissions groups that apply to the policy.
        """
        return pulumi.get(self, "permissions_groups")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> _builtins.bool:
        """
        Indicates that the policy is a default one.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Sequence[_builtins.str]:
        """
        Set of resources affected by the policy.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Date of the last update of this group.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetPolicyResult(GetPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyResult(
            allows=self.allows,
            created_at=self.created_at,
            denies=self.denies,
            description=self.description,
            excepts=self.excepts,
            id=self.id,
            identities=self.identities,
            name=self.name,
            owner=self.owner,
            permissions_groups=self.permissions_groups,
            read_only=self.read_only,
            resources=self.resources,
            updated_at=self.updated_at)


def get_policy(allows: Optional[Sequence[_builtins.str]] = None,
               denies: Optional[Sequence[_builtins.str]] = None,
               description: Optional[_builtins.str] = None,
               excepts: Optional[Sequence[_builtins.str]] = None,
               id: Optional[_builtins.str] = None,
               permissions_groups: Optional[Sequence[_builtins.str]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyResult:
    """
    Use this data source to retrieve am IAM policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_policy = ovh.Iam.get_policy(id="my_policy_id")
    ```


    :param Sequence[_builtins.str] allows: Set of actions allowed by the policy.
    :param Sequence[_builtins.str] denies: Set of actions that will be denied no matter what policy exists.
    :param _builtins.str description: Group description.
    :param Sequence[_builtins.str] excepts: Set of actions that will be subtracted from the `allow` list.
    :param _builtins.str id: UUID of the policy.
    :param Sequence[_builtins.str] permissions_groups: Set of permissions groups that apply to the policy.
    """
    __args__ = dict()
    __args__['allows'] = allows
    __args__['denies'] = denies
    __args__['description'] = description
    __args__['excepts'] = excepts
    __args__['id'] = id
    __args__['permissionsGroups'] = permissions_groups
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Iam/getPolicy:getPolicy', __args__, opts=opts, typ=GetPolicyResult).value

    return AwaitableGetPolicyResult(
        allows=pulumi.get(__ret__, 'allows'),
        created_at=pulumi.get(__ret__, 'created_at'),
        denies=pulumi.get(__ret__, 'denies'),
        description=pulumi.get(__ret__, 'description'),
        excepts=pulumi.get(__ret__, 'excepts'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        name=pulumi.get(__ret__, 'name'),
        owner=pulumi.get(__ret__, 'owner'),
        permissions_groups=pulumi.get(__ret__, 'permissions_groups'),
        read_only=pulumi.get(__ret__, 'read_only'),
        resources=pulumi.get(__ret__, 'resources'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_policy_output(allows: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      denies: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      excepts: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      id: Optional[pulumi.Input[_builtins.str]] = None,
                      permissions_groups: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPolicyResult]:
    """
    Use this data source to retrieve am IAM policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_policy = ovh.Iam.get_policy(id="my_policy_id")
    ```


    :param Sequence[_builtins.str] allows: Set of actions allowed by the policy.
    :param Sequence[_builtins.str] denies: Set of actions that will be denied no matter what policy exists.
    :param _builtins.str description: Group description.
    :param Sequence[_builtins.str] excepts: Set of actions that will be subtracted from the `allow` list.
    :param _builtins.str id: UUID of the policy.
    :param Sequence[_builtins.str] permissions_groups: Set of permissions groups that apply to the policy.
    """
    __args__ = dict()
    __args__['allows'] = allows
    __args__['denies'] = denies
    __args__['description'] = description
    __args__['excepts'] = excepts
    __args__['id'] = id
    __args__['permissionsGroups'] = permissions_groups
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:Iam/getPolicy:getPolicy', __args__, opts=opts, typ=GetPolicyResult)
    return __ret__.apply(lambda __response__: GetPolicyResult(
        allows=pulumi.get(__response__, 'allows'),
        created_at=pulumi.get(__response__, 'created_at'),
        denies=pulumi.get(__response__, 'denies'),
        description=pulumi.get(__response__, 'description'),
        excepts=pulumi.get(__response__, 'excepts'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        name=pulumi.get(__response__, 'name'),
        owner=pulumi.get(__response__, 'owner'),
        permissions_groups=pulumi.get(__response__, 'permissions_groups'),
        read_only=pulumi.get(__response__, 'read_only'),
        resources=pulumi.get(__response__, 'resources'),
        updated_at=pulumi.get(__response__, 'updated_at')))
