# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ResourceGroupArgs', 'ResourceGroup']

@pulumi.input_type
class ResourceGroupArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ResourceGroup resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: Set of the URNs of the resources contained in the resource group. All urns must be ones of valid resources
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of the URNs of the resources contained in the resource group. All urns must be ones of valid resources
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class _ResourceGroupState:
    def __init__(__self__, *,
                 group_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ResourceGroup resources.
        :param pulumi.Input[_builtins.str] group_urn: URN of the resource group, used when writing policies
        :param pulumi.Input[_builtins.str] created_at: Date of the creation of the resource group
        :param pulumi.Input[_builtins.str] name: Name of the resource group
        :param pulumi.Input[_builtins.str] owner: Name of the account owning the resource group
        :param pulumi.Input[_builtins.bool] read_only: Marks that the resource group is not editable. Usually means that this is a default resource group created by OVHcloud
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: Set of the URNs of the resources contained in the resource group. All urns must be ones of valid resources
        :param pulumi.Input[_builtins.str] updated_at: Date of the last modification of the resource group
        """
        if group_urn is not None:
            pulumi.set(__self__, "group_urn", group_urn)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="GroupURN")
    def group_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URN of the resource group, used when writing policies
        """
        return pulumi.get(self, "group_urn")

    @group_urn.setter
    def group_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_urn", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date of the creation of the resource group
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the account owning the resource group
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Marks that the resource group is not editable. Usually means that this is a default resource group created by OVHcloud
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_only", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of the URNs of the resources contained in the resource group. All urns must be ones of valid resources
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date of the last modification of the resource group
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("ovh:Iam/resourceGroup:ResourceGroup")
class ResourceGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an OVHcloud IAM resource group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        my_resource_group = ovh.iam.ResourceGroup("my_resource_group",
            name="my_resource_group",
            resources=[
                "urn:v1:eu:resource:service1:service1-id",
                "urn:v1:eu:resource:service2:service2-id",
            ])
        ```

        ## Import

        Resource groups can be imported by using their id.

        bash

        ```sh
        $ pulumi import ovh:Iam/resourceGroup:ResourceGroup my_resource_group resource_group_id
        ```

        -> Read only resource groups cannot be imported

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: Set of the URNs of the resources contained in the resource group. All urns must be ones of valid resources
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ResourceGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an OVHcloud IAM resource group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        my_resource_group = ovh.iam.ResourceGroup("my_resource_group",
            name="my_resource_group",
            resources=[
                "urn:v1:eu:resource:service1:service1-id",
                "urn:v1:eu:resource:service2:service2-id",
            ])
        ```

        ## Import

        Resource groups can be imported by using their id.

        bash

        ```sh
        $ pulumi import ovh:Iam/resourceGroup:ResourceGroup my_resource_group resource_group_id
        ```

        -> Read only resource groups cannot be imported

        :param str resource_name: The name of the resource.
        :param ResourceGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceGroupArgs.__new__(ResourceGroupArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["resources"] = resources
            __props__.__dict__["group_urn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["read_only"] = None
            __props__.__dict__["updated_at"] = None
        super(ResourceGroup, __self__).__init__(
            'ovh:Iam/resourceGroup:ResourceGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_urn: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            read_only: Optional[pulumi.Input[_builtins.bool]] = None,
            resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'ResourceGroup':
        """
        Get an existing ResourceGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_urn: URN of the resource group, used when writing policies
        :param pulumi.Input[_builtins.str] created_at: Date of the creation of the resource group
        :param pulumi.Input[_builtins.str] name: Name of the resource group
        :param pulumi.Input[_builtins.str] owner: Name of the account owning the resource group
        :param pulumi.Input[_builtins.bool] read_only: Marks that the resource group is not editable. Usually means that this is a default resource group created by OVHcloud
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: Set of the URNs of the resources contained in the resource group. All urns must be ones of valid resources
        :param pulumi.Input[_builtins.str] updated_at: Date of the last modification of the resource group
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceGroupState.__new__(_ResourceGroupState)

        __props__.__dict__["group_urn"] = group_urn
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["read_only"] = read_only
        __props__.__dict__["resources"] = resources
        __props__.__dict__["updated_at"] = updated_at
        return ResourceGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="GroupURN")
    def group_urn(self) -> pulumi.Output[_builtins.str]:
        """
        URN of the resource group, used when writing policies
        """
        return pulumi.get(self, "group_urn")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date of the creation of the resource group
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource group
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the account owning the resource group
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> pulumi.Output[_builtins.bool]:
        """
        Marks that the resource group is not editable. Usually means that this is a default resource group created by OVHcloud
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of the URNs of the resources contained in the resource group. All urns must be ones of valid resources
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date of the last modification of the resource group
        """
        return pulumi.get(self, "updated_at")

