# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetVrackNetworkResult',
    'AwaitableGetVrackNetworkResult',
    'get_vrack_network',
    'get_vrack_network_output',
]

@pulumi.output_type
class GetVrackNetworkResult:
    """
    A collection of values returned by getVrackNetwork.
    """
    def __init__(__self__, display_name=None, id=None, nat_ip=None, service_name=None, subnet=None, vlan=None, vrack_network_id=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if nat_ip and not isinstance(nat_ip, str):
            raise TypeError("Expected argument 'nat_ip' to be a str")
        pulumi.set(__self__, "nat_ip", nat_ip)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if subnet and not isinstance(subnet, str):
            raise TypeError("Expected argument 'subnet' to be a str")
        pulumi.set(__self__, "subnet", subnet)
        if vlan and not isinstance(vlan, int):
            raise TypeError("Expected argument 'vlan' to be a int")
        pulumi.set(__self__, "vlan", vlan)
        if vrack_network_id and not isinstance(vrack_network_id, int):
            raise TypeError("Expected argument 'vrack_network_id' to be a int")
        pulumi.set(__self__, "vrack_network_id", vrack_network_id)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Human readable name for your vrack network
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="natIp")
    def nat_ip(self) -> _builtins.str:
        """
        An IP block used as a pool of IPs by this Load Balancer to connect to the servers in this private network. The blck must be in the private network and reserved for the Load Balancer
        """
        return pulumi.get(self, "nat_ip")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> _builtins.str:
        """
        IP block of the private network in the vRack
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> _builtins.int:
        """
        VLAN of the private network in the vRack. 0 if the private network is not in a VLAN
        """
        return pulumi.get(self, "vlan")

    @_builtins.property
    @pulumi.getter(name="vrackNetworkId")
    def vrack_network_id(self) -> _builtins.int:
        return pulumi.get(self, "vrack_network_id")


class AwaitableGetVrackNetworkResult(GetVrackNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVrackNetworkResult(
            display_name=self.display_name,
            id=self.id,
            nat_ip=self.nat_ip,
            service_name=self.service_name,
            subnet=self.subnet,
            vlan=self.vlan,
            vrack_network_id=self.vrack_network_id)


def get_vrack_network(service_name: Optional[_builtins.str] = None,
                      vrack_network_id: Optional[_builtins.int] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVrackNetworkResult:
    """
    Use this data source to get the details of Vrack network available for your IPLoadbalancer associated with your OVHcloud account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    lb_network = ovh.IpLoadBalancing.get_vrack_network(service_name="XXXXXX",
        vrack_network_id="yyy")
    ```


    :param _builtins.str service_name: The internal name of your IP load balancing
    :param _builtins.int vrack_network_id: Internal Load Balancer identifier of the vRack private network
    """
    __args__ = dict()
    __args__['serviceName'] = service_name
    __args__['vrackNetworkId'] = vrack_network_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:IpLoadBalancing/getVrackNetwork:getVrackNetwork', __args__, opts=opts, typ=GetVrackNetworkResult).value

    return AwaitableGetVrackNetworkResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        nat_ip=pulumi.get(__ret__, 'nat_ip'),
        service_name=pulumi.get(__ret__, 'service_name'),
        subnet=pulumi.get(__ret__, 'subnet'),
        vlan=pulumi.get(__ret__, 'vlan'),
        vrack_network_id=pulumi.get(__ret__, 'vrack_network_id'))
def get_vrack_network_output(service_name: Optional[pulumi.Input[_builtins.str]] = None,
                             vrack_network_id: Optional[pulumi.Input[_builtins.int]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVrackNetworkResult]:
    """
    Use this data source to get the details of Vrack network available for your IPLoadbalancer associated with your OVHcloud account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    lb_network = ovh.IpLoadBalancing.get_vrack_network(service_name="XXXXXX",
        vrack_network_id="yyy")
    ```


    :param _builtins.str service_name: The internal name of your IP load balancing
    :param _builtins.int vrack_network_id: Internal Load Balancer identifier of the vRack private network
    """
    __args__ = dict()
    __args__['serviceName'] = service_name
    __args__['vrackNetworkId'] = vrack_network_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:IpLoadBalancing/getVrackNetwork:getVrackNetwork', __args__, opts=opts, typ=GetVrackNetworkResult)
    return __ret__.apply(lambda __response__: GetVrackNetworkResult(
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        nat_ip=pulumi.get(__response__, 'nat_ip'),
        service_name=pulumi.get(__response__, 'service_name'),
        subnet=pulumi.get(__response__, 'subnet'),
        vlan=pulumi.get(__response__, 'vlan'),
        vrack_network_id=pulumi.get(__response__, 'vrack_network_id')))
