# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HttpRouteRuleInitArgs', 'HttpRouteRule']

@pulumi.input_type
class HttpRouteRuleInitArgs:
    def __init__(__self__, *,
                 field: pulumi.Input[_builtins.str],
                 match: pulumi.Input[_builtins.str],
                 route_id: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_field: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a HttpRouteRule resource.
        :param pulumi.Input[_builtins.str] field: Name of the field to match like "protocol" or "host". See "/ipLoadbalancing/{serviceName}/availableRouteRules" for a list of available rules
        :param pulumi.Input[_builtins.str] match: Matching operator. Not all operators are available for all fields. See "/ipLoadbalancing/{serviceName}/availableRouteRules"
        :param pulumi.Input[_builtins.str] route_id: The route to apply this rule
        :param pulumi.Input[_builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[_builtins.str] display_name: Human readable name for your rule, this field is for you
        :param pulumi.Input[_builtins.bool] negate: Invert the matching operator effect
        :param pulumi.Input[_builtins.str] pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param pulumi.Input[_builtins.str] sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "route_id", route_id)
        pulumi.set(__self__, "service_name", service_name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if sub_field is not None:
            pulumi.set(__self__, "sub_field", sub_field)

    @_builtins.property
    @pulumi.getter
    def field(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the field to match like "protocol" or "host". See "/ipLoadbalancing/{serviceName}/availableRouteRules" for a list of available rules
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "field", value)

    @_builtins.property
    @pulumi.getter
    def match(self) -> pulumi.Input[_builtins.str]:
        """
        Matching operator. Not all operators are available for all fields. See "/ipLoadbalancing/{serviceName}/availableRouteRules"
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "match", value)

    @_builtins.property
    @pulumi.getter(name="routeId")
    def route_id(self) -> pulumi.Input[_builtins.str]:
        """
        The route to apply this rule
        """
        return pulumi.get(self, "route_id")

    @route_id.setter
    def route_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human readable name for your rule, this field is for you
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invert the matching operator effect
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate", value)

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pattern", value)

    @_builtins.property
    @pulumi.getter(name="subField")
    def sub_field(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        return pulumi.get(self, "sub_field")

    @sub_field.setter
    def sub_field(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_field", value)


@pulumi.input_type
class _HttpRouteRuleState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 field: Optional[pulumi.Input[_builtins.str]] = None,
                 match: Optional[pulumi.Input[_builtins.str]] = None,
                 negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 route_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_field: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HttpRouteRule resources.
        :param pulumi.Input[_builtins.str] display_name: Human readable name for your rule, this field is for you
        :param pulumi.Input[_builtins.str] field: Name of the field to match like "protocol" or "host". See "/ipLoadbalancing/{serviceName}/availableRouteRules" for a list of available rules
        :param pulumi.Input[_builtins.str] match: Matching operator. Not all operators are available for all fields. See "/ipLoadbalancing/{serviceName}/availableRouteRules"
        :param pulumi.Input[_builtins.bool] negate: Invert the matching operator effect
        :param pulumi.Input[_builtins.str] pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param pulumi.Input[_builtins.str] route_id: The route to apply this rule
        :param pulumi.Input[_builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[_builtins.str] sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if field is not None:
            pulumi.set(__self__, "field", field)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if route_id is not None:
            pulumi.set(__self__, "route_id", route_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if sub_field is not None:
            pulumi.set(__self__, "sub_field", sub_field)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human readable name for your rule, this field is for you
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the field to match like "protocol" or "host". See "/ipLoadbalancing/{serviceName}/availableRouteRules" for a list of available rules
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "field", value)

    @_builtins.property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Matching operator. Not all operators are available for all fields. See "/ipLoadbalancing/{serviceName}/availableRouteRules"
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "match", value)

    @_builtins.property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Invert the matching operator effect
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate", value)

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pattern", value)

    @_builtins.property
    @pulumi.getter(name="routeId")
    def route_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The route to apply this rule
        """
        return pulumi.get(self, "route_id")

    @route_id.setter
    def route_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="subField")
    def sub_field(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        return pulumi.get(self, "sub_field")

    @sub_field.setter
    def sub_field(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_field", value)


@pulumi.type_token("ovh:IpLoadBalancing/httpRouteRule:HttpRouteRule")
class HttpRouteRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 field: Optional[pulumi.Input[_builtins.str]] = None,
                 match: Optional[pulumi.Input[_builtins.str]] = None,
                 negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 route_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_field: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage rules for HTTP route.

        ## Example Usage

        Route which redirect all URL to HTTPs for example.com (Vhost).

        ```python
        import pulumi
        import pulumi_ovh as ovh

        https_redirect = ovh.iploadbalancing.HttpRoute("https_redirect",
            service_name="loadbalancer-xxxxxxxxxxxxxxxxxx",
            display_name="Redirect to HTTPS",
            weight=1,
            frontend_id=11111,
            action={
                "status": 302,
                "target": "https://${host}${path}${arguments}",
                "type": "redirect",
            })
        example_rule = ovh.iploadbalancing.HttpRouteRule("example_rule",
            service_name="loadbalancer-xxxxxxxxxxxxxxxxxx",
            route_id=https_redirect.id,
            display_name="Match example.com host",
            field="host",
            match="is",
            negate=False,
            pattern="example.com")
        ```

        Rule which match a specific header (same effect as the host match above).

        ```python
        import pulumi
        import pulumi_ovh as ovh

        example_rule = ovh.iploadbalancing.HttpRouteRule("example_rule",
            service_name="loadbalancer-xxxxxxxxxxxxxxxxxx",
            route_id=https_redirect["id"],
            display_name="Match example.com Host header",
            field="headers",
            match="is",
            negate=False,
            pattern="example.com",
            sub_field="Host")
        ```

        ## Import

        HTTP route rule can be imported using the following format `service_name`, the `id` of the route and the `id` of the rule separated by "/" e.g.

        bash

        ```sh
        $ pulumi import ovh:IpLoadBalancing/httpRouteRule:HttpRouteRule examplerule service_name/route_id/rule_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: Human readable name for your rule, this field is for you
        :param pulumi.Input[_builtins.str] field: Name of the field to match like "protocol" or "host". See "/ipLoadbalancing/{serviceName}/availableRouteRules" for a list of available rules
        :param pulumi.Input[_builtins.str] match: Matching operator. Not all operators are available for all fields. See "/ipLoadbalancing/{serviceName}/availableRouteRules"
        :param pulumi.Input[_builtins.bool] negate: Invert the matching operator effect
        :param pulumi.Input[_builtins.str] pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param pulumi.Input[_builtins.str] route_id: The route to apply this rule
        :param pulumi.Input[_builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[_builtins.str] sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HttpRouteRuleInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage rules for HTTP route.

        ## Example Usage

        Route which redirect all URL to HTTPs for example.com (Vhost).

        ```python
        import pulumi
        import pulumi_ovh as ovh

        https_redirect = ovh.iploadbalancing.HttpRoute("https_redirect",
            service_name="loadbalancer-xxxxxxxxxxxxxxxxxx",
            display_name="Redirect to HTTPS",
            weight=1,
            frontend_id=11111,
            action={
                "status": 302,
                "target": "https://${host}${path}${arguments}",
                "type": "redirect",
            })
        example_rule = ovh.iploadbalancing.HttpRouteRule("example_rule",
            service_name="loadbalancer-xxxxxxxxxxxxxxxxxx",
            route_id=https_redirect.id,
            display_name="Match example.com host",
            field="host",
            match="is",
            negate=False,
            pattern="example.com")
        ```

        Rule which match a specific header (same effect as the host match above).

        ```python
        import pulumi
        import pulumi_ovh as ovh

        example_rule = ovh.iploadbalancing.HttpRouteRule("example_rule",
            service_name="loadbalancer-xxxxxxxxxxxxxxxxxx",
            route_id=https_redirect["id"],
            display_name="Match example.com Host header",
            field="headers",
            match="is",
            negate=False,
            pattern="example.com",
            sub_field="Host")
        ```

        ## Import

        HTTP route rule can be imported using the following format `service_name`, the `id` of the route and the `id` of the rule separated by "/" e.g.

        bash

        ```sh
        $ pulumi import ovh:IpLoadBalancing/httpRouteRule:HttpRouteRule examplerule service_name/route_id/rule_id
        ```

        :param str resource_name: The name of the resource.
        :param HttpRouteRuleInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HttpRouteRuleInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 field: Optional[pulumi.Input[_builtins.str]] = None,
                 match: Optional[pulumi.Input[_builtins.str]] = None,
                 negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 route_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_field: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HttpRouteRuleInitArgs.__new__(HttpRouteRuleInitArgs)

            __props__.__dict__["display_name"] = display_name
            if field is None and not opts.urn:
                raise TypeError("Missing required property 'field'")
            __props__.__dict__["field"] = field
            if match is None and not opts.urn:
                raise TypeError("Missing required property 'match'")
            __props__.__dict__["match"] = match
            __props__.__dict__["negate"] = negate
            __props__.__dict__["pattern"] = pattern
            if route_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_id'")
            __props__.__dict__["route_id"] = route_id
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["sub_field"] = sub_field
        super(HttpRouteRule, __self__).__init__(
            'ovh:IpLoadBalancing/httpRouteRule:HttpRouteRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            field: Optional[pulumi.Input[_builtins.str]] = None,
            match: Optional[pulumi.Input[_builtins.str]] = None,
            negate: Optional[pulumi.Input[_builtins.bool]] = None,
            pattern: Optional[pulumi.Input[_builtins.str]] = None,
            route_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            sub_field: Optional[pulumi.Input[_builtins.str]] = None) -> 'HttpRouteRule':
        """
        Get an existing HttpRouteRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: Human readable name for your rule, this field is for you
        :param pulumi.Input[_builtins.str] field: Name of the field to match like "protocol" or "host". See "/ipLoadbalancing/{serviceName}/availableRouteRules" for a list of available rules
        :param pulumi.Input[_builtins.str] match: Matching operator. Not all operators are available for all fields. See "/ipLoadbalancing/{serviceName}/availableRouteRules"
        :param pulumi.Input[_builtins.bool] negate: Invert the matching operator effect
        :param pulumi.Input[_builtins.str] pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param pulumi.Input[_builtins.str] route_id: The route to apply this rule
        :param pulumi.Input[_builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[_builtins.str] sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HttpRouteRuleState.__new__(_HttpRouteRuleState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["field"] = field
        __props__.__dict__["match"] = match
        __props__.__dict__["negate"] = negate
        __props__.__dict__["pattern"] = pattern
        __props__.__dict__["route_id"] = route_id
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["sub_field"] = sub_field
        return HttpRouteRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human readable name for your rule, this field is for you
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def field(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the field to match like "protocol" or "host". See "/ipLoadbalancing/{serviceName}/availableRouteRules" for a list of available rules
        """
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def match(self) -> pulumi.Output[_builtins.str]:
        """
        Matching operator. Not all operators are available for all fields. See "/ipLoadbalancing/{serviceName}/availableRouteRules"
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter
    def negate(self) -> pulumi.Output[_builtins.bool]:
        """
        Invert the matching operator effect
        """
        return pulumi.get(self, "negate")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter(name="routeId")
    def route_id(self) -> pulumi.Output[_builtins.str]:
        """
        The route to apply this rule
        """
        return pulumi.get(self, "route_id")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="subField")
    def sub_field(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        return pulumi.get(self, "sub_field")

