# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerArgs', 'LoadBalancer']

@pulumi.input_type
class LoadBalancerArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 orders: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderArgs']]]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_mean: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input['LoadBalancerPlanArgs']] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanOptionArgs']]]] = None,
                 ssl_configuration: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LoadBalancer resource.
        :param pulumi.Input[_builtins.str] display_name: Set the name displayed in ManagerV6 for your iplb (max 50 chars)
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderArgs']]] orders: Details about an Order
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json under `models.nichandle.OvhSubsidiaryEnum`](https://eu.api.ovh.com/1.0/me.json)
        :param pulumi.Input[_builtins.str] payment_mean: Ovh payment mode
        :param pulumi.Input['LoadBalancerPlanArgs'] plan: Product Plan to order
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanOptionArgs']]] plan_options: Product Plan to order
        :param pulumi.Input[_builtins.str] ssl_configuration: Modern oldest compatible clients : Firefox 27, Chrome 30, IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8. Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5, Safari 1, Windows XP IE8, Android 2.3, Java 7. Intermediate if null. one of "intermediate", "modern".
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if orders is not None:
            pulumi.set(__self__, "orders", orders)
        if ovh_subsidiary is not None:
            pulumi.set(__self__, "ovh_subsidiary", ovh_subsidiary)
        if payment_mean is not None:
            warnings.warn("""This field is not anymore used since the API has been deprecated in favor of /payment/mean. Now, the default payment mean is used.""", DeprecationWarning)
            pulumi.log.warn("""payment_mean is deprecated: This field is not anymore used since the API has been deprecated in favor of /payment/mean. Now, the default payment mean is used.""")
        if payment_mean is not None:
            pulumi.set(__self__, "payment_mean", payment_mean)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if plan_options is not None:
            pulumi.set(__self__, "plan_options", plan_options)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the name displayed in ManagerV6 for your iplb (max 50 chars)
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def orders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderArgs']]]]:
        """
        Details about an Order
        """
        return pulumi.get(self, "orders")

    @orders.setter
    def orders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderArgs']]]]):
        pulumi.set(self, "orders", value)

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json under `models.nichandle.OvhSubsidiaryEnum`](https://eu.api.ovh.com/1.0/me.json)
        """
        return pulumi.get(self, "ovh_subsidiary")

    @ovh_subsidiary.setter
    def ovh_subsidiary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ovh_subsidiary", value)

    @_builtins.property
    @pulumi.getter(name="paymentMean")
    @_utilities.deprecated("""This field is not anymore used since the API has been deprecated in favor of /payment/mean. Now, the default payment mean is used.""")
    def payment_mean(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ovh payment mode
        """
        return pulumi.get(self, "payment_mean")

    @payment_mean.setter
    def payment_mean(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_mean", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['LoadBalancerPlanArgs']]:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['LoadBalancerPlanArgs']]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="planOptions")
    def plan_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanOptionArgs']]]]:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plan_options")

    @plan_options.setter
    def plan_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanOptionArgs']]]]):
        pulumi.set(self, "plan_options", value)

    @_builtins.property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Modern oldest compatible clients : Firefox 27, Chrome 30, IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8. Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5, Safari 1, Windows XP IE8, Android 2.3, Java 7. Intermediate if null. one of "intermediate", "modern".
        """
        return pulumi.get(self, "ssl_configuration")

    @ssl_configuration.setter
    def ssl_configuration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_configuration", value)


@pulumi.input_type
class _LoadBalancerState:
    def __init__(__self__, *,
                 load_balancer_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_loadbalancing: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_token: Optional[pulumi.Input[_builtins.str]] = None,
                 offer: Optional[pulumi.Input[_builtins.str]] = None,
                 orderable_zones: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderableZoneArgs']]]] = None,
                 orders: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderArgs']]]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_mean: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input['LoadBalancerPlanArgs']] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanOptionArgs']]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vrack_eligibility: Optional[pulumi.Input[_builtins.bool]] = None,
                 vrack_name: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering LoadBalancer resources.
        :param pulumi.Input[_builtins.str] load_balancer_urn: URN of the load balancer, used when writing IAM policies
        :param pulumi.Input[_builtins.str] display_name: Set the name displayed in ManagerV6 for your iplb (max 50 chars)
        :param pulumi.Input[_builtins.str] ip_loadbalancing: Your IP load balancing
        :param pulumi.Input[_builtins.str] ipv4: The IPV4 associated to your IP load balancing
        :param pulumi.Input[_builtins.str] ipv6: The IPV6 associated to your IP load balancing. DEPRECATED.
        :param pulumi.Input[_builtins.str] metrics_token: The metrics token associated with your IP load balancing
        :param pulumi.Input[_builtins.str] offer: The offer of your IP load balancing
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderableZoneArgs']]] orderable_zones: Available additional zone for your Load Balancer
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderArgs']]] orders: Details about an Order
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json under `models.nichandle.OvhSubsidiaryEnum`](https://eu.api.ovh.com/1.0/me.json)
        :param pulumi.Input[_builtins.str] payment_mean: Ovh payment mode
        :param pulumi.Input['LoadBalancerPlanArgs'] plan: Product Plan to order
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanOptionArgs']]] plan_options: Product Plan to order
        :param pulumi.Input[_builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[_builtins.str] ssl_configuration: Modern oldest compatible clients : Firefox 27, Chrome 30, IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8. Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5, Safari 1, Windows XP IE8, Android 2.3, Java 7. Intermediate if null. one of "intermediate", "modern".
        :param pulumi.Input[_builtins.str] state: Current state of your IP
        :param pulumi.Input[_builtins.bool] vrack_eligibility: Vrack eligibility
        :param pulumi.Input[_builtins.str] vrack_name: Name of the vRack on which the current Load Balancer is attached to, as it is named on vRack product
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Location where your service is
        """
        if load_balancer_urn is not None:
            pulumi.set(__self__, "load_balancer_urn", load_balancer_urn)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if ip_loadbalancing is not None:
            pulumi.set(__self__, "ip_loadbalancing", ip_loadbalancing)
        if ipv4 is not None:
            pulumi.set(__self__, "ipv4", ipv4)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if metrics_token is not None:
            pulumi.set(__self__, "metrics_token", metrics_token)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if orderable_zones is not None:
            pulumi.set(__self__, "orderable_zones", orderable_zones)
        if orders is not None:
            pulumi.set(__self__, "orders", orders)
        if ovh_subsidiary is not None:
            pulumi.set(__self__, "ovh_subsidiary", ovh_subsidiary)
        if payment_mean is not None:
            warnings.warn("""This field is not anymore used since the API has been deprecated in favor of /payment/mean. Now, the default payment mean is used.""", DeprecationWarning)
            pulumi.log.warn("""payment_mean is deprecated: This field is not anymore used since the API has been deprecated in favor of /payment/mean. Now, the default payment mean is used.""")
        if payment_mean is not None:
            pulumi.set(__self__, "payment_mean", payment_mean)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if plan_options is not None:
            pulumi.set(__self__, "plan_options", plan_options)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vrack_eligibility is not None:
            pulumi.set(__self__, "vrack_eligibility", vrack_eligibility)
        if vrack_name is not None:
            pulumi.set(__self__, "vrack_name", vrack_name)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="LoadBalancerURN")
    def load_balancer_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URN of the load balancer, used when writing IAM policies
        """
        return pulumi.get(self, "load_balancer_urn")

    @load_balancer_urn.setter
    def load_balancer_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_urn", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the name displayed in ManagerV6 for your iplb (max 50 chars)
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="ipLoadbalancing")
    def ip_loadbalancing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your IP load balancing
        """
        return pulumi.get(self, "ip_loadbalancing")

    @ip_loadbalancing.setter
    def ip_loadbalancing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_loadbalancing", value)

    @_builtins.property
    @pulumi.getter
    def ipv4(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPV4 associated to your IP load balancing
        """
        return pulumi.get(self, "ipv4")

    @ipv4.setter
    def ipv4(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4", value)

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPV6 associated to your IP load balancing. DEPRECATED.
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6", value)

    @_builtins.property
    @pulumi.getter(name="metricsToken")
    def metrics_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The metrics token associated with your IP load balancing
        """
        return pulumi.get(self, "metrics_token")

    @metrics_token.setter
    def metrics_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_token", value)

    @_builtins.property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The offer of your IP load balancing
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "offer", value)

    @_builtins.property
    @pulumi.getter(name="orderableZones")
    def orderable_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderableZoneArgs']]]]:
        """
        Available additional zone for your Load Balancer
        """
        return pulumi.get(self, "orderable_zones")

    @orderable_zones.setter
    def orderable_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderableZoneArgs']]]]):
        pulumi.set(self, "orderable_zones", value)

    @_builtins.property
    @pulumi.getter
    def orders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderArgs']]]]:
        """
        Details about an Order
        """
        return pulumi.get(self, "orders")

    @orders.setter
    def orders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderArgs']]]]):
        pulumi.set(self, "orders", value)

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json under `models.nichandle.OvhSubsidiaryEnum`](https://eu.api.ovh.com/1.0/me.json)
        """
        return pulumi.get(self, "ovh_subsidiary")

    @ovh_subsidiary.setter
    def ovh_subsidiary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ovh_subsidiary", value)

    @_builtins.property
    @pulumi.getter(name="paymentMean")
    @_utilities.deprecated("""This field is not anymore used since the API has been deprecated in favor of /payment/mean. Now, the default payment mean is used.""")
    def payment_mean(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ovh payment mode
        """
        return pulumi.get(self, "payment_mean")

    @payment_mean.setter
    def payment_mean(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_mean", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['LoadBalancerPlanArgs']]:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['LoadBalancerPlanArgs']]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="planOptions")
    def plan_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanOptionArgs']]]]:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plan_options")

    @plan_options.setter
    def plan_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanOptionArgs']]]]):
        pulumi.set(self, "plan_options", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Modern oldest compatible clients : Firefox 27, Chrome 30, IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8. Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5, Safari 1, Windows XP IE8, Android 2.3, Java 7. Intermediate if null. one of "intermediate", "modern".
        """
        return pulumi.get(self, "ssl_configuration")

    @ssl_configuration.setter
    def ssl_configuration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_configuration", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Current state of your IP
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="vrackEligibility")
    def vrack_eligibility(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Vrack eligibility
        """
        return pulumi.get(self, "vrack_eligibility")

    @vrack_eligibility.setter
    def vrack_eligibility(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vrack_eligibility", value)

    @_builtins.property
    @pulumi.getter(name="vrackName")
    def vrack_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the vRack on which the current Load Balancer is attached to, as it is named on vRack product
        """
        return pulumi.get(self, "vrack_name")

    @vrack_name.setter
    def vrack_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vrack_name", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Location where your service is
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("ovh:IpLoadBalancing/loadBalancer:LoadBalancer")
class LoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 orders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerOrderArgs', 'LoadBalancerOrderArgsDict']]]]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_mean: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[Union['LoadBalancerPlanArgs', 'LoadBalancerPlanArgsDict']]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPlanOptionArgs', 'LoadBalancerPlanOptionArgsDict']]]]] = None,
                 ssl_configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        myaccount = ovh.Me.get_me()
        mycart = ovh.Order.get_cart(ovh_subsidiary=myaccount.ovh_subsidiary)
        iplb = ovh.Order.get_cart_product_plan(cart_id=mycart.id,
            price_capacity="renew",
            product="ipLoadbalancing",
            plan_code="iplb-lb1")
        bhs = ovh.Order.get_cart_product_options_plan(cart_id=iplb.cart_id,
            price_capacity=iplb.price_capacity,
            product=iplb.product,
            plan_code=iplb.plan_code,
            options_plan_code="iplb-zone-lb1-rbx")
        iplb_lb1 = ovh.iploadbalancing.LoadBalancer("iplb_lb1",
            ovh_subsidiary=mycart.ovh_subsidiary,
            display_name="my ip loadbalancing",
            plan={
                "duration": iplb.selected_prices[0].duration,
                "plan_code": iplb.plan_code,
                "pricing_mode": iplb.selected_prices[0].pricing_mode,
            },
            plan_options=[{
                "duration": bhs.selected_prices[0].duration,
                "plan_code": bhs.plan_code,
                "pricing_mode": bhs.selected_prices[0].pricing_mode,
            }])
        ```

        ## Import

        OVHcloud IP load balancing services can be imported using its `service_name`.

        Using the following configuration:

        terraform

        import {

          to = ovh_iploadbalancing.iplb

          id = "<service name>"

        }

        You can then run:

        bash

        $ pulumi preview -generate-config-out=iplb.tf

        $ pulumi up

        The file `iplb.tf` will then contain the imported resource's configuration, that can be copied next to the `import` block above. See https://developer.hashicorp.com/terraform/language/import/generating-configuration for more details.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: Set the name displayed in ManagerV6 for your iplb (max 50 chars)
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerOrderArgs', 'LoadBalancerOrderArgsDict']]]] orders: Details about an Order
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json under `models.nichandle.OvhSubsidiaryEnum`](https://eu.api.ovh.com/1.0/me.json)
        :param pulumi.Input[_builtins.str] payment_mean: Ovh payment mode
        :param pulumi.Input[Union['LoadBalancerPlanArgs', 'LoadBalancerPlanArgsDict']] plan: Product Plan to order
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPlanOptionArgs', 'LoadBalancerPlanOptionArgsDict']]]] plan_options: Product Plan to order
        :param pulumi.Input[_builtins.str] ssl_configuration: Modern oldest compatible clients : Firefox 27, Chrome 30, IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8. Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5, Safari 1, Windows XP IE8, Android 2.3, Java 7. Intermediate if null. one of "intermediate", "modern".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LoadBalancerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        myaccount = ovh.Me.get_me()
        mycart = ovh.Order.get_cart(ovh_subsidiary=myaccount.ovh_subsidiary)
        iplb = ovh.Order.get_cart_product_plan(cart_id=mycart.id,
            price_capacity="renew",
            product="ipLoadbalancing",
            plan_code="iplb-lb1")
        bhs = ovh.Order.get_cart_product_options_plan(cart_id=iplb.cart_id,
            price_capacity=iplb.price_capacity,
            product=iplb.product,
            plan_code=iplb.plan_code,
            options_plan_code="iplb-zone-lb1-rbx")
        iplb_lb1 = ovh.iploadbalancing.LoadBalancer("iplb_lb1",
            ovh_subsidiary=mycart.ovh_subsidiary,
            display_name="my ip loadbalancing",
            plan={
                "duration": iplb.selected_prices[0].duration,
                "plan_code": iplb.plan_code,
                "pricing_mode": iplb.selected_prices[0].pricing_mode,
            },
            plan_options=[{
                "duration": bhs.selected_prices[0].duration,
                "plan_code": bhs.plan_code,
                "pricing_mode": bhs.selected_prices[0].pricing_mode,
            }])
        ```

        ## Import

        OVHcloud IP load balancing services can be imported using its `service_name`.

        Using the following configuration:

        terraform

        import {

          to = ovh_iploadbalancing.iplb

          id = "<service name>"

        }

        You can then run:

        bash

        $ pulumi preview -generate-config-out=iplb.tf

        $ pulumi up

        The file `iplb.tf` will then contain the imported resource's configuration, that can be copied next to the `import` block above. See https://developer.hashicorp.com/terraform/language/import/generating-configuration for more details.

        :param str resource_name: The name of the resource.
        :param LoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 orders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerOrderArgs', 'LoadBalancerOrderArgsDict']]]]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_mean: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[Union['LoadBalancerPlanArgs', 'LoadBalancerPlanArgsDict']]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPlanOptionArgs', 'LoadBalancerPlanOptionArgsDict']]]]] = None,
                 ssl_configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerArgs.__new__(LoadBalancerArgs)

            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["orders"] = orders
            __props__.__dict__["ovh_subsidiary"] = ovh_subsidiary
            __props__.__dict__["payment_mean"] = payment_mean
            __props__.__dict__["plan"] = plan
            __props__.__dict__["plan_options"] = plan_options
            __props__.__dict__["ssl_configuration"] = ssl_configuration
            __props__.__dict__["load_balancer_urn"] = None
            __props__.__dict__["ip_loadbalancing"] = None
            __props__.__dict__["ipv4"] = None
            __props__.__dict__["ipv6"] = None
            __props__.__dict__["metrics_token"] = None
            __props__.__dict__["offer"] = None
            __props__.__dict__["orderable_zones"] = None
            __props__.__dict__["service_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["vrack_eligibility"] = None
            __props__.__dict__["vrack_name"] = None
            __props__.__dict__["zones"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["metricsToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LoadBalancer, __self__).__init__(
            'ovh:IpLoadBalancing/loadBalancer:LoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            load_balancer_urn: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            ip_loadbalancing: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6: Optional[pulumi.Input[_builtins.str]] = None,
            metrics_token: Optional[pulumi.Input[_builtins.str]] = None,
            offer: Optional[pulumi.Input[_builtins.str]] = None,
            orderable_zones: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerOrderableZoneArgs', 'LoadBalancerOrderableZoneArgsDict']]]]] = None,
            orders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerOrderArgs', 'LoadBalancerOrderArgsDict']]]]] = None,
            ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
            payment_mean: Optional[pulumi.Input[_builtins.str]] = None,
            plan: Optional[pulumi.Input[Union['LoadBalancerPlanArgs', 'LoadBalancerPlanArgsDict']]] = None,
            plan_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPlanOptionArgs', 'LoadBalancerPlanOptionArgsDict']]]]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_configuration: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            vrack_eligibility: Optional[pulumi.Input[_builtins.bool]] = None,
            vrack_name: Optional[pulumi.Input[_builtins.str]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'LoadBalancer':
        """
        Get an existing LoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] load_balancer_urn: URN of the load balancer, used when writing IAM policies
        :param pulumi.Input[_builtins.str] display_name: Set the name displayed in ManagerV6 for your iplb (max 50 chars)
        :param pulumi.Input[_builtins.str] ip_loadbalancing: Your IP load balancing
        :param pulumi.Input[_builtins.str] ipv4: The IPV4 associated to your IP load balancing
        :param pulumi.Input[_builtins.str] ipv6: The IPV6 associated to your IP load balancing. DEPRECATED.
        :param pulumi.Input[_builtins.str] metrics_token: The metrics token associated with your IP load balancing
        :param pulumi.Input[_builtins.str] offer: The offer of your IP load balancing
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerOrderableZoneArgs', 'LoadBalancerOrderableZoneArgsDict']]]] orderable_zones: Available additional zone for your Load Balancer
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerOrderArgs', 'LoadBalancerOrderArgsDict']]]] orders: Details about an Order
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json under `models.nichandle.OvhSubsidiaryEnum`](https://eu.api.ovh.com/1.0/me.json)
        :param pulumi.Input[_builtins.str] payment_mean: Ovh payment mode
        :param pulumi.Input[Union['LoadBalancerPlanArgs', 'LoadBalancerPlanArgsDict']] plan: Product Plan to order
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPlanOptionArgs', 'LoadBalancerPlanOptionArgsDict']]]] plan_options: Product Plan to order
        :param pulumi.Input[_builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[_builtins.str] ssl_configuration: Modern oldest compatible clients : Firefox 27, Chrome 30, IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8. Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5, Safari 1, Windows XP IE8, Android 2.3, Java 7. Intermediate if null. one of "intermediate", "modern".
        :param pulumi.Input[_builtins.str] state: Current state of your IP
        :param pulumi.Input[_builtins.bool] vrack_eligibility: Vrack eligibility
        :param pulumi.Input[_builtins.str] vrack_name: Name of the vRack on which the current Load Balancer is attached to, as it is named on vRack product
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Location where your service is
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerState.__new__(_LoadBalancerState)

        __props__.__dict__["load_balancer_urn"] = load_balancer_urn
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["ip_loadbalancing"] = ip_loadbalancing
        __props__.__dict__["ipv4"] = ipv4
        __props__.__dict__["ipv6"] = ipv6
        __props__.__dict__["metrics_token"] = metrics_token
        __props__.__dict__["offer"] = offer
        __props__.__dict__["orderable_zones"] = orderable_zones
        __props__.__dict__["orders"] = orders
        __props__.__dict__["ovh_subsidiary"] = ovh_subsidiary
        __props__.__dict__["payment_mean"] = payment_mean
        __props__.__dict__["plan"] = plan
        __props__.__dict__["plan_options"] = plan_options
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["ssl_configuration"] = ssl_configuration
        __props__.__dict__["state"] = state
        __props__.__dict__["vrack_eligibility"] = vrack_eligibility
        __props__.__dict__["vrack_name"] = vrack_name
        __props__.__dict__["zones"] = zones
        return LoadBalancer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="LoadBalancerURN")
    def load_balancer_urn(self) -> pulumi.Output[_builtins.str]:
        """
        URN of the load balancer, used when writing IAM policies
        """
        return pulumi.get(self, "load_balancer_urn")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Set the name displayed in ManagerV6 for your iplb (max 50 chars)
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="ipLoadbalancing")
    def ip_loadbalancing(self) -> pulumi.Output[_builtins.str]:
        """
        Your IP load balancing
        """
        return pulumi.get(self, "ip_loadbalancing")

    @_builtins.property
    @pulumi.getter
    def ipv4(self) -> pulumi.Output[_builtins.str]:
        """
        The IPV4 associated to your IP load balancing
        """
        return pulumi.get(self, "ipv4")

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> pulumi.Output[_builtins.str]:
        """
        The IPV6 associated to your IP load balancing. DEPRECATED.
        """
        return pulumi.get(self, "ipv6")

    @_builtins.property
    @pulumi.getter(name="metricsToken")
    def metrics_token(self) -> pulumi.Output[_builtins.str]:
        """
        The metrics token associated with your IP load balancing
        """
        return pulumi.get(self, "metrics_token")

    @_builtins.property
    @pulumi.getter
    def offer(self) -> pulumi.Output[_builtins.str]:
        """
        The offer of your IP load balancing
        """
        return pulumi.get(self, "offer")

    @_builtins.property
    @pulumi.getter(name="orderableZones")
    def orderable_zones(self) -> pulumi.Output[Sequence['outputs.LoadBalancerOrderableZone']]:
        """
        Available additional zone for your Load Balancer
        """
        return pulumi.get(self, "orderable_zones")

    @_builtins.property
    @pulumi.getter
    def orders(self) -> pulumi.Output[Sequence['outputs.LoadBalancerOrder']]:
        """
        Details about an Order
        """
        return pulumi.get(self, "orders")

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> pulumi.Output[_builtins.str]:
        """
        OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json under `models.nichandle.OvhSubsidiaryEnum`](https://eu.api.ovh.com/1.0/me.json)
        """
        return pulumi.get(self, "ovh_subsidiary")

    @_builtins.property
    @pulumi.getter(name="paymentMean")
    @_utilities.deprecated("""This field is not anymore used since the API has been deprecated in favor of /payment/mean. Now, the default payment mean is used.""")
    def payment_mean(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Ovh payment mode
        """
        return pulumi.get(self, "payment_mean")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output['outputs.LoadBalancerPlan']:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="planOptions")
    def plan_options(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerPlanOption']]]:
        """
        Product Plan to order
        """
        return pulumi.get(self, "plan_options")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> pulumi.Output[_builtins.str]:
        """
        Modern oldest compatible clients : Firefox 27, Chrome 30, IE 11 on Windows 7, Edge, Opera 17, Safari 9, Android 5.0, and Java 8. Intermediate oldest compatible clients : Firefox 1, Chrome 1, IE 7, Opera 5, Safari 1, Windows XP IE8, Android 2.3, Java 7. Intermediate if null. one of "intermediate", "modern".
        """
        return pulumi.get(self, "ssl_configuration")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Current state of your IP
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="vrackEligibility")
    def vrack_eligibility(self) -> pulumi.Output[_builtins.bool]:
        """
        Vrack eligibility
        """
        return pulumi.get(self, "vrack_eligibility")

    @_builtins.property
    @pulumi.getter(name="vrackName")
    def vrack_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the vRack on which the current Load Balancer is attached to, as it is named on vRack product
        """
        return pulumi.get(self, "vrack_name")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Location where your service is
        """
        return pulumi.get(self, "zones")

