# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VrackNetworkArgs', 'VrackNetwork']

@pulumi.input_type
class VrackNetworkArgs:
    def __init__(__self__, *,
                 nat_ip: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 subnet: pulumi.Input[_builtins.str],
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 farm_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 vlan: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a VrackNetwork resource.
        :param pulumi.Input[_builtins.str] nat_ip: An IP block used as a pool of IPs by this Load Balancer to connect to the servers in this private network. The blck must be in the private network and reserved for the Load Balancer
        :param pulumi.Input[_builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[_builtins.str] subnet: IP block of the private network in the vRack
        :param pulumi.Input[_builtins.str] display_name: Human readable name for your vrack network
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] farm_ids: This attribute is there for documentation purpose only and isnt passed to the OVHcloud API as it may conflicts with http/tcp farms `vrack_network_id` attribute
        :param pulumi.Input[_builtins.int] vlan: VLAN of the private network in the vRack. 0 if the private network is not in a VLAN
        """
        pulumi.set(__self__, "nat_ip", nat_ip)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "subnet", subnet)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if farm_ids is not None:
            pulumi.set(__self__, "farm_ids", farm_ids)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @_builtins.property
    @pulumi.getter(name="natIp")
    def nat_ip(self) -> pulumi.Input[_builtins.str]:
        """
        An IP block used as a pool of IPs by this Load Balancer to connect to the servers in this private network. The blck must be in the private network and reserved for the Load Balancer
        """
        return pulumi.get(self, "nat_ip")

    @nat_ip.setter
    def nat_ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nat_ip", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[_builtins.str]:
        """
        IP block of the private network in the vRack
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human readable name for your vrack network
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="farmIds")
    def farm_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        This attribute is there for documentation purpose only and isnt passed to the OVHcloud API as it may conflicts with http/tcp farms `vrack_network_id` attribute
        """
        return pulumi.get(self, "farm_ids")

    @farm_ids.setter
    def farm_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "farm_ids", value)

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        VLAN of the private network in the vRack. 0 if the private network is not in a VLAN
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vlan", value)


@pulumi.input_type
class _VrackNetworkState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 farm_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 nat_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan: Optional[pulumi.Input[_builtins.int]] = None,
                 vrack_network_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering VrackNetwork resources.
        :param pulumi.Input[_builtins.str] display_name: Human readable name for your vrack network
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] farm_ids: This attribute is there for documentation purpose only and isnt passed to the OVHcloud API as it may conflicts with http/tcp farms `vrack_network_id` attribute
        :param pulumi.Input[_builtins.str] nat_ip: An IP block used as a pool of IPs by this Load Balancer to connect to the servers in this private network. The blck must be in the private network and reserved for the Load Balancer
        :param pulumi.Input[_builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[_builtins.str] subnet: IP block of the private network in the vRack
        :param pulumi.Input[_builtins.int] vlan: VLAN of the private network in the vRack. 0 if the private network is not in a VLAN
        :param pulumi.Input[_builtins.int] vrack_network_id: (Required) Internal Load Balancer identifier of the vRack private network
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if farm_ids is not None:
            pulumi.set(__self__, "farm_ids", farm_ids)
        if nat_ip is not None:
            pulumi.set(__self__, "nat_ip", nat_ip)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)
        if vrack_network_id is not None:
            pulumi.set(__self__, "vrack_network_id", vrack_network_id)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human readable name for your vrack network
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="farmIds")
    def farm_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        This attribute is there for documentation purpose only and isnt passed to the OVHcloud API as it may conflicts with http/tcp farms `vrack_network_id` attribute
        """
        return pulumi.get(self, "farm_ids")

    @farm_ids.setter
    def farm_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "farm_ids", value)

    @_builtins.property
    @pulumi.getter(name="natIp")
    def nat_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An IP block used as a pool of IPs by this Load Balancer to connect to the servers in this private network. The blck must be in the private network and reserved for the Load Balancer
        """
        return pulumi.get(self, "nat_ip")

    @nat_ip.setter
    def nat_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_ip", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP block of the private network in the vRack
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet", value)

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        VLAN of the private network in the vRack. 0 if the private network is not in a VLAN
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vlan", value)

    @_builtins.property
    @pulumi.getter(name="vrackNetworkId")
    def vrack_network_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Required) Internal Load Balancer identifier of the vRack private network
        """
        return pulumi.get(self, "vrack_network_id")

    @vrack_network_id.setter
    def vrack_network_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vrack_network_id", value)


@pulumi.type_token("ovh:IpLoadBalancing/vrackNetwork:VrackNetwork")
class VrackNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 farm_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 nat_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manage a vrack network for your IP Loadbalancing service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        iplb = ovh.IpLoadBalancing.get_ip_load_balancing(service_name="loadbalancer-xxxxxxxxxxxxxxxxxx")
        vip_lb = ovh.vrack.IpLoadbalancing("vip_lb",
            service_name="xxx",
            loadbalancing_id=iplb.service_name)
        network = ovh.iploadbalancing.VrackNetwork("network",
            service_name=vip_lb.loadbalancing_id,
            subnet="10.0.0.0/16",
            vlan=1,
            nat_ip="10.0.0.0/27",
            display_name="mynetwork")
        test_farm = ovh.iploadbalancing.TcpFarm("test_farm",
            service_name=network.service_name,
            display_name="mytcpbackends",
            port=80,
            vrack_network_id=network.vrack_network_id,
            zone=iplb.zones[0])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: Human readable name for your vrack network
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] farm_ids: This attribute is there for documentation purpose only and isnt passed to the OVHcloud API as it may conflicts with http/tcp farms `vrack_network_id` attribute
        :param pulumi.Input[_builtins.str] nat_ip: An IP block used as a pool of IPs by this Load Balancer to connect to the servers in this private network. The blck must be in the private network and reserved for the Load Balancer
        :param pulumi.Input[_builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[_builtins.str] subnet: IP block of the private network in the vRack
        :param pulumi.Input[_builtins.int] vlan: VLAN of the private network in the vRack. 0 if the private network is not in a VLAN
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VrackNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage a vrack network for your IP Loadbalancing service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        iplb = ovh.IpLoadBalancing.get_ip_load_balancing(service_name="loadbalancer-xxxxxxxxxxxxxxxxxx")
        vip_lb = ovh.vrack.IpLoadbalancing("vip_lb",
            service_name="xxx",
            loadbalancing_id=iplb.service_name)
        network = ovh.iploadbalancing.VrackNetwork("network",
            service_name=vip_lb.loadbalancing_id,
            subnet="10.0.0.0/16",
            vlan=1,
            nat_ip="10.0.0.0/27",
            display_name="mynetwork")
        test_farm = ovh.iploadbalancing.TcpFarm("test_farm",
            service_name=network.service_name,
            display_name="mytcpbackends",
            port=80,
            vrack_network_id=network.vrack_network_id,
            zone=iplb.zones[0])
        ```

        :param str resource_name: The name of the resource.
        :param VrackNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VrackNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 farm_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 nat_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VrackNetworkArgs.__new__(VrackNetworkArgs)

            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["farm_ids"] = farm_ids
            if nat_ip is None and not opts.urn:
                raise TypeError("Missing required property 'nat_ip'")
            __props__.__dict__["nat_ip"] = nat_ip
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if subnet is None and not opts.urn:
                raise TypeError("Missing required property 'subnet'")
            __props__.__dict__["subnet"] = subnet
            __props__.__dict__["vlan"] = vlan
            __props__.__dict__["vrack_network_id"] = None
        super(VrackNetwork, __self__).__init__(
            'ovh:IpLoadBalancing/vrackNetwork:VrackNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            farm_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            nat_ip: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            subnet: Optional[pulumi.Input[_builtins.str]] = None,
            vlan: Optional[pulumi.Input[_builtins.int]] = None,
            vrack_network_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'VrackNetwork':
        """
        Get an existing VrackNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: Human readable name for your vrack network
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] farm_ids: This attribute is there for documentation purpose only and isnt passed to the OVHcloud API as it may conflicts with http/tcp farms `vrack_network_id` attribute
        :param pulumi.Input[_builtins.str] nat_ip: An IP block used as a pool of IPs by this Load Balancer to connect to the servers in this private network. The blck must be in the private network and reserved for the Load Balancer
        :param pulumi.Input[_builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[_builtins.str] subnet: IP block of the private network in the vRack
        :param pulumi.Input[_builtins.int] vlan: VLAN of the private network in the vRack. 0 if the private network is not in a VLAN
        :param pulumi.Input[_builtins.int] vrack_network_id: (Required) Internal Load Balancer identifier of the vRack private network
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VrackNetworkState.__new__(_VrackNetworkState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["farm_ids"] = farm_ids
        __props__.__dict__["nat_ip"] = nat_ip
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["vlan"] = vlan
        __props__.__dict__["vrack_network_id"] = vrack_network_id
        return VrackNetwork(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human readable name for your vrack network
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="farmIds")
    def farm_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        """
        This attribute is there for documentation purpose only and isnt passed to the OVHcloud API as it may conflicts with http/tcp farms `vrack_network_id` attribute
        """
        return pulumi.get(self, "farm_ids")

    @_builtins.property
    @pulumi.getter(name="natIp")
    def nat_ip(self) -> pulumi.Output[_builtins.str]:
        """
        An IP block used as a pool of IPs by this Load Balancer to connect to the servers in this private network. The blck must be in the private network and reserved for the Load Balancer
        """
        return pulumi.get(self, "nat_ip")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[_builtins.str]:
        """
        IP block of the private network in the vRack
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> pulumi.Output[_builtins.int]:
        """
        VLAN of the private network in the vRack. 0 if the private network is not in a VLAN
        """
        return pulumi.get(self, "vlan")

    @_builtins.property
    @pulumi.getter(name="vrackNetworkId")
    def vrack_network_id(self) -> pulumi.Output[_builtins.int]:
        """
        (Required) Internal Load Balancer identifier of the vRack private network
        """
        return pulumi.get(self, "vrack_network_id")

