# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['APIOAuth2ClientArgs', 'APIOAuth2Client']

@pulumi.input_type
class APIOAuth2ClientArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 flow: pulumi.Input[_builtins.str],
                 callback_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a APIOAuth2Client resource.
        :param pulumi.Input[_builtins.str] description: OAuth2 client description.
        :param pulumi.Input[_builtins.str] flow: The OAuth2 flow to use. `AUTHORIZATION_CODE` or `CLIENT_CREDENTIALS` are supported at the moment.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] callback_urls: List of callback urls when configuring the `AUTHORIZATION_CODE` flow.
        :param pulumi.Input[_builtins.str] name: OAuth2 client name.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "flow", flow)
        if callback_urls is not None:
            pulumi.set(__self__, "callback_urls", callback_urls)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        OAuth2 client description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def flow(self) -> pulumi.Input[_builtins.str]:
        """
        The OAuth2 flow to use. `AUTHORIZATION_CODE` or `CLIENT_CREDENTIALS` are supported at the moment.
        """
        return pulumi.get(self, "flow")

    @flow.setter
    def flow(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flow", value)

    @_builtins.property
    @pulumi.getter(name="callbackUrls")
    def callback_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of callback urls when configuring the `AUTHORIZATION_CODE` flow.
        """
        return pulumi.get(self, "callback_urls")

    @callback_urls.setter
    def callback_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "callback_urls", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OAuth2 client name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _APIOAuth2ClientState:
    def __init__(__self__, *,
                 callback_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 flow: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering APIOAuth2Client resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] callback_urls: List of callback urls when configuring the `AUTHORIZATION_CODE` flow.
        :param pulumi.Input[_builtins.str] client_id: Client ID of the created service account.
        :param pulumi.Input[_builtins.str] client_secret: Client secret of the created service account.
        :param pulumi.Input[_builtins.str] description: OAuth2 client description.
        :param pulumi.Input[_builtins.str] flow: The OAuth2 flow to use. `AUTHORIZATION_CODE` or `CLIENT_CREDENTIALS` are supported at the moment.
        :param pulumi.Input[_builtins.str] identity: Identity URN of the service account to be used inside an IAM policy.
        :param pulumi.Input[_builtins.str] name: OAuth2 client name.
        """
        if callback_urls is not None:
            pulumi.set(__self__, "callback_urls", callback_urls)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flow is not None:
            pulumi.set(__self__, "flow", flow)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="callbackUrls")
    def callback_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of callback urls when configuring the `AUTHORIZATION_CODE` flow.
        """
        return pulumi.get(self, "callback_urls")

    @callback_urls.setter
    def callback_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "callback_urls", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client ID of the created service account.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client secret of the created service account.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OAuth2 client description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def flow(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OAuth2 flow to use. `AUTHORIZATION_CODE` or `CLIENT_CREDENTIALS` are supported at the moment.
        """
        return pulumi.get(self, "flow")

    @flow.setter
    def flow(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flow", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identity URN of the service account to be used inside an IAM policy.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OAuth2 client name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("ovh:Me/aPIOAuth2Client:APIOAuth2Client")
class APIOAuth2Client(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 callback_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 flow: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates an OAuth2 service account.

        ## Example Usage

        An OAuth2 client for an app hosted at `my-app.com`, that uses the authorization code flow to authenticate.

        ```python
        import pulumi
        import pulumi_ovh as ovh

        my_oauth2_client_auth_code = ovh.me.APIOAuth2Client("my_oauth2_client_auth_code",
            name="OAuth2 authorization code service account",
            flow="AUTHORIZATION_CODE",
            description="An OAuth2 client using the authorization code flow for my-app.com",
            callback_urls=["https://my-app.com/callback"])
        ```

        An OAuth2 client for an app hosted at `my-app.com`, that uses the client credentials flow to authenticate.

        ```python
        import pulumi
        import pulumi_ovh as ovh

        my_oauth2_client_client_creds = ovh.me.APIOAuth2Client("my_oauth2_client_client_creds",
            name="client credentials service account",
            description="An OAuth2 client using the client credentials flow for my app",
            flow="CLIENT_CREDENTIALS")
        ```

        ## Import

        OAuth2 clients can be imported using their `client_id`:

        bash

        ```sh
        $ pulumi import ovh:Me/aPIOAuth2Client:APIOAuth2Client my_oauth2_client client_id
        ```

        Because the client_secret is only available for resources created using terraform, OAuth2 clients can also be imported using a `client_id` and a `client_secret` with a pipe separator:

        bash

        ```sh
        $ pulumi import ovh:Me/aPIOAuth2Client:APIOAuth2Client my_oauth2_client 'client_id|client_secret'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] callback_urls: List of callback urls when configuring the `AUTHORIZATION_CODE` flow.
        :param pulumi.Input[_builtins.str] description: OAuth2 client description.
        :param pulumi.Input[_builtins.str] flow: The OAuth2 flow to use. `AUTHORIZATION_CODE` or `CLIENT_CREDENTIALS` are supported at the moment.
        :param pulumi.Input[_builtins.str] name: OAuth2 client name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: APIOAuth2ClientArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an OAuth2 service account.

        ## Example Usage

        An OAuth2 client for an app hosted at `my-app.com`, that uses the authorization code flow to authenticate.

        ```python
        import pulumi
        import pulumi_ovh as ovh

        my_oauth2_client_auth_code = ovh.me.APIOAuth2Client("my_oauth2_client_auth_code",
            name="OAuth2 authorization code service account",
            flow="AUTHORIZATION_CODE",
            description="An OAuth2 client using the authorization code flow for my-app.com",
            callback_urls=["https://my-app.com/callback"])
        ```

        An OAuth2 client for an app hosted at `my-app.com`, that uses the client credentials flow to authenticate.

        ```python
        import pulumi
        import pulumi_ovh as ovh

        my_oauth2_client_client_creds = ovh.me.APIOAuth2Client("my_oauth2_client_client_creds",
            name="client credentials service account",
            description="An OAuth2 client using the client credentials flow for my app",
            flow="CLIENT_CREDENTIALS")
        ```

        ## Import

        OAuth2 clients can be imported using their `client_id`:

        bash

        ```sh
        $ pulumi import ovh:Me/aPIOAuth2Client:APIOAuth2Client my_oauth2_client client_id
        ```

        Because the client_secret is only available for resources created using terraform, OAuth2 clients can also be imported using a `client_id` and a `client_secret` with a pipe separator:

        bash

        ```sh
        $ pulumi import ovh:Me/aPIOAuth2Client:APIOAuth2Client my_oauth2_client 'client_id|client_secret'
        ```

        :param str resource_name: The name of the resource.
        :param APIOAuth2ClientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(APIOAuth2ClientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 callback_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 flow: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = APIOAuth2ClientArgs.__new__(APIOAuth2ClientArgs)

            __props__.__dict__["callback_urls"] = callback_urls
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if flow is None and not opts.urn:
                raise TypeError("Missing required property 'flow'")
            __props__.__dict__["flow"] = flow
            __props__.__dict__["name"] = name
            __props__.__dict__["client_id"] = None
            __props__.__dict__["client_secret"] = None
            __props__.__dict__["identity"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(APIOAuth2Client, __self__).__init__(
            'ovh:Me/aPIOAuth2Client:APIOAuth2Client',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            callback_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            client_secret: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            flow: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'APIOAuth2Client':
        """
        Get an existing APIOAuth2Client resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] callback_urls: List of callback urls when configuring the `AUTHORIZATION_CODE` flow.
        :param pulumi.Input[_builtins.str] client_id: Client ID of the created service account.
        :param pulumi.Input[_builtins.str] client_secret: Client secret of the created service account.
        :param pulumi.Input[_builtins.str] description: OAuth2 client description.
        :param pulumi.Input[_builtins.str] flow: The OAuth2 flow to use. `AUTHORIZATION_CODE` or `CLIENT_CREDENTIALS` are supported at the moment.
        :param pulumi.Input[_builtins.str] identity: Identity URN of the service account to be used inside an IAM policy.
        :param pulumi.Input[_builtins.str] name: OAuth2 client name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _APIOAuth2ClientState.__new__(_APIOAuth2ClientState)

        __props__.__dict__["callback_urls"] = callback_urls
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["description"] = description
        __props__.__dict__["flow"] = flow
        __props__.__dict__["identity"] = identity
        __props__.__dict__["name"] = name
        return APIOAuth2Client(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="callbackUrls")
    def callback_urls(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of callback urls when configuring the `AUTHORIZATION_CODE` flow.
        """
        return pulumi.get(self, "callback_urls")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        """
        Client ID of the created service account.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[_builtins.str]:
        """
        Client secret of the created service account.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        OAuth2 client description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def flow(self) -> pulumi.Output[_builtins.str]:
        """
        The OAuth2 flow to use. `AUTHORIZATION_CODE` or `CLIENT_CREDENTIALS` are supported at the moment.
        """
        return pulumi.get(self, "flow")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[_builtins.str]:
        """
        Identity URN of the service account to be used inside an IAM policy.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        OAuth2 client name.
        """
        return pulumi.get(self, "name")

