# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OkmsArgs', 'Okms']

@pulumi.input_type
class OkmsArgs:
    def __init__(__self__, *,
                 ovh_subsidiary: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 display_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Okms resource.
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVH subsidiaries
        :param pulumi.Input[_builtins.str] region: KMS region
        :param pulumi.Input[_builtins.str] display_name: (String) Resource display name
        """
        pulumi.set(__self__, "ovh_subsidiary", ovh_subsidiary)
        pulumi.set(__self__, "region", region)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> pulumi.Input[_builtins.str]:
        """
        OVH subsidiaries
        """
        return pulumi.get(self, "ovh_subsidiary")

    @ovh_subsidiary.setter
    def ovh_subsidiary(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ovh_subsidiary", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        KMS region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) Resource display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class _OkmsState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 iam: Optional[pulumi.Input['OkmsIamArgs']] = None,
                 kmip_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 swagger_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Okms resources.
        :param pulumi.Input[_builtins.str] display_name: (String) Resource display name
        :param pulumi.Input['OkmsIamArgs'] iam: (Attributes) IAM resource metadata (see below for nested schema)
        :param pulumi.Input[_builtins.str] kmip_endpoint: (String) KMS kmip API endpoint
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVH subsidiaries
        :param pulumi.Input[_builtins.str] public_ca: (String) KMS public CA (Certificate Authority)
        :param pulumi.Input[_builtins.str] region: KMS region
        :param pulumi.Input[_builtins.str] rest_endpoint: (String) KMS rest API endpoint
        :param pulumi.Input[_builtins.str] swagger_endpoint: (String) KMS rest API swagger UI
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if kmip_endpoint is not None:
            pulumi.set(__self__, "kmip_endpoint", kmip_endpoint)
        if ovh_subsidiary is not None:
            pulumi.set(__self__, "ovh_subsidiary", ovh_subsidiary)
        if public_ca is not None:
            pulumi.set(__self__, "public_ca", public_ca)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rest_endpoint is not None:
            pulumi.set(__self__, "rest_endpoint", rest_endpoint)
        if swagger_endpoint is not None:
            pulumi.set(__self__, "swagger_endpoint", swagger_endpoint)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) Resource display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def iam(self) -> Optional[pulumi.Input['OkmsIamArgs']]:
        """
        (Attributes) IAM resource metadata (see below for nested schema)
        """
        return pulumi.get(self, "iam")

    @iam.setter
    def iam(self, value: Optional[pulumi.Input['OkmsIamArgs']]):
        pulumi.set(self, "iam", value)

    @_builtins.property
    @pulumi.getter(name="kmipEndpoint")
    def kmip_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) KMS kmip API endpoint
        """
        return pulumi.get(self, "kmip_endpoint")

    @kmip_endpoint.setter
    def kmip_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kmip_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OVH subsidiaries
        """
        return pulumi.get(self, "ovh_subsidiary")

    @ovh_subsidiary.setter
    def ovh_subsidiary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ovh_subsidiary", value)

    @_builtins.property
    @pulumi.getter(name="publicCa")
    def public_ca(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) KMS public CA (Certificate Authority)
        """
        return pulumi.get(self, "public_ca")

    @public_ca.setter
    def public_ca(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ca", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        KMS region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) KMS rest API endpoint
        """
        return pulumi.get(self, "rest_endpoint")

    @rest_endpoint.setter
    def rest_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rest_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="swaggerEndpoint")
    def swagger_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) KMS rest API swagger UI
        """
        return pulumi.get(self, "swagger_endpoint")

    @swagger_endpoint.setter
    def swagger_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "swagger_endpoint", value)


@pulumi.type_token("ovh:Okms/okms:Okms")
class Okms(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        new_kms = ovh.okms.Okms("new_kms",
            ovh_subsidiary="FR",
            region="eu-west-rbx",
            display_name="terraformed KMS")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: (String) Resource display name
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVH subsidiaries
        :param pulumi.Input[_builtins.str] region: KMS region
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OkmsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        new_kms = ovh.okms.Okms("new_kms",
            ovh_subsidiary="FR",
            region="eu-west-rbx",
            display_name="terraformed KMS")
        ```

        :param str resource_name: The name of the resource.
        :param OkmsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OkmsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OkmsArgs.__new__(OkmsArgs)

            __props__.__dict__["display_name"] = display_name
            if ovh_subsidiary is None and not opts.urn:
                raise TypeError("Missing required property 'ovh_subsidiary'")
            __props__.__dict__["ovh_subsidiary"] = ovh_subsidiary
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["iam"] = None
            __props__.__dict__["kmip_endpoint"] = None
            __props__.__dict__["public_ca"] = None
            __props__.__dict__["rest_endpoint"] = None
            __props__.__dict__["swagger_endpoint"] = None
        super(Okms, __self__).__init__(
            'ovh:Okms/okms:Okms',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            iam: Optional[pulumi.Input[Union['OkmsIamArgs', 'OkmsIamArgsDict']]] = None,
            kmip_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
            public_ca: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            swagger_endpoint: Optional[pulumi.Input[_builtins.str]] = None) -> 'Okms':
        """
        Get an existing Okms resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: (String) Resource display name
        :param pulumi.Input[Union['OkmsIamArgs', 'OkmsIamArgsDict']] iam: (Attributes) IAM resource metadata (see below for nested schema)
        :param pulumi.Input[_builtins.str] kmip_endpoint: (String) KMS kmip API endpoint
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVH subsidiaries
        :param pulumi.Input[_builtins.str] public_ca: (String) KMS public CA (Certificate Authority)
        :param pulumi.Input[_builtins.str] region: KMS region
        :param pulumi.Input[_builtins.str] rest_endpoint: (String) KMS rest API endpoint
        :param pulumi.Input[_builtins.str] swagger_endpoint: (String) KMS rest API swagger UI
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OkmsState.__new__(_OkmsState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["iam"] = iam
        __props__.__dict__["kmip_endpoint"] = kmip_endpoint
        __props__.__dict__["ovh_subsidiary"] = ovh_subsidiary
        __props__.__dict__["public_ca"] = public_ca
        __props__.__dict__["region"] = region
        __props__.__dict__["rest_endpoint"] = rest_endpoint
        __props__.__dict__["swagger_endpoint"] = swagger_endpoint
        return Okms(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (String) Resource display name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def iam(self) -> pulumi.Output['outputs.OkmsIam']:
        """
        (Attributes) IAM resource metadata (see below for nested schema)
        """
        return pulumi.get(self, "iam")

    @_builtins.property
    @pulumi.getter(name="kmipEndpoint")
    def kmip_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        (String) KMS kmip API endpoint
        """
        return pulumi.get(self, "kmip_endpoint")

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> pulumi.Output[_builtins.str]:
        """
        OVH subsidiaries
        """
        return pulumi.get(self, "ovh_subsidiary")

    @_builtins.property
    @pulumi.getter(name="publicCa")
    def public_ca(self) -> pulumi.Output[_builtins.str]:
        """
        (String) KMS public CA (Certificate Authority)
        """
        return pulumi.get(self, "public_ca")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        KMS region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        (String) KMS rest API endpoint
        """
        return pulumi.get(self, "rest_endpoint")

    @_builtins.property
    @pulumi.getter(name="swaggerEndpoint")
    def swagger_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        (String) KMS rest API swagger UI
        """
        return pulumi.get(self, "swagger_endpoint")

