# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCartResult',
    'AwaitableGetCartResult',
    'get_cart',
    'get_cart_output',
]

@pulumi.output_type
class GetCartResult:
    """
    A collection of values returned by getCart.
    """
    def __init__(__self__, assign=None, cart_id=None, description=None, expire=None, id=None, items=None, ovh_subsidiary=None, read_only=None):
        if assign and not isinstance(assign, bool):
            raise TypeError("Expected argument 'assign' to be a bool")
        pulumi.set(__self__, "assign", assign)
        if cart_id and not isinstance(cart_id, str):
            raise TypeError("Expected argument 'cart_id' to be a str")
        pulumi.set(__self__, "cart_id", cart_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if expire and not isinstance(expire, str):
            raise TypeError("Expected argument 'expire' to be a str")
        pulumi.set(__self__, "expire", expire)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if ovh_subsidiary and not isinstance(ovh_subsidiary, str):
            raise TypeError("Expected argument 'ovh_subsidiary' to be a str")
        pulumi.set(__self__, "ovh_subsidiary", ovh_subsidiary)
        if read_only and not isinstance(read_only, bool):
            raise TypeError("Expected argument 'read_only' to be a bool")
        pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def assign(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "assign")

    @_builtins.property
    @pulumi.getter(name="cartId")
    def cart_id(self) -> _builtins.str:
        """
        Cart identifier
        """
        return pulumi.get(self, "cart_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def expire(self) -> _builtins.str:
        return pulumi.get(self, "expire")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence[_builtins.int]:
        """
        Items of your cart
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> _builtins.str:
        return pulumi.get(self, "ovh_subsidiary")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> _builtins.bool:
        """
        Indicates if the cart has already been validated
        """
        return pulumi.get(self, "read_only")


class AwaitableGetCartResult(GetCartResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCartResult(
            assign=self.assign,
            cart_id=self.cart_id,
            description=self.description,
            expire=self.expire,
            id=self.id,
            items=self.items,
            ovh_subsidiary=self.ovh_subsidiary,
            read_only=self.read_only)


def get_cart(assign: Optional[_builtins.bool] = None,
             description: Optional[_builtins.str] = None,
             expire: Optional[_builtins.str] = None,
             ovh_subsidiary: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCartResult:
    """
    Use this data source to create a temporary order cart to retrieve information order cart products.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_account = ovh.Me.get_me()
    my_cart = ovh.Order.get_cart(ovh_subsidiary=my_account.ovh_subsidiary)
    ```


    :param _builtins.bool assign: Assign a shopping cart to a logged in client. Values can be `true` or `false`.
    :param _builtins.str description: Description of your cart
    :param _builtins.str expire: Expiration time (format: 2006-01-02T15:04:05+00:00)
    :param _builtins.str ovh_subsidiary: OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json under `models.nichandle.OvhSubsidiaryEnum`](https://eu.api.ovh.com/1.0/me.json)
    """
    __args__ = dict()
    __args__['assign'] = assign
    __args__['description'] = description
    __args__['expire'] = expire
    __args__['ovhSubsidiary'] = ovh_subsidiary
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Order/getCart:getCart', __args__, opts=opts, typ=GetCartResult).value

    return AwaitableGetCartResult(
        assign=pulumi.get(__ret__, 'assign'),
        cart_id=pulumi.get(__ret__, 'cart_id'),
        description=pulumi.get(__ret__, 'description'),
        expire=pulumi.get(__ret__, 'expire'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        ovh_subsidiary=pulumi.get(__ret__, 'ovh_subsidiary'),
        read_only=pulumi.get(__ret__, 'read_only'))
def get_cart_output(assign: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                    description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    expire: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCartResult]:
    """
    Use this data source to create a temporary order cart to retrieve information order cart products.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_account = ovh.Me.get_me()
    my_cart = ovh.Order.get_cart(ovh_subsidiary=my_account.ovh_subsidiary)
    ```


    :param _builtins.bool assign: Assign a shopping cart to a logged in client. Values can be `true` or `false`.
    :param _builtins.str description: Description of your cart
    :param _builtins.str expire: Expiration time (format: 2006-01-02T15:04:05+00:00)
    :param _builtins.str ovh_subsidiary: OVHcloud Subsidiary. Country of OVHcloud legal entity you'll be billed by. List of supported subsidiaries available on API at [/1.0/me.json under `models.nichandle.OvhSubsidiaryEnum`](https://eu.api.ovh.com/1.0/me.json)
    """
    __args__ = dict()
    __args__['assign'] = assign
    __args__['description'] = description
    __args__['expire'] = expire
    __args__['ovhSubsidiary'] = ovh_subsidiary
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:Order/getCart:getCart', __args__, opts=opts, typ=GetCartResult)
    return __ret__.apply(lambda __response__: GetCartResult(
        assign=pulumi.get(__response__, 'assign'),
        cart_id=pulumi.get(__response__, 'cart_id'),
        description=pulumi.get(__response__, 'description'),
        expire=pulumi.get(__response__, 'expire'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        ovh_subsidiary=pulumi.get(__response__, 'ovh_subsidiary'),
        read_only=pulumi.get(__response__, 'read_only')))
