# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCartProductOptionsResult',
    'AwaitableGetCartProductOptionsResult',
    'get_cart_product_options',
    'get_cart_product_options_output',
]

@pulumi.output_type
class GetCartProductOptionsResult:
    """
    A collection of values returned by getCartProductOptions.
    """
    def __init__(__self__, cart_id=None, catalog_name=None, id=None, plan_code=None, product=None, results=None):
        if cart_id and not isinstance(cart_id, str):
            raise TypeError("Expected argument 'cart_id' to be a str")
        pulumi.set(__self__, "cart_id", cart_id)
        if catalog_name and not isinstance(catalog_name, str):
            raise TypeError("Expected argument 'catalog_name' to be a str")
        pulumi.set(__self__, "catalog_name", catalog_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if plan_code and not isinstance(plan_code, str):
            raise TypeError("Expected argument 'plan_code' to be a str")
        pulumi.set(__self__, "plan_code", plan_code)
        if product and not isinstance(product, str):
            raise TypeError("Expected argument 'product' to be a str")
        pulumi.set(__self__, "product", product)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)

    @_builtins.property
    @pulumi.getter(name="cartId")
    def cart_id(self) -> _builtins.str:
        return pulumi.get(self, "cart_id")

    @_builtins.property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "catalog_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> _builtins.str:
        """
        Product offer identifier
        """
        return pulumi.get(self, "plan_code")

    @_builtins.property
    @pulumi.getter
    def product(self) -> _builtins.str:
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetCartProductOptionsResultResult']:
        """
        products results
        """
        return pulumi.get(self, "results")


class AwaitableGetCartProductOptionsResult(GetCartProductOptionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCartProductOptionsResult(
            cart_id=self.cart_id,
            catalog_name=self.catalog_name,
            id=self.id,
            plan_code=self.plan_code,
            product=self.product,
            results=self.results)


def get_cart_product_options(cart_id: Optional[_builtins.str] = None,
                             catalog_name: Optional[_builtins.str] = None,
                             plan_code: Optional[_builtins.str] = None,
                             product: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCartProductOptionsResult:
    """
    Use this data source to retrieve information of order cart product options.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_account = ovh.Me.get_me()
    my_cart = ovh.Order.get_cart(ovh_subsidiary=my_account.ovh_subsidiary)
    options = ovh.Order.get_cart_product_options(cart_id=my_cart.id,
        product="cloud",
        plan_code="project")
    ```


    :param _builtins.str cart_id: Cart identifier
    :param _builtins.str catalog_name: Catalog name
    :param _builtins.str plan_code: Product offer identifier
    :param _builtins.str product: Product
    """
    __args__ = dict()
    __args__['cartId'] = cart_id
    __args__['catalogName'] = catalog_name
    __args__['planCode'] = plan_code
    __args__['product'] = product
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Order/getCartProductOptions:getCartProductOptions', __args__, opts=opts, typ=GetCartProductOptionsResult).value

    return AwaitableGetCartProductOptionsResult(
        cart_id=pulumi.get(__ret__, 'cart_id'),
        catalog_name=pulumi.get(__ret__, 'catalog_name'),
        id=pulumi.get(__ret__, 'id'),
        plan_code=pulumi.get(__ret__, 'plan_code'),
        product=pulumi.get(__ret__, 'product'),
        results=pulumi.get(__ret__, 'results'))
def get_cart_product_options_output(cart_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    catalog_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    plan_code: Optional[pulumi.Input[_builtins.str]] = None,
                                    product: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCartProductOptionsResult]:
    """
    Use this data source to retrieve information of order cart product options.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_account = ovh.Me.get_me()
    my_cart = ovh.Order.get_cart(ovh_subsidiary=my_account.ovh_subsidiary)
    options = ovh.Order.get_cart_product_options(cart_id=my_cart.id,
        product="cloud",
        plan_code="project")
    ```


    :param _builtins.str cart_id: Cart identifier
    :param _builtins.str catalog_name: Catalog name
    :param _builtins.str plan_code: Product offer identifier
    :param _builtins.str product: Product
    """
    __args__ = dict()
    __args__['cartId'] = cart_id
    __args__['catalogName'] = catalog_name
    __args__['planCode'] = plan_code
    __args__['product'] = product
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:Order/getCartProductOptions:getCartProductOptions', __args__, opts=opts, typ=GetCartProductOptionsResult)
    return __ret__.apply(lambda __response__: GetCartProductOptionsResult(
        cart_id=pulumi.get(__response__, 'cart_id'),
        catalog_name=pulumi.get(__response__, 'catalog_name'),
        id=pulumi.get(__response__, 'id'),
        plan_code=pulumi.get(__response__, 'plan_code'),
        product=pulumi.get(__response__, 'product'),
        results=pulumi.get(__response__, 'results')))
