# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OvhcloudConnectPopDatacenterExtraConfigArgs', 'OvhcloudConnectPopDatacenterExtraConfig']

@pulumi.input_type
class OvhcloudConnectPopDatacenterExtraConfigArgs:
    def __init__(__self__, *,
                 config_datacenter_id: pulumi.Input[_builtins.float],
                 config_pop_id: pulumi.Input[_builtins.float],
                 service_name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 bgp_neighbor_area: Optional[pulumi.Input[_builtins.float]] = None,
                 bgp_neighbor_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OvhcloudConnectPopDatacenterExtraConfig resource.
        :param pulumi.Input[_builtins.float] config_datacenter_id: ID of the datacenter configuration
        :param pulumi.Input[_builtins.float] config_pop_id: ID of the pop configuration
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.str] type: Type of the configuration
        :param pulumi.Input[_builtins.float] bgp_neighbor_area: BGP AS number
        :param pulumi.Input[_builtins.str] bgp_neighbor_ip: Router IP for BGP
        :param pulumi.Input[_builtins.str] next_hop: Static route next hop
        :param pulumi.Input[_builtins.str] subnet: Static route ip
        """
        pulumi.set(__self__, "config_datacenter_id", config_datacenter_id)
        pulumi.set(__self__, "config_pop_id", config_pop_id)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "type", type)
        if bgp_neighbor_area is not None:
            pulumi.set(__self__, "bgp_neighbor_area", bgp_neighbor_area)
        if bgp_neighbor_ip is not None:
            pulumi.set(__self__, "bgp_neighbor_ip", bgp_neighbor_ip)
        if next_hop is not None:
            pulumi.set(__self__, "next_hop", next_hop)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter(name="configDatacenterId")
    def config_datacenter_id(self) -> pulumi.Input[_builtins.float]:
        """
        ID of the datacenter configuration
        """
        return pulumi.get(self, "config_datacenter_id")

    @config_datacenter_id.setter
    def config_datacenter_id(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "config_datacenter_id", value)

    @_builtins.property
    @pulumi.getter(name="configPopId")
    def config_pop_id(self) -> pulumi.Input[_builtins.float]:
        """
        ID of the pop configuration
        """
        return pulumi.get(self, "config_pop_id")

    @config_pop_id.setter
    def config_pop_id(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "config_pop_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the configuration
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="bgpNeighborArea")
    def bgp_neighbor_area(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        BGP AS number
        """
        return pulumi.get(self, "bgp_neighbor_area")

    @bgp_neighbor_area.setter
    def bgp_neighbor_area(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "bgp_neighbor_area", value)

    @_builtins.property
    @pulumi.getter(name="bgpNeighborIp")
    def bgp_neighbor_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Router IP for BGP
        """
        return pulumi.get(self, "bgp_neighbor_ip")

    @bgp_neighbor_ip.setter
    def bgp_neighbor_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bgp_neighbor_ip", value)

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Static route next hop
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_hop", value)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Static route ip
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class _OvhcloudConnectPopDatacenterExtraConfigState:
    def __init__(__self__, *,
                 bgp_neighbor_area: Optional[pulumi.Input[_builtins.float]] = None,
                 bgp_neighbor_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 config_datacenter_id: Optional[pulumi.Input[_builtins.float]] = None,
                 config_pop_id: Optional[pulumi.Input[_builtins.float]] = None,
                 next_hop: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OvhcloudConnectPopDatacenterExtraConfig resources.
        :param pulumi.Input[_builtins.float] bgp_neighbor_area: BGP AS number
        :param pulumi.Input[_builtins.str] bgp_neighbor_ip: Router IP for BGP
        :param pulumi.Input[_builtins.float] config_datacenter_id: ID of the datacenter configuration
        :param pulumi.Input[_builtins.float] config_pop_id: ID of the pop configuration
        :param pulumi.Input[_builtins.str] next_hop: Static route next hop
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.str] status: Status of the pop configuration
        :param pulumi.Input[_builtins.str] subnet: Static route ip
        :param pulumi.Input[_builtins.str] type: Type of the configuration
        """
        if bgp_neighbor_area is not None:
            pulumi.set(__self__, "bgp_neighbor_area", bgp_neighbor_area)
        if bgp_neighbor_ip is not None:
            pulumi.set(__self__, "bgp_neighbor_ip", bgp_neighbor_ip)
        if config_datacenter_id is not None:
            pulumi.set(__self__, "config_datacenter_id", config_datacenter_id)
        if config_pop_id is not None:
            pulumi.set(__self__, "config_pop_id", config_pop_id)
        if next_hop is not None:
            pulumi.set(__self__, "next_hop", next_hop)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="bgpNeighborArea")
    def bgp_neighbor_area(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        BGP AS number
        """
        return pulumi.get(self, "bgp_neighbor_area")

    @bgp_neighbor_area.setter
    def bgp_neighbor_area(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "bgp_neighbor_area", value)

    @_builtins.property
    @pulumi.getter(name="bgpNeighborIp")
    def bgp_neighbor_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Router IP for BGP
        """
        return pulumi.get(self, "bgp_neighbor_ip")

    @bgp_neighbor_ip.setter
    def bgp_neighbor_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bgp_neighbor_ip", value)

    @_builtins.property
    @pulumi.getter(name="configDatacenterId")
    def config_datacenter_id(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        ID of the datacenter configuration
        """
        return pulumi.get(self, "config_datacenter_id")

    @config_datacenter_id.setter
    def config_datacenter_id(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "config_datacenter_id", value)

    @_builtins.property
    @pulumi.getter(name="configPopId")
    def config_pop_id(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        ID of the pop configuration
        """
        return pulumi.get(self, "config_pop_id")

    @config_pop_id.setter
    def config_pop_id(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "config_pop_id", value)

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Static route next hop
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_hop", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the pop configuration
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Static route ip
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the configuration
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("ovh:index/ovhcloudConnectPopDatacenterExtraConfig:OvhcloudConnectPopDatacenterExtraConfig")
class OvhcloudConnectPopDatacenterExtraConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_neighbor_area: Optional[pulumi.Input[_builtins.float]] = None,
                 bgp_neighbor_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 config_datacenter_id: Optional[pulumi.Input[_builtins.float]] = None,
                 config_pop_id: Optional[pulumi.Input[_builtins.float]] = None,
                 next_hop: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates an extra datacenter configuration for an Ovhcloud Connect product.

        Please take a look at the list of available `types` in the `Required` section in order to know the list of available type configurations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        pop_cfgs = ovh.get_ovhcloud_connect_config_pops(service_name="XXX")
        datacenter_cfgs = ovh.get_ovhcloud_connect_config_pop_datacenters(service_name=pop_cfgs.service_name,
            config_pop_id=pop_cfgs.pop_configs[0].id)
        extra = ovh.OvhcloudConnectPopDatacenterExtraConfig("extra",
            service_name=pop_cfgs.service_name,
            config_pop_id=pop_cfgs.pop_configs[0].id,
            config_datacenter_id=datacenter_cfgs.datacenter_configs[0].id,
            type="network",
            next_hop="P.P.P.P",
            subnet="I.I.I.I/M")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] bgp_neighbor_area: BGP AS number
        :param pulumi.Input[_builtins.str] bgp_neighbor_ip: Router IP for BGP
        :param pulumi.Input[_builtins.float] config_datacenter_id: ID of the datacenter configuration
        :param pulumi.Input[_builtins.float] config_pop_id: ID of the pop configuration
        :param pulumi.Input[_builtins.str] next_hop: Static route next hop
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.str] subnet: Static route ip
        :param pulumi.Input[_builtins.str] type: Type of the configuration
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OvhcloudConnectPopDatacenterExtraConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an extra datacenter configuration for an Ovhcloud Connect product.

        Please take a look at the list of available `types` in the `Required` section in order to know the list of available type configurations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        pop_cfgs = ovh.get_ovhcloud_connect_config_pops(service_name="XXX")
        datacenter_cfgs = ovh.get_ovhcloud_connect_config_pop_datacenters(service_name=pop_cfgs.service_name,
            config_pop_id=pop_cfgs.pop_configs[0].id)
        extra = ovh.OvhcloudConnectPopDatacenterExtraConfig("extra",
            service_name=pop_cfgs.service_name,
            config_pop_id=pop_cfgs.pop_configs[0].id,
            config_datacenter_id=datacenter_cfgs.datacenter_configs[0].id,
            type="network",
            next_hop="P.P.P.P",
            subnet="I.I.I.I/M")
        ```

        :param str resource_name: The name of the resource.
        :param OvhcloudConnectPopDatacenterExtraConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OvhcloudConnectPopDatacenterExtraConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_neighbor_area: Optional[pulumi.Input[_builtins.float]] = None,
                 bgp_neighbor_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 config_datacenter_id: Optional[pulumi.Input[_builtins.float]] = None,
                 config_pop_id: Optional[pulumi.Input[_builtins.float]] = None,
                 next_hop: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OvhcloudConnectPopDatacenterExtraConfigArgs.__new__(OvhcloudConnectPopDatacenterExtraConfigArgs)

            __props__.__dict__["bgp_neighbor_area"] = bgp_neighbor_area
            __props__.__dict__["bgp_neighbor_ip"] = bgp_neighbor_ip
            if config_datacenter_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_datacenter_id'")
            __props__.__dict__["config_datacenter_id"] = config_datacenter_id
            if config_pop_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_pop_id'")
            __props__.__dict__["config_pop_id"] = config_pop_id
            __props__.__dict__["next_hop"] = next_hop
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["subnet"] = subnet
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["status"] = None
        super(OvhcloudConnectPopDatacenterExtraConfig, __self__).__init__(
            'ovh:index/ovhcloudConnectPopDatacenterExtraConfig:OvhcloudConnectPopDatacenterExtraConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bgp_neighbor_area: Optional[pulumi.Input[_builtins.float]] = None,
            bgp_neighbor_ip: Optional[pulumi.Input[_builtins.str]] = None,
            config_datacenter_id: Optional[pulumi.Input[_builtins.float]] = None,
            config_pop_id: Optional[pulumi.Input[_builtins.float]] = None,
            next_hop: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'OvhcloudConnectPopDatacenterExtraConfig':
        """
        Get an existing OvhcloudConnectPopDatacenterExtraConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] bgp_neighbor_area: BGP AS number
        :param pulumi.Input[_builtins.str] bgp_neighbor_ip: Router IP for BGP
        :param pulumi.Input[_builtins.float] config_datacenter_id: ID of the datacenter configuration
        :param pulumi.Input[_builtins.float] config_pop_id: ID of the pop configuration
        :param pulumi.Input[_builtins.str] next_hop: Static route next hop
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.str] status: Status of the pop configuration
        :param pulumi.Input[_builtins.str] subnet: Static route ip
        :param pulumi.Input[_builtins.str] type: Type of the configuration
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OvhcloudConnectPopDatacenterExtraConfigState.__new__(_OvhcloudConnectPopDatacenterExtraConfigState)

        __props__.__dict__["bgp_neighbor_area"] = bgp_neighbor_area
        __props__.__dict__["bgp_neighbor_ip"] = bgp_neighbor_ip
        __props__.__dict__["config_datacenter_id"] = config_datacenter_id
        __props__.__dict__["config_pop_id"] = config_pop_id
        __props__.__dict__["next_hop"] = next_hop
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["type"] = type
        return OvhcloudConnectPopDatacenterExtraConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bgpNeighborArea")
    def bgp_neighbor_area(self) -> pulumi.Output[_builtins.float]:
        """
        BGP AS number
        """
        return pulumi.get(self, "bgp_neighbor_area")

    @_builtins.property
    @pulumi.getter(name="bgpNeighborIp")
    def bgp_neighbor_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Router IP for BGP
        """
        return pulumi.get(self, "bgp_neighbor_ip")

    @_builtins.property
    @pulumi.getter(name="configDatacenterId")
    def config_datacenter_id(self) -> pulumi.Output[_builtins.float]:
        """
        ID of the datacenter configuration
        """
        return pulumi.get(self, "config_datacenter_id")

    @_builtins.property
    @pulumi.getter(name="configPopId")
    def config_pop_id(self) -> pulumi.Output[_builtins.float]:
        """
        ID of the pop configuration
        """
        return pulumi.get(self, "config_pop_id")

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Output[_builtins.str]:
        """
        Static route next hop
        """
        return pulumi.get(self, "next_hop")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the pop configuration
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[_builtins.str]:
        """
        Static route ip
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the configuration
        """
        return pulumi.get(self, "type")

