# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 api_rate_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 application_key: Optional[pulumi.Input[_builtins.str]] = None,
                 application_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 consumer_key: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 user_agent_extra: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] access_token: The OVH API Access Token
        :param pulumi.Input[_builtins.int] api_rate_limit: Specify the API request rate limit, X operations by seconds (default: unlimited)
        :param pulumi.Input[_builtins.str] application_key: The OVH API Application Key
        :param pulumi.Input[_builtins.str] application_secret: The OVH API Application Secret
        :param pulumi.Input[_builtins.str] client_id: OAuth 2.0 application's ID
        :param pulumi.Input[_builtins.str] client_secret: OAuth 2.0 application's secret
        :param pulumi.Input[_builtins.str] consumer_key: The OVH API Consumer Key
        :param pulumi.Input[_builtins.str] endpoint: The OVH API endpoint to target (ex: "ovh-eu")
        :param pulumi.Input[_builtins.str] user_agent_extra: Extra information to append to the user-agent
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if api_rate_limit is not None:
            pulumi.set(__self__, "api_rate_limit", api_rate_limit)
        if application_key is not None:
            pulumi.set(__self__, "application_key", application_key)
        if application_secret is not None:
            pulumi.set(__self__, "application_secret", application_secret)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if consumer_key is not None:
            pulumi.set(__self__, "consumer_key", consumer_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if user_agent_extra is not None:
            pulumi.set(__self__, "user_agent_extra", user_agent_extra)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OVH API Access Token
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_token", value)

    @_builtins.property
    @pulumi.getter(name="apiRateLimit")
    def api_rate_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specify the API request rate limit, X operations by seconds (default: unlimited)
        """
        return pulumi.get(self, "api_rate_limit")

    @api_rate_limit.setter
    def api_rate_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "api_rate_limit", value)

    @_builtins.property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OVH API Application Key
        """
        return pulumi.get(self, "application_key")

    @application_key.setter
    def application_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_key", value)

    @_builtins.property
    @pulumi.getter(name="applicationSecret")
    def application_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OVH API Application Secret
        """
        return pulumi.get(self, "application_secret")

    @application_secret.setter
    def application_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_secret", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OAuth 2.0 application's ID
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OAuth 2.0 application's secret
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="consumerKey")
    def consumer_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OVH API Consumer Key
        """
        return pulumi.get(self, "consumer_key")

    @consumer_key.setter
    def consumer_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consumer_key", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OVH API endpoint to target (ex: "ovh-eu")
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="userAgentExtra")
    def user_agent_extra(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Extra information to append to the user-agent
        """
        return pulumi.get(self, "user_agent_extra")

    @user_agent_extra.setter
    def user_agent_extra(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_agent_extra", value)


@pulumi.type_token("pulumi:providers:ovh")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 api_rate_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 application_key: Optional[pulumi.Input[_builtins.str]] = None,
                 application_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 consumer_key: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 user_agent_extra: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the ovh package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_token: The OVH API Access Token
        :param pulumi.Input[_builtins.int] api_rate_limit: Specify the API request rate limit, X operations by seconds (default: unlimited)
        :param pulumi.Input[_builtins.str] application_key: The OVH API Application Key
        :param pulumi.Input[_builtins.str] application_secret: The OVH API Application Secret
        :param pulumi.Input[_builtins.str] client_id: OAuth 2.0 application's ID
        :param pulumi.Input[_builtins.str] client_secret: OAuth 2.0 application's secret
        :param pulumi.Input[_builtins.str] consumer_key: The OVH API Consumer Key
        :param pulumi.Input[_builtins.str] endpoint: The OVH API endpoint to target (ex: "ovh-eu")
        :param pulumi.Input[_builtins.str] user_agent_extra: Extra information to append to the user-agent
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the ovh package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 api_rate_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 application_key: Optional[pulumi.Input[_builtins.str]] = None,
                 application_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 consumer_key: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 user_agent_extra: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["access_token"] = access_token
            __props__.__dict__["api_rate_limit"] = pulumi.Output.from_input(api_rate_limit).apply(pulumi.runtime.to_json) if api_rate_limit is not None else None
            __props__.__dict__["application_key"] = application_key
            __props__.__dict__["application_secret"] = application_secret
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = client_secret
            __props__.__dict__["consumer_key"] = consumer_key
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["user_agent_extra"] = user_agent_extra
        super(Provider, __self__).__init__(
            'ovh',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The OVH API Access Token
        """
        return pulumi.get(self, "access_token")

    @_builtins.property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The OVH API Application Key
        """
        return pulumi.get(self, "application_key")

    @_builtins.property
    @pulumi.getter(name="applicationSecret")
    def application_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The OVH API Application Secret
        """
        return pulumi.get(self, "application_secret")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        OAuth 2.0 application's ID
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        OAuth 2.0 application's secret
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="consumerKey")
    def consumer_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The OVH API Consumer Key
        """
        return pulumi.get(self, "consumer_key")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The OVH API endpoint to target (ex: "ovh-eu")
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="userAgentExtra")
    def user_agent_extra(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Extra information to append to the user-agent
        """
        return pulumi.get(self, "user_agent_extra")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:ovh/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

