# UnitySVC Provider SDK Documentation

Welcome to the UnitySVC Provider SDK documentation. This package enables digital service providers to manage their service offerings through a local-first, version-controlled workflow.

## Quick Links

- **[Getting Started](getting-started.md)** - Installation and first steps
- **[Data Structure](data-structure.md)** - Understanding the file organization
- **[CLI Reference](cli-reference.md)** - Complete command-line interface guide
- **[Workflows](workflows.md)** - Common usage patterns and best practices
- **[API Reference](api-reference.md)** - Python API documentation

## What is UnitySVC Provider SDK?

The UnitySVC Provider SDK is a Python package that enables digital service providers to:

- **Define** service offerings and listings using schema-validated files
- **Manage** service data locally in version-controlled repositories
- **Validate** data against JSON schemas before publishing
- **Publish** services to the UnitySVC platform
- **Query** and verify published data

## Key Features

- 📋 **Pydantic Models** - Type-safe data models for all entities
- ✅ **Data Validation** - Comprehensive schema validation
- 🔄 **Local-First** - Work offline, commit to git, publish when ready
- 🚀 **CLI Tools** - Complete command-line interface
- 🤖 **Automation** - Script-based service generation
- 📝 **Multiple Formats** - Support for JSON and TOML

## Documentation Overview

### For New Users

1. [**Getting Started**](getting-started.md) - Install the SDK and create your first service
2. [**Data Structure**](data-structure.md) - Learn about the required file organization
3. [**Workflows**](workflows.md) - Understand manual and automated workflows

### For Reference

- [**CLI Reference**](cli-reference.md) - All available commands and options
- [**File Schemas**](file-schemas.md) - Detailed schema specifications
- [**API Reference**](api-reference.md) - Python API documentation

### For Contributors

- [**Development Guide**](development.md) - Set up development environment
- [**Contributing**](contributing.md) - How to contribute to the project

## Community & Support

- **GitHub**: [unitysvc/unitysvc-services](https://github.com/unitysvc/unitysvc-services)
- **Issues**: [Report bugs or request features](https://github.com/unitysvc/unitysvc-services/issues)
- **PyPI**: [unitysvc-services](https://pypi.org/project/unitysvc-services/)

## License

This project is licensed under the MIT License.
