# PaprWall 🎨

**Modern Desktop Wallpaper Manager with Motivational Quotes**
[![Version](https://img.shields.io/badge/version-1.0.3-blue.svg)](https://github.com/riturajprofile/paprwall/releases)
[![Python](https://img.shields.io/badge/python-3.8+-blue.svg)](https://www.python.org/downloads/)
[![License: CC BY-NC 4.0](https://img.shields.io/badge/License-CC--BY--NC%204.0-blue.svg)](https://creativecommons.org/licenses/by-nc/4.0/)
[![Platform](https://img.shields.io/badge/platform-Linux%20%7C%20Windows-lightgrey.svg)](https://github.com/riturajprofile/paprwall)


Beautiful wallpapers with inspirational quotes. Auto-rotation, 6 quote categories, and clean dark UI.

## ✨ Features

- 🎨 **Modern Dark UI** - Clean, full-screen interface with large preview
- 💭 **6 Quote Categories** - Motivational, Math, Science, Famous, Tech, Philosophy
- 🔄 **Auto-Rotation** - Customizable timer with countdown display
- 📜 **History Gallery** - Browse and reuse previous wallpapers
- �️ **Multi-Desktop** - Supports GNOME, KDE, XFCE, Cinnamon, MATE, LXQt
- 🌐 **Multiple Sources** - Random images from multiple APIs
- 📁 **Local Files** - Use your own images with quotes

## 🚀 Installation

### PyPI (Easiest)
```bash
pip install paprwall
paprwall-gui
```

### Linux / Windows Binaries
Download from [Releases](https://github.com/riturajprofile/paprwall/releases/latest):
- Linux: `.tar.gz`, `.deb`, `.rpm`, or AppImage
- Windows: `.zip` with executable

### Requirements
- Python 3.8+ (PyPI install only)
- Linux: `sudo apt install python3-tk` (Ubuntu/Debian)
- Windows: Included with Python

## � Usage

1. **Select Quote Category** - Choose from 6 types (Motivational, Math, Science, etc.)
2. **Fetch Wallpaper** - Click "Random" or "Refresh" button
3. **Preview** - View wallpaper with embedded quote
4. **Set Wallpaper** - Apply to desktop
5. **Auto-Rotate** - Enable timer for automatic changes
6. **History** - Browse and reuse previous wallpapers

### Data Locations
- **Linux**: `~/.local/share/paprwall/wallpapers/`
- **Windows**: `%APPDATA%\PaprWall\wallpapers\`



## 🔧 Troubleshooting

**GUI won't start?** Install Tkinter: `sudo apt install python3-tk` (Linux)  
**Wallpaper not changing?** Check supported desktop: GNOME, KDE, XFCE, MATE, Cinnamon, LXQt  
**Windows SmartScreen?** Click "More info" → "Run anyway"

See [INSTALLATION.md](INSTALLATION.md) for full troubleshooting guide.

## 🤝 Contributing

```bash
git clone https://github.com/riturajprofile/paprwall.git
cd paprwall
pip install -e ".[dev]"
```

## 💬 Support

- **Issues**: [GitHub Issues](https://github.com/riturajprofile/paprwall/issues)
- **Releases**: [Latest Version](https://github.com/riturajprofile/paprwall/releases/latest)


---

⭐ **Star this repo if you like it!** • Made with ❤️ by [riturajprofile](https://github.com/riturajprofile)
