# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrchestratorConfigArgs', 'OrchestratorConfig']

@pulumi.input_type
class OrchestratorConfigArgs:
    def __init__(__self__, *,
                 distribution: pulumi.Input['OrchestratorConfigDistributionArgs'],
                 orchestrator_id: pulumi.Input[_builtins.str],
                 binpacking: Optional[pulumi.Input['OrchestratorConfigBinpackingArgs']] = None,
                 commitment_integration: Optional[pulumi.Input['OrchestratorConfigCommitmentIntegrationArgs']] = None,
                 node_preferences: Optional[pulumi.Input['OrchestratorConfigNodePreferencesArgs']] = None,
                 replacement_schedule: Optional[pulumi.Input['OrchestratorConfigReplacementScheduleArgs']] = None):
        """
        The set of arguments for constructing a OrchestratorConfig resource.
        :param pulumi.Input['OrchestratorConfigDistributionArgs'] distribution: Spot and Ondemand Distribution Preferences for workload replicas
        :param pulumi.Input[_builtins.str] orchestrator_id: ID of the Cluster Orchestrator Object
        :param pulumi.Input['OrchestratorConfigBinpackingArgs'] binpacking: Binpacking preferences for Cluster Orchestrator
        :param pulumi.Input['OrchestratorConfigCommitmentIntegrationArgs'] commitment_integration: Commitment integration configuration for Cluster Orchestrator
        :param pulumi.Input['OrchestratorConfigNodePreferencesArgs'] node_preferences: Node preferences for Cluster Orchestrator
        :param pulumi.Input['OrchestratorConfigReplacementScheduleArgs'] replacement_schedule: Replacement schedule for Cluster Orchestrator
        """
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "orchestrator_id", orchestrator_id)
        if binpacking is not None:
            pulumi.set(__self__, "binpacking", binpacking)
        if commitment_integration is not None:
            pulumi.set(__self__, "commitment_integration", commitment_integration)
        if node_preferences is not None:
            pulumi.set(__self__, "node_preferences", node_preferences)
        if replacement_schedule is not None:
            pulumi.set(__self__, "replacement_schedule", replacement_schedule)

    @_builtins.property
    @pulumi.getter
    def distribution(self) -> pulumi.Input['OrchestratorConfigDistributionArgs']:
        """
        Spot and Ondemand Distribution Preferences for workload replicas
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: pulumi.Input['OrchestratorConfigDistributionArgs']):
        pulumi.set(self, "distribution", value)

    @_builtins.property
    @pulumi.getter(name="orchestratorId")
    def orchestrator_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the Cluster Orchestrator Object
        """
        return pulumi.get(self, "orchestrator_id")

    @orchestrator_id.setter
    def orchestrator_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "orchestrator_id", value)

    @_builtins.property
    @pulumi.getter
    def binpacking(self) -> Optional[pulumi.Input['OrchestratorConfigBinpackingArgs']]:
        """
        Binpacking preferences for Cluster Orchestrator
        """
        return pulumi.get(self, "binpacking")

    @binpacking.setter
    def binpacking(self, value: Optional[pulumi.Input['OrchestratorConfigBinpackingArgs']]):
        pulumi.set(self, "binpacking", value)

    @_builtins.property
    @pulumi.getter(name="commitmentIntegration")
    def commitment_integration(self) -> Optional[pulumi.Input['OrchestratorConfigCommitmentIntegrationArgs']]:
        """
        Commitment integration configuration for Cluster Orchestrator
        """
        return pulumi.get(self, "commitment_integration")

    @commitment_integration.setter
    def commitment_integration(self, value: Optional[pulumi.Input['OrchestratorConfigCommitmentIntegrationArgs']]):
        pulumi.set(self, "commitment_integration", value)

    @_builtins.property
    @pulumi.getter(name="nodePreferences")
    def node_preferences(self) -> Optional[pulumi.Input['OrchestratorConfigNodePreferencesArgs']]:
        """
        Node preferences for Cluster Orchestrator
        """
        return pulumi.get(self, "node_preferences")

    @node_preferences.setter
    def node_preferences(self, value: Optional[pulumi.Input['OrchestratorConfigNodePreferencesArgs']]):
        pulumi.set(self, "node_preferences", value)

    @_builtins.property
    @pulumi.getter(name="replacementSchedule")
    def replacement_schedule(self) -> Optional[pulumi.Input['OrchestratorConfigReplacementScheduleArgs']]:
        """
        Replacement schedule for Cluster Orchestrator
        """
        return pulumi.get(self, "replacement_schedule")

    @replacement_schedule.setter
    def replacement_schedule(self, value: Optional[pulumi.Input['OrchestratorConfigReplacementScheduleArgs']]):
        pulumi.set(self, "replacement_schedule", value)


@pulumi.input_type
class _OrchestratorConfigState:
    def __init__(__self__, *,
                 binpacking: Optional[pulumi.Input['OrchestratorConfigBinpackingArgs']] = None,
                 commitment_integration: Optional[pulumi.Input['OrchestratorConfigCommitmentIntegrationArgs']] = None,
                 distribution: Optional[pulumi.Input['OrchestratorConfigDistributionArgs']] = None,
                 node_preferences: Optional[pulumi.Input['OrchestratorConfigNodePreferencesArgs']] = None,
                 orchestrator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replacement_schedule: Optional[pulumi.Input['OrchestratorConfigReplacementScheduleArgs']] = None):
        """
        Input properties used for looking up and filtering OrchestratorConfig resources.
        :param pulumi.Input['OrchestratorConfigBinpackingArgs'] binpacking: Binpacking preferences for Cluster Orchestrator
        :param pulumi.Input['OrchestratorConfigCommitmentIntegrationArgs'] commitment_integration: Commitment integration configuration for Cluster Orchestrator
        :param pulumi.Input['OrchestratorConfigDistributionArgs'] distribution: Spot and Ondemand Distribution Preferences for workload replicas
        :param pulumi.Input['OrchestratorConfigNodePreferencesArgs'] node_preferences: Node preferences for Cluster Orchestrator
        :param pulumi.Input[_builtins.str] orchestrator_id: ID of the Cluster Orchestrator Object
        :param pulumi.Input['OrchestratorConfigReplacementScheduleArgs'] replacement_schedule: Replacement schedule for Cluster Orchestrator
        """
        if binpacking is not None:
            pulumi.set(__self__, "binpacking", binpacking)
        if commitment_integration is not None:
            pulumi.set(__self__, "commitment_integration", commitment_integration)
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if node_preferences is not None:
            pulumi.set(__self__, "node_preferences", node_preferences)
        if orchestrator_id is not None:
            pulumi.set(__self__, "orchestrator_id", orchestrator_id)
        if replacement_schedule is not None:
            pulumi.set(__self__, "replacement_schedule", replacement_schedule)

    @_builtins.property
    @pulumi.getter
    def binpacking(self) -> Optional[pulumi.Input['OrchestratorConfigBinpackingArgs']]:
        """
        Binpacking preferences for Cluster Orchestrator
        """
        return pulumi.get(self, "binpacking")

    @binpacking.setter
    def binpacking(self, value: Optional[pulumi.Input['OrchestratorConfigBinpackingArgs']]):
        pulumi.set(self, "binpacking", value)

    @_builtins.property
    @pulumi.getter(name="commitmentIntegration")
    def commitment_integration(self) -> Optional[pulumi.Input['OrchestratorConfigCommitmentIntegrationArgs']]:
        """
        Commitment integration configuration for Cluster Orchestrator
        """
        return pulumi.get(self, "commitment_integration")

    @commitment_integration.setter
    def commitment_integration(self, value: Optional[pulumi.Input['OrchestratorConfigCommitmentIntegrationArgs']]):
        pulumi.set(self, "commitment_integration", value)

    @_builtins.property
    @pulumi.getter
    def distribution(self) -> Optional[pulumi.Input['OrchestratorConfigDistributionArgs']]:
        """
        Spot and Ondemand Distribution Preferences for workload replicas
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: Optional[pulumi.Input['OrchestratorConfigDistributionArgs']]):
        pulumi.set(self, "distribution", value)

    @_builtins.property
    @pulumi.getter(name="nodePreferences")
    def node_preferences(self) -> Optional[pulumi.Input['OrchestratorConfigNodePreferencesArgs']]:
        """
        Node preferences for Cluster Orchestrator
        """
        return pulumi.get(self, "node_preferences")

    @node_preferences.setter
    def node_preferences(self, value: Optional[pulumi.Input['OrchestratorConfigNodePreferencesArgs']]):
        pulumi.set(self, "node_preferences", value)

    @_builtins.property
    @pulumi.getter(name="orchestratorId")
    def orchestrator_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Cluster Orchestrator Object
        """
        return pulumi.get(self, "orchestrator_id")

    @orchestrator_id.setter
    def orchestrator_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "orchestrator_id", value)

    @_builtins.property
    @pulumi.getter(name="replacementSchedule")
    def replacement_schedule(self) -> Optional[pulumi.Input['OrchestratorConfigReplacementScheduleArgs']]:
        """
        Replacement schedule for Cluster Orchestrator
        """
        return pulumi.get(self, "replacement_schedule")

    @replacement_schedule.setter
    def replacement_schedule(self, value: Optional[pulumi.Input['OrchestratorConfigReplacementScheduleArgs']]):
        pulumi.set(self, "replacement_schedule", value)


@pulumi.type_token("harness:cluster/orchestratorConfig:OrchestratorConfig")
class OrchestratorConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 binpacking: Optional[pulumi.Input[Union['OrchestratorConfigBinpackingArgs', 'OrchestratorConfigBinpackingArgsDict']]] = None,
                 commitment_integration: Optional[pulumi.Input[Union['OrchestratorConfigCommitmentIntegrationArgs', 'OrchestratorConfigCommitmentIntegrationArgsDict']]] = None,
                 distribution: Optional[pulumi.Input[Union['OrchestratorConfigDistributionArgs', 'OrchestratorConfigDistributionArgsDict']]] = None,
                 node_preferences: Optional[pulumi.Input[Union['OrchestratorConfigNodePreferencesArgs', 'OrchestratorConfigNodePreferencesArgsDict']]] = None,
                 orchestrator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replacement_schedule: Optional[pulumi.Input[Union['OrchestratorConfigReplacementScheduleArgs', 'OrchestratorConfigReplacementScheduleArgsDict']]] = None,
                 __props__=None):
        """
        Resource for ClusterOrchestrator Config.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.cluster.OrchestratorConfig("example",
            orchestrator_id="orch-cvifpfl9rbg8neldj97g",
            distribution={
                "base_ondemand_capacity": 2,
                "ondemand_replica_percentage": 50,
                "selector": "ALL",
                "strategy": "CostOptimized",
            },
            binpacking={
                "pod_eviction": {
                    "threshold": {
                        "cpu": 60,
                        "memory": 80,
                    },
                },
                "disruption": {
                    "criteria": "WhenEmpty",
                    "delay": "10m",
                    "budgets": [
                        {
                            "reasons": [
                                "Drifted",
                                "Underutilized",
                                "Empty",
                            ],
                            "nodes": "20",
                        },
                        {
                            "reasons": [
                                "Drifted",
                                "Empty",
                            ],
                            "nodes": "1",
                            "schedule": {
                                "frequency": "@monthly",
                                "duration": "10m",
                            },
                        },
                    ],
                },
            },
            node_preferences={
                "ttl": "Never",
                "reverse_fallback_interval": "6h",
            },
            commitment_integration={
                "enabled": True,
                "master_account_id": "dummyAccountId",
            },
            replacement_schedule={
                "window_type": "Custom",
                "applies_to": {
                    "consolidation": True,
                    "harness_pod_eviction": True,
                    "reverse_fallback": True,
                },
                "window_details": {
                    "days": [
                        "SUN",
                        "WED",
                        "SAT",
                    ],
                    "time_zone": "Asia/Calcutta",
                    "all_day": False,
                    "start_time": "10:30",
                    "end_time": "11:30",
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['OrchestratorConfigBinpackingArgs', 'OrchestratorConfigBinpackingArgsDict']] binpacking: Binpacking preferences for Cluster Orchestrator
        :param pulumi.Input[Union['OrchestratorConfigCommitmentIntegrationArgs', 'OrchestratorConfigCommitmentIntegrationArgsDict']] commitment_integration: Commitment integration configuration for Cluster Orchestrator
        :param pulumi.Input[Union['OrchestratorConfigDistributionArgs', 'OrchestratorConfigDistributionArgsDict']] distribution: Spot and Ondemand Distribution Preferences for workload replicas
        :param pulumi.Input[Union['OrchestratorConfigNodePreferencesArgs', 'OrchestratorConfigNodePreferencesArgsDict']] node_preferences: Node preferences for Cluster Orchestrator
        :param pulumi.Input[_builtins.str] orchestrator_id: ID of the Cluster Orchestrator Object
        :param pulumi.Input[Union['OrchestratorConfigReplacementScheduleArgs', 'OrchestratorConfigReplacementScheduleArgsDict']] replacement_schedule: Replacement schedule for Cluster Orchestrator
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrchestratorConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for ClusterOrchestrator Config.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.cluster.OrchestratorConfig("example",
            orchestrator_id="orch-cvifpfl9rbg8neldj97g",
            distribution={
                "base_ondemand_capacity": 2,
                "ondemand_replica_percentage": 50,
                "selector": "ALL",
                "strategy": "CostOptimized",
            },
            binpacking={
                "pod_eviction": {
                    "threshold": {
                        "cpu": 60,
                        "memory": 80,
                    },
                },
                "disruption": {
                    "criteria": "WhenEmpty",
                    "delay": "10m",
                    "budgets": [
                        {
                            "reasons": [
                                "Drifted",
                                "Underutilized",
                                "Empty",
                            ],
                            "nodes": "20",
                        },
                        {
                            "reasons": [
                                "Drifted",
                                "Empty",
                            ],
                            "nodes": "1",
                            "schedule": {
                                "frequency": "@monthly",
                                "duration": "10m",
                            },
                        },
                    ],
                },
            },
            node_preferences={
                "ttl": "Never",
                "reverse_fallback_interval": "6h",
            },
            commitment_integration={
                "enabled": True,
                "master_account_id": "dummyAccountId",
            },
            replacement_schedule={
                "window_type": "Custom",
                "applies_to": {
                    "consolidation": True,
                    "harness_pod_eviction": True,
                    "reverse_fallback": True,
                },
                "window_details": {
                    "days": [
                        "SUN",
                        "WED",
                        "SAT",
                    ],
                    "time_zone": "Asia/Calcutta",
                    "all_day": False,
                    "start_time": "10:30",
                    "end_time": "11:30",
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param OrchestratorConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrchestratorConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 binpacking: Optional[pulumi.Input[Union['OrchestratorConfigBinpackingArgs', 'OrchestratorConfigBinpackingArgsDict']]] = None,
                 commitment_integration: Optional[pulumi.Input[Union['OrchestratorConfigCommitmentIntegrationArgs', 'OrchestratorConfigCommitmentIntegrationArgsDict']]] = None,
                 distribution: Optional[pulumi.Input[Union['OrchestratorConfigDistributionArgs', 'OrchestratorConfigDistributionArgsDict']]] = None,
                 node_preferences: Optional[pulumi.Input[Union['OrchestratorConfigNodePreferencesArgs', 'OrchestratorConfigNodePreferencesArgsDict']]] = None,
                 orchestrator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replacement_schedule: Optional[pulumi.Input[Union['OrchestratorConfigReplacementScheduleArgs', 'OrchestratorConfigReplacementScheduleArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrchestratorConfigArgs.__new__(OrchestratorConfigArgs)

            __props__.__dict__["binpacking"] = binpacking
            __props__.__dict__["commitment_integration"] = commitment_integration
            if distribution is None and not opts.urn:
                raise TypeError("Missing required property 'distribution'")
            __props__.__dict__["distribution"] = distribution
            __props__.__dict__["node_preferences"] = node_preferences
            if orchestrator_id is None and not opts.urn:
                raise TypeError("Missing required property 'orchestrator_id'")
            __props__.__dict__["orchestrator_id"] = orchestrator_id
            __props__.__dict__["replacement_schedule"] = replacement_schedule
        super(OrchestratorConfig, __self__).__init__(
            'harness:cluster/orchestratorConfig:OrchestratorConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            binpacking: Optional[pulumi.Input[Union['OrchestratorConfigBinpackingArgs', 'OrchestratorConfigBinpackingArgsDict']]] = None,
            commitment_integration: Optional[pulumi.Input[Union['OrchestratorConfigCommitmentIntegrationArgs', 'OrchestratorConfigCommitmentIntegrationArgsDict']]] = None,
            distribution: Optional[pulumi.Input[Union['OrchestratorConfigDistributionArgs', 'OrchestratorConfigDistributionArgsDict']]] = None,
            node_preferences: Optional[pulumi.Input[Union['OrchestratorConfigNodePreferencesArgs', 'OrchestratorConfigNodePreferencesArgsDict']]] = None,
            orchestrator_id: Optional[pulumi.Input[_builtins.str]] = None,
            replacement_schedule: Optional[pulumi.Input[Union['OrchestratorConfigReplacementScheduleArgs', 'OrchestratorConfigReplacementScheduleArgsDict']]] = None) -> 'OrchestratorConfig':
        """
        Get an existing OrchestratorConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['OrchestratorConfigBinpackingArgs', 'OrchestratorConfigBinpackingArgsDict']] binpacking: Binpacking preferences for Cluster Orchestrator
        :param pulumi.Input[Union['OrchestratorConfigCommitmentIntegrationArgs', 'OrchestratorConfigCommitmentIntegrationArgsDict']] commitment_integration: Commitment integration configuration for Cluster Orchestrator
        :param pulumi.Input[Union['OrchestratorConfigDistributionArgs', 'OrchestratorConfigDistributionArgsDict']] distribution: Spot and Ondemand Distribution Preferences for workload replicas
        :param pulumi.Input[Union['OrchestratorConfigNodePreferencesArgs', 'OrchestratorConfigNodePreferencesArgsDict']] node_preferences: Node preferences for Cluster Orchestrator
        :param pulumi.Input[_builtins.str] orchestrator_id: ID of the Cluster Orchestrator Object
        :param pulumi.Input[Union['OrchestratorConfigReplacementScheduleArgs', 'OrchestratorConfigReplacementScheduleArgsDict']] replacement_schedule: Replacement schedule for Cluster Orchestrator
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrchestratorConfigState.__new__(_OrchestratorConfigState)

        __props__.__dict__["binpacking"] = binpacking
        __props__.__dict__["commitment_integration"] = commitment_integration
        __props__.__dict__["distribution"] = distribution
        __props__.__dict__["node_preferences"] = node_preferences
        __props__.__dict__["orchestrator_id"] = orchestrator_id
        __props__.__dict__["replacement_schedule"] = replacement_schedule
        return OrchestratorConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def binpacking(self) -> pulumi.Output[Optional['outputs.OrchestratorConfigBinpacking']]:
        """
        Binpacking preferences for Cluster Orchestrator
        """
        return pulumi.get(self, "binpacking")

    @_builtins.property
    @pulumi.getter(name="commitmentIntegration")
    def commitment_integration(self) -> pulumi.Output[Optional['outputs.OrchestratorConfigCommitmentIntegration']]:
        """
        Commitment integration configuration for Cluster Orchestrator
        """
        return pulumi.get(self, "commitment_integration")

    @_builtins.property
    @pulumi.getter
    def distribution(self) -> pulumi.Output['outputs.OrchestratorConfigDistribution']:
        """
        Spot and Ondemand Distribution Preferences for workload replicas
        """
        return pulumi.get(self, "distribution")

    @_builtins.property
    @pulumi.getter(name="nodePreferences")
    def node_preferences(self) -> pulumi.Output[Optional['outputs.OrchestratorConfigNodePreferences']]:
        """
        Node preferences for Cluster Orchestrator
        """
        return pulumi.get(self, "node_preferences")

    @_builtins.property
    @pulumi.getter(name="orchestratorId")
    def orchestrator_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Cluster Orchestrator Object
        """
        return pulumi.get(self, "orchestrator_id")

    @_builtins.property
    @pulumi.getter(name="replacementSchedule")
    def replacement_schedule(self) -> pulumi.Output[Optional['outputs.OrchestratorConfigReplacementSchedule']]:
        """
        Replacement schedule for Cluster Orchestrator
        """
        return pulumi.get(self, "replacement_schedule")

