# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentClustersMappingArgs', 'EnvironmentClustersMapping']

@pulumi.input_type
class EnvironmentClustersMappingArgs:
    def __init__(__self__, *,
                 env_id: pulumi.Input[_builtins.str],
                 identifier: pulumi.Input[_builtins.str],
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentClustersMappingClusterArgs']]]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EnvironmentClustersMapping resource.
        :param pulumi.Input[_builtins.str] env_id: environment identifier.
        :param pulumi.Input[_builtins.str] identifier: identifier for the cluster mapping(can be given any value).
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentClustersMappingClusterArgs']]] clusters: list of cluster identifiers and names
        :param pulumi.Input[_builtins.str] org_id: org_id of the environment.
        :param pulumi.Input[_builtins.str] project_id: project_id of the environment.
        """
        pulumi.set(__self__, "env_id", env_id)
        pulumi.set(__self__, "identifier", identifier)
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Input[_builtins.str]:
        """
        environment identifier.
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "env_id", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        identifier for the cluster mapping(can be given any value).
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentClustersMappingClusterArgs']]]]:
        """
        list of cluster identifiers and names
        """
        return pulumi.get(self, "clusters")

    @clusters.setter
    def clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentClustersMappingClusterArgs']]]]):
        pulumi.set(self, "clusters", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        org_id of the environment.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        project_id of the environment.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class _EnvironmentClustersMappingState:
    def __init__(__self__, *,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentClustersMappingClusterArgs']]]] = None,
                 env_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnvironmentClustersMapping resources.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentClustersMappingClusterArgs']]] clusters: list of cluster identifiers and names
        :param pulumi.Input[_builtins.str] env_id: environment identifier.
        :param pulumi.Input[_builtins.str] identifier: identifier for the cluster mapping(can be given any value).
        :param pulumi.Input[_builtins.str] org_id: org_id of the environment.
        :param pulumi.Input[_builtins.str] project_id: project_id of the environment.
        :param pulumi.Input[_builtins.str] scope: scope at which the environment exists in harness.
        """
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if env_id is not None:
            pulumi.set(__self__, "env_id", env_id)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentClustersMappingClusterArgs']]]]:
        """
        list of cluster identifiers and names
        """
        return pulumi.get(self, "clusters")

    @clusters.setter
    def clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentClustersMappingClusterArgs']]]]):
        pulumi.set(self, "clusters", value)

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        environment identifier.
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "env_id", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        identifier for the cluster mapping(can be given any value).
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        org_id of the environment.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        project_id of the environment.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        scope at which the environment exists in harness.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.type_token("harness:platform/environmentClustersMapping:EnvironmentClustersMapping")
class EnvironmentClustersMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentClustersMappingClusterArgs', 'EnvironmentClustersMappingClusterArgsDict']]]]] = None,
                 env_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for mapping environment with Harness Clusters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # mapping a cluster to a project level env
        example = harness.platform.EnvironmentClustersMapping("example",
            identifier="mycustomidentifier",
            org_id="orgIdentifer",
            project_id="projectIdentifier",
            env_id="exampleEnvId",
            clusters=[{
                "identifier": "incluster",
                "name": "in-cluster",
                "agent_identifier": "account.gitopsagentdev",
                "scope": "ACCOUNT",
            }])
        # mapping two clusters to account level env
        example2 = harness.platform.EnvironmentClustersMapping("example2",
            identifier="mycustomidentifier",
            env_id="env1",
            clusters=[
                {
                    "identifier": "clusterA",
                    "name": "cluster-A",
                    "agent_identifier": "account.gitopsagentprod",
                    "scope": "ACCOUNT",
                },
                {
                    "identifier": "clusterB",
                    "name": "cluster-B",
                    "agent_identifier": "account.gitopsagentprod",
                    "scope": "ACCOUNT",
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentClustersMappingClusterArgs', 'EnvironmentClustersMappingClusterArgsDict']]]] clusters: list of cluster identifiers and names
        :param pulumi.Input[_builtins.str] env_id: environment identifier.
        :param pulumi.Input[_builtins.str] identifier: identifier for the cluster mapping(can be given any value).
        :param pulumi.Input[_builtins.str] org_id: org_id of the environment.
        :param pulumi.Input[_builtins.str] project_id: project_id of the environment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentClustersMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for mapping environment with Harness Clusters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # mapping a cluster to a project level env
        example = harness.platform.EnvironmentClustersMapping("example",
            identifier="mycustomidentifier",
            org_id="orgIdentifer",
            project_id="projectIdentifier",
            env_id="exampleEnvId",
            clusters=[{
                "identifier": "incluster",
                "name": "in-cluster",
                "agent_identifier": "account.gitopsagentdev",
                "scope": "ACCOUNT",
            }])
        # mapping two clusters to account level env
        example2 = harness.platform.EnvironmentClustersMapping("example2",
            identifier="mycustomidentifier",
            env_id="env1",
            clusters=[
                {
                    "identifier": "clusterA",
                    "name": "cluster-A",
                    "agent_identifier": "account.gitopsagentprod",
                    "scope": "ACCOUNT",
                },
                {
                    "identifier": "clusterB",
                    "name": "cluster-B",
                    "agent_identifier": "account.gitopsagentprod",
                    "scope": "ACCOUNT",
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        :param str resource_name: The name of the resource.
        :param EnvironmentClustersMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentClustersMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentClustersMappingClusterArgs', 'EnvironmentClustersMappingClusterArgsDict']]]]] = None,
                 env_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentClustersMappingArgs.__new__(EnvironmentClustersMappingArgs)

            __props__.__dict__["clusters"] = clusters
            if env_id is None and not opts.urn:
                raise TypeError("Missing required property 'env_id'")
            __props__.__dict__["env_id"] = env_id
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["scope"] = None
        super(EnvironmentClustersMapping, __self__).__init__(
            'harness:platform/environmentClustersMapping:EnvironmentClustersMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            clusters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentClustersMappingClusterArgs', 'EnvironmentClustersMappingClusterArgsDict']]]]] = None,
            env_id: Optional[pulumi.Input[_builtins.str]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None) -> 'EnvironmentClustersMapping':
        """
        Get an existing EnvironmentClustersMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentClustersMappingClusterArgs', 'EnvironmentClustersMappingClusterArgsDict']]]] clusters: list of cluster identifiers and names
        :param pulumi.Input[_builtins.str] env_id: environment identifier.
        :param pulumi.Input[_builtins.str] identifier: identifier for the cluster mapping(can be given any value).
        :param pulumi.Input[_builtins.str] org_id: org_id of the environment.
        :param pulumi.Input[_builtins.str] project_id: project_id of the environment.
        :param pulumi.Input[_builtins.str] scope: scope at which the environment exists in harness.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentClustersMappingState.__new__(_EnvironmentClustersMappingState)

        __props__.__dict__["clusters"] = clusters
        __props__.__dict__["env_id"] = env_id
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["scope"] = scope
        return EnvironmentClustersMapping(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> pulumi.Output[Optional[Sequence['outputs.EnvironmentClustersMappingCluster']]]:
        """
        list of cluster identifiers and names
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Output[_builtins.str]:
        """
        environment identifier.
        """
        return pulumi.get(self, "env_id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        identifier for the cluster mapping(can be given any value).
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        org_id of the environment.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        project_id of the environment.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[_builtins.str]:
        """
        scope at which the environment exists in harness.
        """
        return pulumi.get(self, "scope")

