# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSloResult',
    'AwaitableGetSloResult',
    'get_slo',
    'get_slo_output',
]

@pulumi.output_type
class GetSloResult:
    """
    A collection of values returned by getSlo.
    """
    def __init__(__self__, id=None, identifier=None, org_id=None, project_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Identifier of the SLO.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> _builtins.str:
        """
        Identifier of the organization in which the SLO is configured.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Identifier of the project in which the SLO is configured.
        """
        return pulumi.get(self, "project_id")


class AwaitableGetSloResult(GetSloResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSloResult(
            id=self.id,
            identifier=self.identifier,
            org_id=self.org_id,
            project_id=self.project_id)


def get_slo(identifier: Optional[_builtins.str] = None,
            org_id: Optional[_builtins.str] = None,
            project_id: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSloResult:
    """
    Data source for retrieving an SLO.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_slo(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param _builtins.str identifier: Identifier of the SLO.
    :param _builtins.str org_id: Identifier of the organization in which the SLO is configured.
    :param _builtins.str project_id: Identifier of the project in which the SLO is configured.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getSlo:getSlo', __args__, opts=opts, typ=GetSloResult).value

    return AwaitableGetSloResult(
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_slo_output(identifier: Optional[pulumi.Input[_builtins.str]] = None,
                   org_id: Optional[pulumi.Input[_builtins.str]] = None,
                   project_id: Optional[pulumi.Input[_builtins.str]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSloResult]:
    """
    Data source for retrieving an SLO.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_slo(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param _builtins.str identifier: Identifier of the SLO.
    :param _builtins.str org_id: Identifier of the organization in which the SLO is configured.
    :param _builtins.str project_id: Identifier of the project in which the SLO is configured.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getSlo:getSlo', __args__, opts=opts, typ=GetSloResult)
    return __ret__.apply(lambda __response__: GetSloResult(
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id')))
