# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NotificationRuleArgs', 'NotificationRule']

@pulumi.input_type
class NotificationRuleArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[_builtins.str],
                 org_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 request: Optional[pulumi.Input['NotificationRuleRequestArgs']] = None):
        """
        The set of arguments for constructing a NotificationRule resource.
        :param pulumi.Input[_builtins.str] identifier: Identifier of the Notification Rule.
        :param pulumi.Input[_builtins.str] org_id: Identifier of the organization in which the Notification Rule is configured.
        :param pulumi.Input[_builtins.str] project_id: Identifier of the project in which the Notification Rule is configured.
        :param pulumi.Input['NotificationRuleRequestArgs'] request: Request for creating or updating Notification Rule.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "project_id", project_id)
        if request is not None:
            pulumi.set(__self__, "request", request)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the Notification Rule.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the organization in which the Notification Rule is configured.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the project in which the Notification Rule is configured.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input['NotificationRuleRequestArgs']]:
        """
        Request for creating or updating Notification Rule.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input['NotificationRuleRequestArgs']]):
        pulumi.set(self, "request", value)


@pulumi.input_type
class _NotificationRuleState:
    def __init__(__self__, *,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 request: Optional[pulumi.Input['NotificationRuleRequestArgs']] = None):
        """
        Input properties used for looking up and filtering NotificationRule resources.
        :param pulumi.Input[_builtins.str] identifier: Identifier of the Notification Rule.
        :param pulumi.Input[_builtins.str] org_id: Identifier of the organization in which the Notification Rule is configured.
        :param pulumi.Input[_builtins.str] project_id: Identifier of the project in which the Notification Rule is configured.
        :param pulumi.Input['NotificationRuleRequestArgs'] request: Request for creating or updating Notification Rule.
        """
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if request is not None:
            pulumi.set(__self__, "request", request)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the Notification Rule.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the organization in which the Notification Rule is configured.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the project in which the Notification Rule is configured.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input['NotificationRuleRequestArgs']]:
        """
        Request for creating or updating Notification Rule.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input['NotificationRuleRequestArgs']]):
        pulumi.set(self, "request", value)


@pulumi.type_token("harness:platform/notificationRule:NotificationRule")
class NotificationRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 request: Optional[pulumi.Input[Union['NotificationRuleRequestArgs', 'NotificationRuleRequestArgsDict']]] = None,
                 __props__=None):
        """
        Resource for creating a Notification Rule.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_harness as harness

        # Sample resource for SLO
        example = harness.platform.NotificationRule("example",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "notification_method": {
                    "type": "Slack",
                    "spec": json.dumps({
                        "webhook_url": "http://myslackwebhookurl.com",
                        "user_groups": ["account.test"],
                    }),
                },
                "type": "ServiceLevelObjective",
                "conditions": [
                    {
                        "type": "ErrorBudgetBurnRate",
                        "spec": json.dumps({
                            "threshold": 1,
                        }),
                    },
                    {
                        "type": "ErrorBudgetRemainingPercentage",
                        "spec": json.dumps({
                            "threshold": 30,
                        }),
                    },
                    {
                        "type": "ErrorBudgetRemainingMinutes",
                        "spec": json.dumps({
                            "threshold": 300,
                        }),
                    },
                ],
            })
        # Sample resource for Monitored Service
        example1 = harness.platform.NotificationRule("example1",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "notification_method": {
                    "type": "Slack",
                    "spec": json.dumps({
                        "webhook_url": "http://myslackwebhookurl.com",
                        "user_groups": ["account.test"],
                    }),
                },
                "type": "MonitoredService",
                "conditions": [
                    {
                        "type": "ChangeImpact",
                        "spec": json.dumps({
                            "threshold": 33,
                            "period": "30m",
                            "changeCategories": [
                                "Deployment",
                                "Infrastructure",
                            ],
                        }),
                    },
                    {
                        "type": "HealthScore",
                        "spec": json.dumps({
                            "threshold": 33,
                            "period": "30m",
                        }),
                    },
                    {
                        "type": "ChangeObserved",
                        "spec": json.dumps({
                            "changeCategories": [
                                "Deployment",
                                "Alert",
                                "ChaosExperiment",
                            ],
                        }),
                    },
                    {
                        "type": "DeploymentImpactReport",
                        "spec": json.dumps({}),
                    },
                ],
            })
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level Notification Rule

        ```sh
        $ pulumi import harness:platform/notificationRule:NotificationRule example <notification_rule_id>
        ```

        Import organization level Notification Rule

        ```sh
        $ pulumi import harness:platform/notificationRule:NotificationRule example <org_id>/<notification_rule_id>
        ```

        Import project level Notification Rule

        ```sh
        $ pulumi import harness:platform/notificationRule:NotificationRule example <org_id>/<project_id>/<notification_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] identifier: Identifier of the Notification Rule.
        :param pulumi.Input[_builtins.str] org_id: Identifier of the organization in which the Notification Rule is configured.
        :param pulumi.Input[_builtins.str] project_id: Identifier of the project in which the Notification Rule is configured.
        :param pulumi.Input[Union['NotificationRuleRequestArgs', 'NotificationRuleRequestArgsDict']] request: Request for creating or updating Notification Rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotificationRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Notification Rule.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_harness as harness

        # Sample resource for SLO
        example = harness.platform.NotificationRule("example",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "notification_method": {
                    "type": "Slack",
                    "spec": json.dumps({
                        "webhook_url": "http://myslackwebhookurl.com",
                        "user_groups": ["account.test"],
                    }),
                },
                "type": "ServiceLevelObjective",
                "conditions": [
                    {
                        "type": "ErrorBudgetBurnRate",
                        "spec": json.dumps({
                            "threshold": 1,
                        }),
                    },
                    {
                        "type": "ErrorBudgetRemainingPercentage",
                        "spec": json.dumps({
                            "threshold": 30,
                        }),
                    },
                    {
                        "type": "ErrorBudgetRemainingMinutes",
                        "spec": json.dumps({
                            "threshold": 300,
                        }),
                    },
                ],
            })
        # Sample resource for Monitored Service
        example1 = harness.platform.NotificationRule("example1",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "notification_method": {
                    "type": "Slack",
                    "spec": json.dumps({
                        "webhook_url": "http://myslackwebhookurl.com",
                        "user_groups": ["account.test"],
                    }),
                },
                "type": "MonitoredService",
                "conditions": [
                    {
                        "type": "ChangeImpact",
                        "spec": json.dumps({
                            "threshold": 33,
                            "period": "30m",
                            "changeCategories": [
                                "Deployment",
                                "Infrastructure",
                            ],
                        }),
                    },
                    {
                        "type": "HealthScore",
                        "spec": json.dumps({
                            "threshold": 33,
                            "period": "30m",
                        }),
                    },
                    {
                        "type": "ChangeObserved",
                        "spec": json.dumps({
                            "changeCategories": [
                                "Deployment",
                                "Alert",
                                "ChaosExperiment",
                            ],
                        }),
                    },
                    {
                        "type": "DeploymentImpactReport",
                        "spec": json.dumps({}),
                    },
                ],
            })
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level Notification Rule

        ```sh
        $ pulumi import harness:platform/notificationRule:NotificationRule example <notification_rule_id>
        ```

        Import organization level Notification Rule

        ```sh
        $ pulumi import harness:platform/notificationRule:NotificationRule example <org_id>/<notification_rule_id>
        ```

        Import project level Notification Rule

        ```sh
        $ pulumi import harness:platform/notificationRule:NotificationRule example <org_id>/<project_id>/<notification_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param NotificationRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotificationRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 request: Optional[pulumi.Input[Union['NotificationRuleRequestArgs', 'NotificationRuleRequestArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotificationRuleArgs.__new__(NotificationRuleArgs)

            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["request"] = request
        super(NotificationRule, __self__).__init__(
            'harness:platform/notificationRule:NotificationRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            request: Optional[pulumi.Input[Union['NotificationRuleRequestArgs', 'NotificationRuleRequestArgsDict']]] = None) -> 'NotificationRule':
        """
        Get an existing NotificationRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] identifier: Identifier of the Notification Rule.
        :param pulumi.Input[_builtins.str] org_id: Identifier of the organization in which the Notification Rule is configured.
        :param pulumi.Input[_builtins.str] project_id: Identifier of the project in which the Notification Rule is configured.
        :param pulumi.Input[Union['NotificationRuleRequestArgs', 'NotificationRuleRequestArgsDict']] request: Request for creating or updating Notification Rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotificationRuleState.__new__(_NotificationRuleState)

        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["request"] = request
        return NotificationRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the Notification Rule.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the organization in which the Notification Rule is configured.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the project in which the Notification Rule is configured.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def request(self) -> pulumi.Output[Optional['outputs.NotificationRuleRequest']]:
        """
        Request for creating or updating Notification Rule.
        """
        return pulumi.get(self, "request")

