# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDiscoverySettingResult',
    'AwaitableGetDiscoverySettingResult',
    'get_discovery_setting',
    'get_discovery_setting_output',
]

@pulumi.output_type
class GetDiscoverySettingResult:
    """
    A collection of values returned by getDiscoverySetting.
    """
    def __init__(__self__, correlation_id=None, created_at=None, id=None, image_registries=None, org_identifier=None, project_identifier=None, updated_at=None):
        if correlation_id and not isinstance(correlation_id, str):
            raise TypeError("Expected argument 'correlation_id' to be a str")
        pulumi.set(__self__, "correlation_id", correlation_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_registries and not isinstance(image_registries, list):
            raise TypeError("Expected argument 'image_registries' to be a list")
        pulumi.set(__self__, "image_registries", image_registries)
        if org_identifier and not isinstance(org_identifier, str):
            raise TypeError("Expected argument 'org_identifier' to be a str")
        pulumi.set(__self__, "org_identifier", org_identifier)
        if project_identifier and not isinstance(project_identifier, str):
            raise TypeError("Expected argument 'project_identifier' to be a str")
        pulumi.set(__self__, "project_identifier", project_identifier)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> Optional[_builtins.str]:
        """
        Correlation ID for the request.
        """
        return pulumi.get(self, "correlation_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Timestamp when the setting was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageRegistries")
    def image_registries(self) -> Sequence['outputs.GetDiscoverySettingImageRegistryResult']:
        """
        Image registry configuration.
        """
        return pulumi.get(self, "image_registries")

    @_builtins.property
    @pulumi.getter(name="orgIdentifier")
    def org_identifier(self) -> Optional[_builtins.str]:
        """
        The organization identifier.
        """
        return pulumi.get(self, "org_identifier")

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> Optional[_builtins.str]:
        """
        The project identifier.
        """
        return pulumi.get(self, "project_identifier")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Timestamp when the setting was last updated.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetDiscoverySettingResult(GetDiscoverySettingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiscoverySettingResult(
            correlation_id=self.correlation_id,
            created_at=self.created_at,
            id=self.id,
            image_registries=self.image_registries,
            org_identifier=self.org_identifier,
            project_identifier=self.project_identifier,
            updated_at=self.updated_at)


def get_discovery_setting(correlation_id: Optional[_builtins.str] = None,
                          org_identifier: Optional[_builtins.str] = None,
                          project_identifier: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiscoverySettingResult:
    """
    Data source for retrieving service discovery settings.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    # Data source to fetch service discovery setting by name
    example = harness.service.get_discovery_setting(org_identifier="<org_identifier>",
        project_identifier="<project_identifier>")
    ```


    :param _builtins.str correlation_id: Correlation ID for the request.
    :param _builtins.str org_identifier: The organization identifier.
    :param _builtins.str project_identifier: The project identifier.
    """
    __args__ = dict()
    __args__['correlationId'] = correlation_id
    __args__['orgIdentifier'] = org_identifier
    __args__['projectIdentifier'] = project_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:service/getDiscoverySetting:getDiscoverySetting', __args__, opts=opts, typ=GetDiscoverySettingResult).value

    return AwaitableGetDiscoverySettingResult(
        correlation_id=pulumi.get(__ret__, 'correlation_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        image_registries=pulumi.get(__ret__, 'image_registries'),
        org_identifier=pulumi.get(__ret__, 'org_identifier'),
        project_identifier=pulumi.get(__ret__, 'project_identifier'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_discovery_setting_output(correlation_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 org_identifier: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 project_identifier: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDiscoverySettingResult]:
    """
    Data source for retrieving service discovery settings.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    # Data source to fetch service discovery setting by name
    example = harness.service.get_discovery_setting(org_identifier="<org_identifier>",
        project_identifier="<project_identifier>")
    ```


    :param _builtins.str correlation_id: Correlation ID for the request.
    :param _builtins.str org_identifier: The organization identifier.
    :param _builtins.str project_identifier: The project identifier.
    """
    __args__ = dict()
    __args__['correlationId'] = correlation_id
    __args__['orgIdentifier'] = org_identifier
    __args__['projectIdentifier'] = project_identifier
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:service/getDiscoverySetting:getDiscoverySetting', __args__, opts=opts, typ=GetDiscoverySettingResult)
    return __ret__.apply(lambda __response__: GetDiscoverySettingResult(
        correlation_id=pulumi.get(__response__, 'correlation_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        image_registries=pulumi.get(__response__, 'image_registries'),
        org_identifier=pulumi.get(__response__, 'org_identifier'),
        project_identifier=pulumi.get(__response__, 'project_identifier'),
        updated_at=pulumi.get(__response__, 'updated_at')))
