# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AmiVariable',
    'CodedeployVariable',
    'DiscoveryAgentConfig',
    'DiscoveryAgentConfigData',
    'DiscoveryAgentConfigDataCron',
    'DiscoveryAgentConfigKubernete',
    'DiscoveryAgentConfigKuberneteResource',
    'DiscoveryAgentConfigKuberneteResourceLimit',
    'DiscoveryAgentConfigKuberneteResourceRequest',
    'DiscoveryAgentConfigKuberneteToleration',
    'DiscoveryAgentConfigMtl',
    'DiscoveryAgentConfigProxy',
    'DiscoveryAgentInstallationDetail',
    'DiscoveryAgentInstallationDetailAgentDetail',
    'DiscoveryAgentInstallationDetailAgentDetailCluster',
    'DiscoverySettingImageRegistry',
    'EcsVariable',
    'HelmVariable',
    'KubernetesVariable',
    'LambdaVariable',
    'SshVariable',
    'TanzuVariable',
    'WinrmVariable',
    'GetDiscoveryAgentConfigResult',
    'GetDiscoveryAgentConfigDataResult',
    'GetDiscoveryAgentConfigDataCronResult',
    'GetDiscoveryAgentConfigKuberneteResult',
    'GetDiscoveryAgentConfigKuberneteResourceResult',
    'GetDiscoveryAgentConfigKuberneteResourceLimitResult',
    'GetDiscoveryAgentConfigKuberneteResourceRequestResult',
    'GetDiscoveryAgentConfigKuberneteTolerationResult',
    'GetDiscoveryAgentConfigMtlResult',
    'GetDiscoveryAgentConfigProxyResult',
    'GetDiscoveryAgentInstallationDetailResult',
    'GetDiscoveryAgentInstallationDetailAgentDetailResult',
    'GetDiscoveryAgentInstallationDetailAgentDetailClusterResult',
    'GetDiscoveryAgentInstallationDetailAgentDetailNodeResult',
    'GetDiscoverySettingImageRegistryResult',
]

@pulumi.output_type
class AmiVariable(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the variable
        :param _builtins.str type: Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        :param _builtins.str value: Value of the variable
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the variable
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the variable
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CodedeployVariable(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the variable
        :param _builtins.str type: Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        :param _builtins.str value: Value of the variable
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the variable
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the variable
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DiscoveryAgentConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectorImage":
            suggest = "collector_image"
        elif key == "imagePullSecrets":
            suggest = "image_pull_secrets"
        elif key == "logWatcherImage":
            suggest = "log_watcher_image"
        elif key == "skipSecureVerify":
            suggest = "skip_secure_verify"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryAgentConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryAgentConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryAgentConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kubernetes: Sequence['outputs.DiscoveryAgentConfigKubernete'],
                 collector_image: Optional[_builtins.str] = None,
                 datas: Optional[Sequence['outputs.DiscoveryAgentConfigData']] = None,
                 image_pull_secrets: Optional[Sequence[_builtins.str]] = None,
                 log_watcher_image: Optional[_builtins.str] = None,
                 mtls: Optional[Sequence['outputs.DiscoveryAgentConfigMtl']] = None,
                 proxies: Optional[Sequence['outputs.DiscoveryAgentConfigProxy']] = None,
                 skip_secure_verify: Optional[_builtins.bool] = None):
        """
        :param Sequence['DiscoveryAgentConfigKuberneteArgs'] kubernetes: Kubernetes-specific configuration.
        :param _builtins.str collector_image: Docker image for the collector.
        :param Sequence['DiscoveryAgentConfigDataArgs'] datas: Data collection configuration.
        :param Sequence[_builtins.str] image_pull_secrets: List of image pull secrets.
        :param _builtins.str log_watcher_image: Docker image for the log watcher.
        :param Sequence['DiscoveryAgentConfigMtlArgs'] mtls: mTLS configuration.
        :param Sequence['DiscoveryAgentConfigProxyArgs'] proxies: Proxy configuration.
        :param _builtins.bool skip_secure_verify: Whether to skip TLS verification.
        """
        pulumi.set(__self__, "kubernetes", kubernetes)
        if collector_image is not None:
            pulumi.set(__self__, "collector_image", collector_image)
        if datas is not None:
            pulumi.set(__self__, "datas", datas)
        if image_pull_secrets is not None:
            pulumi.set(__self__, "image_pull_secrets", image_pull_secrets)
        if log_watcher_image is not None:
            pulumi.set(__self__, "log_watcher_image", log_watcher_image)
        if mtls is not None:
            pulumi.set(__self__, "mtls", mtls)
        if proxies is not None:
            pulumi.set(__self__, "proxies", proxies)
        if skip_secure_verify is not None:
            pulumi.set(__self__, "skip_secure_verify", skip_secure_verify)

    @_builtins.property
    @pulumi.getter
    def kubernetes(self) -> Sequence['outputs.DiscoveryAgentConfigKubernete']:
        """
        Kubernetes-specific configuration.
        """
        return pulumi.get(self, "kubernetes")

    @_builtins.property
    @pulumi.getter(name="collectorImage")
    def collector_image(self) -> Optional[_builtins.str]:
        """
        Docker image for the collector.
        """
        return pulumi.get(self, "collector_image")

    @_builtins.property
    @pulumi.getter
    def datas(self) -> Optional[Sequence['outputs.DiscoveryAgentConfigData']]:
        """
        Data collection configuration.
        """
        return pulumi.get(self, "datas")

    @_builtins.property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of image pull secrets.
        """
        return pulumi.get(self, "image_pull_secrets")

    @_builtins.property
    @pulumi.getter(name="logWatcherImage")
    def log_watcher_image(self) -> Optional[_builtins.str]:
        """
        Docker image for the log watcher.
        """
        return pulumi.get(self, "log_watcher_image")

    @_builtins.property
    @pulumi.getter
    def mtls(self) -> Optional[Sequence['outputs.DiscoveryAgentConfigMtl']]:
        """
        mTLS configuration.
        """
        return pulumi.get(self, "mtls")

    @_builtins.property
    @pulumi.getter
    def proxies(self) -> Optional[Sequence['outputs.DiscoveryAgentConfigProxy']]:
        """
        Proxy configuration.
        """
        return pulumi.get(self, "proxies")

    @_builtins.property
    @pulumi.getter(name="skipSecureVerify")
    def skip_secure_verify(self) -> Optional[_builtins.bool]:
        """
        Whether to skip TLS verification.
        """
        return pulumi.get(self, "skip_secure_verify")


@pulumi.output_type
class DiscoveryAgentConfigData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blacklistedNamespaces":
            suggest = "blacklisted_namespaces"
        elif key == "collectionWindowInMin":
            suggest = "collection_window_in_min"
        elif key == "enableBatchResources":
            suggest = "enable_batch_resources"
        elif key == "enableNodeAgent":
            suggest = "enable_node_agent"
        elif key == "enableOrphanedPod":
            suggest = "enable_orphaned_pod"
        elif key == "namespaceSelector":
            suggest = "namespace_selector"
        elif key == "nodeAgentSelector":
            suggest = "node_agent_selector"
        elif key == "observedNamespaces":
            suggest = "observed_namespaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryAgentConfigData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryAgentConfigData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryAgentConfigData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blacklisted_namespaces: Optional[Sequence[_builtins.str]] = None,
                 collection_window_in_min: Optional[_builtins.int] = None,
                 crons: Optional[Sequence['outputs.DiscoveryAgentConfigDataCron']] = None,
                 enable_batch_resources: Optional[_builtins.bool] = None,
                 enable_node_agent: Optional[_builtins.bool] = None,
                 enable_orphaned_pod: Optional[_builtins.bool] = None,
                 namespace_selector: Optional[_builtins.str] = None,
                 node_agent_selector: Optional[_builtins.str] = None,
                 observed_namespaces: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] blacklisted_namespaces: List of namespaces to exclude from discovery.
        :param _builtins.int collection_window_in_min: Collection window in minutes.
        :param Sequence['DiscoveryAgentConfigDataCronArgs'] crons: Cron schedule for data collection.
        :param _builtins.bool enable_batch_resources: Whether to enable batch resources.
        :param _builtins.bool enable_node_agent: Whether to enable node agent.
        :param _builtins.bool enable_orphaned_pod: Whether to enable orphaned pod detection.
        :param _builtins.str namespace_selector: Namespace selector for the agent.
        :param _builtins.str node_agent_selector: Node selector for the node agent.
        :param Sequence[_builtins.str] observed_namespaces: List of namespaces to observe.
        """
        if blacklisted_namespaces is not None:
            pulumi.set(__self__, "blacklisted_namespaces", blacklisted_namespaces)
        if collection_window_in_min is not None:
            pulumi.set(__self__, "collection_window_in_min", collection_window_in_min)
        if crons is not None:
            pulumi.set(__self__, "crons", crons)
        if enable_batch_resources is not None:
            pulumi.set(__self__, "enable_batch_resources", enable_batch_resources)
        if enable_node_agent is not None:
            pulumi.set(__self__, "enable_node_agent", enable_node_agent)
        if enable_orphaned_pod is not None:
            pulumi.set(__self__, "enable_orphaned_pod", enable_orphaned_pod)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if node_agent_selector is not None:
            pulumi.set(__self__, "node_agent_selector", node_agent_selector)
        if observed_namespaces is not None:
            pulumi.set(__self__, "observed_namespaces", observed_namespaces)

    @_builtins.property
    @pulumi.getter(name="blacklistedNamespaces")
    def blacklisted_namespaces(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of namespaces to exclude from discovery.
        """
        return pulumi.get(self, "blacklisted_namespaces")

    @_builtins.property
    @pulumi.getter(name="collectionWindowInMin")
    def collection_window_in_min(self) -> Optional[_builtins.int]:
        """
        Collection window in minutes.
        """
        return pulumi.get(self, "collection_window_in_min")

    @_builtins.property
    @pulumi.getter
    def crons(self) -> Optional[Sequence['outputs.DiscoveryAgentConfigDataCron']]:
        """
        Cron schedule for data collection.
        """
        return pulumi.get(self, "crons")

    @_builtins.property
    @pulumi.getter(name="enableBatchResources")
    def enable_batch_resources(self) -> Optional[_builtins.bool]:
        """
        Whether to enable batch resources.
        """
        return pulumi.get(self, "enable_batch_resources")

    @_builtins.property
    @pulumi.getter(name="enableNodeAgent")
    def enable_node_agent(self) -> Optional[_builtins.bool]:
        """
        Whether to enable node agent.
        """
        return pulumi.get(self, "enable_node_agent")

    @_builtins.property
    @pulumi.getter(name="enableOrphanedPod")
    def enable_orphaned_pod(self) -> Optional[_builtins.bool]:
        """
        Whether to enable orphaned pod detection.
        """
        return pulumi.get(self, "enable_orphaned_pod")

    @_builtins.property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional[_builtins.str]:
        """
        Namespace selector for the agent.
        """
        return pulumi.get(self, "namespace_selector")

    @_builtins.property
    @pulumi.getter(name="nodeAgentSelector")
    def node_agent_selector(self) -> Optional[_builtins.str]:
        """
        Node selector for the node agent.
        """
        return pulumi.get(self, "node_agent_selector")

    @_builtins.property
    @pulumi.getter(name="observedNamespaces")
    def observed_namespaces(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of namespaces to observe.
        """
        return pulumi.get(self, "observed_namespaces")


@pulumi.output_type
class DiscoveryAgentConfigDataCron(dict):
    def __init__(__self__, *,
                 expression: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Cron expression for scheduling.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        Cron expression for scheduling.
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class DiscoveryAgentConfigKubernete(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableNamespaceCreation":
            suggest = "disable_namespace_creation"
        elif key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "nodeSelector":
            suggest = "node_selector"
        elif key == "runAsGroup":
            suggest = "run_as_group"
        elif key == "runAsUser":
            suggest = "run_as_user"
        elif key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryAgentConfigKubernete. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryAgentConfigKubernete.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryAgentConfigKubernete.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace: _builtins.str,
                 annotations: Optional[Mapping[str, _builtins.str]] = None,
                 disable_namespace_creation: Optional[_builtins.bool] = None,
                 image_pull_policy: Optional[_builtins.str] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 namespaced: Optional[_builtins.bool] = None,
                 node_selector: Optional[Mapping[str, _builtins.str]] = None,
                 resources: Optional[Sequence['outputs.DiscoveryAgentConfigKuberneteResource']] = None,
                 run_as_group: Optional[_builtins.int] = None,
                 run_as_user: Optional[_builtins.int] = None,
                 service_account: Optional[_builtins.str] = None,
                 tolerations: Optional[Sequence['outputs.DiscoveryAgentConfigKuberneteToleration']] = None):
        """
        :param _builtins.str namespace: Kubernetes namespace to use
        :param Mapping[str, _builtins.str] annotations: Annotations to add to all resources.
        :param _builtins.bool disable_namespace_creation: Whether to disable namespace creation.
        :param _builtins.str image_pull_policy: The image pull policy.
        :param Mapping[str, _builtins.str] labels: Labels to add to all resources.
        :param _builtins.bool namespaced: Whether the agent is namespaced.
        :param Mapping[str, _builtins.str] node_selector: Node selector labels.
        :param Sequence['DiscoveryAgentConfigKuberneteResourceArgs'] resources: Compute resource requirements for the agent container.
        :param _builtins.int run_as_group: The group ID to run as.
        :param _builtins.int run_as_user: The user ID to run as.
        :param _builtins.str service_account: Service account to use
        :param Sequence['DiscoveryAgentConfigKuberneteTolerationArgs'] tolerations: Tolerations for pod assignment.
        """
        pulumi.set(__self__, "namespace", namespace)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if disable_namespace_creation is not None:
            pulumi.set(__self__, "disable_namespace_creation", disable_namespace_creation)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if namespaced is not None:
            pulumi.set(__self__, "namespaced", namespaced)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        Kubernetes namespace to use
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Annotations to add to all resources.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="disableNamespaceCreation")
    def disable_namespace_creation(self) -> Optional[_builtins.bool]:
        """
        Whether to disable namespace creation.
        """
        return pulumi.get(self, "disable_namespace_creation")

    @_builtins.property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[_builtins.str]:
        """
        The image pull policy.
        """
        return pulumi.get(self, "image_pull_policy")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Labels to add to all resources.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def namespaced(self) -> Optional[_builtins.bool]:
        """
        Whether the agent is namespaced.
        """
        return pulumi.get(self, "namespaced")

    @_builtins.property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Node selector labels.
        """
        return pulumi.get(self, "node_selector")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[Sequence['outputs.DiscoveryAgentConfigKuberneteResource']]:
        """
        Compute resource requirements for the agent container.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[_builtins.int]:
        """
        The group ID to run as.
        """
        return pulumi.get(self, "run_as_group")

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[_builtins.int]:
        """
        The user ID to run as.
        """
        return pulumi.get(self, "run_as_user")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[_builtins.str]:
        """
        Service account to use
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def tolerations(self) -> Optional[Sequence['outputs.DiscoveryAgentConfigKuberneteToleration']]:
        """
        Tolerations for pod assignment.
        """
        return pulumi.get(self, "tolerations")


@pulumi.output_type
class DiscoveryAgentConfigKuberneteResource(dict):
    def __init__(__self__, *,
                 limits: Optional[Sequence['outputs.DiscoveryAgentConfigKuberneteResourceLimit']] = None,
                 requests: Optional[Sequence['outputs.DiscoveryAgentConfigKuberneteResourceRequest']] = None):
        """
        :param Sequence['DiscoveryAgentConfigKuberneteResourceLimitArgs'] limits: Maximum amount of compute resources allowed.
        :param Sequence['DiscoveryAgentConfigKuberneteResourceRequestArgs'] requests: Minimum amount of compute resources required.
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Optional[Sequence['outputs.DiscoveryAgentConfigKuberneteResourceLimit']]:
        """
        Maximum amount of compute resources allowed.
        """
        return pulumi.get(self, "limits")

    @_builtins.property
    @pulumi.getter
    def requests(self) -> Optional[Sequence['outputs.DiscoveryAgentConfigKuberneteResourceRequest']]:
        """
        Minimum amount of compute resources required.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class DiscoveryAgentConfigKuberneteResourceLimit(dict):
    def __init__(__self__, *,
                 cpu: Optional[_builtins.str] = None,
                 memory: Optional[_builtins.str] = None):
        """
        :param _builtins.str cpu: CPU limit in CPU units (e.g., 500m = 0.5 CPU, 2 = 2 CPUs).
        :param _builtins.str memory: Memory limit in bytes (e.g., 128Mi, 1Gi).
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.str]:
        """
        CPU limit in CPU units (e.g., 500m = 0.5 CPU, 2 = 2 CPUs).
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.str]:
        """
        Memory limit in bytes (e.g., 128Mi, 1Gi).
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class DiscoveryAgentConfigKuberneteResourceRequest(dict):
    def __init__(__self__, *,
                 cpu: Optional[_builtins.str] = None,
                 memory: Optional[_builtins.str] = None):
        """
        :param _builtins.str cpu: CPU request in CPU units (e.g., 100m = 0.1 CPU).
        :param _builtins.str memory: Memory request in bytes (e.g., 128Mi, 1Gi).
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.str]:
        """
        CPU request in CPU units (e.g., 100m = 0.1 CPU).
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.str]:
        """
        Memory request in bytes (e.g., 128Mi, 1Gi).
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class DiscoveryAgentConfigKuberneteToleration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tolerationSeconds":
            suggest = "toleration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryAgentConfigKuberneteToleration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryAgentConfigKuberneteToleration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryAgentConfigKuberneteToleration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effect: _builtins.str,
                 key: _builtins.str,
                 operator: _builtins.str,
                 toleration_seconds: Optional[_builtins.int] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str effect: Effect indicates the taint effect to match.
        :param _builtins.str key: The taint key that the toleration applies to.
        :param _builtins.str operator: Operator represents a key's relationship to the value.
        :param _builtins.int toleration_seconds: TolerationSeconds represents the period of time the toleration tolerates the taint.
        :param _builtins.str value: The taint value the toleration matches to.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "operator", operator)
        if toleration_seconds is not None:
            pulumi.set(__self__, "toleration_seconds", toleration_seconds)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> _builtins.str:
        """
        Effect indicates the taint effect to match.
        """
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The taint key that the toleration applies to.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator represents a key's relationship to the value.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter(name="tolerationSeconds")
    def toleration_seconds(self) -> Optional[_builtins.int]:
        """
        TolerationSeconds represents the period of time the toleration tolerates the taint.
        """
        return pulumi.get(self, "toleration_seconds")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The taint value the toleration matches to.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DiscoveryAgentConfigMtl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certPath":
            suggest = "cert_path"
        elif key == "keyPath":
            suggest = "key_path"
        elif key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryAgentConfigMtl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryAgentConfigMtl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryAgentConfigMtl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_path: Optional[_builtins.str] = None,
                 key_path: Optional[_builtins.str] = None,
                 secret_name: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.str cert_path: Path to the certificate file.
        :param _builtins.str key_path: Path to the key file.
        :param _builtins.str secret_name: Name of the Kubernetes secret containing the certificate and key.
        :param _builtins.str url: URL of the mTLS server.
        """
        if cert_path is not None:
            pulumi.set(__self__, "cert_path", cert_path)
        if key_path is not None:
            pulumi.set(__self__, "key_path", key_path)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="certPath")
    def cert_path(self) -> Optional[_builtins.str]:
        """
        Path to the certificate file.
        """
        return pulumi.get(self, "cert_path")

    @_builtins.property
    @pulumi.getter(name="keyPath")
    def key_path(self) -> Optional[_builtins.str]:
        """
        Path to the key file.
        """
        return pulumi.get(self, "key_path")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[_builtins.str]:
        """
        Name of the Kubernetes secret containing the certificate and key.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        URL of the mTLS server.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class DiscoveryAgentConfigProxy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpProxy":
            suggest = "http_proxy"
        elif key == "httpsProxy":
            suggest = "https_proxy"
        elif key == "noProxy":
            suggest = "no_proxy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryAgentConfigProxy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryAgentConfigProxy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryAgentConfigProxy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_proxy: Optional[_builtins.str] = None,
                 https_proxy: Optional[_builtins.str] = None,
                 no_proxy: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.str http_proxy: HTTP proxy URL.
        :param _builtins.str https_proxy: HTTPS proxy URL.
        :param _builtins.str no_proxy: Comma-separated list of hosts that should not use the proxy.
        :param _builtins.str url: Proxy server URL.
        """
        if http_proxy is not None:
            pulumi.set(__self__, "http_proxy", http_proxy)
        if https_proxy is not None:
            pulumi.set(__self__, "https_proxy", https_proxy)
        if no_proxy is not None:
            pulumi.set(__self__, "no_proxy", no_proxy)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="httpProxy")
    def http_proxy(self) -> Optional[_builtins.str]:
        """
        HTTP proxy URL.
        """
        return pulumi.get(self, "http_proxy")

    @_builtins.property
    @pulumi.getter(name="httpsProxy")
    def https_proxy(self) -> Optional[_builtins.str]:
        """
        HTTPS proxy URL.
        """
        return pulumi.get(self, "https_proxy")

    @_builtins.property
    @pulumi.getter(name="noProxy")
    def no_proxy(self) -> Optional[_builtins.str]:
        """
        Comma-separated list of hosts that should not use the proxy.
        """
        return pulumi.get(self, "no_proxy")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        Proxy server URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class DiscoveryAgentInstallationDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountIdentifier":
            suggest = "account_identifier"
        elif key == "agentDetails":
            suggest = "agent_details"
        elif key == "agentId":
            suggest = "agent_id"
        elif key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "delegateId":
            suggest = "delegate_id"
        elif key == "delegateTaskId":
            suggest = "delegate_task_id"
        elif key == "delegateTaskStatus":
            suggest = "delegate_task_status"
        elif key == "environmentIdentifier":
            suggest = "environment_identifier"
        elif key == "isCronTriggered":
            suggest = "is_cron_triggered"
        elif key == "logStreamCreatedAt":
            suggest = "log_stream_created_at"
        elif key == "logStreamId":
            suggest = "log_stream_id"
        elif key == "organizationIdentifier":
            suggest = "organization_identifier"
        elif key == "projectIdentifier":
            suggest = "project_identifier"
        elif key == "updatedAt":
            suggest = "updated_at"
        elif key == "updatedBy":
            suggest = "updated_by"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryAgentInstallationDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryAgentInstallationDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryAgentInstallationDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_identifier: Optional[_builtins.str] = None,
                 agent_details: Optional[Sequence['outputs.DiscoveryAgentInstallationDetailAgentDetail']] = None,
                 agent_id: Optional[_builtins.str] = None,
                 created_at: Optional[_builtins.str] = None,
                 created_by: Optional[_builtins.str] = None,
                 delegate_id: Optional[_builtins.str] = None,
                 delegate_task_id: Optional[_builtins.str] = None,
                 delegate_task_status: Optional[_builtins.str] = None,
                 environment_identifier: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 is_cron_triggered: Optional[_builtins.bool] = None,
                 log_stream_created_at: Optional[_builtins.str] = None,
                 log_stream_id: Optional[_builtins.str] = None,
                 organization_identifier: Optional[_builtins.str] = None,
                 project_identifier: Optional[_builtins.str] = None,
                 removed: Optional[_builtins.bool] = None,
                 stopped: Optional[_builtins.bool] = None,
                 updated_at: Optional[_builtins.str] = None,
                 updated_by: Optional[_builtins.str] = None):
        """
        :param _builtins.str account_identifier: The account identifier for the installation.
        :param Sequence['DiscoveryAgentInstallationDetailAgentDetailArgs'] agent_details: Details about the installed agent.
        :param _builtins.str agent_id: The ID of the installed agent.
        :param _builtins.str created_at: The timestamp when the installation was created.
        :param _builtins.str created_by: The user who created the installation.
        :param _builtins.str delegate_id: The ID of the delegate used for installation.
        :param _builtins.str delegate_task_id: The ID of the delegate task for the installation.
        :param _builtins.str delegate_task_status: The status of the delegate task (e.g., 'SUCCESS').
        :param _builtins.str environment_identifier: The environment identifier for the installation.
        :param _builtins.str id: The unique identifier of the installation.
        :param _builtins.bool is_cron_triggered: Whether the installation was triggered by a cron job.
        :param _builtins.str log_stream_created_at: The timestamp when the log stream was created.
        :param _builtins.str log_stream_id: The ID of the log stream for the installation.
        :param _builtins.str organization_identifier: The organization identifier for the installation.
        :param _builtins.str project_identifier: The project identifier for the installation.
        :param _builtins.bool removed: Whether the installation has been removed.
        :param _builtins.bool stopped: Whether the installation has been stopped.
        :param _builtins.str updated_at: The timestamp when the installation was last updated.
        :param _builtins.str updated_by: The user who last updated the installation.
        """
        if account_identifier is not None:
            pulumi.set(__self__, "account_identifier", account_identifier)
        if agent_details is not None:
            pulumi.set(__self__, "agent_details", agent_details)
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if delegate_id is not None:
            pulumi.set(__self__, "delegate_id", delegate_id)
        if delegate_task_id is not None:
            pulumi.set(__self__, "delegate_task_id", delegate_task_id)
        if delegate_task_status is not None:
            pulumi.set(__self__, "delegate_task_status", delegate_task_status)
        if environment_identifier is not None:
            pulumi.set(__self__, "environment_identifier", environment_identifier)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_cron_triggered is not None:
            pulumi.set(__self__, "is_cron_triggered", is_cron_triggered)
        if log_stream_created_at is not None:
            pulumi.set(__self__, "log_stream_created_at", log_stream_created_at)
        if log_stream_id is not None:
            pulumi.set(__self__, "log_stream_id", log_stream_id)
        if organization_identifier is not None:
            pulumi.set(__self__, "organization_identifier", organization_identifier)
        if project_identifier is not None:
            pulumi.set(__self__, "project_identifier", project_identifier)
        if removed is not None:
            pulumi.set(__self__, "removed", removed)
        if stopped is not None:
            pulumi.set(__self__, "stopped", stopped)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)

    @_builtins.property
    @pulumi.getter(name="accountIdentifier")
    def account_identifier(self) -> Optional[_builtins.str]:
        """
        The account identifier for the installation.
        """
        return pulumi.get(self, "account_identifier")

    @_builtins.property
    @pulumi.getter(name="agentDetails")
    def agent_details(self) -> Optional[Sequence['outputs.DiscoveryAgentInstallationDetailAgentDetail']]:
        """
        Details about the installed agent.
        """
        return pulumi.get(self, "agent_details")

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[_builtins.str]:
        """
        The ID of the installed agent.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[_builtins.str]:
        """
        The timestamp when the installation was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[_builtins.str]:
        """
        The user who created the installation.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="delegateId")
    def delegate_id(self) -> Optional[_builtins.str]:
        """
        The ID of the delegate used for installation.
        """
        return pulumi.get(self, "delegate_id")

    @_builtins.property
    @pulumi.getter(name="delegateTaskId")
    def delegate_task_id(self) -> Optional[_builtins.str]:
        """
        The ID of the delegate task for the installation.
        """
        return pulumi.get(self, "delegate_task_id")

    @_builtins.property
    @pulumi.getter(name="delegateTaskStatus")
    def delegate_task_status(self) -> Optional[_builtins.str]:
        """
        The status of the delegate task (e.g., 'SUCCESS').
        """
        return pulumi.get(self, "delegate_task_status")

    @_builtins.property
    @pulumi.getter(name="environmentIdentifier")
    def environment_identifier(self) -> Optional[_builtins.str]:
        """
        The environment identifier for the installation.
        """
        return pulumi.get(self, "environment_identifier")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The unique identifier of the installation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isCronTriggered")
    def is_cron_triggered(self) -> Optional[_builtins.bool]:
        """
        Whether the installation was triggered by a cron job.
        """
        return pulumi.get(self, "is_cron_triggered")

    @_builtins.property
    @pulumi.getter(name="logStreamCreatedAt")
    def log_stream_created_at(self) -> Optional[_builtins.str]:
        """
        The timestamp when the log stream was created.
        """
        return pulumi.get(self, "log_stream_created_at")

    @_builtins.property
    @pulumi.getter(name="logStreamId")
    def log_stream_id(self) -> Optional[_builtins.str]:
        """
        The ID of the log stream for the installation.
        """
        return pulumi.get(self, "log_stream_id")

    @_builtins.property
    @pulumi.getter(name="organizationIdentifier")
    def organization_identifier(self) -> Optional[_builtins.str]:
        """
        The organization identifier for the installation.
        """
        return pulumi.get(self, "organization_identifier")

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> Optional[_builtins.str]:
        """
        The project identifier for the installation.
        """
        return pulumi.get(self, "project_identifier")

    @_builtins.property
    @pulumi.getter
    def removed(self) -> Optional[_builtins.bool]:
        """
        Whether the installation has been removed.
        """
        return pulumi.get(self, "removed")

    @_builtins.property
    @pulumi.getter
    def stopped(self) -> Optional[_builtins.bool]:
        """
        Whether the installation has been stopped.
        """
        return pulumi.get(self, "stopped")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[_builtins.str]:
        """
        The timestamp when the installation was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[_builtins.str]:
        """
        The user who last updated the installation.
        """
        return pulumi.get(self, "updated_by")


@pulumi.output_type
class DiscoveryAgentInstallationDetailAgentDetail(dict):
    def __init__(__self__, *,
                 clusters: Optional[Sequence['outputs.DiscoveryAgentInstallationDetailAgentDetailCluster']] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param Sequence['DiscoveryAgentInstallationDetailAgentDetailClusterArgs'] clusters: Details about the cluster where the agent is installed.
        :param _builtins.str status: The status of the agent installation.
        """
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Optional[Sequence['outputs.DiscoveryAgentInstallationDetailAgentDetailCluster']]:
        """
        Details about the cluster where the agent is installed.
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the agent installation.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DiscoveryAgentInstallationDetailAgentDetailCluster(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 uid: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the cluster.
        :param _builtins.str namespace: The namespace where the agent is installed.
        :param _builtins.str status: The status of the cluster (e.g., 'Succeeded').
        :param _builtins.str uid: The UID of the cluster.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The namespace where the agent is installed.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the cluster (e.g., 'Succeeded').
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.str]:
        """
        The UID of the cluster.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class DiscoverySettingImageRegistry(dict):
    def __init__(__self__, *,
                 account: _builtins.str,
                 server: _builtins.str,
                 secrets: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str account: The account name for the image registry.
        :param _builtins.str server: The server URL for the image registry.
        :param Sequence[_builtins.str] secrets: List of secrets for the image registry.
        """
        pulumi.set(__self__, "account", account)
        pulumi.set(__self__, "server", server)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @_builtins.property
    @pulumi.getter
    def account(self) -> _builtins.str:
        """
        The account name for the image registry.
        """
        return pulumi.get(self, "account")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        The server URL for the image registry.
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of secrets for the image registry.
        """
        return pulumi.get(self, "secrets")


@pulumi.output_type
class EcsVariable(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the variable
        :param _builtins.str type: Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        :param _builtins.str value: Value of the variable
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the variable
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the variable
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HelmVariable(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the variable
        :param _builtins.str type: Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        :param _builtins.str value: Value of the variable
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the variable
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the variable
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class KubernetesVariable(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the variable
        :param _builtins.str type: Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        :param _builtins.str value: Value of the variable
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the variable
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the variable
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LambdaVariable(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the variable
        :param _builtins.str type: Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        :param _builtins.str value: Value of the variable
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the variable
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the variable
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SshVariable(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the variable
        :param _builtins.str type: Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        :param _builtins.str value: Value of the variable
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the variable
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the variable
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TanzuVariable(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the variable
        :param _builtins.str type: Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        :param _builtins.str value: Value of the variable
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the variable
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the variable
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class WinrmVariable(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the variable
        :param _builtins.str type: Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        :param _builtins.str value: Value of the variable
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the variable
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the variable. Options are 'TEXT' and 'ENCRYPTED_TEXT'
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the variable
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDiscoveryAgentConfigResult(dict):
    def __init__(__self__, *,
                 collector_image: _builtins.str,
                 datas: Sequence['outputs.GetDiscoveryAgentConfigDataResult'],
                 image_pull_secrets: Sequence[_builtins.str],
                 kubernetes: Sequence['outputs.GetDiscoveryAgentConfigKuberneteResult'],
                 log_watcher_image: _builtins.str,
                 mtls: Sequence['outputs.GetDiscoveryAgentConfigMtlResult'],
                 proxies: Sequence['outputs.GetDiscoveryAgentConfigProxyResult'],
                 skip_secure_verify: _builtins.bool):
        """
        :param _builtins.str collector_image: Docker image for the collector.
        :param Sequence['GetDiscoveryAgentConfigDataArgs'] datas: Data collection configuration.
        :param Sequence[_builtins.str] image_pull_secrets: List of image pull secrets.
        :param Sequence['GetDiscoveryAgentConfigKuberneteArgs'] kubernetes: Kubernetes-specific configuration.
        :param _builtins.str log_watcher_image: Docker image for the log watcher.
        :param Sequence['GetDiscoveryAgentConfigMtlArgs'] mtls: mTLS configuration.
        :param Sequence['GetDiscoveryAgentConfigProxyArgs'] proxies: Proxy configuration.
        :param _builtins.bool skip_secure_verify: Whether to skip TLS verification.
        """
        pulumi.set(__self__, "collector_image", collector_image)
        pulumi.set(__self__, "datas", datas)
        pulumi.set(__self__, "image_pull_secrets", image_pull_secrets)
        pulumi.set(__self__, "kubernetes", kubernetes)
        pulumi.set(__self__, "log_watcher_image", log_watcher_image)
        pulumi.set(__self__, "mtls", mtls)
        pulumi.set(__self__, "proxies", proxies)
        pulumi.set(__self__, "skip_secure_verify", skip_secure_verify)

    @_builtins.property
    @pulumi.getter(name="collectorImage")
    def collector_image(self) -> _builtins.str:
        """
        Docker image for the collector.
        """
        return pulumi.get(self, "collector_image")

    @_builtins.property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.GetDiscoveryAgentConfigDataResult']:
        """
        Data collection configuration.
        """
        return pulumi.get(self, "datas")

    @_builtins.property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> Sequence[_builtins.str]:
        """
        List of image pull secrets.
        """
        return pulumi.get(self, "image_pull_secrets")

    @_builtins.property
    @pulumi.getter
    def kubernetes(self) -> Sequence['outputs.GetDiscoveryAgentConfigKuberneteResult']:
        """
        Kubernetes-specific configuration.
        """
        return pulumi.get(self, "kubernetes")

    @_builtins.property
    @pulumi.getter(name="logWatcherImage")
    def log_watcher_image(self) -> _builtins.str:
        """
        Docker image for the log watcher.
        """
        return pulumi.get(self, "log_watcher_image")

    @_builtins.property
    @pulumi.getter
    def mtls(self) -> Sequence['outputs.GetDiscoveryAgentConfigMtlResult']:
        """
        mTLS configuration.
        """
        return pulumi.get(self, "mtls")

    @_builtins.property
    @pulumi.getter
    def proxies(self) -> Sequence['outputs.GetDiscoveryAgentConfigProxyResult']:
        """
        Proxy configuration.
        """
        return pulumi.get(self, "proxies")

    @_builtins.property
    @pulumi.getter(name="skipSecureVerify")
    def skip_secure_verify(self) -> _builtins.bool:
        """
        Whether to skip TLS verification.
        """
        return pulumi.get(self, "skip_secure_verify")


@pulumi.output_type
class GetDiscoveryAgentConfigDataResult(dict):
    def __init__(__self__, *,
                 blacklisted_namespaces: Sequence[_builtins.str],
                 collection_window_in_min: _builtins.int,
                 crons: Sequence['outputs.GetDiscoveryAgentConfigDataCronResult'],
                 enable_batch_resources: _builtins.bool,
                 enable_node_agent: _builtins.bool,
                 enable_orphaned_pod: _builtins.bool,
                 namespace_selector: _builtins.str,
                 node_agent_selector: _builtins.str,
                 observed_namespaces: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] blacklisted_namespaces: List of namespaces to exclude from discovery.
        :param _builtins.int collection_window_in_min: Collection window in minutes.
        :param Sequence['GetDiscoveryAgentConfigDataCronArgs'] crons: Cron schedule for data collection.
        :param _builtins.bool enable_batch_resources: Whether to enable batch resources.
        :param _builtins.bool enable_node_agent: Whether to enable node agent.
        :param _builtins.bool enable_orphaned_pod: Whether to enable orphaned pod detection.
        :param _builtins.str namespace_selector: Namespace selector for the agent.
        :param _builtins.str node_agent_selector: Node selector for the node agent.
        :param Sequence[_builtins.str] observed_namespaces: List of namespaces to observe.
        """
        pulumi.set(__self__, "blacklisted_namespaces", blacklisted_namespaces)
        pulumi.set(__self__, "collection_window_in_min", collection_window_in_min)
        pulumi.set(__self__, "crons", crons)
        pulumi.set(__self__, "enable_batch_resources", enable_batch_resources)
        pulumi.set(__self__, "enable_node_agent", enable_node_agent)
        pulumi.set(__self__, "enable_orphaned_pod", enable_orphaned_pod)
        pulumi.set(__self__, "namespace_selector", namespace_selector)
        pulumi.set(__self__, "node_agent_selector", node_agent_selector)
        pulumi.set(__self__, "observed_namespaces", observed_namespaces)

    @_builtins.property
    @pulumi.getter(name="blacklistedNamespaces")
    def blacklisted_namespaces(self) -> Sequence[_builtins.str]:
        """
        List of namespaces to exclude from discovery.
        """
        return pulumi.get(self, "blacklisted_namespaces")

    @_builtins.property
    @pulumi.getter(name="collectionWindowInMin")
    def collection_window_in_min(self) -> _builtins.int:
        """
        Collection window in minutes.
        """
        return pulumi.get(self, "collection_window_in_min")

    @_builtins.property
    @pulumi.getter
    def crons(self) -> Sequence['outputs.GetDiscoveryAgentConfigDataCronResult']:
        """
        Cron schedule for data collection.
        """
        return pulumi.get(self, "crons")

    @_builtins.property
    @pulumi.getter(name="enableBatchResources")
    def enable_batch_resources(self) -> _builtins.bool:
        """
        Whether to enable batch resources.
        """
        return pulumi.get(self, "enable_batch_resources")

    @_builtins.property
    @pulumi.getter(name="enableNodeAgent")
    def enable_node_agent(self) -> _builtins.bool:
        """
        Whether to enable node agent.
        """
        return pulumi.get(self, "enable_node_agent")

    @_builtins.property
    @pulumi.getter(name="enableOrphanedPod")
    def enable_orphaned_pod(self) -> _builtins.bool:
        """
        Whether to enable orphaned pod detection.
        """
        return pulumi.get(self, "enable_orphaned_pod")

    @_builtins.property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> _builtins.str:
        """
        Namespace selector for the agent.
        """
        return pulumi.get(self, "namespace_selector")

    @_builtins.property
    @pulumi.getter(name="nodeAgentSelector")
    def node_agent_selector(self) -> _builtins.str:
        """
        Node selector for the node agent.
        """
        return pulumi.get(self, "node_agent_selector")

    @_builtins.property
    @pulumi.getter(name="observedNamespaces")
    def observed_namespaces(self) -> Sequence[_builtins.str]:
        """
        List of namespaces to observe.
        """
        return pulumi.get(self, "observed_namespaces")


@pulumi.output_type
class GetDiscoveryAgentConfigDataCronResult(dict):
    def __init__(__self__, *,
                 expression: _builtins.str):
        """
        :param _builtins.str expression: Cron expression for scheduling.
        """
        pulumi.set(__self__, "expression", expression)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Cron expression for scheduling.
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class GetDiscoveryAgentConfigKuberneteResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, _builtins.str],
                 disable_namespace_creation: _builtins.bool,
                 image_pull_policy: _builtins.str,
                 labels: Mapping[str, _builtins.str],
                 namespace: _builtins.str,
                 namespaced: _builtins.bool,
                 node_selector: Mapping[str, _builtins.str],
                 resources: Sequence['outputs.GetDiscoveryAgentConfigKuberneteResourceResult'],
                 run_as_group: _builtins.int,
                 run_as_user: _builtins.int,
                 service_account: _builtins.str,
                 tolerations: Sequence['outputs.GetDiscoveryAgentConfigKuberneteTolerationResult']):
        """
        :param Mapping[str, _builtins.str] annotations: Annotations to add to all resources.
        :param _builtins.bool disable_namespace_creation: Whether to disable namespace creation.
        :param _builtins.str image_pull_policy: The image pull policy.
        :param Mapping[str, _builtins.str] labels: Labels to add to all resources.
        :param _builtins.str namespace: Kubernetes namespace to use
        :param _builtins.bool namespaced: Whether the agent is namespaced.
        :param Mapping[str, _builtins.str] node_selector: Node selector labels.
        :param Sequence['GetDiscoveryAgentConfigKuberneteResourceArgs'] resources: Compute resource requirements for the agent container.
        :param _builtins.int run_as_group: The group ID to run as.
        :param _builtins.int run_as_user: The user ID to run as.
        :param _builtins.str service_account: Service account to use
        :param Sequence['GetDiscoveryAgentConfigKuberneteTolerationArgs'] tolerations: Tolerations for pod assignment.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "disable_namespace_creation", disable_namespace_creation)
        pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "namespaced", namespaced)
        pulumi.set(__self__, "node_selector", node_selector)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "run_as_group", run_as_group)
        pulumi.set(__self__, "run_as_user", run_as_user)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "tolerations", tolerations)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        """
        Annotations to add to all resources.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="disableNamespaceCreation")
    def disable_namespace_creation(self) -> _builtins.bool:
        """
        Whether to disable namespace creation.
        """
        return pulumi.get(self, "disable_namespace_creation")

    @_builtins.property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> _builtins.str:
        """
        The image pull policy.
        """
        return pulumi.get(self, "image_pull_policy")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels to add to all resources.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        Kubernetes namespace to use
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def namespaced(self) -> _builtins.bool:
        """
        Whether the agent is namespaced.
        """
        return pulumi.get(self, "namespaced")

    @_builtins.property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Mapping[str, _builtins.str]:
        """
        Node selector labels.
        """
        return pulumi.get(self, "node_selector")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetDiscoveryAgentConfigKuberneteResourceResult']:
        """
        Compute resource requirements for the agent container.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> _builtins.int:
        """
        The group ID to run as.
        """
        return pulumi.get(self, "run_as_group")

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> _builtins.int:
        """
        The user ID to run as.
        """
        return pulumi.get(self, "run_as_user")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> _builtins.str:
        """
        Service account to use
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def tolerations(self) -> Sequence['outputs.GetDiscoveryAgentConfigKuberneteTolerationResult']:
        """
        Tolerations for pod assignment.
        """
        return pulumi.get(self, "tolerations")


@pulumi.output_type
class GetDiscoveryAgentConfigKuberneteResourceResult(dict):
    def __init__(__self__, *,
                 limits: Sequence['outputs.GetDiscoveryAgentConfigKuberneteResourceLimitResult'],
                 requests: Sequence['outputs.GetDiscoveryAgentConfigKuberneteResourceRequestResult']):
        """
        :param Sequence['GetDiscoveryAgentConfigKuberneteResourceLimitArgs'] limits: Maximum amount of compute resources allowed.
        :param Sequence['GetDiscoveryAgentConfigKuberneteResourceRequestArgs'] requests: Minimum amount of compute resources required.
        """
        pulumi.set(__self__, "limits", limits)
        pulumi.set(__self__, "requests", requests)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Sequence['outputs.GetDiscoveryAgentConfigKuberneteResourceLimitResult']:
        """
        Maximum amount of compute resources allowed.
        """
        return pulumi.get(self, "limits")

    @_builtins.property
    @pulumi.getter
    def requests(self) -> Sequence['outputs.GetDiscoveryAgentConfigKuberneteResourceRequestResult']:
        """
        Minimum amount of compute resources required.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class GetDiscoveryAgentConfigKuberneteResourceLimitResult(dict):
    def __init__(__self__, *,
                 cpu: _builtins.str,
                 memory: _builtins.str):
        """
        :param _builtins.str cpu: CPU limit in CPU units (e.g., 500m = 0.5 CPU, 2 = 2 CPUs).
        :param _builtins.str memory: Memory limit in bytes (e.g., 128Mi, 1Gi).
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory", memory)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.str:
        """
        CPU limit in CPU units (e.g., 500m = 0.5 CPU, 2 = 2 CPUs).
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.str:
        """
        Memory limit in bytes (e.g., 128Mi, 1Gi).
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class GetDiscoveryAgentConfigKuberneteResourceRequestResult(dict):
    def __init__(__self__, *,
                 cpu: _builtins.str,
                 memory: _builtins.str):
        """
        :param _builtins.str cpu: CPU request in CPU units (e.g., 100m = 0.1 CPU).
        :param _builtins.str memory: Memory request in bytes (e.g., 128Mi, 1Gi).
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory", memory)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.str:
        """
        CPU request in CPU units (e.g., 100m = 0.1 CPU).
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.str:
        """
        Memory request in bytes (e.g., 128Mi, 1Gi).
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class GetDiscoveryAgentConfigKuberneteTolerationResult(dict):
    def __init__(__self__, *,
                 effect: _builtins.str,
                 key: _builtins.str,
                 operator: _builtins.str,
                 toleration_seconds: _builtins.int,
                 value: _builtins.str):
        """
        :param _builtins.str effect: Effect indicates the taint effect to match.
        :param _builtins.str key: The taint key that the toleration applies to.
        :param _builtins.str operator: Operator represents a key's relationship to the value.
        :param _builtins.int toleration_seconds: TolerationSeconds represents the period of time the toleration tolerates the taint.
        :param _builtins.str value: The taint value the toleration matches to.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "toleration_seconds", toleration_seconds)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> _builtins.str:
        """
        Effect indicates the taint effect to match.
        """
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The taint key that the toleration applies to.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Operator represents a key's relationship to the value.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter(name="tolerationSeconds")
    def toleration_seconds(self) -> _builtins.int:
        """
        TolerationSeconds represents the period of time the toleration tolerates the taint.
        """
        return pulumi.get(self, "toleration_seconds")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The taint value the toleration matches to.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDiscoveryAgentConfigMtlResult(dict):
    def __init__(__self__, *,
                 cert_path: _builtins.str,
                 key_path: _builtins.str,
                 secret_name: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str cert_path: Path to the certificate file.
        :param _builtins.str key_path: Path to the key file.
        :param _builtins.str secret_name: Name of the Kubernetes secret containing the certificate and key.
        :param _builtins.str url: URL of the mTLS server.
        """
        pulumi.set(__self__, "cert_path", cert_path)
        pulumi.set(__self__, "key_path", key_path)
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="certPath")
    def cert_path(self) -> _builtins.str:
        """
        Path to the certificate file.
        """
        return pulumi.get(self, "cert_path")

    @_builtins.property
    @pulumi.getter(name="keyPath")
    def key_path(self) -> _builtins.str:
        """
        Path to the key file.
        """
        return pulumi.get(self, "key_path")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        Name of the Kubernetes secret containing the certificate and key.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL of the mTLS server.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetDiscoveryAgentConfigProxyResult(dict):
    def __init__(__self__, *,
                 http_proxy: _builtins.str,
                 https_proxy: _builtins.str,
                 no_proxy: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str http_proxy: HTTP proxy URL.
        :param _builtins.str https_proxy: HTTPS proxy URL.
        :param _builtins.str no_proxy: Comma-separated list of hosts that should not use the proxy.
        :param _builtins.str url: Proxy server URL.
        """
        pulumi.set(__self__, "http_proxy", http_proxy)
        pulumi.set(__self__, "https_proxy", https_proxy)
        pulumi.set(__self__, "no_proxy", no_proxy)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="httpProxy")
    def http_proxy(self) -> _builtins.str:
        """
        HTTP proxy URL.
        """
        return pulumi.get(self, "http_proxy")

    @_builtins.property
    @pulumi.getter(name="httpsProxy")
    def https_proxy(self) -> _builtins.str:
        """
        HTTPS proxy URL.
        """
        return pulumi.get(self, "https_proxy")

    @_builtins.property
    @pulumi.getter(name="noProxy")
    def no_proxy(self) -> _builtins.str:
        """
        Comma-separated list of hosts that should not use the proxy.
        """
        return pulumi.get(self, "no_proxy")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Proxy server URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetDiscoveryAgentInstallationDetailResult(dict):
    def __init__(__self__, *,
                 account_identifier: _builtins.str,
                 agent_details: Sequence['outputs.GetDiscoveryAgentInstallationDetailAgentDetailResult'],
                 agent_id: _builtins.str,
                 created_at: _builtins.str,
                 created_by: _builtins.str,
                 delegate_id: _builtins.str,
                 delegate_task_id: _builtins.str,
                 delegate_task_status: _builtins.str,
                 environment_identifier: _builtins.str,
                 id: _builtins.str,
                 is_cron_triggered: _builtins.bool,
                 log_stream_created_at: _builtins.str,
                 log_stream_id: _builtins.str,
                 org_identifier: _builtins.str,
                 project_identifier: _builtins.str,
                 removed: _builtins.bool,
                 removed_at: _builtins.str,
                 stopped: _builtins.bool,
                 updated_at: _builtins.str,
                 updated_by: _builtins.str):
        """
        :param _builtins.str account_identifier: Account identifier of the installation.
        :param Sequence['GetDiscoveryAgentInstallationDetailAgentDetailArgs'] agent_details: Details about the agent installation.
        :param _builtins.str agent_id: ID of the agent.
        :param _builtins.str created_at: When the installation was created.
        :param _builtins.str created_by: Who created the installation.
        :param _builtins.str delegate_id: ID of the delegate.
        :param _builtins.str delegate_task_id: ID of the delegate task.
        :param _builtins.str delegate_task_status: Status of the delegate task.
        :param _builtins.str environment_identifier: Environment identifier of the installation.
        :param _builtins.str id: Installation ID.
        :param _builtins.bool is_cron_triggered: Whether the installation was triggered by a cron job.
        :param _builtins.str log_stream_created_at: When the log stream was created.
        :param _builtins.str log_stream_id: ID of the log stream.
        :param _builtins.str org_identifier: Organization identifier of the installation.
        :param _builtins.str project_identifier: Project identifier of the installation.
        :param _builtins.bool removed: Whether the installation has been removed.
        :param _builtins.str removed_at: When the installation was removed.
        :param _builtins.bool stopped: Whether the installation has been stopped.
        :param _builtins.str updated_at: When the installation was last updated.
        :param _builtins.str updated_by: Who last updated the installation.
        """
        pulumi.set(__self__, "account_identifier", account_identifier)
        pulumi.set(__self__, "agent_details", agent_details)
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "delegate_id", delegate_id)
        pulumi.set(__self__, "delegate_task_id", delegate_task_id)
        pulumi.set(__self__, "delegate_task_status", delegate_task_status)
        pulumi.set(__self__, "environment_identifier", environment_identifier)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_cron_triggered", is_cron_triggered)
        pulumi.set(__self__, "log_stream_created_at", log_stream_created_at)
        pulumi.set(__self__, "log_stream_id", log_stream_id)
        pulumi.set(__self__, "org_identifier", org_identifier)
        pulumi.set(__self__, "project_identifier", project_identifier)
        pulumi.set(__self__, "removed", removed)
        pulumi.set(__self__, "removed_at", removed_at)
        pulumi.set(__self__, "stopped", stopped)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "updated_by", updated_by)

    @_builtins.property
    @pulumi.getter(name="accountIdentifier")
    def account_identifier(self) -> _builtins.str:
        """
        Account identifier of the installation.
        """
        return pulumi.get(self, "account_identifier")

    @_builtins.property
    @pulumi.getter(name="agentDetails")
    def agent_details(self) -> Sequence['outputs.GetDiscoveryAgentInstallationDetailAgentDetailResult']:
        """
        Details about the agent installation.
        """
        return pulumi.get(self, "agent_details")

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> _builtins.str:
        """
        ID of the agent.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        When the installation was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        Who created the installation.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="delegateId")
    def delegate_id(self) -> _builtins.str:
        """
        ID of the delegate.
        """
        return pulumi.get(self, "delegate_id")

    @_builtins.property
    @pulumi.getter(name="delegateTaskId")
    def delegate_task_id(self) -> _builtins.str:
        """
        ID of the delegate task.
        """
        return pulumi.get(self, "delegate_task_id")

    @_builtins.property
    @pulumi.getter(name="delegateTaskStatus")
    def delegate_task_status(self) -> _builtins.str:
        """
        Status of the delegate task.
        """
        return pulumi.get(self, "delegate_task_status")

    @_builtins.property
    @pulumi.getter(name="environmentIdentifier")
    def environment_identifier(self) -> _builtins.str:
        """
        Environment identifier of the installation.
        """
        return pulumi.get(self, "environment_identifier")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Installation ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isCronTriggered")
    def is_cron_triggered(self) -> _builtins.bool:
        """
        Whether the installation was triggered by a cron job.
        """
        return pulumi.get(self, "is_cron_triggered")

    @_builtins.property
    @pulumi.getter(name="logStreamCreatedAt")
    def log_stream_created_at(self) -> _builtins.str:
        """
        When the log stream was created.
        """
        return pulumi.get(self, "log_stream_created_at")

    @_builtins.property
    @pulumi.getter(name="logStreamId")
    def log_stream_id(self) -> _builtins.str:
        """
        ID of the log stream.
        """
        return pulumi.get(self, "log_stream_id")

    @_builtins.property
    @pulumi.getter(name="orgIdentifier")
    def org_identifier(self) -> _builtins.str:
        """
        Organization identifier of the installation.
        """
        return pulumi.get(self, "org_identifier")

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> _builtins.str:
        """
        Project identifier of the installation.
        """
        return pulumi.get(self, "project_identifier")

    @_builtins.property
    @pulumi.getter
    def removed(self) -> _builtins.bool:
        """
        Whether the installation has been removed.
        """
        return pulumi.get(self, "removed")

    @_builtins.property
    @pulumi.getter(name="removedAt")
    def removed_at(self) -> _builtins.str:
        """
        When the installation was removed.
        """
        return pulumi.get(self, "removed_at")

    @_builtins.property
    @pulumi.getter
    def stopped(self) -> _builtins.bool:
        """
        Whether the installation has been stopped.
        """
        return pulumi.get(self, "stopped")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        When the installation was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> _builtins.str:
        """
        Who last updated the installation.
        """
        return pulumi.get(self, "updated_by")


@pulumi.output_type
class GetDiscoveryAgentInstallationDetailAgentDetailResult(dict):
    def __init__(__self__, *,
                 clusters: Sequence['outputs.GetDiscoveryAgentInstallationDetailAgentDetailClusterResult'],
                 nodes: Sequence['outputs.GetDiscoveryAgentInstallationDetailAgentDetailNodeResult'],
                 status: _builtins.str):
        """
        :param Sequence['GetDiscoveryAgentInstallationDetailAgentDetailClusterArgs'] clusters: Cluster information.
        :param Sequence['GetDiscoveryAgentInstallationDetailAgentDetailNodeArgs'] nodes: List of nodes in the cluster.
        :param _builtins.str status: Status of the agent.
        """
        pulumi.set(__self__, "clusters", clusters)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Sequence['outputs.GetDiscoveryAgentInstallationDetailAgentDetailClusterResult']:
        """
        Cluster information.
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetDiscoveryAgentInstallationDetailAgentDetailNodeResult']:
        """
        List of nodes in the cluster.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the agent.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDiscoveryAgentInstallationDetailAgentDetailClusterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 namespace: _builtins.str,
                 status: _builtins.str,
                 uid: _builtins.str):
        """
        :param _builtins.str name: Name of the cluster.
        :param _builtins.str namespace: Namespace of the cluster.
        :param _builtins.str status: Status of the cluster.
        :param _builtins.str uid: UID of the cluster.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        Namespace of the cluster.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        """
        UID of the cluster.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetDiscoveryAgentInstallationDetailAgentDetailNodeResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 namespace: _builtins.str,
                 status: _builtins.str,
                 uid: _builtins.str):
        """
        :param _builtins.str name: Name of the node.
        :param _builtins.str namespace: Namespace of the node.
        :param _builtins.str status: Status of the node.
        :param _builtins.str uid: UID of the node.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the node.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        Namespace of the node.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the node.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        """
        UID of the node.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetDiscoverySettingImageRegistryResult(dict):
    def __init__(__self__, *,
                 account: _builtins.str,
                 secrets: Sequence[_builtins.str],
                 server: _builtins.str):
        """
        :param _builtins.str account: The account name for the image registry.
        :param Sequence[_builtins.str] secrets: List of secrets for the image registry.
        :param _builtins.str server: The server URL for the image registry.
        """
        pulumi.set(__self__, "account", account)
        pulumi.set(__self__, "secrets", secrets)
        pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter
    def account(self) -> _builtins.str:
        """
        The account name for the image registry.
        """
        return pulumi.get(self, "account")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Sequence[_builtins.str]:
        """
        List of secrets for the image registry.
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        The server URL for the image registry.
        """
        return pulumi.get(self, "server")


