# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.10.4, generator: @autorest/python@6.34.2)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core import MatchConditions, PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceModifiedError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._configuration import DiracConfiguration
from .._utils.serialization import Deserializer, Serializer
from .._utils.utils import prep_if_match, prep_if_none_match, raise_if_not_implemented

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_well_known_get_openid_configuration_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/.well-known/openid-configuration"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_well_known_get_jwks_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/.well-known/jwks.json"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_well_known_get_security_txt_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/.well-known/.well-known/security.txt"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_well_known_get_installation_metadata_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/.well-known/dirac-metadata"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_auth_initiate_device_flow_request(*, client_id: str, scope: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/auth/device"

    # Construct parameters
    _params["client_id"] = _SERIALIZER.query("client_id", client_id, "str")
    _params["scope"] = _SERIALIZER.query("scope", scope, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_auth_do_device_flow_request(*, user_code: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/auth/device"

    # Construct parameters
    _params["user_code"] = _SERIALIZER.query("user_code", user_code, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_auth_finish_device_flow_request(*, code: str, state: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/auth/device/complete"

    # Construct parameters
    _params["code"] = _SERIALIZER.query("code", code, "str")
    _params["state"] = _SERIALIZER.query("state", state, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_auth_finished_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/auth/device/complete/finished"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_auth_get_refresh_tokens_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/auth/refresh-tokens"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_auth_revoke_refresh_token_by_refresh_token_request(  # pylint: disable=name-too-long
    *, refresh_token: str, client_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/auth/revoke"

    # Construct parameters
    _params["refresh_token"] = _SERIALIZER.query("refresh_token", refresh_token, "str")
    _params["client_id"] = _SERIALIZER.query("client_id", client_id, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_auth_revoke_refresh_token_by_jti_request(  # pylint: disable=name-too-long
    jti: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/auth/refresh-tokens/{jti}"
    path_format_arguments = {
        "jti": _SERIALIZER.url("jti", jti, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_auth_userinfo_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/auth/userinfo"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_auth_initiate_authorization_flow_request(  # pylint: disable=name-too-long
    *,
    response_type: str,
    code_challenge: str,
    code_challenge_method: str,
    client_id: str,
    redirect_uri: str,
    scope: str,
    state: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/auth/authorize"

    # Construct parameters
    _params["response_type"] = _SERIALIZER.query("response_type", response_type, "str")
    _params["code_challenge"] = _SERIALIZER.query("code_challenge", code_challenge, "str")
    _params["code_challenge_method"] = _SERIALIZER.query("code_challenge_method", code_challenge_method, "str")
    _params["client_id"] = _SERIALIZER.query("client_id", client_id, "str")
    _params["redirect_uri"] = _SERIALIZER.query("redirect_uri", redirect_uri, "str")
    _params["scope"] = _SERIALIZER.query("scope", scope, "str")
    _params["state"] = _SERIALIZER.query("state", state, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_auth_complete_authorization_flow_request(  # pylint: disable=name-too-long
    *, code: str, state: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/auth/authorize/complete"

    # Construct parameters
    _params["code"] = _SERIALIZER.query("code", code, "str")
    _params["state"] = _SERIALIZER.query("state", state, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_config_serve_config_request(
    *,
    if_modified_since: Optional[str] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/config/"

    # Construct headers
    if if_modified_since is not None:
        _headers["if-modified-since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_jobs_initiate_sandbox_upload_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/jobs/sandbox"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_jobs_get_sandbox_file_request(*, pfn: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/jobs/sandbox"

    # Construct parameters
    _params["pfn"] = _SERIALIZER.query(
        "pfn",
        pfn,
        "str",
        max_length=256,
        pattern=r"^(:?SB:[A-Za-z]+\|)?/S3/[a-z0-9\.\-]{3,63}(?:/[^/]+){3}/[a-z0-9]{3,10}:[0-9a-f]{64}\.[a-z0-9\.]+$",
    )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_jobs_get_job_sandboxes_request(job_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/jobs/{job_id}/sandbox"
    path_format_arguments = {
        "job_id": _SERIALIZER.url("job_id", job_id, "int"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_jobs_unassign_job_sandboxes_request(  # pylint: disable=name-too-long
    job_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/jobs/{job_id}/sandbox"
    path_format_arguments = {
        "job_id": _SERIALIZER.url("job_id", job_id, "int"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_jobs_get_job_sandbox_request(
    job_id: int, sandbox_type: Union[str, _models.SandboxType], **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/jobs/{job_id}/sandbox/{sandbox_type}"
    path_format_arguments = {
        "job_id": _SERIALIZER.url("job_id", job_id, "int"),
        "sandbox_type": _SERIALIZER.url("sandbox_type", sandbox_type, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_jobs_assign_sandbox_to_job_request(job_id: int, *, content: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/jobs/{job_id}/sandbox/output"
    path_format_arguments = {
        "job_id": _SERIALIZER.url("job_id", job_id, "int"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, content=content, **kwargs)


def build_jobs_unassign_bulk_jobs_sandboxes_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    # Construct URL
    _url = "/api/jobs/sandbox/unassign"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_jobs_set_job_statuses_request(*, force: bool = False, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/jobs/status"

    # Construct parameters
    if force is not None:
        _params["force"] = _SERIALIZER.query("force", force, "bool")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_jobs_add_heartbeat_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/jobs/heartbeat"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_jobs_reschedule_jobs_request(*, reset_jobs: bool = False, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/jobs/reschedule"

    # Construct parameters
    if reset_jobs is not None:
        _params["reset_jobs"] = _SERIALIZER.query("reset_jobs", reset_jobs, "bool")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_jobs_patch_metadata_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    # Construct URL
    _url = "/api/jobs/metadata"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_jobs_search_request(*, page: int = 1, per_page: int = 100, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/jobs/search"

    # Construct parameters
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int")
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query("per_page", per_page, "int")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_jobs_summary_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/jobs/summary"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_jobs_submit_jdl_jobs_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/jobs/jdl"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_lollygag_insert_owner_object_request(  # pylint: disable=name-too-long
    owner_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/lollygag/insert_owner/{owner_name}"
    path_format_arguments = {
        "owner_name": _SERIALIZER.url("owner_name", owner_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_lollygag_get_owner_object_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/lollygag/get_owners"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_lollygag_get_gubbins_secrets_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/api/lollygag/gubbins_sensei"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


class WellKnownOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.Dirac`'s
        :attr:`well_known` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: DiracConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get_openid_configuration(self, **kwargs: Any) -> _models.OpenIDConfiguration:
        """Get Openid Configuration.

        OpenID Connect discovery endpoint.

        :return: OpenIDConfiguration
        :rtype: ~_generated.models.OpenIDConfiguration
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.OpenIDConfiguration] = kwargs.pop("cls", None)

        _request = build_well_known_get_openid_configuration_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("OpenIDConfiguration", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_jwks(self, **kwargs: Any) -> Dict[str, Any]:
        """Get Jwks.

        Get the JWKs (public keys).

        :return: dict mapping str to any
        :rtype: dict[str, any]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Dict[str, Any]] = kwargs.pop("cls", None)

        _request = build_well_known_get_jwks_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("{object}", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_security_txt(self, **kwargs: Any) -> str:
        """Get Security Txt.

        Get the security.txt file.

        :return: str
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[str] = kwargs.pop("cls", None)

        _request = build_well_known_get_security_txt_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("str", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_installation_metadata(self, **kwargs: Any) -> _models.ExtendedMetadata:
        """Get Installation Metadata.

        Get Installation Metadata.

        :return: ExtendedMetadata
        :rtype: ~_generated.models.ExtendedMetadata
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ExtendedMetadata] = kwargs.pop("cls", None)

        _request = build_well_known_get_installation_metadata_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("ExtendedMetadata", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class AuthOperations:  # pylint: disable=abstract-class-instantiated
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.Dirac`'s
        :attr:`auth` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: DiracConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

        raise_if_not_implemented(
            self.__class__,
            [
                "get_oidc_token",
            ],
        )

    @distributed_trace
    def initiate_device_flow(self, *, client_id: str, scope: str, **kwargs: Any) -> _models.InitiateDeviceFlowResponse:
        """Initiate Device Flow.

        Initiate the device flow against DIRAC authorization Server.

        Scope details:


        *
          If only VO is provided: Uses the default group and its properties for the VO.

        *
          If VO and group are provided: Uses the specified group and its properties for the VO.

        *
          If VO and properties are provided: Uses the default group and combines its properties with
        the
          provided properties.

        *
          If VO, group, and properties are provided: Uses the specified group and combines its
        properties with the
          provided properties.

        Offers the user to go with the browser to
        ``auth/<vo>/device?user_code=XYZ``.

        :keyword client_id: Required.
        :paramtype client_id: str
        :keyword scope: Required.
        :paramtype scope: str
        :return: InitiateDeviceFlowResponse
        :rtype: ~_generated.models.InitiateDeviceFlowResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.InitiateDeviceFlowResponse] = kwargs.pop("cls", None)

        _request = build_auth_initiate_device_flow_request(
            client_id=client_id,
            scope=scope,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("InitiateDeviceFlowResponse", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def do_device_flow(self, *, user_code: str, **kwargs: Any) -> Any:
        """Do Device Flow.

        This is called as the verification URI for the device flow.
        It will redirect to the actual OpenID server (IAM, CheckIn) to
        perform a authorization code flow.

        We set the user_code obtained from the device flow in a cookie
        to be able to map the authorization flow with the corresponding
        device flow.
        (note: it can't be put as parameter or in the URL).

        :keyword user_code: Required.
        :paramtype user_code: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_auth_do_device_flow_request(
            user_code=user_code,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def finish_device_flow(self, *, code: str, state: str, **kwargs: Any) -> Any:
        """Finish Device Flow.

        This the url callbacked by IAM/CheckIn after the authorization
        flow was granted.
        It gets us the code we need for the authorization flow, and we
        can map it to the corresponding device flow using the user_code
        in the cookie/session.

        :keyword code: Required.
        :paramtype code: str
        :keyword state: Required.
        :paramtype state: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_auth_finish_device_flow_request(
            code=code,
            state=state,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def finished(self, **kwargs: Any) -> Any:
        """Finished.

        This is the final step of the device flow.

        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_auth_finished_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_refresh_tokens(self, **kwargs: Any) -> List[Any]:
        """Get Refresh Tokens.

        Get all refresh tokens for the user. If the user has the ``proxy_management`` property, then
        the subject is not used to filter the refresh tokens.

        :return: list of any
        :rtype: list[any]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[Any]] = kwargs.pop("cls", None)

        _request = build_auth_get_refresh_tokens_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[object]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def revoke_refresh_token_by_refresh_token(self, *, refresh_token: str, client_id: str, **kwargs: Any) -> str:
        """Revoke Refresh Token By Refresh Token.

        Revoke a refresh token.

        :keyword refresh_token: Required.
        :paramtype refresh_token: str
        :keyword client_id: Required.
        :paramtype client_id: str
        :return: str
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[str] = kwargs.pop("cls", None)

        _request = build_auth_revoke_refresh_token_by_refresh_token_request(
            refresh_token=refresh_token,
            client_id=client_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("str", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def revoke_refresh_token_by_jti(self, jti: str, **kwargs: Any) -> str:
        """Revoke Refresh Token By Jti.

        Revoke a refresh token. If the user has the ``proxy_management`` property, then
        the subject is not used to filter the refresh tokens.

        :param jti: Required.
        :type jti: str
        :return: str
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[str] = kwargs.pop("cls", None)

        _request = build_auth_revoke_refresh_token_by_jti_request(
            jti=jti,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("str", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def userinfo(self, **kwargs: Any) -> _models.UserInfoResponse:
        """Userinfo.

        Get information about the user's identity.

        :return: UserInfoResponse
        :rtype: ~_generated.models.UserInfoResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.UserInfoResponse] = kwargs.pop("cls", None)

        _request = build_auth_userinfo_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("UserInfoResponse", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def initiate_authorization_flow(
        self,
        *,
        response_type: str,
        code_challenge: str,
        code_challenge_method: str,
        client_id: str,
        redirect_uri: str,
        scope: str,
        state: str,
        **kwargs: Any
    ) -> Any:
        """Initiate Authorization Flow.

        Initiate the authorization flow.
        It will redirect to the actual OpenID server (IAM, CheckIn) to
        perform a authorization code flow.

        Scope details:


        *
          If only VO is provided: Uses the default group and its properties for the VO.

        *
          If VO and group are provided: Uses the specified group and its properties for the VO.

        *
          If VO and properties are provided: Uses the default group and combines its properties with
        the
          provided properties.

        *
          If VO, group, and properties are provided: Uses the specified group and combines its
        properties with the
          provided properties.

        We set the user details obtained from the user authorize flow in a cookie
        to be able to map the authorization flow with the corresponding
        user authorize flow.

        :keyword response_type: Required.
        :paramtype response_type: str
        :keyword code_challenge: Required.
        :paramtype code_challenge: str
        :keyword code_challenge_method: Required.
        :paramtype code_challenge_method: str
        :keyword client_id: Required.
        :paramtype client_id: str
        :keyword redirect_uri: Required.
        :paramtype redirect_uri: str
        :keyword scope: Required.
        :paramtype scope: str
        :keyword state: Required.
        :paramtype state: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_auth_initiate_authorization_flow_request(
            response_type=response_type,
            code_challenge=code_challenge,
            code_challenge_method=code_challenge_method,
            client_id=client_id,
            redirect_uri=redirect_uri,
            scope=scope,
            state=state,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def complete_authorization_flow(self, *, code: str, state: str, **kwargs: Any) -> Any:
        """Complete Authorization Flow.

        Complete the authorization flow.

        The user is redirected back to the DIRAC auth service after completing the IAM's authorization
        flow.
        We retrieve the original flow details from the decrypted state and store the ID token requested
        from the IAM.
        The user is then redirected to the client's redirect URI.

        :keyword code: Required.
        :paramtype code: str
        :keyword state: Required.
        :paramtype state: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_auth_complete_authorization_flow_request(
            code=code,
            state=state,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class ConfigOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.Dirac`'s
        :attr:`config` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: DiracConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def serve_config(
        self,
        *,
        if_modified_since: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> Any:
        """Serve Config.

        Get the latest view of the config.

        If If-None-Match header is given and matches the latest ETag, return 304

        If If-Modified-Since is given and is newer than latest,
            return 304: this is to avoid flip/flopping.

        :keyword if_modified_since: Default value is None.
        :paramtype if_modified_since: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_config_serve_config_request(
            if_modified_since=if_modified_since,
            etag=etag,
            match_condition=match_condition,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class JobsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.Dirac`'s
        :attr:`jobs` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: DiracConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def initiate_sandbox_upload(
        self, body: _models.SandboxInfo, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.SandboxUploadResponse:
        """Initiate Sandbox Upload.

        Get the PFN for the given sandbox, initiate an upload as required.

        If the sandbox already exists in the database then the PFN is returned
        and there is no "url" field in the response.

        If the sandbox does not exist in the database then the "url" and "fields"
        should be used to upload the sandbox to the storage backend.

        :param body: Required.
        :type body: ~_generated.models.SandboxInfo
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SandboxUploadResponse
        :rtype: ~_generated.models.SandboxUploadResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def initiate_sandbox_upload(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.SandboxUploadResponse:
        """Initiate Sandbox Upload.

        Get the PFN for the given sandbox, initiate an upload as required.

        If the sandbox already exists in the database then the PFN is returned
        and there is no "url" field in the response.

        If the sandbox does not exist in the database then the "url" and "fields"
        should be used to upload the sandbox to the storage backend.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SandboxUploadResponse
        :rtype: ~_generated.models.SandboxUploadResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def initiate_sandbox_upload(
        self, body: Union[_models.SandboxInfo, IO[bytes]], **kwargs: Any
    ) -> _models.SandboxUploadResponse:
        """Initiate Sandbox Upload.

        Get the PFN for the given sandbox, initiate an upload as required.

        If the sandbox already exists in the database then the PFN is returned
        and there is no "url" field in the response.

        If the sandbox does not exist in the database then the "url" and "fields"
        should be used to upload the sandbox to the storage backend.

        :param body: Is either a SandboxInfo type or a IO[bytes] type. Required.
        :type body: ~_generated.models.SandboxInfo or IO[bytes]
        :return: SandboxUploadResponse
        :rtype: ~_generated.models.SandboxUploadResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SandboxUploadResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "SandboxInfo")

        _request = build_jobs_initiate_sandbox_upload_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("SandboxUploadResponse", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_sandbox_file(self, *, pfn: str, **kwargs: Any) -> _models.SandboxDownloadResponse:
        """Get Sandbox File.

        Get a presigned URL to download a sandbox file.

        This route cannot use a redirect response most clients will also send the
        authorization header when following a redirect. This is not desirable as
        it would leak the authorization token to the storage backend. Additionally,
        most storage backends return an error when they receive an authorization
        header for a presigned URL.

        :keyword pfn: Required.
        :paramtype pfn: str
        :return: SandboxDownloadResponse
        :rtype: ~_generated.models.SandboxDownloadResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.SandboxDownloadResponse] = kwargs.pop("cls", None)

        _request = build_jobs_get_sandbox_file_request(
            pfn=pfn,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("SandboxDownloadResponse", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_job_sandboxes(self, job_id: int, **kwargs: Any) -> Dict[str, List[Any]]:
        """Get Job Sandboxes.

        Get input and output sandboxes of given job.

        :param job_id: Required.
        :type job_id: int
        :return: dict mapping str to list of any
        :rtype: dict[str, list[any]]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Dict[str, List[Any]]] = kwargs.pop("cls", None)

        _request = build_jobs_get_job_sandboxes_request(
            job_id=job_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("{[object]}", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def unassign_job_sandboxes(self, job_id: int, **kwargs: Any) -> Any:
        """Unassign Job Sandboxes.

        Delete single job sandbox mapping.

        :param job_id: Required.
        :type job_id: int
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_jobs_unassign_job_sandboxes_request(
            job_id=job_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_job_sandbox(self, job_id: int, sandbox_type: Union[str, _models.SandboxType], **kwargs: Any) -> List[Any]:
        """Get Job Sandbox.

        Get input or output sandbox of given job.

        :param job_id: Required.
        :type job_id: int
        :param sandbox_type: Known values are: "input" and "output". Required.
        :type sandbox_type: str or ~_generated.models.SandboxType
        :return: list of any
        :rtype: list[any]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[Any]] = kwargs.pop("cls", None)

        _request = build_jobs_get_job_sandbox_request(
            job_id=job_id,
            sandbox_type=sandbox_type,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[object]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def assign_sandbox_to_job(self, job_id: int, body: str, **kwargs: Any) -> Any:
        """Assign Sandbox To Job.

        Map the pfn as output sandbox to job.

        :param job_id: Required.
        :type job_id: int
        :param body: Required.
        :type body: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))
        cls: ClsType[Any] = kwargs.pop("cls", None)

        _content = self._serialize.body(body, "str")

        _request = build_jobs_assign_sandbox_to_job_request(
            job_id=job_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def unassign_bulk_jobs_sandboxes(
        self, body: _models.BodyJobsUnassignBulkJobsSandboxes, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Unassign Bulk Jobs Sandboxes.

        Delete bulk jobs sandbox mapping.

        :param body: Required.
        :type body: ~_generated.models.BodyJobsUnassignBulkJobsSandboxes
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def unassign_bulk_jobs_sandboxes(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Unassign Bulk Jobs Sandboxes.

        Delete bulk jobs sandbox mapping.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def unassign_bulk_jobs_sandboxes(  # pylint: disable=inconsistent-return-statements
        self, body: Union[_models.BodyJobsUnassignBulkJobsSandboxes, IO[bytes]], **kwargs: Any
    ) -> None:
        """Unassign Bulk Jobs Sandboxes.

        Delete bulk jobs sandbox mapping.

        :param body: Is either a BodyJobsUnassignBulkJobsSandboxes type or a IO[bytes] type. Required.
        :type body: ~_generated.models.BodyJobsUnassignBulkJobsSandboxes or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "BodyJobsUnassignBulkJobsSandboxes")

        _request = build_jobs_unassign_bulk_jobs_sandboxes_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    def set_job_statuses(
        self,
        body: Dict[str, Dict[str, _models.JobStatusUpdate]],
        *,
        force: bool = False,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SetJobStatusReturn:
        """Set Job Statuses.

        Set the status of a job or a list of jobs.

        Body parameters:


        * ``Status``\\ : The new status of the job.
        * ``MinorStatus``\\ : The minor status of the job.
        * ``ApplicationStatus``\\ : The application-specific status of the job.
        * ``Source``\\ : The source of the status update (default is "Unknown").

        :param body: Required.
        :type body: dict[str, dict[str, ~_generated.models.JobStatusUpdate]]
        :keyword force: Default value is False.
        :paramtype force: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SetJobStatusReturn
        :rtype: ~_generated.models.SetJobStatusReturn
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def set_job_statuses(
        self, body: IO[bytes], *, force: bool = False, content_type: str = "application/json", **kwargs: Any
    ) -> _models.SetJobStatusReturn:
        """Set Job Statuses.

        Set the status of a job or a list of jobs.

        Body parameters:


        * ``Status``\\ : The new status of the job.
        * ``MinorStatus``\\ : The minor status of the job.
        * ``ApplicationStatus``\\ : The application-specific status of the job.
        * ``Source``\\ : The source of the status update (default is "Unknown").

        :param body: Required.
        :type body: IO[bytes]
        :keyword force: Default value is False.
        :paramtype force: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SetJobStatusReturn
        :rtype: ~_generated.models.SetJobStatusReturn
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def set_job_statuses(
        self,
        body: Union[Dict[str, Dict[str, _models.JobStatusUpdate]], IO[bytes]],
        *,
        force: bool = False,
        **kwargs: Any
    ) -> _models.SetJobStatusReturn:
        """Set Job Statuses.

        Set the status of a job or a list of jobs.

        Body parameters:


        * ``Status``\\ : The new status of the job.
        * ``MinorStatus``\\ : The minor status of the job.
        * ``ApplicationStatus``\\ : The application-specific status of the job.
        * ``Source``\\ : The source of the status update (default is "Unknown").

        :param body: Is either a {str: {str: JobStatusUpdate}} type or a IO[bytes] type. Required.
        :type body: dict[str, dict[str, ~_generated.models.JobStatusUpdate]] or IO[bytes]
        :keyword force: Default value is False.
        :paramtype force: bool
        :return: SetJobStatusReturn
        :rtype: ~_generated.models.SetJobStatusReturn
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SetJobStatusReturn] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "{{JobStatusUpdate}}")

        _request = build_jobs_set_job_statuses_request(
            force=force,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("SetJobStatusReturn", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def add_heartbeat(
        self, body: Dict[str, _models.HeartbeatData], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.JobCommand]:
        """Add Heartbeat.

        Register a heartbeat from the job.

        This endpoint is used by the JobAgent to send heartbeats to the WMS and to
        receive job commands from the WMS. It also results in stalled jobs being
        restored to the RUNNING status.

        The ``data`` parameter and return value are mappings keyed by job ID.

        :param body: Required.
        :type body: dict[str, ~_generated.models.HeartbeatData]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of JobCommand
        :rtype: list[~_generated.models.JobCommand]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def add_heartbeat(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.JobCommand]:
        """Add Heartbeat.

        Register a heartbeat from the job.

        This endpoint is used by the JobAgent to send heartbeats to the WMS and to
        receive job commands from the WMS. It also results in stalled jobs being
        restored to the RUNNING status.

        The ``data`` parameter and return value are mappings keyed by job ID.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of JobCommand
        :rtype: list[~_generated.models.JobCommand]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def add_heartbeat(
        self, body: Union[Dict[str, _models.HeartbeatData], IO[bytes]], **kwargs: Any
    ) -> List[_models.JobCommand]:
        """Add Heartbeat.

        Register a heartbeat from the job.

        This endpoint is used by the JobAgent to send heartbeats to the WMS and to
        receive job commands from the WMS. It also results in stalled jobs being
        restored to the RUNNING status.

        The ``data`` parameter and return value are mappings keyed by job ID.

        :param body: Is either a {str: HeartbeatData} type or a IO[bytes] type. Required.
        :type body: dict[str, ~_generated.models.HeartbeatData] or IO[bytes]
        :return: list of JobCommand
        :rtype: list[~_generated.models.JobCommand]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.JobCommand]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "{HeartbeatData}")

        _request = build_jobs_add_heartbeat_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[JobCommand]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def reschedule_jobs(
        self,
        body: _models.BodyJobsRescheduleJobs,
        *,
        reset_jobs: bool = False,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Dict[str, Any]:
        """Reschedule Jobs.

        Reschedule a list of killed or failed jobs.

        Body parameters:


        * ``job_ids``\\ : List of job IDs to reschedule.
        * ``reset_jobs``\\ : If True, reset the count of reschedules for the jobs.

        :param body: Required.
        :type body: ~_generated.models.BodyJobsRescheduleJobs
        :keyword reset_jobs: Default value is False.
        :paramtype reset_jobs: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: dict mapping str to any
        :rtype: dict[str, any]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def reschedule_jobs(
        self, body: IO[bytes], *, reset_jobs: bool = False, content_type: str = "application/json", **kwargs: Any
    ) -> Dict[str, Any]:
        """Reschedule Jobs.

        Reschedule a list of killed or failed jobs.

        Body parameters:


        * ``job_ids``\\ : List of job IDs to reschedule.
        * ``reset_jobs``\\ : If True, reset the count of reschedules for the jobs.

        :param body: Required.
        :type body: IO[bytes]
        :keyword reset_jobs: Default value is False.
        :paramtype reset_jobs: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: dict mapping str to any
        :rtype: dict[str, any]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def reschedule_jobs(
        self, body: Union[_models.BodyJobsRescheduleJobs, IO[bytes]], *, reset_jobs: bool = False, **kwargs: Any
    ) -> Dict[str, Any]:
        """Reschedule Jobs.

        Reschedule a list of killed or failed jobs.

        Body parameters:


        * ``job_ids``\\ : List of job IDs to reschedule.
        * ``reset_jobs``\\ : If True, reset the count of reschedules for the jobs.

        :param body: Is either a BodyJobsRescheduleJobs type or a IO[bytes] type. Required.
        :type body: ~_generated.models.BodyJobsRescheduleJobs or IO[bytes]
        :keyword reset_jobs: Default value is False.
        :paramtype reset_jobs: bool
        :return: dict mapping str to any
        :rtype: dict[str, any]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Dict[str, Any]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "BodyJobsRescheduleJobs")

        _request = build_jobs_reschedule_jobs_request(
            reset_jobs=reset_jobs,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("{object}", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def patch_metadata(
        self, body: Dict[str, _models.JobMetaData], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Patch Metadata.

        Update job metadata such as UserPriority, HeartBeatTime, JobType, etc.
        The argument  are all the attributes/parameters of a job (except the ID).

        :param body: Required.
        :type body: dict[str, ~_generated.models.JobMetaData]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def patch_metadata(self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any) -> None:
        """Patch Metadata.

        Update job metadata such as UserPriority, HeartBeatTime, JobType, etc.
        The argument  are all the attributes/parameters of a job (except the ID).

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def patch_metadata(  # pylint: disable=inconsistent-return-statements
        self, body: Union[Dict[str, _models.JobMetaData], IO[bytes]], **kwargs: Any
    ) -> None:
        """Patch Metadata.

        Update job metadata such as UserPriority, HeartBeatTime, JobType, etc.
        The argument  are all the attributes/parameters of a job (except the ID).

        :param body: Is either a {str: JobMetaData} type or a IO[bytes] type. Required.
        :type body: dict[str, ~_generated.models.JobMetaData] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "{JobMetaData}")

        _request = build_jobs_patch_metadata_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    def search(
        self,
        body: Optional[_models.SearchParams] = None,
        *,
        page: int = 1,
        per_page: int = 100,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[Dict[str, Any]]:
        """Search.

        Creates a search query to the job database. This search can be based on
        different parameters, such as jobID, status, owner, etc.

        **Possibilities**


        * Use ``search`` to filter jobs based on various parameters (optional).
        * Use ``parameters`` to specify which job parameters to return (optional).
        * Use ``sort`` to order the results based on specific parameters (optional).

        By default, the search will return all jobs the user has access to, and all the fields
        of the job will be returned.

        :param body: Default value is None.
        :type body: ~_generated.models.SearchParams
        :keyword page: Default value is 1.
        :paramtype page: int
        :keyword per_page: Default value is 100.
        :paramtype per_page: int
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of dict mapping str to any
        :rtype: list[dict[str, any]]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def search(
        self,
        body: Optional[IO[bytes]] = None,
        *,
        page: int = 1,
        per_page: int = 100,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[Dict[str, Any]]:
        """Search.

        Creates a search query to the job database. This search can be based on
        different parameters, such as jobID, status, owner, etc.

        **Possibilities**


        * Use ``search`` to filter jobs based on various parameters (optional).
        * Use ``parameters`` to specify which job parameters to return (optional).
        * Use ``sort`` to order the results based on specific parameters (optional).

        By default, the search will return all jobs the user has access to, and all the fields
        of the job will be returned.

        :param body: Default value is None.
        :type body: IO[bytes]
        :keyword page: Default value is 1.
        :paramtype page: int
        :keyword per_page: Default value is 100.
        :paramtype per_page: int
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of dict mapping str to any
        :rtype: list[dict[str, any]]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def search(
        self,
        body: Optional[Union[_models.SearchParams, IO[bytes]]] = None,
        *,
        page: int = 1,
        per_page: int = 100,
        **kwargs: Any
    ) -> List[Dict[str, Any]]:
        """Search.

        Creates a search query to the job database. This search can be based on
        different parameters, such as jobID, status, owner, etc.

        **Possibilities**


        * Use ``search`` to filter jobs based on various parameters (optional).
        * Use ``parameters`` to specify which job parameters to return (optional).
        * Use ``sort`` to order the results based on specific parameters (optional).

        By default, the search will return all jobs the user has access to, and all the fields
        of the job will be returned.

        :param body: Is either a SearchParams type or a IO[bytes] type. Default value is None.
        :type body: ~_generated.models.SearchParams or IO[bytes]
        :keyword page: Default value is 1.
        :paramtype page: int
        :keyword per_page: Default value is 100.
        :paramtype per_page: int
        :return: list of dict mapping str to any
        :rtype: list[dict[str, any]]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[Dict[str, Any]]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "SearchParams")
            else:
                _json = None

        _request = build_jobs_search_request(
            page=page,
            per_page=per_page,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 206]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 206:
            response_headers["Content-Range"] = self._deserialize("str", response.headers.get("Content-Range"))

        deserialized = self._deserialize("[{object}]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def summary(self, body: _models.SummaryParams, *, content_type: str = "application/json", **kwargs: Any) -> Any:
        """Summary.

        Group jobs by a specific list of parameters. Returns an array of n-uplets, where each n-uplet
        contains the
        values of the grouping parameters and the number of jobs that match those values.

        Body parameters:


        * ``grouping``\\ : List of parameters to group the jobs by.
        * ``search``\\ : List of search parameters to filter the jobs by (optional).

        :param body: Required.
        :type body: ~_generated.models.SummaryParams
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def summary(self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any) -> Any:
        """Summary.

        Group jobs by a specific list of parameters. Returns an array of n-uplets, where each n-uplet
        contains the
        values of the grouping parameters and the number of jobs that match those values.

        Body parameters:


        * ``grouping``\\ : List of parameters to group the jobs by.
        * ``search``\\ : List of search parameters to filter the jobs by (optional).

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def summary(self, body: Union[_models.SummaryParams, IO[bytes]], **kwargs: Any) -> Any:
        """Summary.

        Group jobs by a specific list of parameters. Returns an array of n-uplets, where each n-uplet
        contains the
        values of the grouping parameters and the number of jobs that match those values.

        Body parameters:


        * ``grouping``\\ : List of parameters to group the jobs by.
        * ``search``\\ : List of search parameters to filter the jobs by (optional).

        :param body: Is either a SummaryParams type or a IO[bytes] type. Required.
        :type body: ~_generated.models.SummaryParams or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "SummaryParams")

        _request = build_jobs_summary_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def submit_jdl_jobs(
        self, body: List[str], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.InsertedJob]:
        """Submit Jdl Jobs.

        Submit a list of jobs in JDL format.

        :param body: Required.
        :type body: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of InsertedJob
        :rtype: list[~_generated.models.InsertedJob]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def submit_jdl_jobs(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.InsertedJob]:
        """Submit Jdl Jobs.

        Submit a list of jobs in JDL format.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of InsertedJob
        :rtype: list[~_generated.models.InsertedJob]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def submit_jdl_jobs(self, body: Union[List[str], IO[bytes]], **kwargs: Any) -> List[_models.InsertedJob]:
        """Submit Jdl Jobs.

        Submit a list of jobs in JDL format.

        :param body: Is either a [str] type or a IO[bytes] type. Required.
        :type body: list[str] or IO[bytes]
        :return: list of InsertedJob
        :rtype: list[~_generated.models.InsertedJob]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.InsertedJob]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "[str]")

        _request = build_jobs_submit_jdl_jobs_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[InsertedJob]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class LollygagOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.Dirac`'s
        :attr:`lollygag` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: DiracConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def insert_owner_object(self, owner_name: str, **kwargs: Any) -> Any:
        """Insert Owner Object.

        Insert Owner Object.

        :param owner_name: Required.
        :type owner_name: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_lollygag_insert_owner_object_request(
            owner_name=owner_name,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_owner_object(self, **kwargs: Any) -> Any:
        """Get Owner Object.

        Get Owner Object.

        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_lollygag_get_owner_object_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_gubbins_secrets(self, **kwargs: Any) -> Any:
        """Get Gubbins Secrets.

        Does nothing but expects a GUBBINS_SENSEI permission.

        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_lollygag_get_gubbins_secrets_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
