import abc
from abc import ABC, abstractmethod
from m_crawler.engine.abstract_request import AbstractRequest as AbstractRequest
from m_crawler.engine.abstract_response import AbstractResponse as AbstractResponse

class AbstractEngine(ABC, metaclass=abc.ABCMeta):
    def before_download_hook(self, request: AbstractRequest) -> AbstractRequest: ...
    def after_download_hook(self, result: AbstractResponse) -> AbstractResponse: ...
    @abstractmethod
    def download(self, request: AbstractRequest) -> AbstractResponse: ...
    def run(self, request: AbstractRequest) -> AbstractResponse: ...
