import abc
from abc import ABC, abstractmethod
from m_crawler.scheduler.scheduler import Scheduler as Scheduler
from typing import Any

class AbstractPipeline(ABC, metaclass=abc.ABCMeta):
    schedulers: set[Scheduler] | None
    def __init__(self) -> None: ...
    def register_scheduler(self, scheduler: Scheduler) -> None: ...
    def process(self, item: Any) -> None: ...
    @abstractmethod
    def process_item(self, item: Any) -> Any: ...
